<!-- received="Sun Apr 23 01:51:01 2000 EET DST" -->
<!-- sent="Sat, 22 Apr 2000 17:47:46 -0500" -->
<!-- name="Bill Wendling" -->
<!-- email="wendling@ganymede.isdn.uiuc.edu" -->
<!-- subject="[patch-2.3.99pre6-5] Include File Patches" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [patch-2.3.99pre6-5] Include File Patches</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch-2.3.99pre6-5] Include File Patches</h1>
<b>Bill Wendling</b> (<a href="mailto:wendling@ganymede.isdn.uiuc.edu"><i>wendling@ganymede.isdn.uiuc.edu</i></a>)<br>
<i>Sat, 22 Apr 2000 17:47:46 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#8">[ date ]</a><a href="index.html#8">[ thread ]</a><a href="subject.html#8">[ subject ]</a><a href="author.html#8">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0009.html">Manfred Spraul: "Re: Endless kernel Oops with plain 2.3.99-pre5"</a>
<li> <b>Previous message:</b> <a href="0007.html">Tim Waugh: "Re: [RFC] Flat /lib/modules/`uname -r`"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--d6Gm4EdcadzBjdND<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi, Linus et al,<br>
<p>
Here are some minor patches to the include files. I tried to compile the<br>
kernel with -pedantic (and failed). I got several warnings about newlines<br>
in strings being invalid in ANSI C. There were some text after an #endif<br>
in the include/linux/raid files which should be comments. One of the<br>
strangest errors was this:<br>
<p>
	__u8 short slot_tablelen;<br>
<p>
in include/linux/cdrom.h. __u8 is typedef'ed as unsigned char. I'm<br>
assuming this was meant to be unsigned short instead?<br>
<p>
Also, the __skb_pull() function in include/linux/skbuff.h was returning a<br>
char * when it should have been returning an unsigned char *.<br>
<p>
Anyway, here are the patches for your purusal(sp?).<br>
<p>
<pre>
-- 
|| Bill Wendling			<a href="mailto:wendling@ganymede.isdn.uiuc.edu">wendling@ganymede.isdn.uiuc.edu</a>
<p>
--d6Gm4EdcadzBjdND
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="patch-asm.include"
<p>
diff -Naur linux-2.3.99-pre6-5/include/asm-i386/checksum.h linux-2.3.99-pre6-5-new/include/asm-i386/checksum.h
--- linux-2.3.99-pre6-5/include/asm-i386/checksum.h	Tue Feb  1 01:41:14 2000
+++ linux-2.3.99-pre6-5-new/include/asm-i386/checksum.h	Sat Apr 22 02:41:46 2000
@@ -69,25 +69,24 @@
 					  unsigned int ihl) {
 	unsigned int sum;
 
-	__asm__ __volatile__("
-	    movl (%1), %0
-	    subl $4, %2
-	    jbe 2f
-	    addl 4(%1), %0
-	    adcl 8(%1), %0
-	    adcl 12(%1), %0
-1:	    adcl 16(%1), %0
-	    lea 4(%1), %1
-	    decl %2
-	    jne	1b
-	    adcl $0, %0
-	    movl %0, %2
-	    shrl $16, %0
-	    addw %w2, %w0
-	    adcl $0, %0
-	    notl %0
-2:
-	    "
+	__asm__ __volatile__(
+	    "movl (%1), %0\n\t"
+	    "subl $4, %2\n\t"
+	    "jbe 2f\n\t"
+	    "addl 4(%1), %0\n\t"
+	    "adcl 8(%1), %0\n\t"
+	    "adcl 12(%1), %0\n\t"
+	    "1:	adcl 16(%1), %0\n\t"
+	    "lea 4(%1), %1\n\t"
+	    "decl %2\n\t"
+	    "jne 1b\n\t"
+	    "adcl $0, %0\n\t"
+	    "movl %0, %2\n\t"
+	    "shrl $16, %0\n\t"
+	    "addw %w2, %w0\n\t"
+	    "adcl $0, %0\n\t"
+	    "notl %0\n\t"
+	    "2:"
 	/* Since the input registers which are loaded with iph and ipl
 	   are modified, we must also specify them as outputs, or gcc
 	   will assume they contain their original values. */
@@ -102,10 +101,8 @@
 
 static inline unsigned int csum_fold(unsigned int sum)
 {
-	__asm__("
-		addl %1, %0
-		adcl $0xffff, %0
-		"
+	__asm__("addl %1, %0\n\t"
+		"adcl $0xffff, %0"
 		: "=r" (sum)
 		: "r" (sum &lt;&lt; 16), "0" (sum &amp; 0xffff0000)
 	);
@@ -118,12 +115,10 @@
 						   unsigned short proto,
 						   unsigned int sum) 
 {
-    __asm__("
-	addl %1, %0
-	adcl %2, %0
-	adcl %3, %0
-	adcl $0, %0
-	"
+    __asm__("addl %1, %0\n\t"
+	    "adcl %2, %0\n\t"
+	    "adcl %3, %0\n\t"
+	    "adcl $0, %0\n\t"
 	: "=r" (sum)
 	: "g" (daddr), "g"(saddr), "g"((ntohs(len)&lt;&lt;16)+proto*256), "0"(sum));
     return sum;
@@ -158,19 +153,17 @@
 						     unsigned short proto,
 						     unsigned int sum) 
 {
-	__asm__("
-		addl 0(%1), %0
-		adcl 4(%1), %0
-		adcl 8(%1), %0
-		adcl 12(%1), %0
-		adcl 0(%2), %0
-		adcl 4(%2), %0
-		adcl 8(%2), %0
-		adcl 12(%2), %0
-		adcl %3, %0
-		adcl %4, %0
-		adcl $0, %0
-		"
+	__asm__("addl 0(%1), %0\n\t"
+		"adcl 4(%1), %0\n\t"
+		"adcl 8(%1), %0\n\t"
+		"adcl 12(%1), %0\n\t"
+		"adcl 0(%2), %0\n\t"
+		"adcl 4(%2), %0\n\t"
+		"adcl 8(%2), %0\n\t"
+		"adcl 12(%2), %0\n\t"
+		"adcl %3, %0\n\t"
+		"adcl %4, %0\n\t"
+		"adcl $0, %0\n\t"
 		: "=&amp;r" (sum)
 		: "r" (saddr), "r" (daddr), 
 		  "r"(htonl(len)), "r"(htonl(proto)), "0"(sum));
diff -Naur linux-2.3.99-pre6-5/include/asm-i386/string.h linux-2.3.99-pre6-5-new/include/asm-i386/string.h
--- linux-2.3.99-pre6-5/include/asm-i386/string.h	Fri Apr 21 21:55:43 2000
+++ linux-2.3.99-pre6-5-new/include/asm-i386/string.h	Sat Apr 22 02:41:46 2000
@@ -549,10 +549,10 @@
 {
 	if (!size)
 		return addr;
-	__asm__("repnz; scasb
-		jnz 1f
-		dec %%edi
-1:		"
+	__asm__("repnz; scasb\n\t"
+		"jnz 1f\n\t"
+		"dec %%edi\n\t"
+		"1:"
 		: "=D" (addr), "=c" (size)
 		: "0" (addr), "1" (size), "a" (c));
 	return addr;
diff -Naur linux-2.3.99-pre6-5/include/asm-i386/system.h linux-2.3.99-pre6-5-new/include/asm-i386/system.h
--- linux-2.3.99-pre6-5/include/asm-i386/system.h	Thu Mar 23 17:36:06 2000
+++ linux-2.3.99-pre6-5-new/include/asm-i386/system.h	Sat Apr 22 02:42:27 2000
@@ -145,10 +145,10 @@
 		unsigned int low, unsigned int high)
 {
 __asm__ __volatile__ (
-	"1:	movl (%0), %%eax;
-		movl 4(%0), %%edx;
-		cmpxchg8b (%0);
-		jnz 1b"
+	"1:	movl (%0), %%eax; \n\t"
+	"movl 4(%0), %%edx; \n\t"
+	"cmpxchg8b (%0); \n\t"
+	"jnz 1b"
 	::		"D"(ptr),
 			"b"(low),
 			"c"(high)
<p>
--d6Gm4EdcadzBjdND
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="patch-linux.include"
<p>
diff -Naur linux-2.3.99-pre6-5/include/linux/cdrom.h linux-2.3.99-pre6-5-new/include/linux/cdrom.h
--- linux-2.3.99-pre6-5/include/linux/cdrom.h	Thu Mar 23 17:36:08 2000
+++ linux-2.3.99-pre6-5-new/include/linux/cdrom.h	Sat Apr 22 02:41:49 2000
@@ -905,7 +905,7 @@
 #endif
 	__u8     curlba[3];
 	__u8     nslots;
-	__u8 short slot_tablelen;
+	unsigned short slot_tablelen;
 };
 
 struct cdrom_slot {
diff -Naur linux-2.3.99-pre6-5/include/linux/raid/md.h linux-2.3.99-pre6-5-new/include/linux/raid/md.h
--- linux-2.3.99-pre6-5/include/linux/raid/md.h	Thu Mar 23 17:39:32 2000
+++ linux-2.3.99-pre6-5-new/include/linux/raid/md.h	Sat Apr 22 02:41:50 2000
@@ -90,5 +90,4 @@
 
 #define MD_BUG(x...) { printk("md: bug in file %s, line %d\n", __FILE__, __LINE__); md_print_devices(); }
 
-#endif _MD_H
-
+#endif /* _MD_H */
diff -Naur linux-2.3.99-pre6-5/include/linux/raid/md_compatible.h linux-2.3.99-pre6-5-new/include/linux/raid/md_compatible.h
--- linux-2.3.99-pre6-5/include/linux/raid/md_compatible.h	Thu Mar 23 17:36:18 2000
+++ linux-2.3.99-pre6-5-new/include/linux/raid/md_compatible.h	Sat Apr 22 02:41:50 2000
@@ -156,5 +156,5 @@
 
 /* END */
 
-#endif _MD_COMPATIBLE_H
+#endif /* _MD_COMPATIBLE_H */
 
diff -Naur linux-2.3.99-pre6-5/include/linux/raid/md_k.h linux-2.3.99-pre6-5-new/include/linux/raid/md_k.h
--- linux-2.3.99-pre6-5/include/linux/raid/md_k.h	Wed Feb 23 11:13:52 2000
+++ linux-2.3.99-pre6-5-new/include/linux/raid/md_k.h	Sat Apr 22 02:41:50 2000
@@ -339,5 +339,4 @@
 	char name [MAX_DISKNAME_LEN];
 } dev_name_t;
 
-#endif _MD_K_H
-
+#endif /* _MD_K_H */
diff -Naur linux-2.3.99-pre6-5/include/linux/raid/md_p.h linux-2.3.99-pre6-5-new/include/linux/raid/md_p.h
--- linux-2.3.99-pre6-5/include/linux/raid/md_p.h	Tue Feb  8 13:39:00 2000
+++ linux-2.3.99-pre6-5-new/include/linux/raid/md_p.h	Sat Apr 22 02:41:50 2000
@@ -157,5 +157,4 @@
 
 } mdp_super_t;
 
-#endif _MD_P_H
-
+#endif /* _MD_P_H */
diff -Naur linux-2.3.99-pre6-5/include/linux/raid/md_u.h linux-2.3.99-pre6-5-new/include/linux/raid/md_u.h
--- linux-2.3.99-pre6-5/include/linux/raid/md_u.h	Fri Apr 21 21:55:48 2000
+++ linux-2.3.99-pre6-5-new/include/linux/raid/md_u.h	Sat Apr 22 02:41:50 2000
@@ -111,5 +111,4 @@
 	int			max_fault;	/* unused for now */
 } mdu_param_t;
 
-#endif _MD_U_H
-
+#endif /* _MD_U_H */
diff -Naur linux-2.3.99-pre6-5/include/linux/skbuff.h linux-2.3.99-pre6-5-new/include/linux/skbuff.h
--- linux-2.3.99-pre6-5/include/linux/skbuff.h	Fri Apr 21 21:55:48 2000
+++ linux-2.3.99-pre6-5-new/include/linux/skbuff.h	Sat Apr 22 02:41:50 2000
@@ -766,7 +766,7 @@
 	return skb-&gt;data;
 }
 
-extern __inline__ char *__skb_pull(struct sk_buff *skb, unsigned int len)
+extern __inline__ unsigned char *__skb_pull(struct sk_buff *skb, unsigned int len)
 {
 	skb-&gt;len-=len;
 	return 	skb-&gt;data+=len;
<p>
--d6Gm4EdcadzBjdND--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0009.html">Manfred Spraul: "Re: Endless kernel Oops with plain 2.3.99-pre5"</a>
<li> <b>Previous message:</b> <a href="0007.html">Tim Waugh: "Re: [RFC] Flat /lib/modules/`uname -r`"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
