<!-- received="Sun Apr 23 07:26:26 2000 EET DST" -->
<!-- sent="Sun, 23 Apr 2000 01:17:51 -0300" -->
<!-- name="Cesar Eduardo Barros" -->
<!-- email="cesarb@web4u.com.br" -->
<!-- subject="[PATCH] Fix for rtc.c non-atomic mess (try 3)" -->
<!-- id="" -->
<!-- inreplyto="20000422222850.A2927@cesarb.uucp.openprojects.net" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] Fix for rtc.c non-atomic mess (try 3)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Fix for rtc.c non-atomic mess (try 3)</h1>
<b>Cesar Eduardo Barros</b> (<a href="mailto:cesarb@web4u.com.br"><i>cesarb@web4u.com.br</i></a>)<br>
<i>Sun, 23 Apr 2000 01:17:51 -0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#29">[ date ]</a><a href="index.html#29">[ thread ]</a><a href="subject.html#29">[ subject ]</a><a href="author.html#29">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0030.html">Horst von Brand: "Re: [patch-2.3.99pre6-5] Include File Patches"</a>
<li> <b>Previous message:</b> <a href="0028.html">David S. Miller: "Re: [PATCH] f_op-&gt;poll() without lock_kernel()"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
It's me, again. This time I:<br>
<p>
1) Changed mb() to wmb() (which seems the Right Thing to me)<br>
2) Changed irqsave/irqrestore to irq in all places I'm sure (or at least I<br>
   think I am sure) that can't be called with interrupts off.<br>
<p>
Now I just have to figure out if rtc_dropped_irq is called with interrupts off,<br>
on, or unknown.<br>
<p>
I just tested compiling, and probably missed something somewhere in the code.<br>
<p>
<p>
--- linux-2.3.99-pre5/drivers/char/rtc.c	Fri Apr 14 14:31:08 2000<br>
+++ linux-rtcfix3/drivers/char/rtc.c	Sun Apr 23 01:07:10 2000<br>
@@ -40,6 +40,9 @@<br>
  *	1.10b	Andrew Morton: SMP lock fix<br>
  */<br>
 <br>
+/* If someone thinks this is spinlocking too much, feel free to use a single<br>
+ * global /dev/rtc driver spinlock plus the rtc_lock for the CMOS_* stuff */<br>
+<br>
 #define RTC_VERSION		"1.10b"<br>
 <br>
 #define RTC_IRQ 	8	/* Can't see this changing soon.	*/<br>
@@ -124,8 +127,21 @@<br>
 #define RTC_IS_OPEN		0x01	/* means /dev/rtc is in use	*/<br>
 #define RTC_TIMER_ON		0x02	/* missed irq timer active	*/<br>
 <br>
-static atomic_t rtc_status = ATOMIC_INIT(0); /* bitmapped status byte.	*/<br>
+/*<br>
+ * rtc_status is never changed by rtc_interrupt, and ioctl/open/close is<br>
+ * protected by the big kernel lock. However, ioctl can still disable the timer<br>
+ * in rtc_status and then with del_timer after the interrupt has read<br>
+ * rtc_status but before mod_timer is called, which would then reenable the<br>
+ * timer (but you would need to have an awful timing before you'd trip on it)<br>
+ */<br>
+static spinlock_t rtc_irq_timer_lock = SPIN_LOCK_UNLOCKED;<br>
+static unsigned long rtc_status = 0;	/* bitmapped status byte.	*/<br>
 static unsigned long rtc_freq = 0;	/* Current periodic IRQ rate	*/<br>
+/* Having rtc_lock double as rtc_irq_data_lock is evil */<br>
+static spinlock_t rtc_irq_data_lock = SPIN_LOCK_UNLOCKED;<br>
+/* Making this two variables instead of one might make the interrupt a bit<br>
+ * faster (and exchange a spinlock (2 locked mem accesses) by two variable<br>
+ * atomic updates (2 locked mem accesses)). Or maybe slower. Ideas? */<br>
 static unsigned long rtc_irq_data = 0;	/* our output to the world	*/<br>
 <br>
 /*<br>
@@ -151,6 +167,8 @@<br>
 <br>
 static void rtc_interrupt(int irq, void *dev_id, struct pt_regs *regs)<br>
 {<br>
+	unsigned long rtc_data;<br>
+<br>
 	/*<br>
 	 *	Can be an alarm interrupt, update complete interrupt,<br>
 	 *	or a periodic interrupt. We store the status in the<br>
@@ -158,19 +176,29 @@<br>
 	 *	the last read in the remainder of rtc_irq_data.<br>
 	 */<br>
 <br>
+	/* First, ack the interrupt */<br>
 	spin_lock (&amp;rtc_lock);<br>
+	rtc_data = CMOS_READ(RTC_INTR_FLAGS);<br>
+	spin_unlock (&amp;rtc_lock);<br>
+<br>
+	/* Second, avoid a bogus rtc_dropped_irq */<br>
+	spin_lock (&amp;rtc_irq_timer_lock);<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
+		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
+	spin_unlock (&amp;rtc_irq_timer_lock);<br>
+<br>
+	/* Third, update rtc_irq_data */<br>
+	spin_lock (&amp;rtc_irq_data_lock);<br>
 	rtc_irq_data += 0x100;<br>
 	rtc_irq_data &amp;= ~0xff;<br>
-	rtc_irq_data |= (CMOS_READ(RTC_INTR_FLAGS) &amp; 0xF0);<br>
-	spin_unlock (&amp;rtc_lock);<br>
+	rtc_irq_data |= rtc_data &amp; 0xF0;<br>
+	spin_unlock (&amp;rtc_irq_data_lock);<br>
 <br>
+	/* Now do the rest of the actions */<br>
 	wake_up_interruptible(&amp;rtc_wait);	<br>
 <br>
 	if (rtc_async_queue)<br>
 		kill_fasync (rtc_async_queue, SIGIO, POLL_IN);<br>
-<br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)<br>
-		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
 }<br>
 #endif<br>
 <br>
@@ -200,7 +228,18 @@<br>
 <br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		<br>
-	while ((data = xchg(&amp;rtc_irq_data, 0)) == 0) {<br>
+	do {<br>
+		/* First make it right. Then make it fast. Putting this whole<br>
+		 * block within the parentheses of a while would be too<br>
+		 * confusing. And no, xchg() is not the answer. */<br>
+		spin_lock_irq (&amp;rtc_irq_data_lock);<br>
+		data = rtc_irq_data;<br>
+		rtc_irq_data = 0;<br>
+		spin_unlock_irq (&amp;rtc_irq_data_lock);<br>
+<br>
+		if (data != 0)<br>
+			break;<br>
+<br>
 		if (file-&gt;f_flags &amp; O_NONBLOCK) {<br>
 			retval = -EAGAIN;<br>
 			goto out;<br>
@@ -210,7 +249,7 @@<br>
 			goto out;<br>
 		}<br>
 		schedule();<br>
-	}<br>
+	} while (1);<br>
 <br>
 	retval = put_user(data, (unsigned long *)buf); <br>
 	if (!retval)<br>
@@ -227,7 +266,6 @@<br>
 		     unsigned long arg)<br>
 {<br>
 <br>
-	unsigned long flags;<br>
 	struct rtc_time wtime; <br>
 <br>
 	switch (cmd) {<br>
@@ -245,11 +283,12 @@<br>
 	case RTC_PIE_OFF:	/* Mask periodic int. enab. bit	*/<br>
 	{<br>
 		mask_rtc_irq_bit(RTC_PIE);<br>
-		if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON) {<br>
+		spin_lock_irq (&amp;rtc_irq_timer_lock);<br>
+		if (rtc_status &amp; RTC_TIMER_ON) {<br>
+			rtc_status &amp;= ~RTC_TIMER_ON;<br>
 			del_timer(&amp;rtc_irq_timer);<br>
-			atomic_set(&amp;rtc_status,<br>
-				   atomic_read(&amp;rtc_status) &amp; ~RTC_TIMER_ON);<br>
 		}<br>
+		spin_unlock_irq (&amp;rtc_irq_timer_lock);<br>
 		return 0;<br>
 	}<br>
 	case RTC_PIE_ON:	/* Allow periodic ints		*/<br>
@@ -262,11 +301,14 @@<br>
 		if ((rtc_freq &gt; 64) &amp;&amp; (!capable(CAP_SYS_RESOURCE)))<br>
 			return -EACCES;<br>
 <br>
-		if (!(atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)) {<br>
-			atomic_set(&amp;rtc_status,<br>
-				   atomic_read(&amp;rtc_status) | RTC_TIMER_ON);<br>
+		/* No need to spinlock here if RTC_TIMER_ON is only enabled at<br>
+		 * the end. The wmb() makes sure the timer was added before we<br>
+		 * mark it as enabled in the status flags*/<br>
+		if (!(rtc_status &amp; RTC_TIMER_ON)) {<br>
 			rtc_irq_timer.expires = jiffies + HZ/rtc_freq + 2*HZ/100;<br>
 			add_timer(&amp;rtc_irq_timer);<br>
+			wmb ();<br>
+			rtc_status |= RTC_TIMER_ON;<br>
 		}<br>
 		set_rtc_irq_bit(RTC_PIE);<br>
 		return 0;<br>
@@ -320,7 +362,7 @@<br>
 		if (sec &gt;= 60)<br>
 			sec = 0xff;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		if (!(CMOS_READ(RTC_CONTROL) &amp; RTC_DM_BINARY) ||<br>
 		    RTC_ALWAYS_BCD)<br>
 		{<br>
@@ -331,7 +373,7 @@<br>
 		CMOS_WRITE(hrs, RTC_HOURS_ALARM);<br>
 		CMOS_WRITE(min, RTC_MINUTES_ALARM);<br>
 		CMOS_WRITE(sec, RTC_SECONDS_ALARM);<br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 		return 0;<br>
 	}<br>
@@ -346,8 +388,7 @@<br>
 		unsigned char mon, day, hrs, min, sec, leap_yr;<br>
 		unsigned char save_control, save_freq_select;<br>
 		unsigned int yrs;<br>
-		unsigned long flags;<br>
-			<br>
+<br>
 		if (!capable(CAP_SYS_TIME))<br>
 			return -EACCES;<br>
 <br>
@@ -379,11 +420,11 @@<br>
 		if ((yrs -= epoch) &gt; 255)    /* They are unsigned */<br>
 			return -EINVAL;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		if (!(CMOS_READ(RTC_CONTROL) &amp; RTC_DM_BINARY)<br>
<i> 		    || RTC_ALWAYS_BCD) {</i><br>
 			if (yrs &gt; 169) {<br>
-				spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+				spin_unlock_irq(&amp;rtc_lock);<br>
 				return -EINVAL;<br>
 			}<br>
 			if (yrs &gt;= 100)<br>
@@ -412,7 +453,7 @@<br>
 		CMOS_WRITE(save_control, RTC_CONTROL);<br>
 		CMOS_WRITE(save_freq_select, RTC_FREQ_SELECT);<br>
 <br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 		return 0;<br>
 	}<br>
 #ifndef __alpha__<br>
@@ -448,11 +489,11 @@<br>
 <br>
 		rtc_freq = arg;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		val = CMOS_READ(RTC_FREQ_SELECT) &amp; 0xf0;<br>
 		val |= (16 - tmp);<br>
 		CMOS_WRITE(val, RTC_FREQ_SELECT);<br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 		return 0;<br>
 	}<br>
 #else<br>
@@ -489,18 +530,18 @@<br>
 <br>
 static int rtc_open(struct inode *inode, struct file *file)<br>
 {<br>
-	unsigned long flags;<br>
-<br>
-	if(atomic_read(&amp;rtc_status) &amp; RTC_IS_OPEN)<br>
+	/* If someday somebody decides to remove the kernel_lock on open and<br>
+	 * close and ioctl this is gonna get open to races again */<br>
+	if(rtc_status &amp; RTC_IS_OPEN)<br>
 		return -EBUSY;<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
 <br>
-	atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) | RTC_IS_OPEN);<br>
+	rtc_status |= RTC_IS_OPEN;<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_irq_data_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_irq_data_lock);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -512,7 +553,6 @@<br>
 <br>
 static int rtc_release(struct inode *inode, struct file *file)<br>
 {<br>
-	unsigned long flags;<br>
 #ifndef __alpha__<br>
 	/*<br>
 	 * Turn off all interrupts once the device is no longer<br>
@@ -521,19 +561,21 @@<br>
 <br>
 	unsigned char tmp;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	tmp = CMOS_READ(RTC_CONTROL);<br>
 	tmp &amp;=  ~RTC_PIE;<br>
 	tmp &amp;=  ~RTC_AIE;<br>
 	tmp &amp;=  ~RTC_UIE;<br>
 	CMOS_WRITE(tmp, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON) {<br>
-		atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) &amp; ~RTC_TIMER_ON);<br>
+	spin_lock_irq (&amp;rtc_irq_timer_lock);<br>
+	if (rtc_status &amp; RTC_TIMER_ON) {<br>
+		rtc_status &amp;= ~RTC_TIMER_ON;<br>
 		del_timer(&amp;rtc_irq_timer);<br>
 	}<br>
+	spin_unlock_irq (&amp;rtc_irq_timer_lock);<br>
 <br>
 	if (file-&gt;f_flags &amp; FASYNC) {<br>
 		rtc_fasync (-1, file, 0);<br>
@@ -542,23 +584,24 @@<br>
 #endif<br>
 	MOD_DEC_USE_COUNT;<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	/* FIXME: why is this outside the #ifndef __alpha__? */<br>
+	spin_lock_irq (&amp;rtc_irq_data_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
-	atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) &amp; ~RTC_IS_OPEN);<br>
+	spin_unlock_irq (&amp;rtc_irq_data_lock);<br>
+	rtc_status &amp;= ~RTC_IS_OPEN;<br>
 	return 0;<br>
 }<br>
 <br>
 #ifndef __alpha__<br>
 static unsigned int rtc_poll(struct file *file, poll_table *wait)<br>
 {<br>
-	unsigned long l, flags;<br>
+	unsigned long l;<br>
 <br>
 	poll_wait(file, &amp;rtc_wait, wait);<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_irq_data_lock);<br>
 	l = rtc_irq_data;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_irq_data_lock);<br>
 <br>
 	if (l != 0)<br>
 		return POLLIN | POLLRDNORM;<br>
@@ -591,7 +634,6 @@<br>
 <br>
 static int __init rtc_init(void)<br>
 {<br>
-	unsigned long flags;<br>
 #ifdef __alpha__<br>
 	unsigned int year, ctrl;<br>
 	unsigned long uip_watchdog;<br>
@@ -662,10 +704,10 @@<br>
 		while (jiffies - uip_watchdog &lt; 2*HZ/100)<br>
 			barrier();<br>
 	<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	year = CMOS_READ(RTC_YEAR);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	<br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 		BCD_TO_BIN(year);       /* This should never happen... */<br>
@@ -683,10 +725,10 @@<br>
 #ifndef __alpha__<br>
 	init_timer(&amp;rtc_irq_timer);<br>
 	rtc_irq_timer.function = rtc_dropped_irq;<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	/* Initialize periodic freq. to CMOS reset default, which is 1024Hz */<br>
 	CMOS_WRITE(((CMOS_READ(RTC_FREQ_SELECT) &amp; 0xF0) | 0x06), RTC_FREQ_SELECT);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 #endif<br>
 	rtc_freq = 1024;<br>
 <br>
@@ -698,9 +740,14 @@<br>
 static void __exit rtc_exit (void)<br>
 {<br>
 	/* interrupts and maybe timer disabled at this point by rtc_release */<br>
+	/* FIXME: Maybe??? */<br>
 <br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)<br>
+#if 0<br>
+	spin_lock_irqsave (&amp;rtc_irq_timer_lock, flags);<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
 		del_timer(&amp;rtc_irq_timer);<br>
+	spin_unlock_irqrestore (&amp;rtc_irq_timer_lock, flags);<br>
+#endif<br>
 <br>
 	remove_proc_entry ("driver/rtc", NULL);<br>
 	misc_deregister(&amp;rtc_dev);<br>
@@ -734,16 +781,38 @@<br>
 <br>
 static void rtc_dropped_irq(unsigned long data)<br>
 {<br>
-	unsigned long flags;<br>
+	unsigned long rtc_data;<br>
+	unsigned long flags;	/* FIXME are we on cli() or not? */<br>
 <br>
 	printk(KERN_INFO "rtc: lost some interrupts at %ldHz.\n", rtc_freq);<br>
-	mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	/* First, ack the (missed) interrupt */<br>
+	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	rtc_data = CMOS_READ(RTC_INTR_FLAGS);<br>
+	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+<br>
+	/* Second, avoid a bogus rtc_dropped_irq */<br>
+	spin_lock_irqsave (&amp;rtc_irq_timer_lock, flags);<br>
+	/* Just in case someone disabled the timer from behind our back... */<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
+		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
+	spin_unlock_irqrestore (&amp;rtc_irq_timer_lock, flags);<br>
+<br>
+	/* Third, update rtc_irq_data */<br>
+	/* FIXME: what happens if the real interrupt comes before we get here?<br>
+	 * The order of the status would get a bit missed up... Maybe I should<br>
+	 * ack within this block? */<br>
+	spin_lock_irqsave(&amp;rtc_irq_data_lock, flags);<br>
 	rtc_irq_data += ((rtc_freq/HZ)&lt;&lt;8);<br>
 	rtc_irq_data &amp;= ~0xff;<br>
-	rtc_irq_data |= (CMOS_READ(RTC_INTR_FLAGS) &amp; 0xF0);	/* restart */<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	rtc_irq_data |= rtc_data &amp; 0xF0;<br>
+	spin_unlock_irqrestore(&amp;rtc_irq_data_lock, flags);<br>
+<br>
+	/* Now we have new data */<br>
+	wake_up_interruptible(&amp;rtc_wait);<br>
+<br>
+	if (rtc_async_queue)<br>
+		kill_fasync (rtc_async_queue, SIGIO, POLL_IN);<br>
 }<br>
 #endif<br>
 <br>
@@ -758,12 +827,11 @@<br>
 	char *p;<br>
 	struct rtc_time tm;<br>
 	unsigned char batt, ctrl;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	batt = CMOS_READ(RTC_VALID) &amp; RTC_VRT;<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	p = buf;<br>
 <br>
@@ -843,21 +911,20 @@<br>
 /*<br>
  * Returns true if a clock update is in progress<br>
  */<br>
+/* FIXME shouldn't this be above rtc_init to inline it? */<br>
 static inline unsigned char rtc_is_updating(void)<br>
 {<br>
-	unsigned long flags;<br>
 	unsigned char uip;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	uip = (CMOS_READ(RTC_FREQ_SELECT) &amp; RTC_UIP);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	return uip;<br>
 }<br>
 <br>
 static void get_rtc_time(struct rtc_time *rtc_tm)<br>
 {<br>
-<br>
-	unsigned long flags, uip_watchdog = jiffies;<br>
+	unsigned long uip_watchdog = jiffies;<br>
 	unsigned char ctrl;<br>
 <br>
 	/*<br>
@@ -880,7 +947,7 @@<br>
 	 * RTC has RTC_DAY_OF_WEEK, we ignore it, as it is only updated<br>
 	 * by the RTC when initially set to a non-zero value.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	rtc_tm-&gt;tm_sec = CMOS_READ(RTC_SECONDS);<br>
 	rtc_tm-&gt;tm_min = CMOS_READ(RTC_MINUTES);<br>
 	rtc_tm-&gt;tm_hour = CMOS_READ(RTC_HOURS);<br>
@@ -888,7 +955,7 @@<br>
 	rtc_tm-&gt;tm_mon = CMOS_READ(RTC_MONTH);<br>
 	rtc_tm-&gt;tm_year = CMOS_READ(RTC_YEAR);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 	{<br>
@@ -912,19 +979,18 @@<br>
 <br>
 static void get_rtc_alm_time(struct rtc_time *alm_tm)<br>
 {<br>
-	unsigned long flags;<br>
 	unsigned char ctrl;<br>
 <br>
 	/*<br>
 	 * Only the values that we read from the RTC are set. That<br>
 	 * means only tm_hour, tm_min, and tm_sec.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	alm_tm-&gt;tm_sec = CMOS_READ(RTC_SECONDS_ALARM);<br>
 	alm_tm-&gt;tm_min = CMOS_READ(RTC_MINUTES_ALARM);<br>
 	alm_tm-&gt;tm_hour = CMOS_READ(RTC_HOURS_ALARM);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 	{<br>
@@ -948,28 +1014,34 @@<br>
 static void mask_rtc_irq_bit(unsigned char bit)<br>
 {<br>
 	unsigned char val;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	val = CMOS_READ(RTC_CONTROL);<br>
 	val &amp;=  ~bit;<br>
 	CMOS_WRITE(val, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
+<br>
+	/* FIXME is moving this outside the rtc_lock ok? */<br>
+	spin_lock_irq (&amp;rtc_irq_data_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_irq_data_lock);<br>
 }<br>
 <br>
 static void set_rtc_irq_bit(unsigned char bit)<br>
 {<br>
 	unsigned char val;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	val = CMOS_READ(RTC_CONTROL);<br>
 	val |= bit;<br>
 	CMOS_WRITE(val, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
+<br>
+	/* FIXME is doing this outside the rtc_lock ok? */<br>
+	spin_lock_irq (&amp;rtc_irq_data_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_irq_data_lock);<br>
 }<br>
 #endif<br>
<p>
<pre>
-- 
Cesar Eduardo Barros
<a href="mailto:cesarb@web4u.com.br">cesarb@web4u.com.br</a>
<a href="mailto:cesarb@dcc.ufrj.br">cesarb@dcc.ufrj.br</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0030.html">Horst von Brand: "Re: [patch-2.3.99pre6-5] Include File Patches"</a>
<li> <b>Previous message:</b> <a href="0028.html">David S. Miller: "Re: [PATCH] f_op-&gt;poll() without lock_kernel()"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
