<!-- received="Sun Apr 23 21:53:49 2000 EET DST" -->
<!-- sent="Sun, 23 Apr 2000 19:49:26 +0100 (BST)" -->
<!-- name="Tigran Aivazian" -->
<!-- email="tigran@veritas.com" -->
<!-- subject="[patch-2.3.99-pre6-5] __put_unused_fd()/put_unused_fd() improved" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.21.0004221659230.632-100000@saturn.homenet" -->
<title>Linux-kernel mailing list archive 2000-17,: [patch-2.3.99-pre6-5] __put_unused_fd()/put_unused_fd() improved</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch-2.3.99-pre6-5] __put_unused_fd()/put_unused_fd() improved</h1>
<b>Tigran Aivazian</b> (<a href="mailto:tigran@veritas.com"><i>tigran@veritas.com</i></a>)<br>
<i>Sun, 23 Apr 2000 19:49:26 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#79">[ date ]</a><a href="index.html#79">[ thread ]</a><a href="subject.html#79">[ subject ]</a><a href="author.html#79">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0080.html">Dunlap, Randy: "RE: Announce: modutils 2.3.11 is available - the debugger's helpe"</a>
<li> <b>Previous message:</b> <a href="0078.html">Richard Gooch: "Re: PROBLEM: Linux SCSI Reset With Tekram DC390-U2W and NCR/SYM"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
I have redone the previous patch "do_close optimization" in a<br>
hopefully better way - namely, adding a 'struct task_struct *tsk' argument<br>
to __put_unused_fd and making put_unused_fd(fd) call<br>
__put_unused_fd(current, fd). I think it is a good idea to allow things<br>
like __put_unused_fd() (see patch below) to be called outside of 'current'<br>
context, e.g. when you want to mess with some other process' descriptors.<br>
<p>
Strictly speaking there should be four things:<br>
<p>
__put_unused_fd_task(tsk, fd)<br>
__put_unused_fd(fd)<br>
put_unused_fd_task(tsk, fd)<br>
put_unused_fd(fd)<br>
<p>
but only two seem immediately useful so I did not implement the other two.<br>
<p>
Regards,<br>
Tigran<br>
<p>
--- linux/include/linux/fs.h	Sat Apr 22 10:30:25 2000<br>
+++ close/include/linux/fs.h	Sun Apr 23 19:34:59 2000<br>
@@ -25,6 +25,7 @@<br>
 #include &lt;asm/bitops.h&gt;<br>
 <br>
 struct poll_table_struct;<br>
+struct task_struct; /* for __put_unused_fd */<br>
 <br>
 <br>
 /*<br>
@@ -848,7 +849,8 @@<br>
 extern int do_close(unsigned int, int);		/* yes, it's really unsigned */<br>
 extern int do_truncate(struct dentry *, loff_t start);<br>
 extern int get_unused_fd(void);<br>
-extern void put_unused_fd(unsigned int);<br>
+extern void __put_unused_fd(struct task_struct *, unsigned int); /* locked by the caller */<br>
+extern void put_unused_fd(unsigned int);                         /* locked internally */<br>
 <br>
 extern struct file *filp_open(const char *, int, int);<br>
 extern struct file * dentry_open(struct dentry *, struct vfsmount *, int);<br>
--- linux/fs/open.c	Sat Apr 22 10:30:24 2000<br>
+++ close/fs/open.c	Sun Apr 23 19:44:55 2000<br>
@@ -756,12 +756,17 @@<br>
 	return error;<br>
 }<br>
 <br>
+inline void __put_unused_fd(struct task_struct *tsk, unsigned int fd)<br>
+{<br>
+	FD_CLR(fd, tsk-&gt;files-&gt;open_fds);<br>
+	if (fd &lt; tsk-&gt;files-&gt;next_fd)<br>
+		tsk-&gt;files-&gt;next_fd = fd;<br>
+}<br>
+<br>
 inline void put_unused_fd(unsigned int fd)<br>
 {<br>
 	write_lock(&amp;current-&gt;files-&gt;file_lock);<br>
-	FD_CLR(fd, current-&gt;files-&gt;open_fds);<br>
-	if (fd &lt; current-&gt;files-&gt;next_fd)<br>
-		current-&gt;files-&gt;next_fd = fd;<br>
+	__put_unused_fd(current, fd);<br>
 	write_unlock(&amp;current-&gt;files-&gt;file_lock);<br>
 }<br>
 <br>
@@ -852,9 +857,9 @@<br>
 	if (!filp)<br>
 		goto out_unlock;<br>
 	FD_CLR(fd, files-&gt;close_on_exec);<br>
-	write_unlock(&amp;files-&gt;file_lock);<br>
 	if (release)<br>
-		put_unused_fd(fd);<br>
+		__put_unused_fd(current, fd);<br>
+	write_unlock(&amp;files-&gt;file_lock);<br>
 	lock_kernel();<br>
 	error = filp_close(filp, files);<br>
 	unlock_kernel();<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0080.html">Dunlap, Randy: "RE: Announce: modutils 2.3.11 is available - the debugger's helpe"</a>
<li> <b>Previous message:</b> <a href="0078.html">Richard Gooch: "Re: PROBLEM: Linux SCSI Reset With Tekram DC390-U2W and NCR/SYM"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
