<!-- received="Mon Apr 24 17:39:00 2000 EET DST" -->
<!-- sent="Mon, 24 Apr 2000 16:31:45 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="Re: lockless poll() (was Re: namei() query)" -->
<!-- id="" -->
<!-- inreplyto="lockless poll() (was Re: namei() query)" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: lockless poll() (was Re: namei() query)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: lockless poll() (was Re: namei() query)</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Mon, 24 Apr 2000 16:31:45 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#169">[ date ]</a><a href="index.html#169">[ thread ]</a><a href="subject.html#169">[ subject ]</a><a href="author.html#169">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0170.html">Ville Herva: "Re: 2.2.15pre12: inode leak or something, maybe smbfs related"</a>
<li> <b>Previous message:</b> <a href="0168.html">Benno Senoner: "Re: IDE drives and unmaskirq"</a>
<li> <b>Maybe in reply to:</b> <a href="0151.html">kumon@flab.fujitsu.co.jp: "lockless poll() (was Re: namei() query)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0208.html">willy@thepuffingroup.com: "Re: lockless poll() (was Re: namei() query)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------650184F092A0A7D6F95FF4BF<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Searching for SMP races transforms your brain to jelly:<br>
<p>
We should start with the obvious optimization:<br>
kmalloc(PAGE_SIZE,GFP_KERNEL) is vastly faster than<br>
get_free_page(GFP_KERNEL).<br>
<p>
I replaced getname()/putname() with kmalloc, and now stat("/bin") is ~25<br>
% faster (from 2241 down to 1638 cpu ticks)<br>
<p>
As an second optimization, we might try to optimize kmalloc for fixed<br>
size allocations:<br>
with __builtin_constant_p() we could directly allocate from the correct<br>
cs_cachep without the loop in kmalloc().<br>
<p>
<pre>
--
	Manfred
--------------650184F092A0A7D6F95FF4BF
Content-Type: text/plain; charset=us-ascii;
 name="patch-kmalloc"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-kmalloc"
<p>
--- 2.3/include/linux/fs.h	Wed Apr 12 15:00:31 2000
+++ build-2.3/include/linux/fs.h	Mon Apr 24 15:53:10 2000
@@ -847,8 +847,11 @@
 extern struct file * dentry_open(struct dentry *, struct vfsmount *, int);
 extern int filp_close(struct file *, fl_owner_t id);
 extern char * getname(const char *);
-#define __getname()	((char *) __get_free_page(GFP_KERNEL))
-#define putname(name)	free_page((unsigned long)(name))
+/* forward declarations */
+extern void *kmalloc(size_t, int);
+extern void kfree(const void *);
+#define __getname()	((char *) kmalloc(PAGE_SIZE, GFP_KERNEL))
+#define putname(name)	kfree((name))
 
 enum {BDEV_FILE, BDEV_SWAP, BDEV_FS, BDEV_RAW};
 extern void kill_fasync(struct fasync_struct *, int, int);
<p>
<p>
<p>
<p>
--------------650184F092A0A7D6F95FF4BF--
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0170.html">Ville Herva: "Re: 2.2.15pre12: inode leak or something, maybe smbfs related"</a>
<li> <b>Previous message:</b> <a href="0168.html">Benno Senoner: "Re: IDE drives and unmaskirq"</a>
<li> <b>Maybe in reply to:</b> <a href="0151.html">kumon@flab.fujitsu.co.jp: "lockless poll() (was Re: namei() query)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0208.html">willy@thepuffingroup.com: "Re: lockless poll() (was Re: namei() query)"</a>
<!-- reply="end" -->
</ul>
</font></body>
