<!-- received="Mon Apr 24 21:39:56 2000 EET DST" -->
<!-- sent="Mon, 24 Apr 2000 20:25:43 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="[PATCH] optimization for fixed size kmalloc()" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] optimization for fixed size kmalloc()</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] optimization for fixed size kmalloc()</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Mon, 24 Apr 2000 20:25:43 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#207">[ date ]</a><a href="index.html#207">[ thread ]</a><a href="subject.html#207">[ subject ]</a><a href="author.html#207">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0208.html">willy@thepuffingroup.com: "Re: lockless poll() (was Re: namei() query)"</a>
<li> <b>Previous message:</b> <a href="0206.html">Nerijus: "CDRW IDE, IDE-SCSI"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------3D62E810114C1D3CF03200DF<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Most kmalloc calls are fixed size - we could use the same optimization<br>
that's used by put_user()/get_user().<br>
<p>
Which benchmarks are useful for testing such a patch?<br>
<p>
<p>
<pre>
--
	Manfred
--------------3D62E810114C1D3CF03200DF
Content-Type: text/plain; charset=us-ascii;
 name="patch-km"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-km"
<p>
// $Header$
// Kernel Version:
//  VERSION = 2
//  PATCHLEVEL = 3
//  SUBLEVEL = 99
//  EXTRAVERSION = -pre5
--- 2.3/kernel/ksyms.c	Wed Apr 12 15:00:33 2000
+++ build-2.3/kernel/ksyms.c	Mon Apr 24 19:42:22 2000
@@ -107,7 +107,8 @@
 EXPORT_SYMBOL(kmem_cache_shrink);
 EXPORT_SYMBOL(kmem_cache_alloc);
 EXPORT_SYMBOL(kmem_cache_free);
-EXPORT_SYMBOL(kmalloc);
+EXPORT_SYMBOL(cache_sizes);
+EXPORT_SYMBOL(__kmalloc);
 EXPORT_SYMBOL(kfree);
 EXPORT_SYMBOL(kfree_s);
 EXPORT_SYMBOL(vmalloc);
--- 2.3/mm/slab.c	Wed Apr 12 15:00:33 2000
+++ build-2.3/mm/slab.c	Mon Apr 24 19:38:59 2000
@@ -324,13 +324,8 @@
 #define	SLAB_SET_PAGE_SLAB(pg,x)   ((pg)-&gt;list.prev = (struct list_head *)(x))
 #define	SLAB_GET_PAGE_SLAB(pg)     ((kmem_slab_t *)(pg)-&gt;list.prev)
 
-/* Size description struct for general caches. */
-typedef struct cache_sizes {
-	size_t		 cs_size;
-	kmem_cache_t	*cs_cachep;
-} cache_sizes_t;
-
-static cache_sizes_t cache_sizes[] = {
+/* these values are hardcoded in &lt;linux/kmalloc.h&gt; */
+cache_sizes_t cache_sizes[] = {
 #if	PAGE_SIZE == 4096
 	{  32,		NULL},
 #endif
@@ -1680,7 +1675,7 @@
 }
 
 void *
-kmalloc(size_t size, int flags)
+__kmalloc(size_t size, int flags)
 {
 	cache_sizes_t	*csizep = cache_sizes;
 
diff -urN --exclude autoconf.h --exclude wait.h --exclude gdb.h --exclude modversions.h --exclude version.h --exclude compile.h 2.3/include/linux/kmalloc.h build-2.3/include/linux/kmalloc.h
--- 2.3/include/linux/kmalloc.h	Thu Jan  1 01:00:00 1970
+++ build-2.3/include/linux/kmalloc.h	Mon Apr 24 20:07:05 2000
@@ -0,0 +1,64 @@
+/*
+ * linux/mm/slab.h
+ * Written by Manfred Spraul, 2000
+ * (<a href="mailto:manfreds@colorfullife.com">manfreds@colorfullife.com</a>)
+ */
+
+#ifndef _LINUX_KMALLOC_H
+#define	_LINUX_KMALLOC_H
+
+#ifdef __KERNEL__
+
+#include &lt;asm/page.h&gt;
+extern void *__kmalloc(size_t, int);
+extern void kfree(const void *);
+extern void kfree_s(const void *, size_t);
+
+/* Size description struct for general caches. */
+typedef struct cache_sizes {
+	size_t		 cs_size;
+	kmem_cache_t	*cs_cachep;
+} cache_sizes_t;
+
+extern cache_sizes_t cache_sizes[];
+extern void __you_cannot_kmalloc_more_than_128_kilo_bytes(void);
+
+static inline void* __constant_kmalloc(size_t size, int flags)
+{
+#if	PAGE_SIZE == 4096
+	if(size &lt; 32)
+		return kmem_cache_alloc(cache_sizes[0].cs_cachep, flags);
+#define KSHIFT 0
+#else
+#define KSHIFT 1
+#endif
+#define FIXED_ALLOC(len,off) \
+	if(size &lt; len) \
+		return kmem_cache_alloc(cache_sizes[off-KSHIFT].cs_cachep, flags)
+	FIXED_ALLOC(64,1);
+	FIXED_ALLOC(128,2);
+	FIXED_ALLOC(256,3);
+	FIXED_ALLOC(512,4);
+	FIXED_ALLOC(1024,5);
+	FIXED_ALLOC(2048,6);
+	FIXED_ALLOC(4096,7);
+	FIXED_ALLOC(8192,8);
+	FIXED_ALLOC(16384,9);
+	FIXED_ALLOC(32768,10);
+	FIXED_ALLOC(65536,11);
+	FIXED_ALLOC(131072,12);
+#undef FIXED_ALLOC
+#undef KSHIFT
+	__you_cannot_kmalloc_more_than_128_kilo_bytes();
+	return NULL;
+}
+
+extern void *kmem_cache_alloc(kmem_cache_t *, int);
+
+#define kmalloc(size, flags)				\
+	(__builtin_constant_p(size) ?			\
+	 __constant_kmalloc((size),(flags)) :	\
+	 __kmalloc(size,flags))
+
+#endif /* __KERNEL__ */
+#endif	/* _LINUX_KMALLOC_H */
diff -urN --exclude autoconf.h --exclude wait.h --exclude gdb.h --exclude modversions.h --exclude version.h --exclude compile.h 2.3/include/linux/slab.h build-2.3/include/linux/slab.h
--- 2.3/include/linux/slab.h	Sat Feb 12 20:42:24 2000
+++ build-2.3/include/linux/slab.h	Mon Apr 24 20:10:20 2000
@@ -56,9 +56,7 @@
 extern void *kmem_cache_alloc(kmem_cache_t *, int);
 extern void kmem_cache_free(kmem_cache_t *, void *);
 
-extern void *kmalloc(size_t, int);
-extern void kfree(const void *);
-extern void kfree_s(const void *, size_t);
+#include &lt;linux/kmalloc.h&gt;
 
 extern void kmem_cache_reap(int);
 extern int get_slabinfo(char *);
<p>
--------------3D62E810114C1D3CF03200DF--
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0208.html">willy@thepuffingroup.com: "Re: lockless poll() (was Re: namei() query)"</a>
<li> <b>Previous message:</b> <a href="0206.html">Nerijus: "CDRW IDE, IDE-SCSI"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
