<!-- received="Tue Apr 25 04:40:32 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 02:31:25 +0100 (BST)" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="Re: Linux Jobs as of 2.3.99pre6-5" -->
<!-- id="E12juCF-0006R0-00@the-village.bc.nu" -->
<!-- inreplyto="8e2s4o$4ti$1@penguin.transmeta.com" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: Linux Jobs as of 2.3.99pre6-5</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Linux Jobs as of 2.3.99pre6-5</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Tue, 25 Apr 2000 02:31:25 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#249">[ date ]</a><a href="index.html#249">[ thread ]</a><a href="subject.html#249">[ subject ]</a><a href="author.html#249">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0250.html">Simon Kirby: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<li> <b>Previous message:</b> <a href="0248.html">Saxena, Sunil: "Re: "movb" for spin-unlock (was Re: namei() query)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0254.html">Linus Torvalds: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<li> <b>Reply:</b> <a href="0254.html">Linus Torvalds: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; I've never been able to verify this. As far as I know, the kernel</i><br>
<i>&gt; handles %fs and %gs just right. You should re-check, and maybe try to</i><br>
<i>&gt; make a test-case for what you think is incorrect behaviour..</i><br>
<p>
Ulrich provided one a while back. I've not retried it on 2.3.99pre but<br>
I include it below<br>
<p>
<p>
#include &lt;assert.h&gt;<br>
#include &lt;fcntl.h&gt;<br>
#include &lt;sched.h&gt;<br>
#include &lt;signal.h&gt;<br>
#include &lt;unistd.h&gt;<br>
#include &lt;sys/poll.h&gt;<br>
#include &lt;sys/wait.h&gt;<br>
<p>
char seg[4096];<br>
char buf[16386];<br>
<p>
<p>
#define show_gs(c) \<br>
  { \<br>
    char buf[10]; \<br>
    int gs; \<br>
    asm("movl %%gs,%0":"=g"(gs)); \<br>
    buf[0]='g'; \<br>
    buf[1]='s'; \<br>
    buf[2]=c; \<br>
    buf[3]='='; \<br>
    buf[4]=((gs&gt;&gt;4)&amp;0xf)&gt;9?'a'+((gs&gt;&gt;4)&amp;0x0f)-10:'0'+((gs&gt;&gt;4)&amp;0xf); \<br>
    buf[5]=(gs&amp;0xf)&gt;9?'a'+(gs&amp;0xf)-10:'0'+(gs&amp;0xf); \<br>
    buf[6]='\n'; \<br>
    write(2,buf,7); \<br>
  }<br>
<p>
<p>
struct modify_ldt_ldt_s<br>
{<br>
  unsigned int entry_number;<br>
  unsigned long int base_addr;<br>
  unsigned int limit;<br>
  unsigned int seg_32bit:1;<br>
  unsigned int contents:2;<br>
  unsigned int read_exec_only:1;<br>
  unsigned int limit_in_pages:1;<br>
  unsigned int seg_not_present:1;<br>
  unsigned int useable:1;<br>
  unsigned int empty:25;<br>
};<br>
<p>
<p>
static int<br>
fn (void *arg)<br>
{<br>
  sleep (1);<br>
  _exit (0);<br>
}<br>
<p>
<p>
void<br>
catch (int sig)<br>
{<br>
  unsigned char c;<br>
<p>
#if 0<br>
  asm ("movb %%gs:0,%b0" : "=r" (c));<br>
<p>
  assert (c == 0);<br>
#endif<br>
}<br>
<p>
<p>
<p>
int<br>
main (void)<br>
{<br>
  int fd = open ("/dev/null", O_RDONLY);<br>
  struct pollfd ufd;<br>
  struct modify_ldt_ldt_s ldt_entry;<br>
  struct sigaction sa;<br>
<p>
  ufd.fd = fd;<br>
  ufd.events = POLLIN;<br>
<p>
  ldt_entry.entry_number = 0;<br>
  ldt_entry.base_addr = (long int) seg;<br>
  ldt_entry.limit = sizeof (seg);<br>
  ldt_entry.seg_32bit = 1;<br>
  ldt_entry.contents = 0;<br>
  ldt_entry.read_exec_only = 0;<br>
  ldt_entry.limit_in_pages = 0;<br>
  ldt_entry.seg_not_present = 0;<br>
  ldt_entry.useable = 1;<br>
  ldt_entry.empty = 0;<br>
<p>
  modify_ldt (1, &amp;ldt_entry, sizeof (ldt_entry));<br>
<p>
  asm volatile ("movw %w0,%%gs" : : "r" (7));<br>
<p>
<p>
  sa.sa_handler = catch;<br>
  sa.sa_flags = 9;<br>
  sigemptyset (&amp;sa.sa_mask);<br>
  sigaddset (&amp;sa.sa_mask, SIGCHLD);<br>
  sigaction (SIGCHLD, &amp;sa, NULL);<br>
<p>
  while (1)<br>
    {<br>
      unsigned char c;<br>
      int s;<br>
      int p;<br>
<p>
      show_gs ('1');<br>
<p>
      p = clone (fn, buf + sizeof buf,<br>
	         CLONE_VM | CLONE_FS | CLONE_FILES | CLONE_SIGHAND | SIGRTMIN,<br>
	         NULL);<br>
<p>
      show_gs ('2');<br>
<p>
      poll (&amp;ufd, 1, 2000);<br>
<p>
      show_gs ('3');<br>
<p>
      asm ("movb %%gs:0,%b0" : "=r" (c));<br>
<p>
      show_gs ('4');<br>
<p>
      if (c != 0)<br>
        abort ();<br>
<p>
      waitpid (p, &amp;s, WNOHANG | __WCLONE);<br>
<p>
      show_gs ('5');<br>
    }<br>
<p>
  return 0;<br>
}<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0250.html">Simon Kirby: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<li> <b>Previous message:</b> <a href="0248.html">Saxena, Sunil: "Re: "movb" for spin-unlock (was Re: namei() query)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0254.html">Linus Torvalds: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<li> <b>Reply:</b> <a href="0254.html">Linus Torvalds: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<!-- reply="end" -->
</ul>
</font></body>
