<!-- received="Tue Apr 25 18:09:43 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 08:04:13 -0700" -->
<!-- name="Iain McClatchie" -->
<!-- email="iain@10xinc.com" -->
<!-- subject="wchar_t mismatch between Xlib.h and stddef.h" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: wchar_t mismatch between Xlib.h and stddef.h</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>wchar_t mismatch between Xlib.h and stddef.h</h1>
<b>Iain McClatchie</b> (<a href="mailto:iain@10xinc.com"><i>iain@10xinc.com</i></a>)<br>
<i>Tue, 25 Apr 2000 08:04:13 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#336">[ date ]</a><a href="index.html#336">[ thread ]</a><a href="subject.html#336">[ subject ]</a><a href="author.html#336">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0337.html">Sergey Kubushin: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<li> <b>Previous message:</b> <a href="0335.html">Jeff Garzik: "ppro config.in patch..."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
GCC-2.95.2<br>
Xfree86 3.3.5<br>
RedHat 6.1 on an SMP PII<br>
<p>
While attempting to compile Magic-6.5.1, I get the following error:<br>
gcc `cat ../misc/CFLAGS` `cat ../misc/DFLAGS` -I. -I../include<br>
-I/usr/openwin/include -c grX11su1.c<br>
In file included from grX11su1.c:47:<br>
/usr/X11R6/include/X11/Xlib.h:83: conflicting types for `wchar_t'<br>
/usr/local/lib/gcc-lib/i686-pc-linux-gnu/2.95.2/include/stddef.h:255: previous<br>
declaration of `wchar_t'<br>
<p>
The comments around the definition in stddef.h seem significant:<br>
<p>
#ifndef X_WCHAR<br>
#include &lt;stddef.h&gt;<br>
#else<br>
#ifdef __EMX__<br>
#include &lt;stdlib.h&gt;<br>
#else<br>
#ifdef DGUX<br>
/* DG/ux needs this always! */<br>
#include &lt;stddef.h&gt;<br>
#else<br>
/* replace this with #include or typedef appropriate for your system */<br>
typedef unsigned long wchar_t;<br>
#endif<br>
#endif<br>
#endif<br>
<p>
I'm pulling in that last unsigned long definition.<br>
<p>
It's clear to me what _should_ be happening: stddef.h should define<br>
wchar_t, and Xlib.h should notice that it's already defined and<br>
leave it alone.<br>
<p>
CFLAGS, above, defines the macros SYSV and linux, to say what<br>
platform is being compiled for.  This causes lots of the right<br>
things to happen, but SYSV also causes Xosdefs.h to define<br>
X_NOT_STDC_ENV (the logic is that defined(i386) &amp;&amp; defined( SYSV )<br>
&amp;&amp; !defined( ISC ) &amp;&amp; !defined( SCO ) leads to X_NOT_STDC_ENV).<br>
<p>
Xlib.h defines X_WCHAR in response to X_NOT_STDC_ENV, which then<br>
causes it to typedef wchar_t in the above code.<br>
<p>
So that makes me think that SYSV should be turned off for Linux<br>
compilations.  But that doesn't sound right... is it?  The<br>
alternative is to hack Xlib.h -- which isn't something I really<br>
want to be doing.<br>
<p>
I also get lots of other problems attempting to get a clean build.<br>
In particular, it appears &lt;string.h&gt; gets included after many of<br>
the magic-specific includes, which leads to macro conflicts.  There<br>
are also some issues with string.h not being included when it should.<br>
I'd like to help fix these problems if I could get some guidance on<br>
the right kind of fix.<br>
<p>
-Iain McClatchie                            650-364-0520 voice<br>
<a href="http://www.10xinc.com">http://www.10xinc.com</a>                       650-364-0530 FAX<br>
<a href="mailto:iain@10xinc.com">iain@10xinc.com</a>                             650-906-8832 cell<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0337.html">Sergey Kubushin: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<li> <b>Previous message:</b> <a href="0335.html">Jeff Garzik: "ppro config.in patch..."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
