<!-- received="Tue Apr 25 22:49:15 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 14:59:50 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@mandrakesoft.com" -->
<!-- subject="Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing" -->
<!-- id="" -->
<!-- inreplyto="[PATCH] 2.3.99-pre6-3+  VM rebalancing" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@mandrakesoft.com"><i>jgarzik@mandrakesoft.com</i></a>)<br>
<i>Tue, 25 Apr 2000 14:59:50 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#394">[ date ]</a><a href="index.html#394">[ thread ]</a><a href="subject.html#394">[ subject ]</a><a href="author.html#394">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0395.html">Jamie Lokier: "Re: "movb" for spin-unlock (was Re: namei() query)"</a>
<li> <b>Previous message:</b> <a href="0393.html">kuznet@ms2.inr.ac.ru: "Re: /proc/net/arp silliness"</a>
<li> <b>Maybe in reply to:</b> <a href="0022.html">Rik van Riel: "[PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0473.html">David S. Miller: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------29A5383F0B1F58900684AA9C<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Simon Kirby wrote:<br>
<i>&gt; Hrmm.. I guess the ideal solution would be that swappable pages would age</i><br>
<i>&gt; just like cache pages and everything else?  Then, if a particular</i><br>
<i>&gt; program's page hasn't been accessed for 60 seconds and there is nothing</i><br>
<i>&gt; older in the page cahce, it would swap out...</i><br>
<p>
Again a policy decision...  I think such a feature should be present and<br>
enabled by default, but there are some people who would prefer that<br>
their configuration not do this, or would prefer that the timeout for<br>
old pages be far longer than 60 seconds.<br>
<p>
The main reason is there is a noticeable performance increase when you<br>
have so much more physical memory available for page and buffer cache. <br>
I manually force this behavior now with the attached 'fillmem' program,<br>
usually before a big compile on an otherwise quiet machine.<br>
<p>
	Jeff<br>
<p>
<p>
<p>
<p>
<p>
<pre>
-- 
Jeff Garzik              | Nothing cures insomnia like the
Building 1024            | realization that it's time to get up.
MandrakeSoft, Inc.       |        -- random fortune
--------------29A5383F0B1F58900684AA9C
Content-Type: text/plain; charset=us-ascii;
 name="fillmem.c"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="fillmem.c"
<p>
#include &lt;stdio.h&gt;
#include &lt;stdlib.h&gt;
#include &lt;time.h&gt;
#include &lt;string.h&gt;
<p>
#define MEGS 140
#define MEG (1024 * 1024)
<p>
int main (int argc, char *argv[])
{
	void **data;
	int i, r;
	size_t megs = MEGS;
<p>
	if ((argc &gt;= 2) &amp;&amp; (atoi(argv[1]) &gt; 0))
		megs = atoi(argv[1]);
<p>
	data = malloc (megs * sizeof (void*));
	if (!data) abort();
<p>
	memset (data, 0, megs * sizeof (void*));
<p>
	srand(time(NULL));
<p>
	for (i = 0; i &lt; megs; i++) {
		data[i] = malloc(MEG);
		memset (data[i], i, MEG);
		printf("malloc/memset %03d/%03lu\n", i+1, megs);
	}
	for (i = megs - 1; i &gt;= 0; i--) {
		r = rand() % 200;
		memset (data[i], r, MEG);
		printf("memset #2 %03d/%03lu = %d\n", i+1, megs, r);
	}
	printf("done\n");
	return 0;
}
<p>
--------------29A5383F0B1F58900684AA9C--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0395.html">Jamie Lokier: "Re: "movb" for spin-unlock (was Re: namei() query)"</a>
<li> <b>Previous message:</b> <a href="0393.html">kuznet@ms2.inr.ac.ru: "Re: /proc/net/arp silliness"</a>
<li> <b>Maybe in reply to:</b> <a href="0022.html">Rik van Riel: "[PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0473.html">David S. Miller: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<!-- reply="end" -->
</ul>
</font></body>
