<!-- received="Tue Apr 25 23:42:03 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 15:34:49 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@mandrakesoft.com" -->
<!-- subject="Re: Linux Jobs as of 2.3.99pre6-5" -->
<!-- id="" -->
<!-- inreplyto="Linux Jobs as of 2.3.99pre6-5" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: Linux Jobs as of 2.3.99pre6-5</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Linux Jobs as of 2.3.99pre6-5</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@mandrakesoft.com"><i>jgarzik@mandrakesoft.com</i></a>)<br>
<i>Tue, 25 Apr 2000 15:34:49 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#405">[ date ]</a><a href="index.html#405">[ thread ]</a><a href="subject.html#405">[ subject ]</a><a href="author.html#405">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0406.html">Rik van Riel: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<li> <b>Previous message:</b> <a href="0404.html">Olaf Titz: "Re: [PATCH] Generic dead function optimisation"</a>
<li> <b>Maybe in reply to:</b> <a href="0233.html">Alan Cox: "Linux Jobs as of 2.3.99pre6-5"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0424.html">Linus Torvalds: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------B81419BBDC891D38AE013AF2<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Tim Waugh wrote:<br>
<i>&gt; </i><br>
<i>&gt; On Tue, Apr 25, 2000 at 06:28:12PM +0100, Alan Cox wrote:</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; Do we have ALL_BUT in the subvendor data yet ? So that we can exclude the</i><br>
<i>&gt; &gt; lanmedia from tulip</i><br>
<i>&gt; </i><br>
<i>&gt; I prefer that drivers explicitly list the devices that they support.</i><br>
<i>&gt; I must admit I don't know the details with lanmedia/tulip though.</i><br>
<p>
If lanmedia advertises a tulip PCI id and a unique subvendor/device id,<br>
then both tulip and lanmedia drivers will try to grab the same device.<br>
<p>
Currently the Tulip driver needs to either list all existing<br>
subvendor/device ids (not feasible), or manually exclude specific<br>
subvendor/device ids in the xxx_init_one method.<br>
<p>
The more I think about the more I like adding an 'exclude_table' field<br>
to struct pci_driver.<br>
<p>
Does the attached patch look ok to everyone?<br>
<p>
	Jeff<br>
<p>
<p>
<p>
<p>
<p>
<pre>
-- 
Jeff Garzik              | Nothing cures insomnia like the
Building 1024            | realization that it's time to get up.
MandrakeSoft, Inc.       |        -- random fortune
--------------B81419BBDC891D38AE013AF2
Content-Type: text/plain; charset=us-ascii;
 name="pci-exclude-2.3.99.6.6.patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="pci-exclude-2.3.99.6.6.patch"
<p>
--- vanilla/linux-2.3.99-pre6-pre6/include/linux/module.h	Tue Apr 11 20:31:26 2000
+++ linux_2_3/include/linux/module.h	Tue Apr 25 15:20:32 2000
@@ -190,6 +190,19 @@
 __attribute__((section(".modinfo"))) =		\
 "parm_desc_" __MODULE_STRING(var) "=" desc
 
+/*
+ * MODULE_DEVICE_TABLE exports information about devices
+ * currently supported by this module.  A device type, such as PCI,
+ * is a C-like identifier passed as the first arg to this macro.
+ * The second macro arg is the variable containing the device
+ * information being made public.
+ *
+ * The following is a list of known device types (arg 1),
+ * and the C types which are to be passed as arg 2.
+ * pci - struct pci_device_id - List of PCI ids supported by this module
+ * exclude_pci - struct pci_device_id - List of PCI ids NOT supported
+ * by this module
+ */
 #define MODULE_DEVICE_TABLE(type,name)	\
 const struct type##_device_id * __module_##type##_device_table = name
 /* not put to .modinfo section to avoid section type conflicts */
--- vanilla/linux-2.3.99-pre6-pre6/include/linux/pci.h	Tue Apr 11 20:31:28 2000
+++ linux_2_3/include/linux/pci.h	Tue Apr 25 15:20:32 2000
@@ -530,6 +530,7 @@
 	struct list_head node;
 	char *name;
 	const struct pci_device_id *id_table;	/* NULL if wants all devices */
+	const struct pci_device_id *exclude_table; /* avoid these devices */
 	int (*probe)(struct pci_dev *dev, const struct pci_device_id *id);	/* New device inserted */
 	void (*remove)(struct pci_dev *dev);	/* Device removed (NULL if not a hot-plug capable driver) */
 	void (*suspend)(struct pci_dev *dev);	/* Device suspended */
--- vanilla/linux-2.3.99-pre6-pre6/drivers/pci/pci.c	Tue Apr 25 15:21:03 2000
+++ linux_2_3/drivers/pci/pci.c	Tue Apr 25 15:20:32 2000
@@ -303,6 +303,14 @@
 			return 0;
 	} else
 		id = NULL;
+
+	if (drv-&gt;exclude_table) {
+		const struct pci_device_id *exclude =
+			pci_match_device(drv-&gt;exclude_table, dev);
+		if (exclude)
+			return 0;
+	}
+
 	if (drv-&gt;probe(dev, id) &gt;= 0) {
 		dev-&gt;driver = drv;
 		return 1;
--- vanilla/linux-2.3.99-pre6-pre6/Documentation/pci.txt	Mon Feb 21 13:59:36 2000
+++ linux_2_3/Documentation/pci.txt	Tue Apr 25 15:32:39 2000
@@ -43,7 +43,15 @@
 
 	name		Name of the driver
 	id_table	Pointer to table of device ID's the driver is
-			interested in
+			interested in.  Most drivers should export this
+			table using MODULE_DEVICE_TABLE(pci,...).
+			Set to NULL to call probe() function for every
+			PCI device known to the system [unless excluded
+			by exclude_table].
+	exclude_table	Pointer to table of device ID's the driver wants
+			to avoid.  Most drivers should export this
+			table using MODULE_DEVICE_TABLE(exclude_pci,...).
+			Set to NULL to disable exclusion of PCI devices.
 	probe		Pointer to a probing function which gets called (during
 			execution of pci_register_driver for already existing
 			devices or later if a new device gets inserted) for all
<p>
--------------B81419BBDC891D38AE013AF2--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0406.html">Rik van Riel: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<li> <b>Previous message:</b> <a href="0404.html">Olaf Titz: "Re: [PATCH] Generic dead function optimisation"</a>
<li> <b>Maybe in reply to:</b> <a href="0233.html">Alan Cox: "Linux Jobs as of 2.3.99pre6-5"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0424.html">Linus Torvalds: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<!-- reply="end" -->
</ul>
</font></body>
