<!-- received="Wed Apr 26 01:00:14 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 22:45:33 +0100 (BST)" -->
<!-- name="Russell King" -->
<!-- email="rmk@arm.linux.org.uk" -->
<!-- subject="Patch: busmouse.c - more doc and spinlock optimisation" -->
<!-- id="200004252145.WAA01677@raistlin.arm.linux.org.uk" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: Patch: busmouse.c - more doc and spinlock optimisation</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Patch: busmouse.c - more doc and spinlock optimisation</h1>
<b>Russell King</b> (<a href="mailto:rmk@arm.linux.org.uk"><i>rmk@arm.linux.org.uk</i></a>)<br>
<i>Tue, 25 Apr 2000 22:45:33 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#416">[ date ]</a><a href="index.html#416">[ thread ]</a><a href="subject.html#416">[ subject ]</a><a href="author.html#416">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0417.html">Erik van Asselt: "Packet lag with kernel 2.3.99.pre6-3?"</a>
<li> <b>Previous message:</b> <a href="0415.html">Bill Wendling: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
The following patch:<br>
<p>
1. removes some old cruft from busmouse.c<br>
2. adds more DocBook documentation to the external functions<br>
3. changes spin_lock_irqsave to spin_lock_irq and spin_unlock_irqrestore to<br>
   spin_unlock_irq in the open() and read() methods.  This should be safe,<br>
   since both these methods should be called with interrupts enabled.<br>
<p>
If there is a major faux pas here, please scream ASAP - I believe it to<br>
be correct.<br>
<p>
--- linux.orig/drivers/char/busmouse.c	Fri Mar 24 23:18:52 2000<br>
+++ linux/drivers/char/busmouse.c	Tue Apr 25 21:48:28 2000<br>
@@ -1,22 +1,11 @@<br>
 /*<br>
- * linux/drivers/char/mouse.c<br>
+ * linux/drivers/char/busmouse.c<br>
  *<br>
- * Copyright (C) 1995 - 1998 Russell King<br>
- *  Protocol taken from busmouse.c<br>
+ * Copyright (C) 1995 - 1998 Russell King &lt;<a href="mailto:linux@arm.linux.org.uk">linux@arm.linux.org.uk</a>&gt;<br>
+ *  Protocol taken from original busmouse.c<br>
  *  read() waiting taken from psaux.c<br>
  *<br>
  * Medium-level interface for quadrature or bus mice.<br>
- *<br>
- * Currently, the majority of kernel busmice drivers in the<br>
- * kernel common code to talk to userspace.  This driver<br>
- * attempts to rectify this situation by presenting a<br>
- * simple and safe interface to the mice and user.<br>
- *<br>
- * This driver:<br>
- *  - is SMP safe<br>
- *  - handles multiple opens<br>
- *  - handles the wakeups and locking<br>
- *  - has optional blocking reads<br>
  */<br>
 <br>
 #include &lt;linux/module.h&gt;<br>
@@ -40,10 +29,8 @@<br>
 /* Uncomment this if your mouse drivers expect the kernel to<br>
  * return with EAGAIN if the mouse does not have any events<br>
  * available, even if the mouse is opened in nonblocking mode.<br>
- *<br>
- * Should this be on a per-mouse basis?  If so, add an entry to<br>
- * the struct busmouse structure and add the relevent flag to<br>
- * the drivers.<br>
+ * Please report use of this "feature" to the author using the<br>
+ * above address.<br>
  */<br>
 /*#define BROKEN_MOUSE*/<br>
 <br>
@@ -56,7 +43,6 @@<br>
 	struct fasync_struct	*fasyncptr;<br>
 	char			active;<br>
 	char			buttons;<br>
-	char			latch_buttons;<br>
 	char			ready;<br>
 	int			dxpos;<br>
 	int			dypos;<br>
@@ -75,32 +61,19 @@<br>
 static struct busmouse_data *busmouse_data[NR_MICE];<br>
 static DECLARE_MUTEX(mouse_sem);<br>
 <br>
-/* a mouse driver just has to interface with these functions<br>
- *  These are !!!OLD!!!  Do not use!!!<br>
- */<br>
-void add_mouse_movement(int dx, int dy)<br>
-{<br>
-	struct busmouse_data *mse = busmouse_data[MINOR_TO_MOUSE(6)];<br>
-<br>
-	mse-&gt;dxpos += dx;<br>
-	mse-&gt;dypos += dy;<br>
-	mse-&gt;ready = 1;<br>
-	wake_up(&amp;mse-&gt;wait);<br>
-}<br>
-<br>
-int add_mouse_buttonchange(int set, int value)<br>
-{<br>
-	struct busmouse_data *mse = busmouse_data[MINOR_TO_MOUSE(6)];<br>
-<br>
-	mse-&gt;buttons = (mse-&gt;buttons &amp; ~set) ^ value;<br>
-	mse-&gt;ready = 1;<br>
-	wake_up(&amp;mse-&gt;wait);<br>
-	return mse-&gt;buttons;<br>
-}<br>
-<br>
-/* New interface.  !!! Use this one !!!<br>
- * These routines will most probably be called from interrupt.<br>
+/**<br>
+ *	busmouse_add_movement - notification of a change of mouse position<br>
+ *	@mousedev: mouse number<br>
+ *	@dx: delta X movement<br>
+ *	@dy: delta Y movement<br>
+ *	@buttons: new button state<br>
+ *<br>
+ *	Updates the mouse position and button information. The mousedev<br>
+ *	parameter is the value returned from register_busmouse. The<br>
+ *	movement information is updated, and the new button state is<br>
+ *	saved.  A waiting user thread is woken.<br>
  */<br>
+ <br>
 void busmouse_add_movementbuttons(int mousedev, int dx, int dy, int buttons)<br>
 {<br>
 	struct busmouse_data *mse = busmouse_data[mousedev];<br>
@@ -113,7 +86,6 @@<br>
 		add_mouse_randomness((buttons &lt;&lt; 16) + (dy &lt;&lt; 8) + dx);<br>
 <br>
 		mse-&gt;buttons = buttons;<br>
-//		mse-&gt;latch_buttons |= buttons;<br>
 		mse-&gt;dxpos += dx;<br>
 		mse-&gt;dypos += dy;<br>
 		mse-&gt;ready = 1;<br>
@@ -143,6 +115,17 @@<br>
 	}<br>
 }<br>
 <br>
+/**<br>
+ *	busmouse_add_movement - notification of a change of mouse position<br>
+ *	@mousedev: mouse number<br>
+ *	@dx: delta X movement<br>
+ *	@dy: delta Y movement<br>
+ *<br>
+ *	Updates the mouse position. The mousedev parameter is the value<br>
+ *	returned from register_busmouse. The movement information is<br>
+ *	updated, and a waiting user thread is woken.<br>
+ */<br>
+ <br>
 void busmouse_add_movement(int mousedev, int dx, int dy)<br>
 {<br>
 	struct busmouse_data *mse = busmouse_data[mousedev];<br>
@@ -150,6 +133,18 @@<br>
 	busmouse_add_movementbuttons(mousedev, dx, dy, mse-&gt;buttons);<br>
 }<br>
 <br>
+/**<br>
+ *	busmouse_add_buttons - notification of a change of button state<br>
+ *	@mousedev: mouse number<br>
+ *	@clear: mask of buttons to clear<br>
+ *	@eor: mask of buttons to change<br>
+ *<br>
+ *	Updates the button state. The mousedev parameter is the value<br>
+ *	returned from register_busmouse. The buttons are updated by:<br>
+ *		new_state = (old_state &amp; ~clear) ^ eor<br>
+ *	A waiting user thread is woken up.<br>
+ */<br>
+ <br>
 void busmouse_add_buttons(int mousedev, int clear, int eor)<br>
 {<br>
 	struct busmouse_data *mse = busmouse_data[mousedev];<br>
@@ -191,7 +186,6 @@<br>
 static int busmouse_open(struct inode *inode, struct file *file)<br>
 {<br>
 	struct busmouse_data *mse;<br>
-	unsigned long flags;<br>
 	unsigned int mousedev;<br>
 	int ret = -ENODEV;<br>
 <br>
@@ -219,7 +213,7 @@<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
 <br>
-	spin_lock_irqsave(&amp;mse-&gt;lock, flags);<br>
+	spin_lock_irq(&amp;mse-&gt;lock);<br>
 <br>
 	mse-&gt;ready   = 0;<br>
 	mse-&gt;dxpos   = 0;<br>
@@ -229,7 +223,7 @@<br>
 	else<br>
 		mse-&gt;buttons = 7;<br>
 <br>
-	spin_unlock_irqrestore(&amp;mse-&gt;lock, flags);<br>
+	spin_unlock_irq(&amp;mse-&gt;lock);<br>
 end:<br>
 	up(&amp;mouse_sem);<br>
 	return ret;<br>
@@ -244,21 +238,20 @@<br>
 {<br>
 	struct busmouse_data *mse = (struct busmouse_data *)file-&gt;private_data;<br>
 	DECLARE_WAITQUEUE(wait, current);<br>
-	unsigned long flags;<br>
 	int dxpos, dypos, buttons;<br>
 <br>
 	if (count &lt; 3)<br>
 		return -EINVAL;<br>
 <br>
-	spin_lock_irqsave(&amp;mse-&gt;lock, flags);<br>
+	spin_lock_irq(&amp;mse-&gt;lock);<br>
 <br>
 	if (!mse-&gt;ready) {<br>
 #ifdef BROKEN_MOUSE<br>
-		spin_unlock_irqrestore(&amp;mse-&gt;lock, flags);<br>
+		spin_unlock_irq(&amp;mse-&gt;lock);<br>
 		return -EAGAIN;<br>
 #else<br>
 		if (file-&gt;f_flags &amp; O_NONBLOCK) {<br>
-			spin_unlock_irqrestore(&amp;mse-&gt;lock, flags);<br>
+			spin_unlock_irq(&amp;mse-&gt;lock);<br>
 			return -EAGAIN;<br>
 		}<br>
 <br>
@@ -266,9 +259,9 @@<br>
 repeat:<br>
 		set_current_state(TASK_INTERRUPTIBLE);<br>
 		if (!mse-&gt;ready &amp;&amp; !signal_pending(current)) {<br>
-			spin_unlock_irqrestore(&amp;mse-&gt;lock, flags);<br>
+			spin_unlock_irq(&amp;mse-&gt;lock);<br>
 			schedule();<br>
-			spin_lock_irqsave(&amp;mse-&gt;lock, flags);<br>
+			spin_lock_irq(&amp;mse-&gt;lock);<br>
 			goto repeat;<br>
 		}<br>
 <br>
@@ -276,7 +269,7 @@<br>
 		remove_wait_queue(&amp;mse-&gt;wait, &amp;wait);<br>
 <br>
 		if (signal_pending(current)) {<br>
-			spin_unlock_irqrestore(&amp;mse-&gt;lock, flags);<br>
+			spin_unlock_irq(&amp;mse-&gt;lock);<br>
 			return -ERESTARTSYS;<br>
 		}<br>
 #endif<br>
@@ -285,7 +278,6 @@<br>
 	dxpos = mse-&gt;dxpos;<br>
 	dypos = mse-&gt;dypos;<br>
 	buttons = mse-&gt;buttons;<br>
-//	mse-&gt;latch_buttons = mse-&gt;buttons;<br>
 <br>
 	if (dxpos &lt; -127)<br>
 		dxpos =- 127;<br>
@@ -306,7 +298,7 @@<br>
 	 */<br>
 	mse-&gt;ready = mse-&gt;dxpos || mse-&gt;dypos;<br>
 <br>
-	spin_unlock_irqrestore(&amp;mse-&gt;lock, flags);<br>
+	spin_unlock_irq(&amp;mse-&gt;lock);<br>
 <br>
 	/* Write out data to the user.  Format is:<br>
 	 *   byte 0 - identifer (0x80) and (inverted) mouse buttons<br>
@@ -412,6 +404,7 @@<br>
 int unregister_busmouse(int mousedev)<br>
 {<br>
 	int err = -EINVAL;<br>
+<br>
 	if (mousedev &lt; 0)<br>
 		return 0;<br>
 	if (mousedev &gt;= NR_MICE) {<br>
@@ -434,7 +427,7 @@<br>
 		goto fail;<br>
 	}<br>
 <br>
-	err=misc_deregister(&amp;busmouse_data[mousedev]-&gt;miscdev);<br>
+	err = misc_deregister(&amp;busmouse_data[mousedev]-&gt;miscdev);<br>
 <br>
 	kfree(busmouse_data[mousedev]);<br>
 	busmouse_data[mousedev] = NULL;<br>
--- linux.orig/drivers/char/busmouse.h	Fri Mar 24 23:18:52 2000<br>
+++ linux/drivers/char/busmouse.h	Sun Apr 23 09:53:27 2000<br>
@@ -1,12 +1,12 @@<br>
 /*<br>
- * linux/drivers/char/mouse.h<br>
+ * linux/drivers/char/busmouse.h<br>
  *<br>
  * Copyright (C) 1995 - 1998 Russell King<br>
  *<br>
  * Prototypes for generic busmouse interface<br>
  */<br>
-#ifndef MOUSE_H<br>
-#define MOUSE_H<br>
+#ifndef BUSMOUSE_H<br>
+#define BUSMOUSE_H<br>
 <br>
 struct busmouse {<br>
 	int minor;<br>
<p>
   _____<br>
<i>  |_____| ------------------------------------------------- ---+---+-</i><br>
<i>  |   |         Russell King        <a href="mailto:rmk@arm.linux.org.uk">rmk@arm.linux.org.uk</a>      --- ---</i><br>
<i>  | | | |   <a href="http://www.arm.linux.org.uk/~rmk/aboutme.html">http://www.arm.linux.org.uk/~rmk/aboutme.html</a>    /  /  |</i><br>
<i>  | +-+-+                                                     --- -+-</i><br>
  /   |               THE developer of ARM Linux              |+| /|\<br>
 /  | | |                                                     ---  |<br>
    +-+-+ -------------------------------------------------  /\\\  |<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0417.html">Erik van Asselt: "Packet lag with kernel 2.3.99.pre6-3?"</a>
<li> <b>Previous message:</b> <a href="0415.html">Bill Wendling: "Re: Linux Jobs as of 2.3.99pre6-5"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
