<!-- received="Wed Apr 26 16:12:54 2000 EET DST" -->
<!-- sent="Wed, 26 Apr 2000 14:08:38 +0100 (BST)" -->
<!-- name="Tigran Aivazian" -->
<!-- email="tigran@veritas.com" -->
<!-- subject="[patch-2.3.99-pre6-7] do_munmap_mm(mm, addr, len)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [patch-2.3.99-pre6-7] do_munmap_mm(mm, addr, len)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch-2.3.99-pre6-7] do_munmap_mm(mm, addr, len)</h1>
<b>Tigran Aivazian</b> (<a href="mailto:tigran@veritas.com"><i>tigran@veritas.com</i></a>)<br>
<i>Wed, 26 Apr 2000 14:08:38 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#484">[ date ]</a><a href="index.html#484">[ thread ]</a><a href="subject.html#484">[ subject ]</a><a href="author.html#484">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0485.html">George Anzinger: "Re: kernel debugger"</a>
<li> <b>Previous message:</b> <a href="0483.html">Stephen C. Tweedie: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
This patch makes it possible to unmap someone else's mmap'd area and not<br>
just current's. This kills two valdshneps with one shot:<br>
<p>
a) makes some code cleaner and possibly more optimized where the value of<br>
tsk-&gt;mm (tsk = current) is needed anyway so there no point in wasting<br>
cycles inside do_munmap() dereferencing current-&gt;mm again.<br>
<p>
b) being able to unmap some other context's mmap'd area is a good thing -<br>
e.g. can be used by forced umount to forcibly unmap all mmap'd files for a<br>
given process.<br>
<p>
I had some doubts on whether call to flush_tlb_range() should be affected<br>
but having had a brief look at arch-specific implementation thereof, they<br>
seem to do the right thing internally so we should be ok.<br>
<p>
A copy is on:<br>
<p>
  <a href="http://www.ocston.org/~tigran/patches/munmap-2.3.99-pre6-7.patch">http://www.ocston.org/~tigran/patches/munmap-2.3.99-pre6-7.patch</a><br>
<p>
Regards,<br>
Tigran<br>
<p>
diff -urN -X dontdiff linux/include/linux/mm.h munmap/include/linux/mm.h<br>
--- linux/include/linux/mm.h	Wed Apr 26 09:41:01 2000<br>
+++ munmap/include/linux/mm.h	Wed Apr 26 13:52:29 2000<br>
@@ -445,7 +445,12 @@<br>
 	return ret;<br>
 }<br>
 <br>
-extern int do_munmap(unsigned long, size_t);<br>
+extern int do_munmap_mm(struct mm_struct *, unsigned long, size_t);<br>
+extern inline int do_munmap(unsigned long addr, size_t len)<br>
+{<br>
+	return do_munmap_mm(current-&gt;mm, addr, len);<br>
+}<br>
+<br>
 extern unsigned long do_brk(unsigned long, unsigned long);<br>
 <br>
 struct zone_t;<br>
diff -urN -X dontdiff linux/kernel/ksyms.c munmap/kernel/ksyms.c<br>
--- linux/kernel/ksyms.c	Wed Apr 26 09:41:01 2000<br>
+++ munmap/kernel/ksyms.c	Wed Apr 26 13:45:11 2000<br>
@@ -91,7 +91,7 @@<br>
 <br>
 /* process memory management */<br>
 EXPORT_SYMBOL(do_mmap_pgoff);<br>
-EXPORT_SYMBOL(do_munmap);<br>
+EXPORT_SYMBOL(do_munmap_mm);<br>
 EXPORT_SYMBOL(do_brk);<br>
 EXPORT_SYMBOL(exit_mm);<br>
 EXPORT_SYMBOL(exit_files);<br>
diff -urN -X dontdiff linux/mm/mmap.c munmap/mm/mmap.c<br>
--- linux/mm/mmap.c	Wed Apr 26 09:41:01 2000<br>
+++ munmap/mm/mmap.c	Wed Apr 26 13:51:20 2000<br>
@@ -110,7 +110,7 @@<br>
 <br>
 	/* Always allow shrinking brk. */<br>
 	if (brk &lt;= mm-&gt;brk) {<br>
-		if (!do_munmap(newbrk, oldbrk-newbrk))<br>
+		if (!do_munmap_mm(mm, newbrk, oldbrk-newbrk))<br>
 			goto set_brk;<br>
 		goto out;<br>
 	}<br>
@@ -281,7 +281,7 @@<br>
 <br>
 	/* Clear old maps */<br>
 	error = -ENOMEM;<br>
-	if (do_munmap(addr, len))<br>
+	if (do_munmap_mm(mm, addr, len))<br>
 		goto free_vma;<br>
 <br>
 	/* Check against address space limit. */<br>
@@ -319,7 +319,7 @@<br>
 		if (error)<br>
 			goto unmap_and_free_vma;<br>
 	} else if (flags &amp; MAP_SHARED) {<br>
-		error = map_zero_setup (vma);<br>
+		error = map_zero_setup(vma);<br>
 	}<br>
 <br>
 	/*<br>
@@ -517,8 +517,9 @@<br>
  * allocate a new one, and the return indicates whether the old<br>
  * area was reused.<br>
  */<br>
-static struct vm_area_struct * unmap_fixup(struct vm_area_struct *area,<br>
-	unsigned long addr, size_t len, struct vm_area_struct *extra)<br>
+static struct vm_area_struct * unmap_fixup(struct mm_struct *mm, <br>
+	struct vm_area_struct *area, unsigned long addr, size_t len, <br>
+	struct vm_area_struct *extra)<br>
 {<br>
 	struct vm_area_struct *mpnt;<br>
 	unsigned long end = addr + len;<br>
@@ -540,11 +541,11 @@<br>
 	/* Work out to one of the ends. */<br>
 	if (end == area-&gt;vm_end) {<br>
 		area-&gt;vm_end = addr;<br>
-		vmlist_modify_lock(current-&gt;mm);<br>
+		vmlist_modify_lock(mm);<br>
 	} else if (addr == area-&gt;vm_start) {<br>
 		area-&gt;vm_pgoff += (end - area-&gt;vm_start) &gt;&gt; PAGE_SHIFT;<br>
 		area-&gt;vm_start = end;<br>
-		vmlist_modify_lock(current-&gt;mm);<br>
+		vmlist_modify_lock(mm);<br>
 	} else {<br>
 	/* Unmapping a hole: area-&gt;vm_start &lt; addr &lt;= end &lt; area-&gt;vm_end */<br>
 		/* Add end mapping -- leave beginning for below */<br>
@@ -566,12 +567,12 @@<br>
 		if (mpnt-&gt;vm_ops &amp;&amp; mpnt-&gt;vm_ops-&gt;open)<br>
 			mpnt-&gt;vm_ops-&gt;open(mpnt);<br>
 		area-&gt;vm_end = addr;	/* Truncate area */<br>
-		vmlist_modify_lock(current-&gt;mm);<br>
-		insert_vm_struct(current-&gt;mm, mpnt);<br>
+		vmlist_modify_lock(mm);<br>
+		insert_vm_struct(mm, mpnt);<br>
 	}<br>
 <br>
-	insert_vm_struct(current-&gt;mm, area);<br>
-	vmlist_modify_unlock(current-&gt;mm);<br>
+	insert_vm_struct(mm, area);<br>
+	vmlist_modify_unlock(mm);<br>
 	return extra;<br>
 }<br>
 <br>
@@ -638,9 +639,8 @@<br>
  * work.  This now handles partial unmappings.<br>
  * Jeremy Fitzhardine &lt;<a href="mailto:jeremy@sw.oz.au">jeremy@sw.oz.au</a>&gt;<br>
  */<br>
-int do_munmap(unsigned long addr, size_t len)<br>
+int do_munmap_mm(struct mm_struct *mm, unsigned long addr, size_t len)<br>
 {<br>
-	struct mm_struct * mm;<br>
 	struct vm_area_struct *mpnt, *prev, **npp, *free, *extra;<br>
 <br>
 	if ((addr &amp; ~PAGE_MASK) || addr &gt; TASK_SIZE || len &gt; TASK_SIZE-addr)<br>
@@ -654,7 +654,6 @@<br>
 	 * every area affected in some way (by any overlap) is put<br>
 	 * on the list.  If nothing is put on, nothing is affected.<br>
 	 */<br>
-	mm = current-&gt;mm;<br>
 	mpnt = find_vma_prev(mm, addr, &amp;prev);<br>
 	if (!mpnt)<br>
 		return 0;<br>
@@ -717,7 +716,7 @@<br>
 		/*<br>
 		 * Fix the mapping, and free the old area if it wasn't reused.<br>
 		 */<br>
-		extra = unmap_fixup(mpnt, st, size, extra);<br>
+		extra = unmap_fixup(mm, mpnt, st, size, extra);<br>
 	}<br>
 <br>
 	/* Release the extra vma struct if it wasn't used */<br>
@@ -732,10 +731,11 @@<br>
 asmlinkage long sys_munmap(unsigned long addr, size_t len)<br>
 {<br>
 	int ret;<br>
+	struct mm_struct *mm = current-&gt;mm;<br>
 <br>
-	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
-	ret = do_munmap(addr, len);<br>
-	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
+	down(&amp;mm-&gt;mmap_sem);<br>
+	ret = do_munmap_mm(mm, addr, len);<br>
+	up(&amp;mm-&gt;mmap_sem);<br>
 	return ret;<br>
 }<br>
 <br>
@@ -767,7 +767,7 @@<br>
 	/*<br>
 	 * Clear old maps.  this also does some error checking for us<br>
 	 */<br>
-	retval = do_munmap(addr, len);<br>
+	retval = do_munmap_mm(mm, addr, len);<br>
 	if (retval != 0)<br>
 		return retval;<br>
 <br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0485.html">George Anzinger: "Re: kernel debugger"</a>
<li> <b>Previous message:</b> <a href="0483.html">Stephen C. Tweedie: "Re: [PATCH] 2.3.99-pre6-3+  VM rebalancing"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
