<!-- received="Wed Apr 26 20:38:49 2000 EET DST" -->
<!-- sent="26 Apr 2000 19:29:30 +0200" -->
<!-- name="Christoph Rohland" -->
<!-- email="hans-christoph.rohland@sap.com" -->
<!-- subject="[Patch] interuptible core dumps" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [Patch] interuptible core dumps</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[Patch] interuptible core dumps</h1>
<b>Christoph Rohland</b> (<a href="mailto:hans-christoph.rohland@sap.com"><i>hans-christoph.rohland@sap.com</i></a>)<br>
<i>26 Apr 2000 19:29:30 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#518">[ date ]</a><a href="index.html#518">[ thread ]</a><a href="subject.html#518">[ subject ]</a><a href="author.html#518">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0519.html">Stepan Kasal: "linux/mount.h patch"</a>
<li> <b>Previous message:</b> <a href="0517.html">willy@thepuffingroup.com: "Re: [pre6-7] cua nd ttyS broken"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--=-=-=<br>
<p>
Hi Linus,<br>
<p>
This patch against 2.3.99-pre6-6 makes core dumping interuptible with<br>
SIGKILL. This makes netscape over NFS home directories much easier to<br>
use ;-)<br>
<p>
Greetings<br>
		Christoph<br>
<p>
<pre>
-- 
<p>
--=-=-=
Content-Disposition: attachment; filename=patch-core_intr
<p>
diff -uNr pre6-6patched/fs/binfmt_elf.c c6/fs/binfmt_elf.c
--- pre6-6patched/fs/binfmt_elf.c	Tue Apr 25 13:43:05 2000
+++ c6/fs/binfmt_elf.c	Wed Apr 26 19:21:20 2000
@@ -991,6 +991,7 @@
 	struct elf_prstatus prstatus;	/* NT_PRSTATUS */
 	elf_fpregset_t fpu;		/* NT_PRFPREG */
 	struct elf_prpsinfo psinfo;	/* NT_PRPSINFO */
+	sigset_t save_set;
 
 	segs = current-&gt;mm-&gt;map_count;
 
@@ -998,6 +999,10 @@
 	printk("elf_core_dump: %d segs %lu limit\n", segs, limit);
 #endif
 
+	spin_lock_irq(&amp;current-&gt;sigmask_lock);
+	save_set = current-&gt;blocked;	
+	spin_unlock_irq(&amp;current-&gt;sigmask_lock);
+
 	/* Set up header */
 	memcpy(elf.e_ident, ELFMAG, SELFMAG);
 	elf.e_ident[EI_CLASS] = ELF_CLASS;
@@ -1181,6 +1186,12 @@
 
 	DUMP_SEEK(dataoff);
 
+	/* Only allow SIGKILL */
+	spin_lock_irq(&amp;current-&gt;sigmask_lock);
+	sigfillset(&amp;current-&gt;blocked);
+	sigdelsetmask(&amp;current-&gt;blocked, sigmask(SIGKILL));
+	spin_unlock_irq(&amp;current-&gt;sigmask_lock);
+
 	for(vma = current-&gt;mm-&gt;mmap; vma != NULL; vma = vma-&gt;vm_next) {
 		unsigned long addr;
 
@@ -1208,6 +1219,8 @@
 			    pte_none(*pte)) {
 				DUMP_SEEK (file-&gt;f_pos + PAGE_SIZE);
 			} else {
+				if (signal_pending(current)) 
+					goto end_coredump;
 				DUMP_WRITE((void*)addr, PAGE_SIZE);
 			}
 		}
@@ -1220,6 +1233,9 @@
 	}
 
  end_coredump:
+	spin_lock_irq(&amp;current-&gt;sigmask_lock);
+	current-&gt;blocked = save_set;
+	spin_unlock_irq(&amp;current-&gt;sigmask_lock);
 	set_fs(fs);
 	return has_dumped;
 }
<p>
--=-=-=--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0519.html">Stepan Kasal: "linux/mount.h patch"</a>
<li> <b>Previous message:</b> <a href="0517.html">willy@thepuffingroup.com: "Re: [pre6-7] cua nd ttyS broken"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
