<!-- received="Wed Apr 26 21:29:52 2000 EET DST" -->
<!-- sent="Wed, 26 Apr 2000 13:26:06 -0500 (CDT)" -->
<!-- name="Victor Zandy" -->
<!-- email="zandy@cs.wisc.edu" -->
<!-- subject="int3 ignored during attach" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: int3 ignored during attach</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>int3 ignored during attach</h1>
<b>Victor Zandy</b> (<a href="mailto:zandy@cs.wisc.edu"><i>zandy@cs.wisc.edu</i></a>)<br>
<i>Wed, 26 Apr 2000 13:26:06 -0500 (CDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#527">[ date ]</a><a href="index.html#527">[ thread ]</a><a href="subject.html#527">[ subject ]</a><a href="author.html#527">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0528.html">=?ISO-8859-1?Q?G=E9rard_Roudier?=: "Re: "movb" for spin-unlock"</a>
<li> <b>Previous message:</b> <a href="0526.html">Trond Myklebust: "Re: 2.3.99-pre5 nfs.h: NFS_VERSION missing"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
    On x86 Linux 2.2 (2.2.12 and 2.2.14 tested), if a process executes<br>
an int3 instruction while another process attaches to it, the SIGTRAP<br>
can be lost.<br>
<p>
    Below is a pair of program that demonstrate this behavior.  The<br>
first program (trap) repeatedly executes and handles an int3.  The<br>
second program (trace) repeatedly attaches and detaches to its input<br>
pid.  When trap is left to itself, it runs forever.  When trace is<br>
applied to a trap process, eventually the int3 falls through (to the<br>
fprintf).<br>
<p>
    My guess is that attaching to a process between the time it has<br>
entered the kernel for an int3, but before the kernel has set up the<br>
signal handler call, can cause the trap to be lost.<br>
<p>
    I would like a way to detect that this is going to happen after I<br>
attach to the process.  I have had trace look at the user and debug<br>
registers (everything accessible from ptrace) and the pending signal<br>
state of the inferior, but there is no difference in the state in<br>
cases when the trap is lost and when the trap is handled.  Is there<br>
any other state I can inspect that might help me distinguish these<br>
cases?<br>
<p>
    Also, can anyone explain why this happens?<br>
<p>
Thanks,<br>
Vic Zandy<br>
<p>
/* trap.c */<br>
#include &lt;stdio.h&gt;<br>
#include &lt;stdlib.h&gt;<br>
#include &lt;signal.h&gt;<br>
<p>
void handler(int sig, struct sigcontext uap)<br>
{<br>
     uap.eip--;<br>
}<br>
<p>
int main(int argc, char *argv[])<br>
{<br>
     struct sigaction sa;<br>
     sa.sa_handler = handler;<br>
     sigemptyset(&amp;sa.sa_mask);<br>
     sa.sa_flags = 0;<br>
     sigaction(SIGTRAP, &amp;sa, NULL);<br>
     fprintf(stderr, "pid = %d\n", getpid());<br>
     asm("int3");<br>
     fprintf(stderr, "Done\n");<br>
}<br>
<p>
/* trace.c */<br>
#include &lt;stdio.h&gt;<br>
#include &lt;sys/ptrace.h&gt;<br>
#include &lt;stdlib.h&gt;<br>
#include &lt;signal.h&gt;<br>
<p>
long int dptrace(enum __ptrace_request req, pid_t pid,<br>
		 void *addr, void *data)<br>
{<br>
     int rv;<br>
<p>
     rv = ptrace(req, pid, addr, data);<br>
     if (0 &gt; rv) {<br>
	  perror("ptrace");<br>
	  exit(1);<br>
     }<br>
     return rv;<br>
}<br>
<p>
int main(int argc, char *argv[])<br>
{<br>
     int pid;<br>
<p>
     if (argc != 2) {<br>
	  fprintf(stderr, "Usage: %s PID\n", argv[0]);<br>
	  exit(1);<br>
     }<br>
     pid = atoi(argv[1]);<br>
<p>
     while (1) {<br>
	  dptrace(PTRACE_ATTACH, pid, 0, 0);<br>
	  waitpid(pid, 0, 0);<br>
	  dptrace(PTRACE_DETACH, pid, 0, 0);<br>
     }<br>
}<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0528.html">=?ISO-8859-1?Q?G=E9rard_Roudier?=: "Re: "movb" for spin-unlock"</a>
<li> <b>Previous message:</b> <a href="0526.html">Trond Myklebust: "Re: 2.3.99-pre5 nfs.h: NFS_VERSION missing"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
