<!-- received="Thu Apr 27 06:20:43 2000 EET DST" -->
<!-- sent="Thu, 27 Apr 2000 13:17:07 +1000 (EST)" -->
<!-- name="Graham Stoney" -->
<!-- email="greyham@research.canon.com.au" -->
<!-- subject="[PATCH] preparing 2.2.14 for gcc-3.0" -->
<!-- id="20000427031707.CB25D509B2@brixi.research.canon.com.au" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] preparing 2.2.14 for gcc-3.0</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] preparing 2.2.14 for gcc-3.0</h1>
<b>Graham Stoney</b> (<a href="mailto:greyham@research.canon.com.au"><i>greyham@research.canon.com.au</i></a>)<br>
<i>Thu, 27 Apr 2000 13:17:07 +1000 (EST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#583">[ date ]</a><a href="index.html#583">[ thread ]</a><a href="subject.html#583">[ subject ]</a><a href="author.html#583">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0584.html">Horst von Brand: "2.3.99-pre6: Unresolved module symbols"</a>
<li> <b>Previous message:</b> <a href="0582.html">Karim Yaghmour: "Jacques Gelinas' "autofs" + "device manager""</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi gang,<br>
<p>
The gcc people are planning for the future release of 3.0. One of their<br>
release criteria is that the Linux 2.2.14 kernel builds and works out of the<br>
box. For more info, see:<br>
    <a href="http://gcc.gnu.org/gcc-3.0/criteria.html">http://gcc.gnu.org/gcc-3.0/criteria.html</a><br>
<p>
One problem to overcome is that __GNUC__ will change from 2 to 3, and there<br>
are some broken tests in the current 2.2.14 kernel. The following patch fixes<br>
all the ones I could find that appear to break.<br>
<p>
I have also changed all the occurances of:<br>
<p>
    #if __GNUC__ &gt; 2 || __GNUC__ &gt;= minor<br>
<p>
to the preferred form of:<br>
<p>
    #if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= minor)<br>
<p>
The former won't break with the transition to 3.0, but is bad because it may<br>
encourage post-3.0 people to start using:<br>
<p>
    #if __GNUC__ &gt; 3 || __GNUC__ &gt;= minor<br>
<p>
which will cause minor versions of gcc-2.x to misbehave.<br>
<p>
I haven't enabled the following missed optimisation opportunity which the<br>
code says are broken in gcc 2.95 and later:<br>
    drivers/isdn/isdn_audio.c:301<br>
<p>
I think it would be extremely wise to make similar fixes to the 2.4 kernel<br>
before it is released, as this will greatly reduce confusion when gcc-3.0<br>
comes around.<br>
<p>
diff -ur linux-2.2.14/arch/sparc64/kernel/sparc64_ksyms.c linux-2.2.14+GNUC/arch/sparc64/kernel/sparc64_ksyms.c<br>
--- linux-2.2.14/arch/sparc64/kernel/sparc64_ksyms.c	Wed Oct 27 10:53:39 1999<br>
+++ linux-2.2.14+GNUC/arch/sparc64/kernel/sparc64_ksyms.c	Thu Apr 27 12:56:14 2000<br>
@@ -232,7 +232,7 @@<br>
 /* sparc library symbols */<br>
 EXPORT_SYMBOL(bcopy);<br>
 EXPORT_SYMBOL(__strlen);<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 EXPORT_SYMBOL(strlen);<br>
 #endif<br>
 EXPORT_SYMBOL(strnlen);<br>
Only in linux-2.2.14+GNUC: cscope.files<br>
Only in linux-2.2.14+GNUC: cscope.out<br>
diff -ur linux-2.2.14/include/asm-alpha/byteorder.h linux-2.2.14+GNUC/include/asm-alpha/byteorder.h<br>
--- linux-2.2.14/include/asm-alpha/byteorder.h	Sun Jun  7 11:52:04 1998<br>
+++ linux-2.2.14+GNUC/include/asm-alpha/byteorder.h	Thu Apr 27 12:29:48 2000<br>
@@ -7,7 +7,7 @@<br>
    with the standard macros.  And since it can schedule, it does even<br>
    better in the end.  */<br>
 <br>
-#if defined(__GNUC__) &amp;&amp; __GNUC_MINOR__ &lt; 91<br>
+#if defined(__GNUC__) &amp;&amp; __GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &lt; 91<br>
 <br>
 static __inline__ __const__ __u32 ___arch__swab32(__u32 x)<br>
 {<br>
diff -ur linux-2.2.14/include/asm-alpha/compiler.h linux-2.2.14+GNUC/include/asm-alpha/compiler.h<br>
--- linux-2.2.14/include/asm-alpha/compiler.h	Mon Aug 10 05:09:06 1998<br>
+++ linux-2.2.14+GNUC/include/asm-alpha/compiler.h	Thu Apr 27 13:03:07 2000<br>
@@ -13,7 +13,7 @@<br>
  * EGCS (of varying versions) does a good job of using insxl and extxl.<br>
  */<br>
 <br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 #define __kernel_insbl(val, shift) \<br>
   (((unsigned long)(val) &amp; 0xfful) &lt;&lt; ((shift) * 8))<br>
 #define __kernel_inswl(val, shift) \<br>
@@ -29,7 +29,7 @@<br>
      __kir; })<br>
 #endif<br>
 <br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 92<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 92)<br>
 #define __kernel_extbl(val, shift)  (((val) &gt;&gt; (((shift) &amp; 7) * 8)) &amp; 0xfful)<br>
 #define __kernel_extwl(val, shift)  (((val) &gt;&gt; (((shift) &amp; 7) * 8)) &amp; 0xfffful)<br>
 #else<br>
diff -ur linux-2.2.14/include/asm-alpha/string.h linux-2.2.14+GNUC/include/asm-alpha/string.h<br>
--- linux-2.2.14/include/asm-alpha/string.h	Mon Aug 10 05:09:06 1998<br>
+++ linux-2.2.14+GNUC/include/asm-alpha/string.h	Thu Apr 27 13:03:47 2000<br>
@@ -14,7 +14,7 @@<br>
 /* For backward compatibility with modules.  Unused otherwise.  */<br>
 extern void * __memcpy(void *, const void *, size_t);<br>
 <br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 #define memcpy __builtin_memcpy<br>
 #endif<br>
 <br>
@@ -22,7 +22,7 @@<br>
 extern void * __constant_c_memset(void *, unsigned long, size_t);<br>
 extern void * __memset(void *, int, size_t);<br>
 <br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 #define memset(s, c, n)							    \<br>
 (__builtin_constant_p(c)						    \<br>
  ? (__builtin_constant_p(n) &amp;&amp; (c) == 0					    \<br>
diff -ur linux-2.2.14/include/asm-alpha/unaligned.h linux-2.2.14+GNUC/include/asm-alpha/unaligned.h<br>
--- linux-2.2.14/include/asm-alpha/unaligned.h	Sun Jun  7 11:52:04 1998<br>
+++ linux-2.2.14+GNUC/include/asm-alpha/unaligned.h	Thu Apr 27 13:08:14 2000<br>
@@ -31,7 +31,7 @@<br>
 <br>
 extern inline unsigned long __uldq(const unsigned long * r11)<br>
 {<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 	const struct __una_u64 *ptr = (const struct __una_u64 *) r11;<br>
 	return ptr-&gt;x;<br>
 #else<br>
@@ -50,7 +50,7 @@<br>
 <br>
 extern inline unsigned long __uldl(const unsigned int * r11)<br>
 {<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 	const struct __una_u32 *ptr = (const struct __una_u32 *) r11;<br>
 	return ptr-&gt;x;<br>
 #else<br>
@@ -69,7 +69,7 @@<br>
 <br>
 extern inline unsigned long __uldw(const unsigned short * r11)<br>
 {<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 	const struct __una_u16 *ptr = (const struct __una_u16 *) r11;<br>
 	return ptr-&gt;x;<br>
 #else<br>
@@ -92,7 +92,7 @@<br>
 <br>
 extern inline void __ustq(unsigned long r5, unsigned long * r11)<br>
 {<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 	struct __una_u64 *ptr = (struct __una_u64 *) r11;<br>
 	ptr-&gt;x = r5;<br>
 #else<br>
@@ -117,7 +117,7 @@<br>
 <br>
 extern inline void __ustl(unsigned long r5, unsigned int * r11)<br>
 {<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 	struct __una_u32 *ptr = (struct __una_u32 *) r11;<br>
 	ptr-&gt;x = r5;<br>
 #else<br>
@@ -142,7 +142,7 @@<br>
 <br>
 extern inline void __ustw(unsigned long r5, unsigned short * r11)<br>
 {<br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 	struct __una_u16 *ptr = (struct __una_u16 *) r11;<br>
 	ptr-&gt;x = r5;<br>
 #else<br>
diff -ur linux-2.2.14/include/asm-mips/init.h linux-2.2.14+GNUC/include/asm-mips/init.h<br>
--- linux-2.2.14/include/asm-mips/init.h	Tue Aug 10 05:04:41 1999<br>
+++ linux-2.2.14+GNUC/include/asm-mips/init.h	Thu Apr 27 12:32:25 2000<br>
@@ -15,7 +15,7 @@<br>
 	__arginit __init; \<br>
 	__arginit<br>
 <br>
-#if __GNUC__ &gt;= 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
 #define __initlocaldata  __initdata<br>
 #else<br>
 #define __initlocaldata<br>
diff -ur linux-2.2.14/include/asm-ppc/byteorder.h linux-2.2.14+GNUC/include/asm-ppc/byteorder.h<br>
--- linux-2.2.14/include/asm-ppc/byteorder.h	Thu Oct  1 03:14:33 1998<br>
+++ linux-2.2.14+GNUC/include/asm-ppc/byteorder.h	Thu Apr 27 12:34:20 2000<br>
@@ -38,7 +38,7 @@<br>
 /* alas, egcs sounds like it has a bug in this code that doesn't use the<br>
    inline asm correctly, and can cause file corruption. Until I hear that<br>
    it's fixed, I can live without the extra speed. I hope. */<br>
-#if !(__GNUC__ &gt;= 2 &amp;&amp; __GNUC_MINOR__ &gt;= 90)<br>
+#if !((__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 90))<br>
 #if 0<br>
 #  define __arch_swab16(x) ld_le16(&amp;x)<br>
 #  define __arch_swab32(x) ld_le32(&amp;x)<br>
diff -ur linux-2.2.14/include/asm-ppc/init.h linux-2.2.14+GNUC/include/asm-ppc/init.h<br>
--- linux-2.2.14/include/asm-ppc/init.h	Thu Dec 31 05:56:58 1998<br>
+++ linux-2.2.14+GNUC/include/asm-ppc/init.h	Thu Apr 27 13:05:12 2000<br>
@@ -1,7 +1,7 @@<br>
 #ifndef _PPC_INIT_H<br>
 #define _PPC_INIT_H<br>
 <br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 90 /* egcs */<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 90 /* egcs */<br>
 #define __init __attribute__ ((__section__ (".text.init")))<br>
 #define __initdata __attribute__ ((__section__ (".data.init")))<br>
 #define __initfunc(__arginit) \<br>
diff -ur linux-2.2.14/include/asm-sparc64/string.h linux-2.2.14+GNUC/include/asm-sparc64/string.h<br>
--- linux-2.2.14/include/asm-sparc64/string.h	Wed Oct 28 04:52:21 1998<br>
+++ linux-2.2.14+GNUC/include/asm-sparc64/string.h	Thu Apr 27 13:05:44 2000<br>
@@ -113,7 +113,7 @@<br>
 <br>
 extern __kernel_size_t __strlen(const char *);<br>
 <br>
-#if __GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 91<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 91)<br>
 extern __kernel_size_t strlen(const char *);<br>
 #else /* !EGCS */<br>
 /* Ugly but it works around a bug in our original sparc64-linux-gcc.  */<br>
diff -ur linux-2.2.14/include/linux/init.h linux-2.2.14+GNUC/include/linux/init.h<br>
--- linux-2.2.14/include/linux/init.h	Mon Dec 28 18:08:10 1998<br>
+++ linux-2.2.14+GNUC/include/linux/init.h	Thu Apr 27 12:36:05 2000<br>
@@ -59,7 +59,7 @@<br>
 #define __INITDATA<br>
 #endif<br>
 <br>
-#if __GNUC__ &gt;= 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
 #define __initlocaldata  __initdata<br>
 #else<br>
 #define __initlocaldata<br>
diff -ur linux-2.2.14/include/linux/linkage.h linux-2.2.14+GNUC/include/linux/linkage.h<br>
--- linux-2.2.14/include/linux/linkage.h	Wed Dec  2 06:28:24 1998<br>
+++ linux-2.2.14+GNUC/include/linux/linkage.h	Thu Apr 27 13:06:33 2000<br>
@@ -7,7 +7,7 @@<br>
 #define CPP_ASMLINKAGE<br>
 #endif<br>
 <br>
-#if defined __i386__ &amp;&amp; (__GNUC__ &gt; 2 || __GNUC_MINOR__ &gt; 7)<br>
+#if defined __i386__ &amp;&amp; (__GNUC__ &gt; 2 || __GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt; 7)<br>
 #define asmlinkage CPP_ASMLINKAGE __attribute__((regparm(0)))<br>
 #else<br>
 #define asmlinkage CPP_ASMLINKAGE<br>
<p>
Regards,<br>
Graham<br>
<pre>
-- 
Graham Stoney
Principal Hardware/Software Engineer
Canon Information Systems Research Australia
Ph: +61 2 9805 2909  Fax: +61 2 9805 2929
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0584.html">Horst von Brand: "2.3.99-pre6: Unresolved module symbols"</a>
<li> <b>Previous message:</b> <a href="0582.html">Karim Yaghmour: "Jacques Gelinas' "autofs" + "device manager""</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
