<!-- received="Thu Apr 27 10:41:59 2000 EET DST" -->
<!-- sent="Thu, 27 Apr 2000 09:34:12 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@suse.cz" -->
<!-- subject="CRC loop device" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: CRC loop device</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>CRC loop device</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@suse.cz"><i>pavel@suse.cz</i></a>)<br>
<i>Thu, 27 Apr 2000 09:34:12 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#606">[ date ]</a><a href="index.html#606">[ thread ]</a><a href="subject.html#606">[ subject ]</a><a href="author.html#606">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0607.html">Tigran Aivazian: "Re: Kernel Debugging"</a>
<li> <b>Previous message:</b> <a href="0605.html">Trond Myklebust: "Re: 2.3.99-pre6-pre7 sync_page in remove_inode_page"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
Here's my attempt at crc-ing loop device. There's slight problem with<br>
it: it locks up io subsystem under heavy load. Did I do something very<br>
stupid with respect to memory managment? Or do I need to set limit for<br>
bufferheads lower because I do 2 io requests for every io request on<br>
loop?<br>
<p>
								Pavel<br>
--- clean/drivers/block/loop.c	Tue Mar 21 20:30:08 2000<br>
+++ linux/drivers/block/loop.c	Wed Apr 19 22:39:59 2000<br>
@@ -61,6 +61,7 @@<br>
 #include &lt;linux/devfs_fs_kernel.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
+#include &lt;asm/checksum.h&gt;<br>
 <br>
 #include &lt;linux/loop.h&gt;		<br>
 <br>
@@ -118,6 +119,101 @@<br>
 	return 0;<br>
 }<br>
 <br>
+#define ID printk(KERN_ERR "crc: info about (%s, %d, %d) ", kdevname(lo-&gt;lo_device), real_block, blksize);<br>
+<br>
+<br>
+static int transfer_crc(struct loop_device *lo, int cmd, char *raw_buf,<br>
+		  char *loop_buf, int size, int real_block)<br>
+{<br>
+	struct buffer_head *bh;<br>
+	int blksize = 1024, nsect;	/* Size of block on auxilary media */<br>
+	int cksum;<br>
+	u32 *data;<br>
+	nsect = blksize / 4;<br>
+<br>
+	if (!lo-&gt;second_device) {<br>
+		ID; printk( "reading from not-yet-setup crc device can result in armagedon. Dont try again.\n" );<br>
+		return -1;<br>
+	}<br>
+	bh = getblk(lo-&gt;second_device, 1+real_block/nsect, blksize);<br>
+	if (!bh) {<br>
+		ID; printk( "getblk returned NULL.\n" );<br>
+		return -1;<br>
+	}<br>
+	if (!buffer_uptodate(bh)) {<br>
+		ll_rw_block(READ, 1, &amp;bh);<br>
+		wait_on_buffer(bh);<br>
+		if (!buffer_uptodate(bh)) {<br>
+			ID; printk(  "could not read block with CRC\n" );<br>
+			goto error;<br>
+		}<br>
+	}<br>
+<br>
+	data = bh-&gt;b_data;<br>
+	if (cmd == READ)<br>
+		cksum = csum_partial_copy_nocheck(raw_buf, loop_buf, size, 0);<br>
+	else<br>
+		cksum = csum_partial_copy_nocheck(loop_buf, raw_buf, size, 0);<br>
+<br>
+	if (cmd == READ) {<br>
+		if (le32_to_cpu(data[real_block%nsect]) != cksum) {<br>
+			if (lo-&gt;lo_encrypt_key_size == 0) {	/* Normal mode */<br>
+				ID; printk( "wrong checksum reading, is %x, should be %x\n", cksum, 0x1234 );<br>
+				goto error;<br>
+			} else { <br>
+				ID; printk( "wrong checksum repairing, setting to %x\n", cksum );<br>
+				goto repair;<br>
+			}<br>
+		}<br>
+	} else {<br>
+	repair:<br>
+		data[real_block%nsect] = cpu_to_le32(cksum);<br>
+		mark_buffer_uptodate(bh, 1);<br>
+		mark_buffer_dirty(bh, 1);<br>
+	}<br>
+<br>
+	brelse(bh);<br>
+	return 0;<br>
+error:<br>
+	brelse(bh);<br>
+	return -1;<br>
+<br>
+}<br>
+<br>
+static int ioctl_crc(struct loop_device *lo, int cmd, unsigned long arg)<br>
+{<br>
+	struct file	*file;<br>
+	struct inode	*inode;<br>
+	int error;<br>
+<br>
+	printk( "Entering ioctl_crc\n" );<br>
+	if (cmd != LOOP_CRC_SET_FD)<br>
+		return -EINVAL;<br>
+<br>
+	error = -EBADF;<br>
+	file = fget(arg);<br>
+	if (!file)<br>
+		return -EINVAL;<br>
+<br>
+	error = -EINVAL;<br>
+	inode = file-&gt;f_dentry-&gt;d_inode;<br>
+	if (!inode) {<br>
+		printk(KERN_ERR "ioctl_crc: NULL inode?!?\n");<br>
+		goto out;<br>
+	}<br>
+<br>
+	if (S_ISBLK(inode-&gt;i_mode)) {<br>
+		error = blkdev_open(inode, file);<br>
+		lo-&gt;second_device = inode-&gt;i_rdev;<br>
+		printk( "loop_crc: Registered device %x\n", lo-&gt;second_device );<br>
+		return error;<br>
+	} else {<br>
+	out:<br>
+		fput(file);<br>
+		return -EINVAL;<br>
+	}<br>
+}<br>
+<br>
 static int none_status(struct loop_device *lo, struct loop_info *info)<br>
 {<br>
 	return 0; <br>
@@ -142,10 +238,19 @@<br>
 	init: xor_status<br>
 }; 	<br>
 <br>
+struct loop_func_table crc_funcs = { <br>
+	number: LO_CRYPT_CRC,<br>
+	transfer: transfer_crc,<br>
+	init: none_status,<br>
+	ioctl: ioctl_crc<br>
+}; 	<br>
+<br>
 /* xfer_funcs[0] is special - its release function is never called */ <br>
 struct loop_func_table *xfer_funcs[MAX_LO_CRYPT] = {<br>
 	&amp;none_funcs,<br>
-	&amp;xor_funcs  <br>
+	&amp;xor_funcs,<br>
+	NULL, NULL, NULL, NULL, NULL,<br>
+	&amp;crc_funcs,<br>
 };<br>
 <br>
 #define MAX_DISK_SIZE 1024*1024*1024<br>
@@ -539,6 +644,7 @@<br>
 	lo-&gt;transfer = NULL;<br>
 	lo-&gt;ioctl = NULL;<br>
 	lo-&gt;lo_device = 0;<br>
+	lo-&gt;second_device = 0;<br>
 	lo-&gt;lo_encrypt_type = 0;<br>
 	lo-&gt;lo_offset = 0;<br>
 	lo-&gt;lo_encrypt_key_size = 0;<br>
--- clean/include/linux/loop.h	Mon Nov 23 06:29:54 1998<br>
+++ linux/include/linux/loop.h	Sat Apr 15 13:22:57 2000<br>
@@ -22,6 +22,7 @@<br>
 	struct dentry	*lo_dentry;<br>
 	int		lo_refcnt;<br>
 	kdev_t		lo_device;<br>
+	kdev_t		second_device;<br>
 	int		lo_offset;<br>
 	int		lo_encrypt_type;<br>
 	int		lo_encrypt_key_size;<br>
@@ -94,6 +95,7 @@<br>
 #define LO_CRYPT_BLOW     4<br>
 #define LO_CRYPT_CAST128  5<br>
 #define LO_CRYPT_IDEA     6<br>
+#define LO_CRYPT_CRC	  7<br>
 #define LO_CRYPT_DUMMY    9<br>
 #define LO_CRYPT_SKIPJACK 10<br>
 #define MAX_LO_CRYPT	20<br>
@@ -126,5 +128,6 @@<br>
 #define LOOP_CLR_FD	0x4C01<br>
 #define LOOP_SET_STATUS	0x4C02<br>
 #define LOOP_GET_STATUS	0x4C03<br>
+#define LOOP_CRC_SET_FD 0x4C04<br>
 <br>
 #endif<br>
--- /dev/null	Sun Jun 27 13:16:23 1999<br>
+++ linux/Documentation/loop.txt	Wed Apr 26 16:00:52 2000<br>
@@ -0,0 +1,55 @@<br>
+			CRC loop method<br>
+			---------------<br>
+			 <a href="mailto:pavel@suse.cz">pavel@suse.cz</a><br>
+<br>
+* What is it good for?<br>
+~~~~~~~~~~~~~~~~~~~~~~<br>
+<br>
+   Assume you have flaky hardware. Your scsi cable is too long, your<br>
+cat likes to chafe against it producing static electricity, and your<br>
+system just crashes from time to time.<br>
+<br>
+   Linux filesystems are designed to be fsck-ed first. If they are<br>
+not, they can do bad things (like crashing system<br>
+completely). Incorrect filesystem is able to induce kernel corruption<br>
+with any results possible. Having flaky io subsystem is equivalent (or<br>
+worse that) unchecked filesystem and it resulted in kernel crashes<br>
+before.<br>
+<br>
+   When you asked on linux-kernel, you were told to shoot your cat and<br>
+make your cable shorter. That is not a option.<br>
+<br>
+   Raid5 is not going to help you in case error is between<br>
+raid-controller and main system. What is worse, raid5 will not help<br>
+you even if error is between raid controller and drives: raid5<br>
+protects you against completely different kind of error: error where<br>
+disk dies and you know it. Undetected io error is something else,<br>
+RAID5 is USELESS there.<br>
+<br>
+   CRC loop method was designed to protect you from exactly this kind<br>
+of situation. It expects io subsystem to produce errors which go away<br>
+when retried (that may not be the case with writes: if you have<br>
+bit-error when writing, subsequent read will discover it, but any<br>
+number of retries is not going to help).<br>
+<br>
+* Usage<br>
+~~~~~~~<br>
+<br>
+   CRC loop method needs two devices to work, main device and crc<br>
+device. It exports loop device which has exactly same contents as main<br>
+device, with exception that errors are generated when crc check<br>
+fails. crc device is used for storing checksums, it has to be as big<br>
+as sizeof(main) / 1024 + 16K.<br>
+<br>
+   CRC loop method has two modes of operation, normal and repair. In<br>
+normal mode, when checksum error is detected on read, failure is<br>
+generated (and error is logged). In repair mode, when checksum error<br>
+is detected on read, failure is logged, but data on crc device is<br>
+updated.<br>
+<br>
+   Repair mode is usefull when first installing CRC loop method, and<br>
+when your machine crashes. [During crash, data could be updated on<br>
+main but not on crc; leading to state with false errors]. Updating<br>
+crcs is actually pretty easy: setup CRC loop in repair mode, then cat<br>
+/dev/loop0 &gt; /dev/null.<br>
+<br>
<p>
And here's software to set it up:<br>
<p>
/*<br>
 * crcsetup.c - setup and control crc's<br>
 */<br>
<p>
#include &lt;stdio.h&gt;<br>
#include &lt;string.h&gt;<br>
#include &lt;ctype.h&gt;<br>
#include &lt;fcntl.h&gt;<br>
#include &lt;unistd.h&gt;<br>
#include &lt;getopt.h&gt;<br>
#include &lt;errno.h&gt;<br>
#include &lt;sys/ioctl.h&gt;<br>
#include &lt;linux/fs.h&gt;<br>
<p>
#define dev_t unsigned short<br>
<p>
#include "/usr/src/linux/include/linux/loop.h"<br>
<p>
static char *progname;<br>
static int repair = 0;<br>
<p>
static char *device = "/dev/loop0";<br>
static char *file = NULL;<br>
static char *crcfile = NULL;<br>
<p>
int set_loop(void)<br>
{<br>
	int offset = 1024;<br>
	struct loop_info loopinfo;<br>
	int	fd, ffd, crcfd, mode, i;<br>
	char buf[1024];<br>
	<br>
	mode = O_RDWR;<br>
	if ((ffd = open (file, O_RDWR)) &lt; 0) {<br>
	  perror (file);<br>
	  return 1;<br>
	}<br>
	if ((crcfd = open (crcfile, O_RDWR)) &lt; 0) {<br>
	  perror (crcfile);<br>
	  return 1;<br>
	}<br>
<p>
	if ((fd = open (device, mode)) &lt; 0) {<br>
	  perror (device);<br>
	  return 1;<br>
	}<br>
<p>
	memset(&amp;loopinfo, 0, sizeof(loopinfo));<br>
	strncpy(loopinfo.lo_name, file, LO_NAME_SIZE);<br>
	loopinfo.lo_name[LO_NAME_SIZE-1] = 0;<br>
	loopinfo.lo_encrypt_type = LO_CRYPT_CRC;<br>
	loopinfo.lo_offset = offset;<br>
	loopinfo.lo_encrypt_key_size = repair;<br>
	if (ioctl(fd, LOOP_SET_FD, ffd) &lt; 0) {<br>
		perror("ioctl: LOOP_SET_FD");<br>
		exit(1);<br>
	}<br>
	if (ioctl(fd, LOOP_SET_STATUS, &amp;loopinfo) &lt; 0) {<br>
		(void) ioctl(fd, LOOP_CLR_FD, 0);<br>
		perror("ioctl: LOOP_SET_STATUS");<br>
		exit(1);<br>
	}<br>
	if (ioctl(fd, LOOP_CRC_SET_FD, crcfd) &lt; 0) {<br>
		perror("ioctl: LOOP_CRC_SET_FD");<br>
		exit(1);<br>
	}<br>
	close(fd);<br>
	close(ffd);<br>
	return 0;<br>
}<br>
<p>
static int usage(void)<br>
{<br>
	fprintf(stderr, "usage:\n\<br>
  %s -d loop_device -f main_device -c crc_device [-r]\n", progname);<br>
	exit(1);<br>
}<br>
<p>
<p>
int main(int argc, char **argv)<br>
{<br>
	char c;<br>
<p>
	progname = argv[0];<br>
	while ((c = getopt(argc,argv,"d:f:c:r")) != EOF) {<br>
		switch (c) {<br>
			case 'd':<br>
				device = optarg;<br>
				break;<br>
			case 'f':<br>
				file = optarg;<br>
				break;<br>
			case 'c':<br>
				crcfile = optarg;<br>
				break;<br>
			case 'r':<br>
				repair = 1;<br>
				break;<br>
			default:<br>
				usage();<br>
		}<br>
	}<br>
	if ((!file) || (!crcfile))<br>
		usage();<br>
	set_loop();<br>
	return 0;<br>
}<br>
<p>
<pre>
-- 
I'm <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. "In my country we have almost anarchy and I don't care."
Panos Katsaloulis describing me w.r.t. patents me at <a href="mailto:discuss@linmodems.org">discuss@linmodems.org</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0607.html">Tigran Aivazian: "Re: Kernel Debugging"</a>
<li> <b>Previous message:</b> <a href="0605.html">Trond Myklebust: "Re: 2.3.99-pre6-pre7 sync_page in remove_inode_page"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
