<!-- received="Fri Apr 28 04:17:34 2000 EET DST" -->
<!-- sent="Thu, 27 Apr 2000 21:13:39 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@mandrakesoft.com" -->
<!-- subject="Re: [PATCH] PCI quirk for VIA ACPI device" -->
<!-- id="" -->
<!-- inreplyto="[PATCH] PCI quirk for VIA ACPI device" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: [PATCH] PCI quirk for VIA ACPI device</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] PCI quirk for VIA ACPI device</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@mandrakesoft.com"><i>jgarzik@mandrakesoft.com</i></a>)<br>
<i>Thu, 27 Apr 2000 21:13:39 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#749">[ date ]</a><a href="index.html#749">[ thread ]</a><a href="subject.html#749">[ subject ]</a><a href="author.html#749">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0750.html">Benjamin Close: "Re: PCI irq fix"</a>
<li> <b>Previous message:</b> <a href="0748.html">G. Hugh Song: "Re: Reading the BSD partition table from Linux/Intel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------49111C6FF7F37FD09A56036C<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Andrey Panin wrote:<br>
<i>&gt; </i><br>
<i>&gt; Hi all,</i><br>
<i>&gt; </i><br>
<i>&gt; this patch (against 2.3.99-pre5) provides PCI quirk for VIA ACPI device (same as for Intel and ALI).</i><br>
<i>&gt; Also modified PIIX4 and VIA support in /linux/arch/i386/kernel/acpi.c to use ioport</i><br>
<i>&gt; base address from pci_dev structure.</i><br>
<p>
ACPI works on my Via test systems both with and without ACPI disabled in<br>
BIOS[1].  I'm curious why this quirk is necessary?<br>
<p>
Are you ever booting into Windows?  I think ACPI needs the attached<br>
patch, and it may positively affect your situation...<br>
<p>
	Jeff<br>
<p>
<p>
<p>
<p>
<p>
<p>
[1] net effect:  absence or presence of ACPI tables<br>
<p>
<pre>
-- 
Jeff Garzik              | Nothing cures insomnia like the
Building 1024            | realization that it's time to get up.
MandrakeSoft, Inc.       |        -- random fortune
--------------49111C6FF7F37FD09A56036C
Content-Type: text/plain; charset=us-ascii;
 name="acpi.patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="acpi.patch"
<p>
Index: arch/i386/kernel/acpi.c
===================================================================
RCS file: /g/cvslan/linux_2_3/arch/i386/kernel/acpi.c,v
retrieving revision 1.1.1.17
retrieving revision 1.1.1.17.4.1
diff -u -r1.1.1.17 -r1.1.1.17.4.1
--- arch/i386/kernel/acpi.c	2000/04/26 01:51:29	1.1.1.17
+++ arch/i386/kernel/acpi.c	2000/04/27 00:41:54	1.1.1.17.4.1
@@ -773,6 +773,10 @@
 static int __init acpi_probe(struct pci_dev *dev,
 			     const struct pci_device_id *id)
 {
+	int rc = pci_enable_device (dev);
+	if (rc)
+		return rc;
+
 	return acpi_chip_info[id-&gt;driver_data].chip_init(dev);
 }
 
@@ -1619,6 +1623,7 @@
 int __init acpi_init(void)
 {
 	struct acpi_facp *facp = NULL;
+	int rc;
 
 	if (acpi)
 		acpi_setup(acpi);
@@ -1627,12 +1632,12 @@
 		return -ENODEV;
 	}
 	else if (acpi_opts &amp; ACPI_TABLES_ONLY) {
-		if (acpi_find_tables())
-			return -ENODEV;
+		rc = acpi_find_tables();
+		if (rc) return rc;
 	}
 	else if (acpi_opts &amp; ACPI_CHIPSET_ONLY) {
-		if (acpi_find_chipset())
-			return -ENODEV;
+		int rc = acpi_find_chipset();
+		if (rc) return rc;
 	}
 	else {
 		switch (acpi_find_tables()) {
<p>
--------------49111C6FF7F37FD09A56036C--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0750.html">Benjamin Close: "Re: PCI irq fix"</a>
<li> <b>Previous message:</b> <a href="0748.html">G. Hugh Song: "Re: Reading the BSD partition table from Linux/Intel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
