<!-- received="Fri Apr 28 13:44:08 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 12:36:30 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="Re: [PATCH] C++ breaks on linux/ioport.h" -->
<!-- id="" -->
<!-- inreplyto="[PATCH] C++ breaks on linux/ioport.h" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: [PATCH] C++ breaks on linux/ioport.h</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] C++ breaks on linux/ioport.h</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Fri, 28 Apr 2000 12:36:30 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#809">[ date ]</a><a href="index.html#809">[ thread ]</a><a href="subject.html#809">[ subject ]</a><a href="author.html#809">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0810.html">Christian Zietz: "[patch] reset ATAPI device before probing, 2.2.14"</a>
<li> <b>Previous message:</b> <a href="0808.html">Trond Myklebust: "invalidate_inode_pages() and mmap()"</a>
<li> <b>Maybe in reply to:</b> <a href="0639.html">Stepan Kasal: "[PATCH] C++ breaks on linux/ioport.h"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0811.html">Manfred Spraul: "Re: [PATCH] C++ breaks on linux/ioport.h"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------368A71064C6861457955BABF<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Jamie Lokier wrote:<br>
<i>&gt; </i><br>
<i>&gt; That's because Domonik really meant:</i><br>
<i>&gt; </i><br>
<i>&gt;    extern "C" {</i><br>
<i>&gt;      #define new     c_new</i><br>
<i>&gt;      #define virtual c_virtual</i><br>
<i>&gt;      #include &lt;linux/header1.h&gt;</i><br>
<i>&gt;      #include &lt;linux/header2.h&gt;</i><br>
<i>&gt;      #undef  new</i><br>
<i>&gt;      #undef  virtual</i><br>
<i>&gt;    }</i><br>
<i>&gt; </i><br>
Ok, I tried that, but there is still one remaining problem:<br>
the "page_address()" macro dereferences virtual, thus you cannot use<br>
page_address() from within the cpp module.<br>
<p>
I've attached a patch, "drivers/net/dummy.cpp" now compiles.<br>
<p>
<pre>
--
	Manfred
--------------368A71064C6861457955BABF
Content-Type: text/plain; charset=us-ascii;
 name="patch-cpp"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-cpp"
<p>
// $Header$
// Kernel Version:
//  VERSION = 2
//  PATCHLEVEL = 3
//  SUBLEVEL = 99
//  EXTRAVERSION = -pre6
--- 2.3/include/linux/signal.h	Tue Jan 26 01:04:20 1999
+++ build-2.3/include/linux/signal.h	Fri Apr 28 12:18:50 2000
@@ -189,7 +189,7 @@
 		memset(&amp;set-&gt;sig[1], 0, sizeof(long)*(_NSIG_WORDS-1));
 		break;
 	case 2: set-&gt;sig[1] = 0;
-	case 1:
+	case 1:;
 	}
 }
 
@@ -201,7 +201,7 @@
 		memset(&amp;set-&gt;sig[1], -1, sizeof(long)*(_NSIG_WORDS-1));
 		break;
 	case 2: set-&gt;sig[1] = -1;
-	case 1:
+	case 1:;
 	}
 }
 
--- 2.3/include/asm-i386/semaphore.h	Tue Feb  1 22:10:55 2000
+++ build-2.3/include/asm-i386/semaphore.h	Fri Apr 28 12:18:50 2000
@@ -320,7 +320,7 @@
 		"2:\tcall __rwsem_wake\n\t"
 		"jmp 1b\n"
 		".previous"
-		::"a" (sem)
+		: :"a" (sem)
 		:"memory"
 		);
 }
@@ -339,7 +339,7 @@
 		"2:\tcall __rwsem_wake\n\t"
 		"jmp 1b\n"
 		".previous"
-		::"a" (sem)
+		: :"a" (sem)
 		:"memory"
 		);
 }
--- 2.3/include/linux/mm.h	Thu Apr 27 11:27:24 2000
+++ build-2.3/include/linux/mm.h	Fri Apr 28 12:20:34 2000
@@ -450,7 +450,10 @@
 
 extern unsigned long do_brk(unsigned long, unsigned long);
 
-struct zone_t;
+#ifndef _LINUX_MMZONE_H
+struct zone_struct;
+typedef struct zone_struct zone_t;
+#endif
 /* filemap.c */
 extern void remove_inode_page(struct page *);
 extern unsigned long page_unuse(struct page *);
--- 2.3/include/asm-i386/system.h	Thu Apr 27 11:27:16 2000
+++ build-2.3/include/asm-i386/system.h	Fri Apr 28 12:16:25 2000
@@ -149,7 +149,7 @@
 		movl 4(%0), %%edx;
 		cmpxchg8b (%0);
 		jnz 1b"
-	::		"D"(ptr),
+	: :		"D"(ptr),
 			"b"(low),
 			"c"(high)
 	:
--- 2.3/drivers/net/dummy.c	Thu Aug 19 21:04:35 1999
+++ build-2.3/drivers/net/dummy.cpp	Fri Apr 28 12:23:36 2000
@@ -29,7 +29,10 @@
 */
 
 /* To have statistics (just packets sent) define this */
-
+extern "C" {
+#define new c_new
+#define virtual c_virtual
+#define typename c_typename
 #include &lt;linux/config.h&gt;
 #include &lt;linux/kernel.h&gt;
 #include &lt;linux/module.h&gt;
@@ -52,6 +55,9 @@
 #include &lt;linux/netdevice.h&gt;
 #include &lt;linux/etherdevice.h&gt;
 #include &lt;linux/skbuff.h&gt;
+#undef new
+#undef virtual
+#undef typename
 
 static int dummy_xmit(struct sk_buff *skb, struct net_device *dev);
 static struct net_device_stats *dummy_get_stats(struct net_device *dev);
@@ -145,6 +151,8 @@
 {
 	/* Find a name for this unit */
 	int err=dev_alloc_name(&amp;dev_dummy,"dummy%d");
+	struct page* ttt = NULL;
+	unsigned long test = page_address(ttt);
 	if(err&lt;0)
 		return err;
 	if (register_netdev(&amp;dev_dummy) != 0)
@@ -159,3 +167,4 @@
 	dev_dummy.priv = NULL;
 }
 #endif /* MODULE */
+}
<p>
--------------368A71064C6861457955BABF--
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0810.html">Christian Zietz: "[patch] reset ATAPI device before probing, 2.2.14"</a>
<li> <b>Previous message:</b> <a href="0808.html">Trond Myklebust: "invalidate_inode_pages() and mmap()"</a>
<li> <b>Maybe in reply to:</b> <a href="0639.html">Stepan Kasal: "[PATCH] C++ breaks on linux/ioport.h"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0811.html">Manfred Spraul: "Re: [PATCH] C++ breaks on linux/ioport.h"</a>
<!-- reply="end" -->
</ul>
</font></body>
