<!-- received="Fri Apr 28 22:01:52 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 11:57:23 -0700 (PDT)" -->
<!-- name="Chris Mason" -->
<!-- email="mason@suse.com" -->
<!-- subject="patch: kernel changes from reiserfs" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: patch: kernel changes from reiserfs</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>patch: kernel changes from reiserfs</h1>
<b>Chris Mason</b> (<a href="mailto:mason@suse.com"><i>mason@suse.com</i></a>)<br>
<i>Fri, 28 Apr 2000 11:57:23 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#874">[ date ]</a><a href="index.html#874">[ thread ]</a><a href="subject.html#874">[ subject ]</a><a href="author.html#874">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0875.html">Mr. Berkley Shands: "slab.c change request"</a>
<li> <b>Previous message:</b> <a href="0873.html">(no name): "(no subject)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hello again,<br>
<p>
Here are the 3 new changes outside the reiserfs source included in the<br>
lastest reiserfs patch.  I thought it would be easier for people to make<br>
comments if I posted them outside the reiserfs patch...<br>
<p>
The fs/buffer.c change locks the super before calling write_super.<br>
super.c does this already, and since I need to unlock the super while<br>
closing a transaction, I need everyone to lock the super before<br>
writing.<br>
<p>
The fs/inode.c and fs.h changes allow the FS to provide a dirty_inode<br>
call.  I'm using this to log the inodes instead of allowing them to hit<br>
the dirty list, which saves me from deadlocks when try_to_free_pages<br>
forces a flush of the dirty inode list.<br>
<p>
--- diff/linux-2.3.99-pre6/fs/buffer.c	Fri Apr 28 12:09:15 2000<br>
+++ linux/fs/buffer.c	Thu Apr 27 20:52:49 2000<br>
@@ -336,10 +336,11 @@<br>
 <br>
 	/* sync the superblock to buffers */<br>
 	sb = inode-&gt;i_sb;<br>
-	wait_on_super(sb);<br>
+	lock_super(sb) ;<br>
 	if (sb-&gt;s_op &amp;&amp; sb-&gt;s_op-&gt;write_super)<br>
 		sb-&gt;s_op-&gt;write_super(sb);<br>
 <br>
+	unlock_super(sb) ;<br>
 	/* .. finally sync the buffers to disk */<br>
 	dev = inode-&gt;i_dev;<br>
 	ret = sync_buffers(dev, 1);<br>
--- diff/linux-2.3.99-pre6/fs/inode.c	Fri Apr 28 12:09:16 2000<br>
+++ linux/fs/inode.c	Thu Apr 27 20:52:50 2000<br>
@@ -126,6 +126,11 @@<br>
 {<br>
 	struct super_block * sb = inode-&gt;i_sb;<br>
 <br>
+	if (inode-&gt;i_sb &amp;&amp; inode-&gt;i_sb-&gt;s_op &amp;&amp; inode-&gt;i_sb-&gt;s_op-&gt;dirty_inode){<br>
+	        inode-&gt;i_sb-&gt;s_op-&gt;dirty_inode(inode) ;<br>
+	        return ;<br>
+	}<br>
+<br>
 	if (sb) {<br>
 		spin_lock(&amp;inode_lock);<br>
 		if (!(inode-&gt;i_state &amp; I_DIRTY)) {<br>
--- linux/include/linux/fs.h.1	Fri Apr 28 14:46:25 2000<br>
+++ linux/include/linux/fs.h	Fri Apr 28 14:46:28 2000<br>
@@ -744,6 +744,7 @@<br>
 struct super_operations {<br>
 	void (*read_inode) (struct inode *);<br>
 	void (*write_inode) (struct inode *);<br>
+	void (*dirty_inode) (struct inode *);<br>
 	void (*put_inode) (struct inode *);<br>
 	void (*delete_inode) (struct inode *);<br>
 	void (*put_super) (struct super_block *);<br>
<p>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0875.html">Mr. Berkley Shands: "slab.c change request"</a>
<li> <b>Previous message:</b> <a href="0873.html">(no name): "(no subject)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
