<!-- received="Fri Apr 28 22:29:43 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 16:15:22 -0300" -->
<!-- name="Cesar Eduardo Barros" -->
<!-- email="cesarb@web4u.com.br" -->
<!-- subject="[PATCH] rtc.c fix" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] rtc.c fix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] rtc.c fix</h1>
<b>Cesar Eduardo Barros</b> (<a href="mailto:cesarb@web4u.com.br"><i>cesarb@web4u.com.br</i></a>)<br>
<i>Fri, 28 Apr 2000 16:15:22 -0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#880">[ date ]</a><a href="index.html#880">[ thread ]</a><a href="subject.html#880">[ subject ]</a><a href="author.html#880">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0881.html">Andi Kleen: "Re: patch: kernel changes from reiserfs"</a>
<li> <b>Previous message:</b> <a href="0879.html">Yuri Dennis Ramos Ramirez: "Necesito el software del sonido de Yamaha"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1020.html">Jeff Garzik: "Re: [PATCH] rtc.c fix"</a>
<li> <b>Reply:</b> <a href="1020.html">Jeff Garzik: "Re: [PATCH] rtc.c fix"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch fixes several SMP issues found in rtc.c<br>
<p>
1. If running rtc_ioctl RTC_PIE_OFF in one CPU and rtc_interrupt in another at<br>
   the same time, rtc_ioctl might remove the timer after rtc_interrupt had read<br>
   rtc_status but before mod_timer was called, which would leave the timer<br>
   active while rtc_status would say it was off (possible crash on module<br>
   unload)<br>
2. rtc_read didn't read rtc_irq_data atomically wrt it being modified in<br>
   rtc_interrupt<br>
3. Lots of unneccesary flag savings (no place in the file really needed<br>
   save_flags)<br>
4. rtc_freq setting in rtc_ioctl wasn't atomic wrt it being used in<br>
   rtc_interrupt or rtc_proc_output<br>
5. On alpha, unless HZ was 1024, rtc_freq would be completely wrong due to it<br>
   being set for the non-alpha case outside a #ifndef __alpha__<br>
6. rtc_dropped_irq didn't do everything rtc_interrupt did<br>
<p>
Thanks to Manfred Spraul for his help. Without him this patch would be a crock,<br>
and wouldn't have fixed half of what it fixes.<br>
<p>
Not tested yet. I plan on testing it this weekend. If it works (and I find<br>
nothing else to fix), I will send it to Linus. So if you think I made something<br>
wrong (again :-) ), please reply before it's too late.<br>
<p>
If you can help me test it on a real SMP (I can only test it with a SMP kernel<br>
on two UP machines), I would appreciate.<br>
<p>
--- linux-2.3.99-pre6/drivers/char/rtc.c	Thu Apr 27 20:37:15 2000<br>
+++ linux-2.3.99-pre6+rtcfix/drivers/char/rtc.c	Fri Apr 28 15:55:34 2000<br>
@@ -38,9 +38,10 @@<br>
  *	1.10    Paul Barton-Davis: add support for async I/O<br>
  *	1.10a	Andrea Arcangeli: Alpha updates<br>
  *	1.10b	Andrew Morton: SMP lock fix<br>
+ *	1.10c	Cesar Barros: SMP locking fixes and cleanup<br>
  */<br>
 <br>
-#define RTC_VERSION		"1.10b"<br>
+#define RTC_VERSION		"1.10c"<br>
 <br>
 #define RTC_IRQ 	8	/* Can't see this changing soon.	*/<br>
 #define RTC_IO_EXTENT	0x10	/* Only really two ports, but...	*/<br>
@@ -124,7 +125,14 @@<br>
 #define RTC_IS_OPEN		0x01	/* means /dev/rtc is in use	*/<br>
 #define RTC_TIMER_ON		0x02	/* missed irq timer active	*/<br>
 <br>
-static atomic_t rtc_status = ATOMIC_INIT(0); /* bitmapped status byte.	*/<br>
+/*<br>
+ * rtc_status is never changed by rtc_interrupt, and ioctl/open/close is<br>
+ * protected by the big kernel lock. However, ioctl can still disable the timer<br>
+ * in rtc_status and then with del_timer after the interrupt has read<br>
+ * rtc_status but before mod_timer is called, which would then reenable the<br>
+ * timer (but you would need to have an awful timing before you'd trip on it)<br>
+ */<br>
+static unsigned long rtc_status = 0;	/* bitmapped status byte.	*/<br>
 static unsigned long rtc_freq = 0;	/* Current periodic IRQ rate	*/<br>
 static unsigned long rtc_irq_data = 0;	/* our output to the world	*/<br>
 <br>
@@ -162,15 +170,17 @@<br>
 	rtc_irq_data += 0x100;<br>
 	rtc_irq_data &amp;= ~0xff;<br>
 	rtc_irq_data |= (CMOS_READ(RTC_INTR_FLAGS) &amp; 0xF0);<br>
+<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
+		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
+<br>
 	spin_unlock (&amp;rtc_lock);<br>
 <br>
+	/* Now do the rest of the actions */<br>
 	wake_up_interruptible(&amp;rtc_wait);	<br>
 <br>
 	if (rtc_async_queue)<br>
 		kill_fasync (rtc_async_queue, SIGIO, POLL_IN);<br>
-<br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)<br>
-		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
 }<br>
 #endif<br>
 <br>
@@ -200,7 +210,18 @@<br>
 <br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		<br>
-	while ((data = xchg(&amp;rtc_irq_data, 0)) == 0) {<br>
+	do {<br>
+		/* First make it right. Then make it fast. Putting this whole<br>
+		 * block within the parentheses of a while would be too<br>
+		 * confusing. And no, xchg() is not the answer. */<br>
+		spin_lock_irq (&amp;rtc_lock);<br>
+		data = rtc_irq_data;<br>
+		rtc_irq_data = 0;<br>
+		spin_unlock_irq (&amp;rtc_lock);<br>
+<br>
+		if (data != 0)<br>
+			break;<br>
+<br>
 		if (file-&gt;f_flags &amp; O_NONBLOCK) {<br>
 			retval = -EAGAIN;<br>
 			goto out;<br>
@@ -210,7 +231,7 @@<br>
 			goto out;<br>
 		}<br>
 		schedule();<br>
-	}<br>
+	} while (1);<br>
 <br>
 	retval = put_user(data, (unsigned long *)buf); <br>
 	if (!retval)<br>
@@ -226,8 +247,6 @@<br>
 static int rtc_ioctl(struct inode *inode, struct file *file, unsigned int cmd,<br>
 		     unsigned long arg)<br>
 {<br>
-<br>
-	unsigned long flags;<br>
 	struct rtc_time wtime; <br>
 <br>
 	switch (cmd) {<br>
@@ -245,10 +264,11 @@<br>
 	case RTC_PIE_OFF:	/* Mask periodic int. enab. bit	*/<br>
 	{<br>
 		mask_rtc_irq_bit(RTC_PIE);<br>
-		if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON) {<br>
+		if (rtc_status &amp; RTC_TIMER_ON) {<br>
+			spin_lock_irq (&amp;rtc_lock);<br>
+			rtc_status &amp;= ~RTC_TIMER_ON;<br>
 			del_timer(&amp;rtc_irq_timer);<br>
-			atomic_set(&amp;rtc_status,<br>
-				   atomic_read(&amp;rtc_status) &amp; ~RTC_TIMER_ON);<br>
+			spin_unlock_irq (&amp;rtc_lock);<br>
 		}<br>
 		return 0;<br>
 	}<br>
@@ -262,11 +282,12 @@<br>
 		if ((rtc_freq &gt; 64) &amp;&amp; (!capable(CAP_SYS_RESOURCE)))<br>
 			return -EACCES;<br>
 <br>
-		if (!(atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)) {<br>
-			atomic_set(&amp;rtc_status,<br>
-				   atomic_read(&amp;rtc_status) | RTC_TIMER_ON);<br>
+		if (!(rtc_status &amp; RTC_TIMER_ON)) {<br>
+			spin_lock_irq (&amp;rtc_lock);<br>
 			rtc_irq_timer.expires = jiffies + HZ/rtc_freq + 2*HZ/100;<br>
 			add_timer(&amp;rtc_irq_timer);<br>
+			rtc_status |= RTC_TIMER_ON;<br>
+			spin_unlock_irq (&amp;rtc_lock);<br>
 		}<br>
 		set_rtc_irq_bit(RTC_PIE);<br>
 		return 0;<br>
@@ -320,7 +341,7 @@<br>
 		if (sec &gt;= 60)<br>
 			sec = 0xff;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		if (!(CMOS_READ(RTC_CONTROL) &amp; RTC_DM_BINARY) ||<br>
 		    RTC_ALWAYS_BCD)<br>
 		{<br>
@@ -331,7 +352,7 @@<br>
 		CMOS_WRITE(hrs, RTC_HOURS_ALARM);<br>
 		CMOS_WRITE(min, RTC_MINUTES_ALARM);<br>
 		CMOS_WRITE(sec, RTC_SECONDS_ALARM);<br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 		return 0;<br>
 	}<br>
@@ -346,8 +367,7 @@<br>
 		unsigned char mon, day, hrs, min, sec, leap_yr;<br>
 		unsigned char save_control, save_freq_select;<br>
 		unsigned int yrs;<br>
-		unsigned long flags;<br>
-			<br>
+<br>
 		if (!capable(CAP_SYS_TIME))<br>
 			return -EACCES;<br>
 <br>
@@ -379,11 +399,11 @@<br>
 		if ((yrs -= epoch) &gt; 255)    /* They are unsigned */<br>
 			return -EINVAL;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		if (!(CMOS_READ(RTC_CONTROL) &amp; RTC_DM_BINARY)<br>
<i> 		    || RTC_ALWAYS_BCD) {</i><br>
 			if (yrs &gt; 169) {<br>
-				spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+				spin_unlock_irq(&amp;rtc_lock);<br>
 				return -EINVAL;<br>
 			}<br>
 			if (yrs &gt;= 100)<br>
@@ -412,7 +432,7 @@<br>
 		CMOS_WRITE(save_control, RTC_CONTROL);<br>
 		CMOS_WRITE(save_freq_select, RTC_FREQ_SELECT);<br>
 <br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 		return 0;<br>
 	}<br>
 #ifndef __alpha__<br>
@@ -446,13 +466,13 @@<br>
 		if (arg != (1&lt;&lt;tmp))<br>
 			return -EINVAL;<br>
 <br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		rtc_freq = arg;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
 		val = CMOS_READ(RTC_FREQ_SELECT) &amp; 0xf0;<br>
 		val |= (16 - tmp);<br>
 		CMOS_WRITE(val, RTC_FREQ_SELECT);<br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 		return 0;<br>
 	}<br>
 #else<br>
@@ -489,18 +509,18 @@<br>
 <br>
 static int rtc_open(struct inode *inode, struct file *file)<br>
 {<br>
-	unsigned long flags;<br>
-<br>
-	if(atomic_read(&amp;rtc_status) &amp; RTC_IS_OPEN)<br>
+	/* If someday somebody decides to remove the kernel_lock on open and<br>
+	 * close and ioctl this is gonna get open to races */<br>
+	if(rtc_status &amp; RTC_IS_OPEN)<br>
 		return -EBUSY;<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
 <br>
-	atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) | RTC_IS_OPEN);<br>
+	rtc_status |= RTC_IS_OPEN;<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_lock);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -512,7 +532,6 @@<br>
 <br>
 static int rtc_release(struct inode *inode, struct file *file)<br>
 {<br>
-	unsigned long flags;<br>
 #ifndef __alpha__<br>
 	/*<br>
 	 * Turn off all interrupts once the device is no longer<br>
@@ -521,19 +540,19 @@<br>
 <br>
 	unsigned char tmp;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	tmp = CMOS_READ(RTC_CONTROL);<br>
 	tmp &amp;=  ~RTC_PIE;<br>
 	tmp &amp;=  ~RTC_AIE;<br>
 	tmp &amp;=  ~RTC_UIE;<br>
 	CMOS_WRITE(tmp, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
 <br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON) {<br>
-		atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) &amp; ~RTC_TIMER_ON);<br>
+	if (rtc_status &amp; RTC_TIMER_ON) {<br>
+		rtc_status &amp;= ~RTC_TIMER_ON;<br>
 		del_timer(&amp;rtc_irq_timer);<br>
 	}<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (file-&gt;f_flags &amp; FASYNC) {<br>
 		rtc_fasync (-1, file, 0);<br>
@@ -542,10 +561,10 @@<br>
 #endif<br>
 	MOD_DEC_USE_COUNT;<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
-	atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) &amp; ~RTC_IS_OPEN);<br>
+	spin_unlock_irq (&amp;rtc_lock);<br>
+	rtc_status = rtc_status &amp; ~RTC_IS_OPEN;<br>
 	return 0;<br>
 }<br>
 <br>
@@ -553,13 +572,13 @@<br>
 /* Called without the kernel lock - fine */<br>
 static unsigned int rtc_poll(struct file *file, poll_table *wait)<br>
 {<br>
-	unsigned long l, flags;<br>
+	unsigned long l;<br>
 <br>
 	poll_wait(file, &amp;rtc_wait, wait);<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
 	l = rtc_irq_data;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_lock);<br>
 <br>
 	if (l != 0)<br>
 		return POLLIN | POLLRDNORM;<br>
@@ -592,7 +611,6 @@<br>
 <br>
 static int __init rtc_init(void)<br>
 {<br>
-	unsigned long flags;<br>
 #ifdef __alpha__<br>
 	unsigned int year, ctrl;<br>
 	unsigned long uip_watchdog;<br>
@@ -663,10 +681,10 @@<br>
 		while (jiffies - uip_watchdog &lt; 2*HZ/100)<br>
 			barrier();<br>
 	<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	year = CMOS_READ(RTC_YEAR);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	<br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 		BCD_TO_BIN(year);       /* This should never happen... */<br>
@@ -684,12 +702,12 @@<br>
 #ifndef __alpha__<br>
 	init_timer(&amp;rtc_irq_timer);<br>
 	rtc_irq_timer.function = rtc_dropped_irq;<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	/* Initialize periodic freq. to CMOS reset default, which is 1024Hz */<br>
 	CMOS_WRITE(((CMOS_READ(RTC_FREQ_SELECT) &amp; 0xF0) | 0x06), RTC_FREQ_SELECT);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
-#endif<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	rtc_freq = 1024;<br>
+#endif<br>
 <br>
 	printk(KERN_INFO "Real Time Clock Driver v" RTC_VERSION "\n");<br>
 <br>
@@ -699,9 +717,16 @@<br>
 static void __exit rtc_exit (void)<br>
 {<br>
 	/* interrupts and maybe timer disabled at this point by rtc_release */<br>
+	/* FIXME: Maybe??? */<br>
 <br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)<br>
+	if (rtc_status &amp; RTC_TIMER_ON) {<br>
+		spin_lock_irq (&amp;rtc_lock);<br>
+		rtc_status &amp;= ~RTC_TIMER_ON;<br>
 		del_timer(&amp;rtc_irq_timer);<br>
+		spin_unlock_irq (&amp;rtc_lock);<br>
+<br>
+		printk(KERN_WARNING "rtc_exit(), and timer still running.\n");<br>
+	}<br>
 <br>
 	remove_proc_entry ("driver/rtc", NULL);<br>
 	misc_deregister(&amp;rtc_dev);<br>
@@ -735,16 +760,24 @@<br>
 <br>
 static void rtc_dropped_irq(unsigned long data)<br>
 {<br>
-	unsigned long flags;<br>
-<br>
 	printk(KERN_INFO "rtc: lost some interrupts at %ldHz.\n", rtc_freq);<br>
-	mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
+<br>
+	/* Just in case someone disabled the timer from behind our back... */<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
+		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
+<br>
 	rtc_irq_data += ((rtc_freq/HZ)&lt;&lt;8);<br>
 	rtc_irq_data &amp;= ~0xff;<br>
 	rtc_irq_data |= (CMOS_READ(RTC_INTR_FLAGS) &amp; 0xF0);	/* restart */<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
+<br>
+	/* Now we have new data */<br>
+	wake_up_interruptible(&amp;rtc_wait);<br>
+<br>
+	if (rtc_async_queue)<br>
+		kill_fasync (rtc_async_queue, SIGIO, POLL_IN);<br>
 }<br>
 #endif<br>
 <br>
@@ -759,12 +792,13 @@<br>
 	char *p;<br>
 	struct rtc_time tm;<br>
 	unsigned char batt, ctrl;<br>
-	unsigned long flags;<br>
+	unsigned long freq;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	batt = CMOS_READ(RTC_VALID) &amp; RTC_VRT;<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	freq = rtc_freq;<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	p = buf;<br>
 <br>
@@ -821,7 +855,7 @@<br>
 		     YN(RTC_AIE),<br>
 		     YN(RTC_UIE),<br>
 		     YN(RTC_PIE),<br>
-		     rtc_freq,<br>
+		     freq,<br>
 		     batt ? "okay" : "dead");<br>
 <br>
 	return  p - buf;<br>
@@ -844,21 +878,20 @@<br>
 /*<br>
  * Returns true if a clock update is in progress<br>
  */<br>
+/* FIXME shouldn't this be above rtc_init to make it fully inlined? */<br>
 static inline unsigned char rtc_is_updating(void)<br>
 {<br>
-	unsigned long flags;<br>
 	unsigned char uip;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	uip = (CMOS_READ(RTC_FREQ_SELECT) &amp; RTC_UIP);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	return uip;<br>
 }<br>
 <br>
 static void get_rtc_time(struct rtc_time *rtc_tm)<br>
 {<br>
-<br>
-	unsigned long flags, uip_watchdog = jiffies;<br>
+	unsigned long uip_watchdog = jiffies;<br>
 	unsigned char ctrl;<br>
 <br>
 	/*<br>
@@ -881,7 +914,7 @@<br>
 	 * RTC has RTC_DAY_OF_WEEK, we ignore it, as it is only updated<br>
 	 * by the RTC when initially set to a non-zero value.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	rtc_tm-&gt;tm_sec = CMOS_READ(RTC_SECONDS);<br>
 	rtc_tm-&gt;tm_min = CMOS_READ(RTC_MINUTES);<br>
 	rtc_tm-&gt;tm_hour = CMOS_READ(RTC_HOURS);<br>
@@ -889,7 +922,7 @@<br>
 	rtc_tm-&gt;tm_mon = CMOS_READ(RTC_MONTH);<br>
 	rtc_tm-&gt;tm_year = CMOS_READ(RTC_YEAR);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 	{<br>
@@ -913,19 +946,18 @@<br>
 <br>
 static void get_rtc_alm_time(struct rtc_time *alm_tm)<br>
 {<br>
-	unsigned long flags;<br>
 	unsigned char ctrl;<br>
 <br>
 	/*<br>
 	 * Only the values that we read from the RTC are set. That<br>
 	 * means only tm_hour, tm_min, and tm_sec.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	alm_tm-&gt;tm_sec = CMOS_READ(RTC_SECONDS_ALARM);<br>
 	alm_tm-&gt;tm_min = CMOS_READ(RTC_MINUTES_ALARM);<br>
 	alm_tm-&gt;tm_hour = CMOS_READ(RTC_HOURS_ALARM);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 	{<br>
@@ -949,28 +981,28 @@<br>
 static void mask_rtc_irq_bit(unsigned char bit)<br>
 {<br>
 	unsigned char val;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	val = CMOS_READ(RTC_CONTROL);<br>
 	val &amp;=  ~bit;<br>
 	CMOS_WRITE(val, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
+<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 }<br>
 <br>
 static void set_rtc_irq_bit(unsigned char bit)<br>
 {<br>
 	unsigned char val;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	val = CMOS_READ(RTC_CONTROL);<br>
 	val |= bit;<br>
 	CMOS_WRITE(val, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
+<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 }<br>
 #endif<br>
<p>
<pre>
-- 
Cesar Eduardo Barros
<a href="mailto:cesarb@web4u.com.br">cesarb@web4u.com.br</a>
<a href="mailto:cesarb@dcc.ufrj.br">cesarb@dcc.ufrj.br</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0881.html">Andi Kleen: "Re: patch: kernel changes from reiserfs"</a>
<li> <b>Previous message:</b> <a href="0879.html">Yuri Dennis Ramos Ramirez: "Necesito el software del sonido de Yamaha"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1020.html">Jeff Garzik: "Re: [PATCH] rtc.c fix"</a>
<li> <b>Reply:</b> <a href="1020.html">Jeff Garzik: "Re: [PATCH] rtc.c fix"</a>
<!-- reply="end" -->
</ul>
</font></body>
