<!-- received="Fri Apr 28 23:45:22 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 21:35:30 +0000" -->
<!-- name="=?iso-8859-1?Q?Fran=E7ois_romieu?=" -->
<!-- email="romieu@ensta.fr" -->
<!-- subject="[PATCH] 2.3.99pre6 use of mod_timer" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] 2.3.99pre6 use of mod_timer</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.99pre6 use of mod_timer</h1>
<b>=?iso-8859-1?Q?Fran=E7ois_romieu?=</b> (<a href="mailto:romieu@ensta.fr"><i>romieu@ensta.fr</i></a>)<br>
<i>Fri, 28 Apr 2000 21:35:30 +0000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#892">[ date ]</a><a href="index.html#892">[ thread ]</a><a href="subject.html#892">[ subject ]</a><a href="author.html#892">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0893.html">Cesar Eduardo Barros: "Re: [PATCH] rtc.c fix"</a>
<li> <b>Previous message:</b> <a href="0891.html">Andi Kleen: "Re: patch: kernel changes from reiserfs"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0899.html">Jeff Garzik: "Re: [PATCH] 2.3.99pre6 use of mod_timer"</a>
<li> <b>Reply:</b> <a href="0899.html">Jeff Garzik: "Re: [PATCH] 2.3.99pre6 use of mod_timer"</a>
<li> <b>Reply:</b> <a href="0912.html">Jeff Garzik: "Re: [PATCH] 2.3.99pre6 use of mod_timer"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The following makes systematic the use of mod_timer. Currently, mod_timer<br>
is defined in include/linux/timer.h as a faster replacement for the<br>
sequence del_timer, timer.expires=..., add_timer.<br>
Copy of the adequate snippet have been Cc:ed to the identified maintainers.<br>
<p>
diff -u --recursive --new-file linux-2.3.99pre6.orig/arch/mips/sgi/kernel/reset.c linux-2.3.99pre6/arch/mips/sgi/kernel/reset.c<br>
--- linux-2.3.99pre6.orig/arch/mips/sgi/kernel/reset.c	Sat Mar 18 07:11:50 2000<br>
+++ linux-2.3.99pre6/arch/mips/sgi/kernel/reset.c	Fri Apr 28 21:43:34 2000<br>
@@ -88,9 +88,7 @@<br>
 	sgi_hpc_write1 ^= (HPC3_WRITE1_LC0OFF|HPC3_WRITE1_LC1OFF);<br>
 	hpc3mregs-&gt;write1 = sgi_hpc_write1;<br>
 <br>
-	del_timer(&amp;blink_timer);<br>
-	blink_timer.expires = jiffies + data;<br>
-	add_timer(&amp;blink_timer);<br>
+	mod_timer(&amp;blink_timer, jiffies+data);<br>
 }<br>
 <br>
 static void debounce(unsigned long data)<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/arch/mips64/sgi-ip22/ip22-reset.c linux-2.3.99pre6/arch/mips64/sgi-ip22/ip22-reset.c<br>
--- linux-2.3.99pre6.orig/arch/mips64/sgi-ip22/ip22-reset.c	Sat Mar 18 07:11:51 2000<br>
+++ linux-2.3.99pre6/arch/mips64/sgi-ip22/ip22-reset.c	Fri Apr 28 21:43:34 2000<br>
@@ -87,9 +87,7 @@<br>
 	sgi_hpc_write1 ^= (HPC3_WRITE1_LC0OFF|HPC3_WRITE1_LC1OFF);<br>
 	hpc3mregs-&gt;write1 = sgi_hpc_write1;<br>
 <br>
-	del_timer(&amp;blink_timer);<br>
-	blink_timer.expires = jiffies + data;<br>
-	add_timer(&amp;blink_timer);<br>
+	mod_timer(&amp;blink_timer, jiffies+data);<br>
 }<br>
 <br>
 static void debounce(unsigned long data)<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/acorn/block/fd1772.c linux-2.3.99pre6/drivers/acorn/block/fd1772.c<br>
--- linux-2.3.99pre6.orig/drivers/acorn/block/fd1772.c	Sat Mar 18 07:09:29 2000<br>
+++ linux-2.3.99pre6/drivers/acorn/block/fd1772.c	Fri Apr 28 21:43:34 2000<br>
@@ -303,11 +303,9 @@<br>
         timer_active |= (1 &lt;&lt; FLOPPY_TIMER);			\<br>
 	} while(0)<br>
 <br>
-#define	START_TIMEOUT()					\<br>
-    do {						\<br>
-        del_timer( &amp;timeout_timer );			\<br>
-        timeout_timer.expires = jiffies + FLOPPY_TIMEOUT;	\<br>
-        add_timer( &amp;timeout_timer );			\<br>
+#define	START_TIMEOUT()					     \<br>
+    do {						     \<br>
+        mod_timer(&amp;timeout_timer, jiffies+FLOPPY_TIMEOUT); \<br>
 	} while(0)<br>
 <br>
 #define	STOP_TIMEOUT()					\<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/char/dtlk.c linux-2.3.99pre6/drivers/char/dtlk.c<br>
--- linux-2.3.99pre6.orig/drivers/char/dtlk.c	Fri Apr 28 20:58:10 2000<br>
+++ linux-2.3.99pre6/drivers/char/dtlk.c	Fri Apr 28 21:43:35 2000<br>
@@ -241,6 +241,8 @@<br>
 static unsigned int dtlk_poll(struct file *file, poll_table * wait)<br>
 {<br>
 	int mask = 0;<br>
+	unsigned long expires;<br>
+<br>
 	TRACE_TEXT(" dtlk_poll");<br>
 	/*<br>
 	   static long int j;<br>
@@ -261,9 +263,8 @@<br>
 	/* there are no exception conditions */<br>
 <br>
 	/* There won't be any interrupts, so we set a timer instead. */<br>
-	del_timer(&amp;dtlk_timer);<br>
-	dtlk_timer.expires = jiffies + 3*HZ / 100;<br>
-	add_timer(&amp;dtlk_timer);<br>
+	expires = jiffies + 3*HZ / 100;<br>
+	mod_timer(&amp;dtlk_timer, expires);<br>
 <br>
 	return mask;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/char/msp3400.c linux-2.3.99pre6/drivers/char/msp3400.c<br>
--- linux-2.3.99pre6.orig/drivers/char/msp3400.c	Fri Apr 28 20:59:40 2000<br>
+++ linux-2.3.99pre6/drivers/char/msp3400.c	Fri Apr 28 21:43:35 2000<br>
@@ -663,11 +663,8 @@<br>
 	}<br>
 	if (once)<br>
 		msp-&gt;watch_stereo = 0;<br>
-	if (msp-&gt;watch_stereo) {<br>
-		del_timer(&amp;msp-&gt;wake_stereo);<br>
-		msp-&gt;wake_stereo.expires = jiffies + 5*HZ;<br>
-		add_timer(&amp;msp-&gt;wake_stereo);<br>
-	}<br>
+	if (msp-&gt;watch_stereo)<br>
+		mod_timer(&amp;msp-&gt;wake_stereo, jiffies+5*HZ);<br>
 }<br>
 <br>
 static int msp3400c_thread(void *data)<br>
@@ -874,11 +871,8 @@<br>
 		/* unmute */<br>
 		msp3400c_setvolume(client, msp-&gt;left, msp-&gt;right);<br>
 <br>
-		if (msp-&gt;watch_stereo) {<br>
-			del_timer(&amp;msp-&gt;wake_stereo);<br>
-			msp-&gt;wake_stereo.expires = jiffies + 5*HZ;<br>
-			add_timer(&amp;msp-&gt;wake_stereo);<br>
-		}<br>
+		if (msp-&gt;watch_stereo) <br>
+			mod_timer(&amp;msp-&gt;wake_stereo, jiffies+5*HZ);<br>
 <br>
 		if (debug)<br>
 			msp3400c_print_mode(msp);<br>
@@ -1092,11 +1086,8 @@<br>
 		msp3400c_settreble(client, msp-&gt;treble);<br>
 		msp3400c_setvolume(client, msp-&gt;left, msp-&gt;right);<br>
 <br>
-		if (msp-&gt;watch_stereo) {<br>
-			del_timer(&amp;msp-&gt;wake_stereo);<br>
-			msp-&gt;wake_stereo.expires = jiffies + HZ;<br>
-			add_timer(&amp;msp-&gt;wake_stereo);<br>
-		}<br>
+		if (msp-&gt;watch_stereo) <br>
+			mod_timer(&amp;msp-&gt;wake_stereo, jiffies+HZ);<br>
 <br>
 		msp-&gt;active = 0;<br>
 	}<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/char/pc110pad.c linux-2.3.99pre6/drivers/char/pc110pad.c<br>
--- linux-2.3.99pre6.orig/drivers/char/pc110pad.c	Sat Mar 18 07:06:31 2000<br>
+++ linux-2.3.99pre6/drivers/char/pc110pad.c	Fri Apr 28 21:43:35 2000<br>
@@ -70,20 +70,6 @@<br>
 static int active=0;	/* number of concurrent open()s */<br>
 static struct semaphore reader_lock;<br>
 <br>
-/*<br>
- *	set_timer_callback:<br>
- *<br>
- *	Utility to reset a timer to go off some time in the future.<br>
- */<br>
-<br>
-static void set_timer_callback(struct timer_list *timer, int ticks)<br>
-{<br>
-	del_timer(timer);<br>
-	timer-&gt;expires = jiffies+ticks;<br>
-	add_timer(timer);<br>
-}<br>
-<br>
-<br>
 /**<br>
  *	wake_readers:<br>
  *<br>
@@ -178,7 +164,7 @@<br>
 		transition_count=1;<br>
 		recent_transition=1;<br>
 	}<br>
-	set_timer_callback(&amp;tap_timer, current_params.tap_interval);<br>
+	mod_timer(&amp;tap_timer, jiffies + current_params.tap_interval);<br>
 <br>
 	/* changes to transition_count can cause reported button to change */<br>
 	button_pending = 1;<br>
@@ -369,8 +355,8 @@<br>
 				else<br>
 				{<br>
 					bounce=JUST_GONE_DOWN;<br>
-					set_timer_callback(&amp;bounce_timer,<br>
-						current_params.bounce_interval);<br>
+					mod_timer(&amp;bounce_timer,<br>
+						jiffies+current_params.bounce_interval);<br>
 					/* start new stroke/tap */<br>
 					debounced_down=new_down;<br>
 					notify_pad_up_down();<br>
@@ -391,8 +377,8 @@<br>
 				{<br>
 					/* don't trust it yet */<br>
 					bounce=JUST_GONE_UP;<br>
-					set_timer_callback(&amp;bounce_timer,<br>
-						current_params.bounce_interval);<br>
+					mod_timer(&amp;bounce_timer,<br>
+						jiffies+current_params.bounce_interval);<br>
 				}<br>
 			}<br>
 		}<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/char/softdog.c linux-2.3.99pre6/drivers/char/softdog.c<br>
--- linux-2.3.99pre6.orig/drivers/char/softdog.c	Sat Mar 18 07:06:32 2000<br>
+++ linux-2.3.99pre6/drivers/char/softdog.c	Fri Apr 28 21:43:35 2000<br>
@@ -83,9 +83,7 @@<br>
 	/*<br>
 	 *	Activate timer<br>
 	 */<br>
-	del_timer(&amp;watchdog_ticktock);<br>
-	watchdog_ticktock.expires=jiffies + (soft_margin * HZ);<br>
-	add_timer(&amp;watchdog_ticktock);<br>
+	mod_timer(&amp;watchdog_ticktock, jiffies+(soft_margin*HZ));<br>
 	timer_alive=1;<br>
 	return 0;<br>
 }<br>
@@ -104,15 +102,6 @@<br>
 	return 0;<br>
 }<br>
 <br>
-static void softdog_ping(void)<br>
-{<br>
-	/*<br>
-	 *	Refresh the timer.<br>
-	 */<br>
-<br>
-	mod_timer(&amp;watchdog_ticktock, jiffies + (soft_margin * HZ));<br>
-}<br>
-<br>
 static ssize_t softdog_write(struct file *file, const char *data, size_t len, loff_t *ppos)<br>
 {<br>
 	/*  Can't seek (pwrite) on this device  */<br>
@@ -122,9 +111,8 @@<br>
 	/*<br>
 	 *	Refresh the timer.<br>
 	 */<br>
-	if(len)<br>
-	{<br>
-		softdog_ping();<br>
+	if(len) {<br>
+		mod_timer(&amp;watchdog_ticktock, jiffies+(soft_margin*HZ));<br>
 		return 1;<br>
 	}<br>
 	return 0;<br>
@@ -151,7 +139,7 @@<br>
 		case WDIOC_GETBOOTSTATUS:<br>
 			return put_user(0,(int *)arg);<br>
 		case WDIOC_KEEPALIVE:<br>
-			softdog_ping();<br>
+			mod_timer(&amp;watchdog_ticktock, jiffies+(soft_margin*HZ));<br>
 			return 0;<br>
 	}<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/isdn/act2000/module.c linux-2.3.99pre6/drivers/isdn/act2000/module.c<br>
--- linux-2.3.99pre6.orig/drivers/isdn/act2000/module.c	Sat Mar 18 06:54:54 2000<br>
+++ linux-2.3.99pre6/drivers/isdn/act2000/module.c	Fri Apr 28 21:43:35 2000<br>
@@ -279,9 +279,7 @@<br>
 	act2000_receive(card);<br>
         save_flags(flags);<br>
         cli();<br>
-        del_timer(&amp;card-&gt;ptimer);<br>
-        card-&gt;ptimer.expires = jiffies + 3;<br>
-        add_timer(&amp;card-&gt;ptimer);<br>
+        mod_timer(&amp;card-&gt;ptimer, jiffies+3);<br>
         restore_flags(flags);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/isdn/hisax/saphir.c linux-2.3.99pre6/drivers/isdn/hisax/saphir.c<br>
--- linux-2.3.99pre6.orig/drivers/isdn/hisax/saphir.c	Sat Mar 18 07:09:59 2000<br>
+++ linux-2.3.99pre6/drivers/isdn/hisax/saphir.c	Fri Apr 28 21:43:35 2000<br>
@@ -173,11 +173,9 @@<br>
 		goto Start_ISAC;<br>
 	}<br>
 	/* Watchdog */<br>
-	if (cs-&gt;hw.saphir.timer.function) {<br>
-		del_timer(&amp;cs-&gt;hw.saphir.timer);<br>
-		cs-&gt;hw.saphir.timer.expires = jiffies + 1*HZ;<br>
-		add_timer(&amp;cs-&gt;hw.saphir.timer);<br>
-	} else<br>
+	if (cs-&gt;hw.saphir.timer.function) <br>
+		mod_timer(&amp;cs-&gt;hw.saphir.timer, jiffies+1*HZ);<br>
+	else<br>
 		printk(KERN_WARNING "saphir: Spurious timer!\n");<br>
 	writereg(cs-&gt;hw.saphir.ale, cs-&gt;hw.saphir.hscx, HSCX_MASK, 0xFF);<br>
 	writereg(cs-&gt;hw.saphir.ale, cs-&gt;hw.saphir.hscx, HSCX_MASK + 0x40, 0xFF);<br>
@@ -192,9 +190,7 @@<br>
 {<br>
         /* 5 sec WatchDog, so read at least every 4 sec */<br>
 	cs-&gt;readisac(cs, ISAC_RBCH);<br>
-	del_timer(&amp;cs-&gt;hw.saphir.timer);<br>
-	cs-&gt;hw.saphir.timer.expires = jiffies + 1*HZ;<br>
-	add_timer(&amp;cs-&gt;hw.saphir.timer);<br>
+	mod_timer(&amp;cs-&gt;hw.saphir.timer, jiffies+1*HZ);<br>
 }<br>
 <br>
 void<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/isdn/icn/icn.c linux-2.3.99pre6/drivers/isdn/icn/icn.c<br>
--- linux-2.3.99pre6.orig/drivers/isdn/icn/icn.c	Sat Mar 18 06:55:09 2000<br>
+++ linux-2.3.99pre6/drivers/isdn/icn/icn.c	Fri Apr 28 21:43:35 2000<br>
@@ -602,9 +602,7 @@<br>
 		/* schedule b-channel polling again */<br>
 		save_flags(flags);<br>
 		cli();<br>
-		del_timer(&amp;card-&gt;rb_timer);<br>
-		card-&gt;rb_timer.expires = jiffies + ICN_TIMER_BCREAD;<br>
-		add_timer(&amp;card-&gt;rb_timer);<br>
+		mod_timer(&amp;card-&gt;rb_timer, jiffies+ICN_TIMER_BCREAD);<br>
 		card-&gt;flags |= ICN_FLAGS_RBTIMER;<br>
 		restore_flags(flags);<br>
 	} else<br>
@@ -905,9 +903,7 @@<br>
 	/* schedule again */<br>
 	save_flags(flags);<br>
 	cli();<br>
-	del_timer(&amp;card-&gt;st_timer);<br>
-	card-&gt;st_timer.expires = jiffies + ICN_TIMER_DCREAD;<br>
-	add_timer(&amp;card-&gt;st_timer);<br>
+	mod_timer(&amp;card-&gt;st_timer, jiffies+ICN_TIMER_DCREAD);<br>
 	restore_flags(flags);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/isdn/isdn_common.c linux-2.3.99pre6/drivers/isdn/isdn_common.c<br>
--- linux-2.3.99pre6.orig/drivers/isdn/isdn_common.c	Fri Apr 28 20:59:43 2000<br>
+++ linux-2.3.99pre6/drivers/isdn/isdn_common.c	Fri Apr 28 21:43:35 2000<br>
@@ -685,9 +685,7 @@<br>
 <br>
 		save_flags(flags);<br>
 		cli();<br>
-		del_timer(&amp;dev-&gt;timer);<br>
-		dev-&gt;timer.expires = jiffies + ISDN_TIMER_RES;<br>
-		add_timer(&amp;dev-&gt;timer);<br>
+		mod_timer(&amp;dev-&gt;timer, jiffies+ISDN_TIMER_RES);<br>
 		restore_flags(flags);<br>
 	}<br>
 }<br>
@@ -708,11 +706,8 @@<br>
 		dev-&gt;tflags |= tf;<br>
 	else<br>
 		dev-&gt;tflags &amp;= ~tf;<br>
-	if (dev-&gt;tflags) {<br>
-		if (!del_timer(&amp;dev-&gt;timer))	/* del_timer is 1, when active */<br>
-			dev-&gt;timer.expires = jiffies + ISDN_TIMER_RES;<br>
-		add_timer(&amp;dev-&gt;timer);<br>
-	}<br>
+	if (dev-&gt;tflags)<br>
+		mod_timer(&amp;dev-&gt;timer, jiffies+ISDN_TIMER_RES);<br>
 	restore_flags(flags);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/isdn/sc/timer.c linux-2.3.99pre6/drivers/isdn/sc/timer.c<br>
--- linux-2.3.99pre6.orig/drivers/isdn/sc/timer.c	Thu Feb 27 13:57:30 1997<br>
+++ linux-2.3.99pre6/drivers/isdn/sc/timer.c	Fri Apr 28 21:43:35 2000<br>
@@ -91,9 +91,7 @@<br>
 	else  {<br>
 		pr_debug("%s: No signature yet, waiting another %d jiffies.\n", <br>
 			adapter[card]-&gt;devicename, CHECKRESET_TIME);<br>
-		del_timer(&amp;adapter[card]-&gt;reset_timer);<br>
-		adapter[card]-&gt;reset_timer.expires = jiffies + CHECKRESET_TIME;<br>
-		add_timer(&amp;adapter[card]-&gt;reset_timer);<br>
+		mod_timer(&amp;adapter[card]-&gt;reset_timer, jiffies+CHECKRESET_TIME);<br>
 	}<br>
 	restore_flags(flags);<br>
 		<br>
@@ -138,9 +136,7 @@<br>
 	/* Reinitialize the timer */<br>
 	save_flags(flags);<br>
 	cli();<br>
-	del_timer(&amp;adapter[card]-&gt;stat_timer);<br>
-	adapter[card]-&gt;stat_timer.expires = jiffies + CHECKSTAT_TIME;<br>
-	add_timer(&amp;adapter[card]-&gt;stat_timer);<br>
+	mod_timer(&amp;adapter[card]-&gt;stat_timer, jiffies+CHECKSTAT_TIME);<br>
 	restore_flags(flags);<br>
 <br>
 	/* Send a new cePhyStatus message */<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/net/3c59x.c linux-2.3.99pre6/drivers/net/3c59x.c<br>
--- linux-2.3.99pre6.orig/drivers/net/3c59x.c	Fri Apr 28 20:59:43 2000<br>
+++ linux-2.3.99pre6/drivers/net/3c59x.c	Fri Apr 28 21:43:35 2000<br>
@@ -1736,9 +1736,7 @@<br>
 				outw(AckIntr | (vp-&gt;deferred &amp; 0x7ff), ioaddr + EL3_CMD);<br>
 			} while ((status = inw(ioaddr + EL3_CMD)) &amp; IntLatch);<br>
 			/* The timer will reenable interrupts. */<br>
-			del_timer(&amp;vp-&gt;timer);<br>
-			vp-&gt;timer.expires = RUN_AT(1);<br>
-			add_timer(&amp;vp-&gt;timer);<br>
+			mod_timer(&amp;vp-&gt;timer, jiffies+1*HZ);<br>
 			break;<br>
 		}<br>
 		/* Acknowledge the IRQ. */<br>
@@ -1854,9 +1852,7 @@<br>
 				outw(AckIntr | (vp-&gt;deferred &amp; 0x7ff), ioaddr + EL3_CMD);<br>
 			} while ((status = inw(ioaddr + EL3_CMD)) &amp; IntLatch);<br>
 			/* The timer will reenable interrupts. */<br>
-			del_timer(&amp;vp-&gt;timer);<br>
-			vp-&gt;timer.expires = RUN_AT(1);<br>
-			add_timer(&amp;vp-&gt;timer);<br>
+			mod_timer(&amp;vp-&gt;timer, jiffies+1*HZ);<br>
 			break;<br>
 		}<br>
 		/* Acknowledge the IRQ. */<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/net/atp.c linux-2.3.99pre6/drivers/net/atp.c<br>
--- linux-2.3.99pre6.orig/drivers/net/atp.c	Sat Mar 18 07:08:52 2000<br>
+++ linux-2.3.99pre6/drivers/net/atp.c	Fri Apr 28 21:43:35 2000<br>
@@ -571,9 +571,7 @@<br>
 		for (i = 0; i &lt; 6; i++)<br>
 			write_reg_byte(ioaddr, PAR0 + i, dev-&gt;dev_addr[i]);<br>
 #ifdef TIMED_CHECKER<br>
-		del_timer(&amp;atp_timer);<br>
-		atp_timer.expires = jiffies + TIMED_CHECKER;<br>
-		add_timer(&amp;atp_timer);<br>
+		mod_timer(&amp;atp_timer, jiffies+TIMED_CHECKER);<br>
 #endif<br>
 	}<br>
 <br>
@@ -605,9 +603,7 @@<br>
 	for (i = 0; i &lt; 6; i++)<br>
 		write_reg_byte(ioaddr, PAR0 + i, atp_timed_dev-&gt;dev_addr[i]);<br>
 	spin_unlock(&amp;lp-&gt;lock);<br>
-	del_timer(&amp;atp_timer);<br>
-	atp_timer.expires = jiffies + TIMED_CHECKER;<br>
-	add_timer(&amp;atp_timer);<br>
+	mod_timer(&amp;atp_timer, jiffies+TIMED_CHECKER);<br>
 }<br>
 #endif<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/net/wan/cycx_x25.c linux-2.3.99pre6/drivers/net/wan/cycx_x25.c<br>
--- linux-2.3.99pre6.orig/drivers/net/wan/cycx_x25.c	Fri Apr 28 20:58:44 2000<br>
+++ linux-2.3.99pre6/drivers/net/wan/cycx_x25.c	Fri Apr 28 21:43:35 2000<br>
@@ -1513,11 +1513,8 @@<br>
 {<br>
 	x25_channel_t *chan = dev-&gt;priv;<br>
 <br>
-	if (chan-&gt;svc) {<br>
-		del_timer(&amp;chan-&gt;timer);<br>
-		chan-&gt;timer.expires = jiffies + chan-&gt;idle_tmout * HZ;<br>
-		add_timer(&amp;chan-&gt;timer);<br>
-	}<br>
+	if (chan-&gt;svc)<br>
+		mod_timer(&amp;chan-&gt;timer, jiffies+chan-&gt;idle_tmout*HZ);<br>
 }<br>
 #ifdef CYCLOMX_X25_DEBUG<br>
 static void x25_dump_config(TX25Config *conf)<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/scsi/NCR5380.c linux-2.3.99pre6/drivers/scsi/NCR5380.c<br>
--- linux-2.3.99pre6.orig/drivers/scsi/NCR5380.c	Sat Mar 18 06:50:39 2000<br>
+++ linux-2.3.99pre6/drivers/scsi/NCR5380.c	Fri Apr 28 21:43:35 2000<br>
@@ -667,9 +667,7 @@<br>
 	((struct NCR5380_hostdata *) instance-&gt;hostdata)-&gt;next_timer = tmp;<br>
 	*prev = instance;<br>
    <br>
-	del_timer(&amp;usleep_timer);<br>
-	usleep_timer.expires = ((struct NCR5380_hostdata *) expires_first-&gt;hostdata)-&gt;time_expires;<br>
-	add_timer(&amp;usleep_timer);<br>
+	mod_timer(&amp;usleep_timer, ((struct NCR5380_hostdata *) expires_first-&gt;hostdata)-&gt;time_expires);<br>
 	restore_flags(flags);<br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/drivers/scsi/aic7xxx.c linux-2.3.99pre6/drivers/scsi/aic7xxx.c<br>
--- linux-2.3.99pre6.orig/drivers/scsi/aic7xxx.c	Sat Mar 18 07:15:27 2000<br>
+++ linux-2.3.99pre6/drivers/scsi/aic7xxx.c	Fri Apr 28 21:43:35 2000<br>
@@ -3585,9 +3585,7 @@<br>
       if ( !(p-&gt;dev_timer_active &amp; (0x01 &lt;&lt; MAX_TARGETS)) ||<br>
             time_after_eq(p-&gt;dev_timer.expires, p-&gt;dev_expires[i]) )<br>
       {<br>
-        del_timer(&amp;p-&gt;dev_timer);<br>
-        p-&gt;dev_timer.expires = p-&gt;dev_expires[i];<br>
-        add_timer(&amp;p-&gt;dev_timer);<br>
+        mod_timer(&amp;p-&gt;dev_timer, p-&gt;dev_expires[i]);<br>
         p-&gt;dev_timer_active |= (0x01 &lt;&lt; MAX_TARGETS);<br>
       }<br>
     }<br>
@@ -5045,11 +5043,7 @@<br>
                 }<br>
                 else if ( time_after_eq(p-&gt;dev_timer.expires,<br>
                                         p-&gt;dev_expires[tindex]) )<br>
-                {<br>
-                  del_timer(&amp;p-&gt;dev_timer);<br>
-                  p-&gt;dev_timer.expires = p-&gt;dev_expires[tindex];<br>
-                  add_timer(&amp;p-&gt;dev_timer);<br>
-                }<br>
+                  mod_timer(&amp;p-&gt;dev_timer, p-&gt;dev_expires[tindex]);<br>
               }<br>
 #ifdef AIC7XXX_VERBOSE_DEBUGGING<br>
               if( (aic7xxx_verbose &amp; VERBOSE_MINOR_ERROR) ||<br>
@@ -12058,9 +12052,7 @@<br>
       if ( !(p-&gt;dev_timer_active &amp; (0x01 &lt;&lt; MAX_TARGETS)) ||<br>
             time_after_eq(p-&gt;dev_timer.expires, p-&gt;dev_expires[p-&gt;scsi_id]) )<br>
       {<br>
-        del_timer(&amp;p-&gt;dev_timer);<br>
-        p-&gt;dev_timer.expires = p-&gt;dev_expires[p-&gt;scsi_id];<br>
-        add_timer(&amp;p-&gt;dev_timer);<br>
+        mod_timer(&amp;p-&gt;dev_timer, p-&gt;dev_expires[p-&gt;scsi_id]);<br>
         p-&gt;dev_timer_active |= (0x01 &lt;&lt; MAX_TARGETS);<br>
       }<br>
       aic7xxx_reset_channel(p, cmd-&gt;channel, TRUE);<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/net/ipv4/ipmr.c linux-2.3.99pre6/net/ipv4/ipmr.c<br>
--- linux-2.3.99pre6.orig/net/ipv4/ipmr.c	Fri Apr 28 20:58:14 2000<br>
+++ linux-2.3.99pre6/net/ipv4/ipmr.c	Fri Apr 28 21:43:35 2000<br>
@@ -321,7 +321,7 @@<br>
 	struct mfc_cache *c, **cp;<br>
 <br>
 	if (!spin_trylock(&amp;mfc_unres_lock)) {<br>
-		mod_timer(&amp;ipmr_expire_timer, jiffies + HZ/10);<br>
+		mod_timer(&amp;ipmr_expire_timer, jiffies+HZ/10);<br>
 		return;<br>
 	}<br>
 <br>
@@ -661,9 +661,7 @@<br>
 		c-&gt;next = mfc_unres_queue;<br>
 		mfc_unres_queue = c;<br>
 <br>
-		if (!del_timer(&amp;ipmr_expire_timer))<br>
-			ipmr_expire_timer.expires = c-&gt;mfc_un.unres.expires;<br>
-		add_timer(&amp;ipmr_expire_timer);<br>
+		mod_timer(&amp;ipmr_expire_timer, c-&gt;mfc_un.unres.expires);<br>
 	}<br>
 <br>
 	/*<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/net/ipx/af_spx.c linux-2.3.99pre6/net/ipx/af_spx.c<br>
--- linux-2.3.99pre6.orig/net/ipx/af_spx.c	Fri Apr 28 20:59:58 2000<br>
+++ linux-2.3.99pre6/net/ipx/af_spx.c	Fri Apr 28 21:43:35 2000<br>
@@ -466,9 +466,7 @@<br>
         ipxh-&gt;spx.allocseq      = htons(pdata-&gt;alloc);<br>
 <br>
 	/* Reset/Set WD timer */<br>
-        del_timer(&amp;pdata-&gt;watchdog);<br>
-        pdata-&gt;watchdog.expires = jiffies + VERIFY_TIMEOUT;<br>
-        add_timer(&amp;pdata-&gt;watchdog);<br>
+        mod_timer(&amp;pdata-&gt;watchdog, jiffies+VERIFY_TIMEOUT);<br>
 <br>
 	switch(type)<br>
 	{<br>
diff -u --recursive --new-file linux-2.3.99pre6.orig/net/sched/sch_tbf.c linux-2.3.99pre6/net/sched/sch_tbf.c<br>
--- linux-2.3.99pre6.orig/net/sched/sch_tbf.c	Sat Mar 18 07:11:28 2000<br>
+++ linux-2.3.99pre6/net/sched/sch_tbf.c	Fri Apr 28 21:43:35 2000<br>
@@ -232,9 +232,7 @@<br>
 			if (delay == 0)<br>
 				delay = 1;<br>
 <br>
-			del_timer(&amp;q-&gt;wd_timer);<br>
-			q-&gt;wd_timer.expires = jiffies + delay;<br>
-			add_timer(&amp;q-&gt;wd_timer);<br>
+			mod_timer(&amp;q-&gt;wd_timer, jiffies+delay);<br>
 		}<br>
 <br>
 		/* Maybe we have a shorter packet in the queue,<br>
<p>
<pre>
--
Ueimor
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0893.html">Cesar Eduardo Barros: "Re: [PATCH] rtc.c fix"</a>
<li> <b>Previous message:</b> <a href="0891.html">Andi Kleen: "Re: patch: kernel changes from reiserfs"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0899.html">Jeff Garzik: "Re: [PATCH] 2.3.99pre6 use of mod_timer"</a>
<li> <b>Reply:</b> <a href="0899.html">Jeff Garzik: "Re: [PATCH] 2.3.99pre6 use of mod_timer"</a>
<li> <b>Reply:</b> <a href="0912.html">Jeff Garzik: "Re: [PATCH] 2.3.99pre6 use of mod_timer"</a>
<!-- reply="end" -->
</ul>
</font></body>
