<!-- received="Sat Apr 29 17:14:42 2000 EET DST" -->
<!-- sent="Sun, 30 Apr 2000 00:08:13 +1000" -->
<!-- name="Andrew Morton" -->
<!-- email="andrewm@uow.edu.au" -->
<!-- subject="fs/nfsd/vfs.c in 2.3.99-pre7-1" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: fs/nfsd/vfs.c in 2.3.99-pre7-1</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>fs/nfsd/vfs.c in 2.3.99-pre7-1</h1>
<b>Andrew Morton</b> (<a href="mailto:andrewm@uow.edu.au"><i>andrewm@uow.edu.au</i></a>)<br>
<i>Sun, 30 Apr 2000 00:08:13 +1000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#971">[ date ]</a><a href="index.html#971">[ thread ]</a><a href="subject.html#971">[ subject ]</a><a href="author.html#971">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0972.html">Jes Sorensen: "Re: slab.c change request"</a>
<li> <b>Previous message:</b> <a href="0970.html">Richard Torkar: "kswapd @ 60-80% CPU during heavy HD i/o."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------9B0AEAEEE8D2B57C7FA59D42<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Something very bad seems to have happened to it.  NFS doesn't<br>
work at all.<br>
<p>
A hastily-tested fix is attached.  Someone had better check the<br>
assumptions about<br>
errno type errors and nfs type errors.  <br>
<p>
<pre>
-- 
-akpm-
--------------9B0AEAEEE8D2B57C7FA59D42
Content-Type: text/plain; charset=us-ascii;
 name="vfs.patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="vfs.patch"
<p>
--- linux-2.3.99-pre7-1/fs/nfsd/vfs.c	Sat Apr 29 21:26:09 2000
+++ linux-akpm/fs/nfsd/vfs.c	Sat Apr 29 23:56:49 2000
@@ -141,8 +141,8 @@
 	} else {
 		dentry = lookup_one(name, dparent);
 		err = PTR_ERR(dentry);
-		if (err)
-			goto out_nfserr;
+		if (IS_ERR(err))
+			goto out;
 		/*
 		 * check if we have crossed a mount point ...
 		 */
@@ -833,10 +833,10 @@
 		dchild = lookup_one(fname, dentry);
 		err = PTR_ERR(dchild);
 		if (IS_ERR(dchild))
-			goto out_nfserr;
+			goto out;
 		err = fh_compose(resfhp, fhp-&gt;fh_export, dchild);
 		if (err)
-			goto out;
+			goto out_nfserr;
 	} else {
 		/* called from nfsd_proc_create */
 		dchild = resfhp-&gt;fh_dentry;
@@ -955,8 +955,8 @@
 	 */
 	dchild = lookup_one(fname, dentry);
 	err = PTR_ERR(dchild);
-	if(IS_ERR(dchild))
-		goto out_nfserr;
+	if (IS_ERR(dchild))
+		goto out;
 
 	err = fh_compose(resfhp, fhp-&gt;fh_export, dchild);
 	if (err)
@@ -1103,7 +1103,7 @@
 	dnew = lookup_one(fname, dentry);
 	err = PTR_ERR(dnew);
 	if (IS_ERR(dnew))
-		goto out_nfserr;
+		goto out;
 
 	err = vfs_symlink(dentry-&gt;d_inode, dnew, path);
 	if (!err) {
@@ -1168,7 +1168,7 @@
 	dnew = lookup_one(fname, ddir);
 	err = PTR_ERR(dnew);
 	if (IS_ERR(dnew))
-		goto out_nfserr;
+		goto out;
 
 	dold = tfhp-&gt;fh_dentry;
 	dest = dold-&gt;d_inode;
@@ -1233,7 +1233,7 @@
 	odentry = lookup_one(fname, fdentry);
 	err = PTR_ERR(odentry);
 	if (IS_ERR(odentry))
-		goto out_nfserr;
+		goto out;
 
 	err = -ENOENT;
 	if (!odentry-&gt;d_inode)
@@ -1269,8 +1269,6 @@
 
 out_dput_old:
 	dput(odentry);
-	if (err)
-		goto out_nfserr;
 out:
 	return err;
 
@@ -1305,7 +1303,7 @@
 	rdentry = lookup_one(fname, dentry);
 	err = PTR_ERR(rdentry);
 	if (IS_ERR(rdentry))
-		goto out_nfserr;
+		goto out;
 
 	if (!rdentry-&gt;d_inode) {
 		dput(rdentry);
<p>
--------------9B0AEAEEE8D2B57C7FA59D42--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0972.html">Jes Sorensen: "Re: slab.c change request"</a>
<li> <b>Previous message:</b> <a href="0970.html">Richard Torkar: "kswapd @ 60-80% CPU during heavy HD i/o."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
