<!-- received="Sun Jun  4 10:42:46 2000 EET DST" -->
<!-- sent="Sun, 4 Jun 2000 01:35:51 -0600" -->
<!-- name="Erik Andersen" -->
<!-- email="andersen@xmission.com" -->
<!-- subject="[PATCH] fix for sysinfo(2) in 2.4.0-test1" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: [PATCH] fix for sysinfo(2) in 2.4.0-test1</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] fix for sysinfo(2) in 2.4.0-test1</h1>
<b>Erik Andersen</b> (<a href="mailto:andersen@xmission.com"><i>andersen@xmission.com</i></a>)<br>
<i>Sun, 4 Jun 2000 01:35:51 -0600</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#50">[ date ]</a><a href="index.html#50">[ thread ]</a><a href="subject.html#50">[ subject ]</a><a href="author.html#50">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0051.html">James Sutherland: "Mobo dying hard with DMA support"</a>
<li> <b>Previous message:</b> <a href="0049.html">James Sutherland: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I have a version of free I wrote for BusyBox that uses sysinfo (rather then<br>
/proc) to get its information.  Under 2.2.x it reports normal stuff, i.e.<br>
    [andersen@dillweed busybox]$ ./free<br>
		  total         used         free       shared      buffers<br>
      Mem:       127800       124268         3532        16956         7544<br>
     Swap:       128516        13584       114932<br>
    Total:       256316       137852       118464<br>
<p>
while under 2.2.0-test1-ac7 it reports wierd numbers (~ #/4096)<br>
    [andersen@dillweed busybox]$ ./free<br>
		  total         used         free       shared      buffers<br>
      Mem:           30           11           19            0            1<br>
     Swap:           31            0           31<br>
    Total:           61           11           50<br>
<p>
After investigating the problem, it turns out that somewhere during 2.3.x the<br>
values for memory stored in struct sysinfo changed from being stored as bytes<br>
to being units of PAGE_SIZE, but kernel/info.c was never updated to reflect<br>
this change in definition.  <br>
<p>
Breaking free isn't that big of a deal, but I also use sysinfo in init to check<br>
that the box has enough ram from within the init process (and no, mounting<br>
/proc from within init and reading /proc/meminfo is not a good solution.<br>
BusyBox is often used in embedded systems where /proc is not compiled in).<br>
<p>
The following patch reinstates the traditional sysinfo(2) interface by<br>
returning bytes (not units of PAGE_SIZE) for memory values.  <br>
<p>
An additional patch suggestion (not included here) would be to eliminate the<br>
supurfluous "mem_unit" variable from struct_sysinfo in include/linux/kernel.h<br>
and arch/*/mm/init.c.<br>
<p>
 -Erik<br>
<p>
<pre>
--
Erik B. Andersen   Web:    <a href="http://www.xmission.com/~andersen/">http://www.xmission.com/~andersen/</a> 
                   email:  <a href="mailto:andersee@debian.org">andersee@debian.org</a>
--This message was written using 73% post-consumer electrons--
<p>
<p>
<p>
--- linux/kernel/info.c.orig	Mon Aug 23 12:15:53 1999
+++ linux/kernel/info.c	Sun Jun  4 01:13:11 2000
@@ -2,6 +2,8 @@
  * linux/kernel/info.c
  *
  * Copyright (C) 1992 Darren Senn
+ * Fixed to once again return bytes instead of page counts,
+ * June 2000, by Erik Andersen &lt;<a href="mailto:andersee@debian.org">andersee@debian.org</a>&gt;
  */
 
 /* This implements the sysinfo() system call */
@@ -10,7 +12,6 @@
 #include &lt;linux/unistd.h&gt;
 #include &lt;linux/swap.h&gt;
 #include &lt;linux/smp_lock.h&gt;
-
 #include &lt;asm/uaccess.h&gt;
 
 asmlinkage long sys_sysinfo(struct sysinfo *info)
@@ -31,6 +32,17 @@
 
 	si_meminfo(&amp;val);
 	si_swapinfo(&amp;val);
+	
+	/* These are in units of PAGE_SIZE, but this interface
+	 * has always returned bytes.  Make it return bytes */
+	val.totalram*=PAGE_SIZE;
+	val.freeram*=PAGE_SIZE;
+	val.sharedram*=PAGE_SIZE;
+	val.bufferram*=PAGE_SIZE;
+	val.totalswap*=PAGE_SIZE;
+	val.freeswap*=PAGE_SIZE;
+	val.totalhigh*=PAGE_SIZE;
+	val.freehigh*=PAGE_SIZE;
 
 	if (copy_to_user(info, &amp;val, sizeof(struct sysinfo)))
 		return -EFAULT;
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0051.html">James Sutherland: "Mobo dying hard with DMA support"</a>
<li> <b>Previous message:</b> <a href="0049.html">James Sutherland: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
