<!-- received="Sun Jun  4 21:53:32 2000 EET DST" -->
<!-- sent="Sun, 4 Jun 2000 19:18:48 +0100" -->
<!-- name="Steve Dodd" -->
<!-- email="steved@loth.demon.co.uk" -->
<!-- subject="[PATCH] 2.4.0-test1: fix for SMP race in getblk()" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: [PATCH] 2.4.0-test1: fix for SMP race in getblk()</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.4.0-test1: fix for SMP race in getblk()</h1>
<b>Steve Dodd</b> (<a href="mailto:steved@loth.demon.co.uk"><i>steved@loth.demon.co.uk</i></a>)<br>
<i>Sun, 4 Jun 2000 19:18:48 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#140">[ date ]</a><a href="index.html#140">[ thread ]</a><a href="subject.html#140">[ subject ]</a><a href="author.html#140">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0141.html">Steve Dodd: "Re: queue_task()"</a>
<li> <b>Previous message:</b> <a href="0139.html">Steve Dodd: "loop device deadlocks (was Re: LINUX Jobs for 2.4 update)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--uQr8t48UFsdbeI+V<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
This is a repost of a patch which I sent a while back but that never got<br>
merged. Can anyone see any problems with it?<br>
<p>
<p>
--uQr8t48UFsdbeI+V<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="getblk-new2.txt"<br>
<p>
I believe the attached patch fixes a potential race in buffer.c:getblk() on<br>
SMP machines. The problem is that another CPU could potentially add the same<br>
buffer between us checking the hash table and adding the new buffer. Most<br>
callers currently take the big kernel lock first, but some don't - block_write,<br>
for example. I also nuked the comment at the top of get_hash_table, because it<br>
really doesn't seem to make sense..<br>
<p>
--uQr8t48UFsdbeI+V<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="getblk-new2.diff"<br>
<p>
Index: kallsyms-kdb.2/fs/buffer.c<br>
--- kallsyms-kdb.2/fs/buffer.c Sat, 03 Jun 2000 16:48:29 +0100 steved (linux/P/22_buffer.c 1.3.1.1.1.6 644)<br>
+++ kallsyms-kdb.2(w)/fs/buffer.c Sat, 03 Jun 2000 18:36:06 +0100 steved (linux/P/22_buffer.c 1.3.1.1.1.6 644)<br>
@@ -28,6 +28,8 @@<br>
 <br>
 /* async buffer flushing, 1999 Andrea Arcangeli &lt;<a href="mailto:andrea@suse.de">andrea@suse.de</a>&gt; */<br>
 <br>
+/* [6-May-2000, Steve Dodd] fix SMP race in getblk() */<br>
+<br>
 #include &lt;linux/config.h&gt;<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/fs.h&gt;<br>
@@ -495,17 +497,6 @@ static void __remove_from_queues(struct <br>
 	__remove_from_lru_list(bh, bh-&gt;b_list);<br>
 }<br>
 <br>
-static void insert_into_queues(struct buffer_head *bh)<br>
-{<br>
-	struct buffer_head **head = &amp;hash(bh-&gt;b_dev, bh-&gt;b_blocknr);<br>
-<br>
-	spin_lock(&amp;lru_list_lock);<br>
-	write_lock(&amp;hash_table_lock);<br>
-	__hash_link(bh, head);<br>
-	__insert_into_lru_list(bh, bh-&gt;b_list);<br>
-	write_unlock(&amp;hash_table_lock);<br>
-	spin_unlock(&amp;lru_list_lock);<br>
-}<br>
 <br>
 /* This function must only run if there are no other<br>
  * references _anywhere_ to this buffer head.<br>
@@ -530,19 +521,11 @@ static void put_last_free(struct buffer_<br>
 	spin_unlock(&amp;head-&gt;lock);<br>
 }<br>
 <br>
-/*<br>
- * Why like this, I hear you say... The reason is race-conditions.<br>
- * As we don't lock buffers (unless we are reading them, that is),<br>
- * something might happen to it while we sleep (ie a read-error<br>
- * will force it bad). This shouldn't really happen currently, but<br>
- * the code is ready.<br>
- */<br>
-struct buffer_head * get_hash_table(kdev_t dev, int block, int size)<br>
+static struct buffer_head * __get_hash_table(kdev_t dev, int block, int size,<br>
+						struct buffer_head **head)<br>
 {<br>
-	struct buffer_head **head = &amp;hash(dev, block);<br>
 	struct buffer_head *bh;<br>
 <br>
-	read_lock(&amp;hash_table_lock);<br>
 	for(bh = *head; bh; bh = bh-&gt;b_next)<br>
 		if (bh-&gt;b_blocknr == block	&amp;&amp;<br>
 		    bh-&gt;b_size    == size	&amp;&amp;<br>
@@ -550,11 +533,44 @@ struct buffer_head * get_hash_table(kdev<br>
 			break;<br>
 	if (bh)<br>
 		atomic_inc(&amp;bh-&gt;b_count);<br>
+<br>
+	return bh;<br>
+}<br>
+<br>
+struct buffer_head * get_hash_table(kdev_t dev, int block, int size)<br>
+{<br>
+	struct buffer_head **head = &amp;hash(dev, block);<br>
+	struct buffer_head *bh;<br>
+<br>
+	read_lock(&amp;hash_table_lock);<br>
+	bh = __get_hash_table(dev, block, size, head);<br>
 	read_unlock(&amp;hash_table_lock);<br>
 <br>
 	return bh;<br>
 }<br>
 <br>
+static int insert_into_queues_unique(struct buffer_head *bh)<br>
+{<br>
+	struct buffer_head **head = &amp;hash(bh-&gt;b_dev, bh-&gt;b_blocknr);<br>
+	struct buffer_head *alias;<br>
+	int err = 0;<br>
+<br>
+	spin_lock(&amp;lru_list_lock);<br>
+	write_lock(&amp;hash_table_lock);<br>
+<br>
+	alias = __get_hash_table(bh-&gt;b_dev, bh-&gt;b_blocknr, bh-&gt;b_size, head);<br>
+	if (!alias) {<br>
+		__hash_link(bh, head);<br>
+		__insert_into_lru_list(bh, bh-&gt;b_list);<br>
+	} else<br>
+		err = 1;<br>
+<br>
+	write_unlock(&amp;hash_table_lock);<br>
+	spin_unlock(&amp;lru_list_lock);<br>
+<br>
+	return err;<br>
+}<br>
+<br>
 unsigned int get_hardblocksize(kdev_t dev)<br>
 {<br>
 	/*<br>
@@ -831,9 +847,8 @@ repeat:<br>
 	spin_unlock(&amp;free_list[isize].lock);<br>
 <br>
 	/*<br>
-	 * OK, FINALLY we know that this buffer is the only one of<br>
-	 * its kind, we hold a reference (b_count&gt;0), it is unlocked,<br>
-	 * and it is clean.<br>
+	 * OK, we hold a reference (b_count&gt;0) to the buffer,<br>
+	 * it is unlocked, and it is clean.<br>
 	 */<br>
 	if (bh) {<br>
 		init_buffer(bh, end_buffer_io_sync, NULL);<br>
@@ -841,8 +856,16 @@ repeat:<br>
 		bh-&gt;b_blocknr = block;<br>
 		bh-&gt;b_state = 1 &lt;&lt; BH_Mapped;<br>
 <br>
-		/* Insert the buffer into the regular lists */<br>
-		insert_into_queues(bh);<br>
+		/* Insert the buffer into the regular lists; check nobody<br>
+		   else added it first */<br>
+		<br>
+		if (!insert_into_queues_unique(bh))<br>
+			goto out;<br>
+<br>
+		/* someone added it after we last checked the hash table */<br>
+		put_last_free(bh);<br>
+		goto repeat;<br>
+	<br>
 	out:<br>
 		touch_buffer(bh);<br>
 		return bh;<br>
<p>
--uQr8t48UFsdbeI+V--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0141.html">Steve Dodd: "Re: queue_task()"</a>
<li> <b>Previous message:</b> <a href="0139.html">Steve Dodd: "loop device deadlocks (was Re: LINUX Jobs for 2.4 update)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
