<!-- received="Sun Jun  4 23:26:43 2000 EET DST" -->
<!-- sent="Sun, 4 Jun 2000 15:09:13 -0500" -->
<!-- name="Jesse Pollard" -->
<!-- email="pollard@cats-chateau.net" -->
<!-- subject="Re: OS stopping stack buffer overflow exploits" -->
<!-- id="00060415171400.18417@tabby" -->
<!-- inreplyto="AFXYeEvuyR@khim.sch57.msk.ru" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: OS stopping stack buffer overflow exploits</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: OS stopping stack buffer overflow exploits</h1>
<b>Jesse Pollard</b> (<a href="mailto:pollard@cats-chateau.net"><i>pollard@cats-chateau.net</i></a>)<br>
<i>Sun, 4 Jun 2000 15:09:13 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#153">[ date ]</a><a href="index.html#153">[ thread ]</a><a href="subject.html#153">[ subject ]</a><a href="author.html#153">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0154.html">Horst von Brand: "Re: %eax %ax 2.2.15"</a>
<li> <b>Previous message:</b> <a href="0152.html">Martin Dalecki: "RFC Maestro-3i"</a>
<li> <b>In reply to:</b> <a href="0118.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0166.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<li> <b>Next in thread:</b> <a href="0119.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<li> <b>Reply:</b> <a href="0166.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, 04 Jun 2000, Khimenko Victor wrote:<br>
<i>&gt;In &lt;<a href="mailto:200006041042.MAA12176@oboe.it.uc3m.es">200006041042.MAA12176@oboe.it.uc3m.es</a>&gt; Peter T. Breuer (ptb@it.uc3m.es) wrote:</i><br>
<i>&gt;&gt; "A month of sundays ago Florian Weimer wrote:"</i><br>
<i>&gt;&gt;&gt; The C and C++ frontends only generate trampolines if you use a GNU</i><br>
<i>&gt;&gt;&gt; extension (nested functions).</i><br>
<i>&gt;</i><br>
<i>&gt;&gt; And I have no idea why they should want to: nesting is purely a</i><br>
<i>&gt;&gt; question of namespaces and syntactic scoping. It should impact</i><br>
<i>&gt;&gt; the implementation semantics not at all.</i><br>
<i>&gt;</i><br>
<i>&gt;Oh, yeah ? I eagerly wait your implementation of draw_table for sample</i><br>
<i>&gt;below without trampolines (just remember: you can not alter for_each or</i><br>
<i>&gt;use any information about it's implementation - there are exist sparate</i><br>
<i>&gt;compilation units, you know). Oh, and of course such implementation</i><br>
<i>&gt;should work in multi-threaded environment as well...</i><br>
<p>
Only piece I haven't covered is the multi-threaded indirect... Though that<br>
could be done by addressing an array via the thread id...<br>
<p>
<p>
 /* example without tramploine */<br>
 <br>
#include &lt;stdio.h&gt;<br>
 <br>
/*<br>
procedure for_each(_from,_to:integer;procedure _do(x:integer));<br>
var<br>
    i:integer;<br>
begin<br>
    for i:=_from to _to do<br>
        _do(i);<br>
end;<br>
 <br>
procedure draw_table;<br>
var<br>
    y:integer;<br>
    procedure one_step(x:integer);<br>
    begin<br>
        write(x*y:4);<br>
    end;<br>
begin<br>
    for y:=1 to 10 do begin<br>
        for_each(1,10,one_step);<br>
        writeln;<br>
    end;<br>
end;<br>
begin<br>
draw_table;<br>
end.<br>
*/<br>
 <br>
void for_each( int from, int to, void _do( int))<br>
{<br>
    int i;<br>
 <br>
    for (i = from; i &lt;= to; i++) {<br>
        _do(i);<br>
    }<br>
}<br>
 <br>
void one_step_a(int *y, int x)<br>
{<br>
    printf("%4d",x * *y);<br>
}<br>
 <br>
static int *y1;                 /* pointer to data of function */<br>
void one_step (int x)           /* substitution for trampoline */<br>
{<br>
    int *y;<br>
 <br>
    y = y1;<br>
    one_step_a(y,x);<br>
    y1 = y;<br>
}<br>
<p>
void draw_table(void)<br>
{<br>
    int y;<br>
 <br>
    y1 = &amp; y;                   /* new */<br>
    for (y = 1; y &lt;= 10; y++) {<br>
        for_each(1,10,one_step);<br>
        printf("\n");<br>
    }<br>
}<br>
 <br>
int main(void)<br>
{<br>
    draw_table();<br>
    return(0);<br>
}                                                                           <br>
<p>
output is:<br>
<p>
tabby$ ./a.out<br>
   1   2   3   4   5   6   7   8   9  10<br>
   2   4   6   8  10  12  14  16  18  20<br>
   3   6   9  12  15  18  21  24  27  30<br>
   4   8  12  16  20  24  28  32  36  40<br>
   5  10  15  20  25  30  35  40  45  50<br>
   6  12  18  24  30  36  42  48  54  60<br>
   7  14  21  28  35  42  49  56  63  70<br>
   8  16  24  32  40  48  56  64  72  80<br>
   9  18  27  36  45  54  63  72  81  90<br>
  10  20  30  40  50  60  70  80  90 100                                        <br>
<p>
This goes back many years to the original "how is recursion implemented in<br>
pascal". There ARE compilers that don't use trampoline code, just as there<br>
are processors that don't have a hardware stack. Take a look at some of<br>
the old lisp interpreters.<br>
<p>
<pre>
-- 
-------------------------------------------------------------------------
Jesse I Pollard, II
Email: <a href="mailto:pollard@cats-chateau.net">pollard@cats-chateau.net</a>
<p>
Any opinions expressed are solely my own.
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0154.html">Horst von Brand: "Re: %eax %ax 2.2.15"</a>
<li> <b>Previous message:</b> <a href="0152.html">Martin Dalecki: "RFC Maestro-3i"</a>
<li> <b>In reply to:</b> <a href="0118.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0166.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<li> <b>Next in thread:</b> <a href="0119.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<li> <b>Reply:</b> <a href="0166.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- reply="end" -->
</ul>
</font></body>
