<!-- received="Mon Jun  5 03:46:10 2000 EET DST" -->
<!-- sent="4 Jun 2000 17:27:46 -0700" -->
<!-- name="david parsons" -->
<!-- email="orc@pell.portland.or.us" -->
<!-- subject="[PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: [PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch</h1>
<b>david parsons</b> (<a href="mailto:orc@pell.portland.or.us"><i>orc@pell.portland.or.us</i></a>)<br>
<i>4 Jun 2000 17:27:46 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#192">[ date ]</a><a href="index.html#192">[ thread ]</a><a href="subject.html#192">[ subject ]</a><a href="author.html#192">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0193.html">Alan Cox: "Re: New Linux 2.5 - 2.6 TODO (beat it up :)"</a>
<li> <b>Previous message:</b> <a href="0191.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0210.html">Albert D. Cahalan: "Re: [PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch"</a>
<li> <b>Reply:</b> <a href="0210.html">Albert D. Cahalan: "Re: [PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here's the last version of the fancy memory detection patch for people<br>
to work with as they see fit.  As far as I know, it works;  I've tested<br>
it on about 10 machines locally and it works for them, plus a couple of<br>
other people have reported that it works for them.<br>
<p>
<p>
diff -Naur linux-2.4.0orig/Documentation/Configure.help linux-2.4.0exp/Documentation/Configure.help<br>
--- linux-2.4.0orig/Documentation/Configure.help	Wed May 31 12:01:46 2000<br>
+++ linux-2.4.0exp/Documentation/Configure.help	Wed May 31 11:29:19 2000<br>
@@ -185,6 +185,40 @@<br>
   on the Alpha. The only time you would ever not say Y is to say M in<br>
   order to debug the code. Say Y unless you know what you are doing.<br>
 <br>
+Use extended bios calls to detect memory<br>
+CONFIG_MEM_E820<br>
+  The traditional Linux memory detection code for ia32 machines is<br>
+  restricted to detecting 64mb (or 16mb!) of core.   The E820 call,<br>
+  which is used by many operating systems, is a modern replacement<br>
+  for it, which gives back a detailed memory map of usable memory,<br>
+  rom, and ACPI tables.  Older machines ignore this detection method,<br>
+  so you should be able to say Y here unless your machine has<br>
+  problems correctly detecting memory.<br>
+<br>
+Merge adjacent memory regions<br>
+CONFIG_E820_MERGE<br>
+  The E820 bios call may return a fragmented map where many segments<br>
+  of the map are too small to fit a Linux memory table entry onto.<br>
+  This option merges adjacent memory sections together before<br>
+  initializing the Linux memory tables.<br>
+<br>
+Reclaim ACPI table memory (DANGEROUS)<br>
+CONFIG_E820_RECLAIM<br>
+  If you are not using ACPI (CONFIG_ACPI) on this machine, you can<br>
+  use this option to use ACPI tables as regular memory.  This is a<br>
+  dangerous option -- some people have reported that attempting to<br>
+  reclaim ACPI tables result in Linux crashing -- so only answer Y<br>
+  if you know what you are doing.<br>
+<br>
+Use bios call e801 to detect memory<br>
+CONFIG_MEM_E801<br>
+  The E801 bios call was an earlier method for detecting memory on<br>
+  ia32 machines.   It has fallen out of favor, and some modern<br>
+  bioses have broken it so that it returns garbage. The kernel<br>
+  will attempt to use this call if the e820 bios call does not<br>
+  exist on the machine.  It's probably safe to answer Y here,<br>
+  though 99% of the machines out there won't use this call.<br>
+<br>
 High Memory support<br>
 CONFIG_NOHIGHMEM<br>
   Linux can use up to 64 Gigabytes of physical memory on x86 systems.<br>
diff -Naur linux-2.4.0orig/Documentation/i386/zero-page.txt linux-2.4.0exp/Documentation/i386/zero-page.txt<br>
--- linux-2.4.0orig/Documentation/i386/zero-page.txt	Wed May 31 12:01:20 2000<br>
+++ linux-2.4.0exp/Documentation/i386/zero-page.txt	Sat May 27 01:59:31 2000<br>
@@ -29,7 +29,8 @@<br>
 			( struct sys_desc_table_struct )<br>
  0xb0 - 0x1df		Free. Add more parameters here if you really need them.<br>
 <br>
-0x1e0	unsigned long	ALT_MEM_K, alternative mem check, in Kb<br>
+0x1e0	unsigned long	E801_MEM_LOW, e801 # kbytes between 1mb and 16mb<br>
+0x1e4	unsigned long	E801_MEM_HIGH, e801 # kbytes above 16mb<br>
 0x1e8	char		number of entries in E820MAP (below)<br>
 0x1f1	char		size of setup.S, number of sectors<br>
 0x1f2	unsigned short	MOUNT_ROOT_RDONLY (if !=0)<br>
diff -Naur linux-2.4.0orig/Makefile linux-2.4.0exp/Makefile<br>
--- linux-2.4.0orig/Makefile	Wed May 31 12:01:46 2000<br>
+++ linux-2.4.0exp/Makefile	Wed May 31 11:29:19 2000<br>
@@ -336,10 +336,10 @@<br>
 	if [ -f PCMCIA_CHAR_MODULES ]; then inst_mod PCMCIA_CHAR_MODULES pcmcia; fi; \<br>
 	if [ -f PCMCIA_SCSI_MODULES ]; then inst_mod PCMCIA_SCSI_MODULES pcmcia; fi; \<br>
 	\<br>
-	ls -1 -U *.o | sort &gt; $$MODLIB/.allmods; \<br>
+	ls -1 *.o | sort &gt; $$MODLIB/.allmods; \<br>
 	if [ -f $$MODLIB/net/3c59x.o ]; then \<br>
 		mkdir -p $$MODLIB/pcmcia; \<br>
-		ln -nfs ../net/3c59x.o $$MODLIB/pcmcia/3c575_cb.o; \<br>
+		ln -fs ../net/3c59x.o $$MODLIB/pcmcia/3c575_cb.o; \<br>
 		MODULES="$$MODULES 3c575_cb.o"; fi; \<br>
 	echo $$MODULES | tr ' ' '\n' | sort | comm -23 $$MODLIB/.allmods - &gt; $$MODLIB/.misc; \<br>
 	if [ -s $$MODLIB/.misc ]; then inst_mod $$MODLIB/.misc misc; fi; \<br>
diff -Naur linux-2.4.0orig/arch/i386/boot/setup.S linux-2.4.0exp/arch/i386/boot/setup.S<br>
--- linux-2.4.0orig/arch/i386/boot/setup.S	Wed May 31 12:01:19 2000<br>
+++ linux-2.4.0exp/arch/i386/boot/setup.S	Sat May 27 01:59:30 2000<br>
@@ -32,6 +32,9 @@<br>
  *<br>
  * Transcribed from Intel (as86) -&gt; AT&amp;T (gas) by Chris Noe, May 1999.<br>
  * &lt;<a href="mailto:stiker@northlink.com">stiker@northlink.com</a>&gt;<br>
+ *<br>
+ * Extended memory detection made more paranoid by <a href="mailto:orc@pell.chi.il.us">orc@pell.chi.il.us</a> (david<br>
+ * parsons) and Nathan Zook (<a href="mailto:nathan.zook@amd.com">nathan.zook@amd.com</a>), December 1999-February 2000.<br>
  */<br>
 <br>
 #define __ASSEMBLY__<br>
@@ -255,91 +258,99 @@<br>
 loader_panic_mess: .string "Wrong loader, giving up..."<br>
 <br>
 loader_ok:<br>
-# Get memory size (extended mem, kB)<br>
+/* MEMORY DETECTION CODE */<br>
 <br>
 	xorl	%eax, %eax<br>
-	movl	%eax, (0x1e0)<br>
-#ifndef STANDARD_MEMORY_BIOS_CALL<br>
-	movb	%al, (E820NR)<br>
-# Try three different memory detection schemes.  First, try<br>
-# e820h, which lets us assemble a memory map, then try e801h,<br>
-# which returns a 32-bit memory size, and finally 88h, which<br>
-# returns 0-64m<br>
-<br>
-# method E820H:<br>
-# the memory map from hell.  e820h returns memory classified into<br>
-# a whole bunch of different types, and allows memory holes and<br>
-# everything.  We scan through this memory map and build a list<br>
-# of the first 32 memory areas, which we return at [E820MAP].<br>
-#<br>
+	movl	%eax, (0x1e0)		# zero e801_mem_low<br>
+	movl	%eax, (0x1e4)		#  "   e801_mem_high<br>
+	movb	%al, (E820NR)		#  "   e820_nr<br>
+<br>
+/*<br>
+ * Try three different memory detection schemes.  First, try<br>
+ * e820h, which lets us assemble a memory map, then try e801h,<br>
+ * which returns a 32-bit memory size, and finally 88h, which<br>
+ * returns 0-64m<br>
+ */<br>
 <br>
-meme820:<br>
-	movl	$0x534d4150, %edx		# ascii `SMAP'<br>
-	xorl	%ebx, %ebx			# continuation counter<br>
-	movw	$E820MAP, %di			# point into the whitelist<br>
-						# so we can have the bios<br>
-						# directly write into it.<br>
+#ifdef CONFIG_MEM_E820<br>
+<br>
+/*<br>
+ * method E820H:<br>
+ * the memory map from hell.  e820h returns memory classified into<br>
+ * a whole bunch of different types, and allows memory holes and<br>
+ * everything.  We scan through this memory map and build a list<br>
+ * of the first E820MAX memory areas, which we return at [E820MAP].<br>
+ */<br>
+#define SMAP	0x534d4150<br>
 <br>
+meme820:<br>
+	xorl	%ebx, %ebx		# e820 continuation counter<br>
+	movw	$E820MAP, %di		# point di at the map<br>
 jmpe820:<br>
-	movl	$0x0000e820, %eax		# e820, upper word zeroed<br>
-	movl	$20, %ecx			# size of the e820rec<br>
-	pushw	%ds				# data record.<br>
+	pushw	%ds			# set es := ds every time around.<br>
 	popw	%es<br>
-	int	$0x15				# make the call<br>
-	jc	bail820				# fall to e801 if it fails<br>
-<br>
-	cmpl	$0x534d4150, %eax		# check the return is `SMAP'<br>
-	jne	bail820				# fall to e801 if it fails<br>
-<br>
-#	cmpl	$1, 16(%di)			# is this usable memory?<br>
-#	jne	again820<br>
-<br>
-	# If this is usable memory, we save it by simply advancing %di by<br>
-	# sizeof(e820rec).<br>
-	#<br>
-good820:<br>
-	movb	(E820NR), %al			# up to 32 entries<br>
-	cmpb	$E820MAX, %al<br>
-	jnl	bail820<br>
-<br>
-	incb	(E820NR)<br>
-	movw	%di, %ax<br>
-	addw	$20, %ax<br>
-	movw	%ax, %di<br>
-again820:<br>
-	cmpl	$0, %ebx			# check to see if<br>
-	jne	jmpe820				# %ebx is set to EOF<br>
-bail820:<br>
-<br>
-<br>
-# method E801H:<br>
-# memory size is in 1k chunksizes, to avoid confusing loadlin.<br>
-# we store the 0xe801 memory size in a completely different place,<br>
-# because it will most likely be longer than 16 bits.<br>
-# (use 1e0 because that's what Larry Augustine uses in his<br>
-# alternative new memory detection scheme, and it's sensible<br>
-# to write everything into the same place.)<br>
+	movl	$0x0000e820, %eax	# e820, upper word zeroed<br>
+	movl	$SMAP, %edx		# assign magic numbers<br>
+	movl	$E820LEN, %ecx		# we'd like one memory record, please.<br>
+<br>
+	int	$0x15			# make the call<br>
+	jc	fin820			# fall out if it fails<br>
+<br>
+	cmpl	$SMAP, %eax		# did e820 properly move the magic?<br>
+	jne	punte820<br>
+<br>
+	cmpw	$E820LEN, %cx		# did we get back a whole memory record?<br>
+	jne	punte820<br>
+<br>
+stash820:<br>
+	incb	(E820NR)		# up the # of records<br>
+	movb	(E820NR), %al		# If the table fills up<br>
+	cmpb	$E820MAX, %al		# we must flee<br>
+	jnl	fin820<br>
+<br>
+	cmp	$0, %ebx		# any more records in the pipe?<br>
+	jz	fin820			# apparently not<br>
+<br>
+	addw	$E820LEN, %di		# point %di at the next record<br>
+	jmp	jmpe820			# and go around again<br>
+<br>
+punte820:				# if something goes wrong, don't<br>
+	xor	%ah, %ah		# let userland look at this (corrupt?)<br>
+	movb	%ah, (E820NR)		# e820 map.<br>
+fin820:<br>
+<br>
+#endif/*CONFIG_MEM_E820*/<br>
+<br>
+#ifdef CONFIG_MEM_E801<br>
+/*<br>
+ * method E801H:<br>
+ * e801 returns 2 memory chunks: 1 from 1mb to 16mb, and 1 from 16mb up.<br>
+ * return the both of them, low in 1e0h, for compatability with older<br>
+ * versions of memory detection code, and high in 1e4h.<br>
+ */<br>
 <br>
 meme801:<br>
 	movw	$0xe801, %ax<br>
 	int	$0x15<br>
-	jc	mem88<br>
+	jc	fine801<br>
 <br>
-	andl	$0xffff, %edx			# clear sign extend<br>
-	shll	$6, %edx			# and go from 64k to 1k chunks<br>
-	movl	%edx, (0x1e0)			# store extended memory size<br>
 	andl	$0xffff, %ecx			# clear sign extend<br>
- 	addl	%ecx, (0x1e0)			# and add lower memory into<br>
-						# total size.<br>
+	movl	%ecx, (0x1e0)			# store 1kb between 1-16mb<br>
+	andl	$0xffff, %edx			# clear sign extend<br>
+	movl	%edx, (0x1e4)			# store 64kb chunks above 16mb<br>
+fine801:<br>
 <br>
-# Ye Olde Traditional Methode.  Returns the memory size (up to 16mb or<br>
-# 64mb, depending on the bios) in ax.<br>
-mem88:<br>
+#endif/*CONFIG_MEM_E801*/<br>
 <br>
-#endif<br>
+/*<br>
+ * Ye Olde Traditional Methode.  Returns the memory size (up to 16mb or<br>
+ * 64mb, depending on the bios) in ax.<br>
+ */<br>
 	movb	$0x88, %ah<br>
 	int	$0x15<br>
 	movw	%ax, (2)<br>
+<br>
+/* END OF MEMORY DETECTION CODE */<br>
 <br>
 # Set the keyboard repeat rate to the max<br>
 	movw	$0x0305, %ax<br>
diff -Naur linux-2.4.0orig/arch/i386/config.in linux-2.4.0exp/arch/i386/config.in<br>
--- linux-2.4.0orig/arch/i386/config.in	Wed May 31 12:01:46 2000<br>
+++ linux-2.4.0exp/arch/i386/config.in	Wed May 31 11:29:19 2000<br>
@@ -108,6 +108,16 @@<br>
    define_bool CONFIG_X86_PAE y<br>
 fi<br>
 <br>
+mainmenu_option next_comment<br>
+comment 'Memory detection'<br>
+bool 'Use extended bios calls to detect memory' CONFIG_MEM_E820<br>
+if [ "$CONFIG_MEM_E820" = "y" ]; then<br>
+   bool '  Merge adjacent memory regions' CONFIG_E820_MERGE<br>
+   bool '  Reclaim ACPI table memory (DANGEROUS)' CONFIG_E820_RECLAIM<br>
+   bool '  Also try bios call E801' CONFIG_MEM_E801<br>
+fi<br>
+endmenu<br>
+<br>
 if [ "$CONFIG_X86_FXSR" != "y" ]; then<br>
    bool 'Math emulation' CONFIG_MATH_EMULATION<br>
 fi<br>
diff -Naur linux-2.4.0orig/arch/i386/defconfig linux-2.4.0exp/arch/i386/defconfig<br>
--- linux-2.4.0orig/arch/i386/defconfig	Wed May 31 12:01:46 2000<br>
+++ linux-2.4.0exp/arch/i386/defconfig	Wed May 31 11:29:19 2000<br>
@@ -37,6 +37,10 @@<br>
 # CONFIG_X86_MSR is not set<br>
 # CONFIG_X86_CPUID is not set<br>
 CONFIG_NOHIGHMEM=y<br>
+CONFIG_MEM_E820=y<br>
+CONFIG_MEM_E801=y<br>
+CONFIG_E820_MERGE=y<br>
+#CONFIG_MEM_RECLAIM is not set<br>
 # CONFIG_HIGHMEM4G is not set<br>
 # CONFIG_HIGHMEM64G is not set<br>
 # CONFIG_MATH_EMULATION is not set<br>
diff -Naur linux-2.4.0orig/arch/i386/kernel/Makefile linux-2.4.0exp/arch/i386/kernel/Makefile<br>
--- linux-2.4.0orig/arch/i386/kernel/Makefile	Wed May 31 12:01:19 2000<br>
+++ linux-2.4.0exp/arch/i386/kernel/Makefile	Sat May 27 01:59:31 2000<br>
@@ -15,7 +15,7 @@<br>
 O_TARGET := kernel.o<br>
 O_OBJS   := process.o semaphore.o signal.o entry.o traps.o irq.o vm86.o \<br>
 	    ptrace.o i8259.o ioport.o ldt.o setup.o time.o sys_i386.o \<br>
-	    pci-dma.o<br>
+	    pci-dma.o regions.o<br>
 OX_OBJS  := i386_ksyms.o<br>
 MX_OBJS  :=<br>
 <br>
diff -Naur linux-2.4.0orig/arch/i386/kernel/regions.c linux-2.4.0exp/arch/i386/kernel/regions.c<br>
--- linux-2.4.0orig/arch/i386/kernel/regions.c	Wed May 31 12:01:19 2000<br>
+++ linux-2.4.0exp/arch/i386/kernel/regions.c	Wed May 31 11:40:13 2000<br>
@@ -0,0 +1,364 @@<br>
+/*<br>
+ * memory region setup and pruning code<br>
+ *<br>
+ * Copyright (c) 2000 by David Parsons, Nathan Zook.<br>
+ */<br>
+#include &lt;linux/errno.h&gt;<br>
+#include &lt;linux/sched.h&gt;<br>
+#include &lt;linux/kernel.h&gt;<br>
+#include &lt;linux/mm.h&gt;<br>
+#include &lt;linux/stddef.h&gt;<br>
+#include &lt;linux/unistd.h&gt;<br>
+#include &lt;linux/ptrace.h&gt;<br>
+#include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/user.h&gt;<br>
+#include &lt;linux/a.out.h&gt;<br>
+#include &lt;linux/tty.h&gt;<br>
+#include &lt;linux/ioport.h&gt;<br>
+#include &lt;linux/delay.h&gt;<br>
+#include &lt;linux/config.h&gt;<br>
+#include &lt;linux/init.h&gt;<br>
+#include &lt;asm/uaccess.h&gt;<br>
+#include &lt;asm/system.h&gt;<br>
+#include &lt;asm/io.h&gt;<br>
+#include &lt;asm/e820.h&gt;<br>
+<br>
+#define PARAM	((unsigned char *)empty_zero_page)<br>
+<br>
+#define EXT_MEM_K (*(unsigned short *) (PARAM+2))<br>
+#define E801_MEM_LOW (*(unsigned long *) (PARAM+0x1e0))<br>
+#define E801_MEM_HIGH (*(unsigned long *) (PARAM+0x1e4))<br>
+#define E820_MAP_NR (*(char*) (PARAM+E820NR))<br>
+#define E820_MAP    ((unsigned long *) (PARAM+E820MAP))<br>
+<br>
+#define GIGABYTE(x)	((x) * 1024LL * 1024LL * 1024LL)<br>
+#define MEGABYTE(x)	((x) * 1024LL * 1024LL)<br>
+#if FLAG_E820_DEBUG<br>
+#  define E820DBG(x)	printk x<br>
+#else<br>
+#  define E820DBG(x)	<br>
+#endif<br>
+<br>
+/*<br>
+ * Do NOT EVER look at the BIOS memory size location.<br>
+ * It does not work on many machines.<br>
+ */<br>
+#define LOWMEMSIZE()	(639 * 1024)<br>
+<br>
+<br>
+<br>
+static struct excluded_memory memory_hole;<br>
+<br>
+#define Hole	memory_hole.hole<br>
+<br>
+/*<br>
+ * clear_memory_regions() wipes out the memory regions map so that it<br>
+ * can be populated from scratch<br>
+ */<br>
+static void __init clear_memory_regions()<br>
+{<br>
+    physical_memory.nr_region = 0;<br>
+}<br>
+<br>
+<br>
+/*<br>
+ * add_memory_region() adds a memory region, merging and reclaiming memory<br>
+ * as needed.  it returns a bitmask of what happened.<br>
+ */<br>
+enum region_flags __init add_memory_region(__u64 start, __u64 end, __u32 type)<br>
+{<br>
+	int i, x;<br>
+	enum region_flags flag = 0;<br>
+<br>
+#ifdef CONFIG_E820_RECLAIM<br>
+	if ( type == E820_ACPI )<br>
+		flag |= RF_RECLAIM;<br>
+	else<br>
+#endif<br>
+		if (type != E820_RAM)<br>
+			return RF_NOT_RAM;<br>
+<br>
+	if (start == end)<br>
+		return flag|RF_ZERO;<br>
+<br>
+	if (start &gt; end)<br>
+		return RF_TOOLONG;<br>
+<br>
+#ifdef CONFIG_E820_MERGE<br>
+	/* see if we can merge this region with an existing one */<br>
+<br>
+	for (x=0; x &lt; physical_memory.nr_region; x++)<br>
+		if (end == Region[x].start) {<br>
+			/* glue memory region onto the start of this one */<br>
+			Region[x].start = start;<br>
+			break;<br>
+		}<br>
+		else if (Region[x].end == start) {<br>
+			/* glue memory region onto the end of this one */<br>
+			Region[x].end = end;<br>
+			break;<br>
+		}<br>
+	if (x &lt; physical_memory.nr_region) {<br>
+		/* If we've merged a region, check to see if the new region<br>
+		 * want to merge with anyone else.<br>
+		 */<br>
+		if (x &gt; 0 &amp;&amp; Region[x].start == Region[x-1].end) {<br>
+			Region[x-1].end = Region[x].end;<br>
+			for (i=x; i &lt; physical_memory.nr_region; i++)<br>
+				    Region[x] = Region[x+1];<br>
+			physical_memory.nr_region--;<br>
+			x--;<br>
+		}<br>
+		if (x &lt; physical_memory.nr_region-1 &amp;&amp; Region[x].end == Region[x+1].start) {<br>
+			Region[x].end = Region[x+1].end;<br>
+			for (i=x+1; i &lt; physical_memory.nr_region-1; i++)<br>
+				    Region[x] = Region[x+1];<br>
+			physical_memory.nr_region--;<br>
+		}<br>
+		else<br>
+			return flag|RF_MERGED;<br>
+	}<br>
+#endif<br>
+<br>
+	if (physical_memory.nr_region == E820MAX)<br>
+		return flag|RF_OVERFLOW;<br>
+<br>
+	/* insert the new region in order */<br>
+	for (x=0; x &lt; physical_memory.nr_region; x++)<br>
+		if (end &lt; Region[x].start) {<br>
+			/* add it in here */<br>
+			for (i=physical_memory.nr_region; i&gt;x; --i)<br>
+				Region[i] = Region[i-1];<br>
+			Region[x].start = start;<br>
+			Region[x].end   = end;<br>
+			physical_memory.nr_region++;<br>
+			return flag|RF_ADDED;<br>
+		}<br>
+	Region[physical_memory.nr_region].start = start;<br>
+	Region[physical_memory.nr_region].end   = end;<br>
+	physical_memory.nr_region++;<br>
+	return flag|RF_ADDED;<br>
+} /* add_memory_region */<br>
+<br>
+<br>
+void __init print_region_map()<br>
+{<br>
+    int x;<br>
+    for (x = 0; x &lt; physical_memory.nr_region; x++)<br>
+	printk("MEM: %010L-%010L\n", Region[x].start, Region[x].end);<br>
+} /* print_region_map */<br>
+<br>
+<br>
+#if FLAG_E820_DEBUG &amp;&amp; defined(CONFIG_MEM_E820)<br>
+/*<br>
+ * report_memory_region() decodes the return value from add_memory_region<br>
+ */<br>
+static void __init report_memory_region(enum region_flags code)<br>
+{<br>
+	if (code &amp; RF_RECLAIM)<br>
+		printk(" reclaimed");<br>
+	if (code &amp; RF_ADDED)<br>
+		printk(" added");<br>
+	if (code &amp; RF_MERGED)<br>
+		printk(" merged");<br>
+	if (code &amp; RF_NOT_RAM)<br>
+		printk(" rom");<br>
+	if (code &amp; RF_ZERO)<br>
+		printk(" zero-length");<br>
+<br>
+	if (code &amp; RF_OVERFLOW)<br>
+		printk(" ERROR: table overflow");<br>
+	else if (code &amp; RF_TOOLONG)<br>
+		printk(" ERROR: start+size &gt; 64 bits");<br>
+}<br>
+#endif<br>
+<br>
+<br>
+/*<br>
+ * prune_memory_region() checks a memory region to see if it needs to be<br>
+ * cut to fit around memory holes.  It returns the index on the next<br>
+ * memory region to process usually x+1, but it will be x if the memory<br>
+ * region in question is swallowed by a memory hole.<br>
+ */<br>
+static int __init prune_memory_region(int x)<br>
+{<br>
+	int i, ct;<br>
+<br>
+	for (ct = 0; ct &lt; memory_hole.nr_hole; ct++) {<br>
+<br>
+		if (Region[x].start &gt;= Hole[ct].start || Region[x].end &lt;= Hole[ct].end)<br>
+			continue;<br>
+<br>
+		if (Region[x].start &gt;= Hole[ct].start) {<br>
+			if (Region[x].end &lt; Hole[ct].end) {<br>
+				E820DBG(("SMAP: %010Lx - %010Lx dropped\n",<br>
+					    Region[x].start, Region[x].end));<br>
+				for (i=x; i &lt; physical_memory.nr_region; i++)<br>
+					Region[i] = Region[i+1];<br>
+				physical_memory.nr_region--;<br>
+				return x;<br>
+			}<br>
+			else {<br>
+				E820DBG(("SMAP: %010Lx - %010Lx trimmed to %010Lx - %010Lx\n",<br>
+					    Region[x].start, Region[x].end,<br>
+					    Hole[ct].start, Region[x].end));<br>
+				Region[x].start = Hole[ct].start;<br>
+			}<br>
+		}<br>
+		else if (Region[x].end &lt; Hole[ct].end || physical_memory.nr_region &gt;= E820PHYSMAX) {<br>
+			if (physical_memory.nr_region &gt;= E820PHYSMAX)<br>
+				E820DBG(("SMAP: Memory region overflow\n"));<br>
+			E820DBG(("SMAP: %010Lx - %010Lx trimmed to %010Lx - %010Lx\n",<br>
+				    Region[x].start, Region[x].end,<br>
+				    Region[x].start, Hole[ct].start));<br>
+			Region[x].end = Hole[ct].start;<br>
+		}<br>
+		else {<br>
+			E820DBG(("SMAP: %010Lx - %010Lx split to %010Lx - %010Lx, %010Lx - %010Lx\n",<br>
+				Region[x].start, Region[x].end,<br>
+				Region[x].start, Hole[ct].start,<br>
+				Hole[ct].end, Region[x].end));<br>
+			for (i=physical_memory.nr_region; i &gt; x; --i)<br>
+				Region[i+1] = Region[i];<br>
+<br>
+			Region[x+1].start = Hole[ct].end;<br>
+			Region[x+1].end = Region[x].end;<br>
+			Region[x].end = Hole[ct].start;<br>
+			physical_memory.nr_region++;<br>
+		}<br>
+	}<br>
+	return x+1;<br>
+}<br>
+<br>
+<br>
+/*<br>
+ * validate_regions() validates the physical_memory map, plus lops out memory<br>
+ * that lives in suspicious places.<br>
+ */<br>
+int __init validate_regions(void)<br>
+{<br>
+	unsigned int x;<br>
+<br>
+	for (x=0; x &lt; physical_memory.nr_region; ) {<br>
+		if (x &lt; physical_memory.nr_region-1<br>
+				    &amp;&amp; Region[x].end &gt;= Region[x+1].start) {<br>
+			printk("SMAP: region %d (%010Lx - %010Lx) overlaps region %d (%010Lx - %010Lx)\n",<br>
+				    x, Region[x].start,<br>
+				       Region[x].end,<br>
+				    x+1, Region[x+1].start,<br>
+					 Region[x+1].end);<br>
+			return 1;<br>
+		}<br>
+		if ( (x = prune_memory_region(x)) &lt; 0)<br>
+		    return 1;<br>
+	}<br>
+	return 0;<br>
+} /* validate_regions */<br>
+<br>
+<br>
+/*<br>
+ * add_memory_hole() does what you'd think it does.<br>
+ */<br>
+int __init add_memory_hole(__u64 start, __u64 end)<br>
+{<br>
+    int idx;<br>
+<br>
+    if ( (idx=memory_hole.nr_hole) &lt; NR_HOLES) {<br>
+	Hole[idx].start = start;<br>
+	Hole[idx].end   = end;<br>
+	memory_hole.nr_hole ++ ;<br>
+	return 0;<br>
+    }<br>
+    printk("memory hole overflow adding %010Lx-%010Lx\n", start, end);<br>
+    return 1;<br>
+} /* add_memory_hole */<br>
+<br>
+<br>
+/*<br>
+ * setup_detected_memory() build the initial physical_memory.region[] map<br>
+ * from the information returned by the system bios (either an e820 memory<br>
+ * map, a 801 low/high memory map, or the old fashioned 88 call)<br>
+ */<br>
+void __init setup_detected_memory(void)<br>
+{<br>
+	int i;<br>
+	enum region_flags ret;<br>
+<br>
+	add_memory_hole(LOWMEMSIZE(), HIGH_MEMORY);<br>
+#if FLAG_E820_4GB_ONLY<br>
+	add_memory_hole(GIGABYTE(4), (__u64)-1);<br>
+#endif<br>
+	clear_memory_regions();<br>
+<br>
+#ifdef CONFIG_MEM_E820<br>
+	/*<br>
+	 * If we're lucky and live on a modern system, the setup code<br>
+	 * will have given us a memory map that we can use to properly<br>
+	 * set up memory.  If we aren't, we'll fake a memory map.<br>
+	 *<br>
+	 * We check to see that the memory map contains at least 2 elements<br>
+	 * before we'll use it, because the detection code in setup.S may<br>
+	 * not be perfect and most every PC known to man has two memory<br>
+	 * regions: one from 0 to ~640k, and one from 1mb up.<br>
+	 */<br>
+	if ( (E820_MAP_NR &gt; 1) &amp;&amp; (E820_MAP_NR &lt; E820MAX) ) {<br>
+		/* got a memory map; copy it into a safe place.<br>
+		 */<br>
+		physical_memory.nr_bios = E820_MAP_NR;<br>
+		memcpy(&amp;(Bios), E820_MAP, E820_MAP_NR * sizeof Bios[0]);<br>
+		for (i=0; i &lt; E820_MAP_NR; i++) {<br>
+			ret = add_memory_region(Bios[i].addr,<br>
+					Bios[i].addr + Bios[i].size,<br>
+					Bios[i].type);<br>
+#if FLAG_E820_DEBUG<br>
+			printk("SMAP: %010Lx - %010Lx ",<br>
+				Bios[i].addr,<br>
+				Bios[i].addr + Bios[i].size);<br>
+			switch (Bios[i].type) {<br>
+			case E820_RAM:	printk("(usable)");<br>
+					break;<br>
+			case E820_RESERVED:<br>
+					printk("(reserved)");<br>
+					break;<br>
+			case E820_ACPI:<br>
+					printk("(ACPI data)");<br>
+					break;<br>
+			case E820_NVS:<br>
+					printk("(ACPI NVS)");<br>
+					break;<br>
+			default:<br>
+					printk("(type %lu)",<br>
+					    (unsigned long)Bios[i].type);<br>
+					break;<br>
+			}<br>
+			report_memory_region(ret);<br>
+			printk("\n");<br>
+#endif<br>
+			if (ret &amp; (RF_TOOLONG|RF_OVERFLOW))<br>
+				goto oldstyle;<br>
+		}<br>
+		/* after putting in the e820 map, massage it into shape<br>
+		 * for use by the kernel.  If validate_regions returns<br>
+		 * anything except 0, something is very ill in the state<br>
+		 * of the bios map and we'll discard it with extreme<br>
+		 * prejudice.<br>
+		 */<br>
+		if (validate_regions() == 0)<br>
+			return /* the map is fine, so we'll use it */;<br>
+	}<br>
+#endif<br>
+<br>
+    oldstyle:<br>
+	clear_memory_regions();<br>
+<br>
+#ifdef CONFIG_MEM_E801<br>
+	if (E801_MEM_LOW &gt; 0) {<br>
+	    add_memory_region(0, (E801_MEM_LOW&lt;&lt;10)+HIGH_MEMORY, E820_RAM);<br>
+	    add_memory_region(MEGABYTE(16), MEGABYTE(16)+(E801_MEM_HIGH&lt;&lt;16), E820_RAM);<br>
+	}<br>
+	else<br>
+#endif<br>
+	    add_memory_region(0, HIGH_MEMORY+(EXT_MEM_K &lt;&lt; 10), E820_RAM);<br>
+<br>
+	validate_regions();<br>
+} /* setup_detected_memory */<br>
diff -Naur linux-2.4.0orig/arch/i386/kernel/setup.c linux-2.4.0exp/arch/i386/kernel/setup.c<br>
--- linux-2.4.0orig/arch/i386/kernel/setup.c	Wed May 31 12:01:46 2000<br>
+++ linux-2.4.0exp/arch/i386/kernel/setup.c	Wed May 31 12:18:51 2000<br>
@@ -120,7 +120,7 @@<br>
 	unsigned char table[0];<br>
 };<br>
 <br>
-struct e820map e820 = { 0 };<br>
+struct physical_memory physical_memory;<br>
 <br>
 unsigned char aux_device_present;<br>
 <br>
@@ -139,10 +139,7 @@<br>
  */<br>
 #define PARAM	((unsigned char *)empty_zero_page)<br>
 #define SCREEN_INFO (*(struct screen_info *) (PARAM+0))<br>
-#define EXT_MEM_K (*(unsigned short *) (PARAM+2))<br>
-#define ALT_MEM_K (*(unsigned long *) (PARAM+0x1e0))<br>
-#define E820_MAP_NR (*(char*) (PARAM+E820NR))<br>
-#define E820_MAP    ((unsigned long *) (PARAM+E820MAP))<br>
+<br>
 #define APM_BIOS_INFO (*(struct apm_bios_info *) (PARAM+0x40))<br>
 #define DRIVE_INFO (*(struct drive_info_struct *) (PARAM+0x80))<br>
 #define SYS_DESC_TABLE (*(struct sys_desc_table_struct*)(PARAM+0xa0))<br>
@@ -380,9 +377,9 @@<br>
 	}<br>
 }<br>
 <br>
-unsigned long __init memparse(char *ptr, char **retptr)<br>
+unsigned long long __init memparse(char *ptr, char **retptr)<br>
 {<br>
-	unsigned long ret;<br>
+	unsigned long long ret;<br>
 <br>
 	ret = simple_strtoul(ptr, retptr, 0);<br>
 <br>
@@ -394,98 +391,21 @@<br>
 		ret &lt;&lt;= 20;<br>
 		(*retptr)++;<br>
 	}<br>
+	else if (**retptr == 'G' || **retptr == 'g') {<br>
+		ret &lt;&lt;= 30;<br>
+		(*retptr)++;<br>
+	}<br>
 	return ret;<br>
 } /* memparse */<br>
 <br>
 <br>
-void __init add_memory_region(unsigned long start,<br>
-                                  unsigned long size, int type)<br>
-{<br>
-	int x = e820.nr_map;<br>
-<br>
-	if (x == E820MAX) {<br>
-	    printk("Ooops! Too many entries in the memory map!\n");<br>
-	    return;<br>
-	}<br>
-<br>
-	e820.map[x].addr = start;<br>
-	e820.map[x].size = size;<br>
-	e820.map[x].type = type;<br>
-	e820.nr_map++;<br>
-} /* add_memory_region */<br>
-<br>
-#define E820_DEBUG	1<br>
-<br>
-static void __init print_e820_map(void)<br>
-{<br>
-	int i;<br>
-<br>
-	for (i = 0; i &lt; e820.nr_map; i++) {<br>
-		printk(" e820: %016Lx @ %016Lx ",<br>
-			e820.map[i].size, e820.map[i].addr);<br>
-		switch (e820.map[i].type) {<br>
-		case E820_RAM:	printk("(usable)\n");<br>
-				break;<br>
-		case E820_RESERVED:<br>
-				printk("(reserved)\n");<br>
-				break;<br>
-		case E820_ACPI:<br>
-				printk("(ACPI data)\n");<br>
-				break;<br>
-		case E820_NVS:<br>
-				printk("(ACPI NVS)\n");<br>
-				break;<br>
-		default:	printk("type %lu\n", e820.map[i].type);<br>
-				break;<br>
-		}<br>
-	}<br>
-}<br>
-<br>
-/*<br>
- * Do NOT EVER look at the BIOS memory size location.<br>
- * It does not work on many machines.<br>
+/* setup_cmdline_memory() parses the command line looking for mem= arguments,<br>
+ *                     and builds a memory region map out of any that it<br>
+ *                     finds.<br>
+ * it returns 1 if mem= is valid,<br>
+ *            0 if mem= is bogus or there is no mem= to be found.<br>
  */<br>
-#define LOWMEMSIZE()	(0x9f000)<br>
-<br>
-void __init setup_memory_region(void)<br>
-{<br>
-	/*<br>
-	 * If we're lucky and live on a modern system, the setup code<br>
-	 * will have given us a memory map that we can use to properly<br>
-	 * set up memory.  If we aren't, we'll fake a memory map.<br>
-	 *<br>
-	 * We check to see that the memory map contains at least 2 elements<br>
-	 * before we'll use it, because the detection code in setup.S may<br>
-	 * not be perfect and most every PC known to man has two memory<br>
-	 * regions: one from 0 to 640k, and one from 1mb up.  (The IBM<br>
-	 * thinkpad 560x, for example, does not cooperate with the memory<br>
-	 * detection code.)<br>
-	 */<br>
-	if (E820_MAP_NR &gt; 1) {<br>
-		/* got a memory map; copy it into a safe place.<br>
-		 */<br>
-		e820.nr_map = E820_MAP_NR;<br>
-		if (e820.nr_map &gt; E820MAX)<br>
-			e820.nr_map = E820MAX;<br>
-		memcpy(e820.map, E820_MAP, e820.nr_map * sizeof e820.map[0]);<br>
-	}<br>
-	else {<br>
-		/* otherwise fake a memory map; one section from 0k-&gt;640k,<br>
-		 * the next section from 1mb-&gt;appropriate_mem_k<br>
-		 */<br>
-		unsigned long mem_size;<br>
-<br>
-		mem_size = (ALT_MEM_K &lt; EXT_MEM_K) ? EXT_MEM_K : ALT_MEM_K;<br>
-<br>
-		add_memory_region(0, LOWMEMSIZE(), E820_RAM);<br>
-		add_memory_region(HIGH_MEMORY, mem_size &lt;&lt; 10, E820_RAM);<br>
-  	}<br>
-	printk("BIOS-provided physical RAM map:\n");<br>
-	print_e820_map();<br>
-} /* setup_memory_region */<br>
-<br>
-<br>
-static inline void parse_mem_cmdline (char ** cmdline_p)<br>
+static inline int setup_cmdline_memory (char ** cmdline_p)<br>
 {<br>
 	char c = ' ', *to = command_line, *from = COMMAND_LINE;<br>
 	int len = 0;<br>
@@ -509,10 +429,6 @@<br>
 			if (!memcmp(from+4, "nopentium", 9)) {<br>
 				from += 9+4;<br>
 				boot_cpu_data.x86_capability &amp;= ~X86_FEATURE_PSE;<br>
-			} else if (!memcmp(from+4, "exactmap", 8)) {<br>
-				from += 8+4;<br>
-				e820.nr_map = 0;<br>
-				usermem = 1;<br>
 			} else {<br>
 				/* If the user specifies memory size, we<br>
 				 * blow away any automatically generated<br>
@@ -520,23 +436,16 @@<br>
 				 */<br>
 				unsigned long start_at, mem_size;<br>
  <br>
-				if (usermem == 0) {<br>
-					/* first time in: zap the whitelist<br>
-					 * and reinitialize it with the<br>
-					 * standard low-memory region.<br>
-					 */<br>
-					e820.nr_map = 0;<br>
-					usermem = 1;<br>
-					add_memory_region(0, LOWMEMSIZE(), E820_RAM);<br>
-				}<br>
+				usermem = 1;<br>
 				mem_size = memparse(from+4, &amp;from);<br>
 				if (*from == '@')<br>
 					start_at = memparse(from+1, &amp;from);<br>
-				else {<br>
-					start_at = HIGH_MEMORY;<br>
-					mem_size -= HIGH_MEMORY;<br>
-					usermem=0;<br>
+				else if (*from == '-') {<br>
+					start_at = mem_size;<br>
+					mem_size += memparse(from+1, &amp;from);<br>
 				}<br>
+				else<br>
+					start_at = 0;<br>
 				add_memory_region(start_at, mem_size, E820_RAM);<br>
 			}<br>
 		}<br>
@@ -550,9 +459,13 @@<br>
 	*to = '\0';<br>
 	*cmdline_p = command_line;<br>
 	if (usermem) {<br>
-		printk("user-defined physical RAM map:\n");<br>
-		print_e820_map();<br>
+		if (validate_regions()) {<br>
+			printk("user-defined physical RAM map:\n");<br>
+			print_region_map();<br>
+			return 1;<br>
+		}<br>
 	}<br>
+	return 0;<br>
 }<br>
 <br>
 void __init setup_arch(char **cmdline_p)<br>
@@ -582,7 +495,8 @@<br>
 	rd_prompt = ((RAMDISK_FLAGS &amp; RAMDISK_PROMPT_FLAG) != 0);<br>
 	rd_doload = ((RAMDISK_FLAGS &amp; RAMDISK_LOAD_FLAG) != 0);<br>
 #endif<br>
-	setup_memory_region();<br>
+	if (!setup_cmdline_memory(cmdline_p))<br>
+		setup_detected_memory();<br>
 <br>
 	if (!MOUNT_ROOT_RDONLY)<br>
 		root_mountflags &amp;= ~MS_RDONLY;<br>
@@ -596,12 +510,6 @@<br>
 	data_resource.start = virt_to_bus(&amp;_etext);<br>
 	data_resource.end = virt_to_bus(&amp;_edata)-1;<br>
 <br>
-	parse_mem_cmdline(cmdline_p);<br>
-<br>
-#define PFN_UP(x)	(((x) + PAGE_SIZE-1) &gt;&gt; PAGE_SHIFT)<br>
-#define PFN_DOWN(x)	((x) &gt;&gt; PAGE_SHIFT)<br>
-#define PFN_PHYS(x)	((x) &lt;&lt; PAGE_SHIFT)<br>
-<br>
 /*<br>
  * 128MB for vmalloc and initrd<br>
  */<br>
@@ -617,21 +525,16 @@<br>
 	start_pfn = PFN_UP(__pa(&amp;_end));<br>
 <br>
 	/*<br>
-	 * Find the highest page frame number we have available<br>
-	 */<br>
-	max_pfn = 0;<br>
-	for (i = 0; i &lt; e820.nr_map; i++) {<br>
-		unsigned long start, end;<br>
-		/* RAM? */<br>
-		if (e820.map[i].type != E820_RAM)<br>
-			continue;<br>
-		start = PFN_UP(e820.map[i].addr);<br>
-		end = PFN_DOWN(e820.map[i].addr + e820.map[i].size);<br>
-		if (start &gt;= end)<br>
-			continue;<br>
-		if (end &gt; max_pfn)<br>
-			max_pfn = end;<br>
-	}<br>
+  	 * Find the highest page frame number we have available<br>
+  	 */<br>
+  	max_pfn = 0;<br>
+ 	for (i = 0; i &lt; physical_memory.nr_region; i++) {<br>
+  		unsigned long start, end;<br>
+		start = PFN_UP(Region[i].start);<br>
+ 		end = PFN_DOWN(Region[i].end);<br>
+  		if ( (start &lt; end) &amp;&amp; (end &gt; max_pfn) )<br>
+  			max_pfn = end;<br>
+  	}<br>
 <br>
 	/*<br>
 	 * Determine low and high memory ranges:<br>
@@ -674,23 +577,19 @@<br>
 	/*<br>
 	 * Register fully available low RAM pages with the bootmem allocator.<br>
 	 */<br>
-	for (i = 0; i &lt; e820.nr_map; i++) {<br>
+	for (i = 0; i &lt; physical_memory.nr_region; i++) {<br>
 		unsigned long curr_pfn, last_pfn, size;<br>
- 		/*<br>
-		 * Reserve usable low memory<br>
-		 */<br>
-		if (e820.map[i].type != E820_RAM)<br>
-			continue;<br>
+<br>
 		/*<br>
 		 * We are rounding up the start address of usable memory:<br>
 		 */<br>
-		curr_pfn = PFN_UP(e820.map[i].addr);<br>
+		curr_pfn = PFN_UP(Region[i].start);<br>
 		if (curr_pfn &gt;= max_low_pfn)<br>
 			continue;<br>
 		/*<br>
 		 * ... and at the end of the usable range downwards:<br>
 		 */<br>
-		last_pfn = PFN_DOWN(e820.map[i].addr + e820.map[i].size);<br>
+		last_pfn = PFN_DOWN(Region[i].end);<br>
 <br>
 		if (last_pfn &gt; max_low_pfn)<br>
 			last_pfn = max_low_pfn;<br>
@@ -771,30 +670,37 @@<br>
 	 * and also for regions reported as reserved by the e820.<br>
 	 */<br>
 	probe_roms();<br>
-	for (i = 0; i &lt; e820.nr_map; i++) {<br>
+	for (i = 0; i &lt; physical_memory.nr_region; i++) {<br>
+		struct resource *res;<br>
+		res = alloc_bootmem_low(sizeof(struct resource));<br>
+		res-&gt;start = Region[i].start;<br>
+		res-&gt;end   = Region[i].end-1;<br>
+		res-&gt;flags = IORESOURCE_MEM | IORESOURCE_BUSY;<br>
+		res-&gt;name  = "System RAM";<br>
+		request_resource(&amp;iomem_resource, res);<br>
+		/*<br>
+		 *  We dont't know which RAM region contains the<br>
+		 *  kernel data, so we try it repeatedly and let<br>
+		 *  the resource manager test it.<br>
+		 */<br>
+		request_resource(res, &amp;code_resource);<br>
+		request_resource(res, &amp;data_resource);<br>
+	}<br>
+	for (i = 0; i &lt; physical_memory.nr_bios; i++) {<br>
 		struct resource *res;<br>
-		if (e820.map[i].addr + e820.map[i].size &gt; 0x100000000ULL)<br>
+		if (Bios[i].type == E820_RAM)<br>
 			continue;<br>
+<br>
 		res = alloc_bootmem_low(sizeof(struct resource));<br>
-		switch (e820.map[i].type) {<br>
-		case E820_RAM:	res-&gt;name = "System RAM"; break;<br>
+		switch (Bios[i].type) {<br>
 		case E820_ACPI:	res-&gt;name = "ACPI Tables"; break;<br>
 		case E820_NVS:	res-&gt;name = "ACPI Non-volatile Storage"; break;<br>
 		default:	res-&gt;name = "reserved";<br>
 		}<br>
-		res-&gt;start = e820.map[i].addr;<br>
-		res-&gt;end = res-&gt;start + e820.map[i].size - 1;<br>
+		res-&gt;start = Bios[i].addr;<br>
+		res-&gt;end = Bios[i].addr + Bios[i].size - 1;<br>
 		res-&gt;flags = IORESOURCE_MEM | IORESOURCE_BUSY;<br>
 		request_resource(&amp;iomem_resource, res);<br>
-		if (e820.map[i].type == E820_RAM) {<br>
-			/*<br>
-			 *  We dont't know which RAM region contains kernel data,<br>
-			 *  so we try it repeatedly and let the resource manager<br>
-			 *  test it.<br>
-			 */<br>
-			request_resource(res, &amp;code_resource);<br>
-			request_resource(res, &amp;data_resource);<br>
-		}<br>
 	}<br>
 	request_resource(&amp;iomem_resource, &amp;vram_resource);<br>
 <br>
diff -Naur linux-2.4.0orig/arch/i386/mm/init.c linux-2.4.0exp/arch/i386/mm/init.c<br>
--- linux-2.4.0orig/arch/i386/mm/init.c	Wed May 31 12:01:19 2000<br>
+++ linux-2.4.0exp/arch/i386/mm/init.c	Sat May 27 01:59:31 2000<br>
@@ -538,21 +538,11 @@<br>
 {<br>
 	int i;<br>
 <br>
-	for (i = 0; i &lt; e820.nr_map; i++) {<br>
-		unsigned long addr, end;<br>
-<br>
-		if (e820.map[i].type != E820_RAM)	/* not usable memory */<br>
-			continue;<br>
-		/*<br>
-		 *	!!!FIXME!!! Some BIOSen report areas as RAM that<br>
-		 *	are not. Notably the 640-&gt;1Mb area. We need a sanity<br>
-		 *	check here.<br>
-		 */<br>
-		addr = (e820.map[i].addr+PAGE_SIZE-1) &gt;&gt; PAGE_SHIFT;<br>
-		end = (e820.map[i].addr+e820.map[i].size) &gt;&gt; PAGE_SHIFT;<br>
-		if  ((pagenr &gt;= addr) &amp;&amp; (pagenr &lt; end))<br>
+	for (i = 0; i &lt; physical_memory.nr_region; i++)<br>
+		if (pagenr &gt;= PFN_UP(physical_memory.region[i].start)<br>
+		    &amp;&amp; pagenr &lt; PFN_DOWN(physical_memory.region[i].end) )<br>
 			return 1;<br>
-	}<br>
+<br>
 	return 0;<br>
 }<br>
 <br>
diff -Naur linux-2.4.0orig/drivers/char/Config.in linux-2.4.0exp/drivers/char/Config.in<br>
--- linux-2.4.0orig/drivers/char/Config.in	Sat May 27 01:58:50 2000<br>
+++ linux-2.4.0exp/drivers/char/Config.in	Wed May 31 11:45:26 2000<br>
@@ -220,7 +220,7 @@<br>
    fi<br>
    dep_tristate '  CPiA Video For Linux' CONFIG_VIDEO_CPIA $CONFIG_VIDEO_DEV<br>
    if [ "$CONFIG_VIDEO_CPIA" != "n" ]; then<br>
-     if [ "CONFIG_PARPORT_1284" != "n" ]; then<br>
+     if [ "$CONFIG_PARPORT_1284" != "n" ]; then<br>
        dep_tristate '    CPiA Parallel Port Lowlevel Support' CONFIG_VIDEO_CPIA_PP $CONFIG_VIDEO_CPIA $CONFIG_PARPORT<br>
      fi<br>
      if [ "$CONFIG_USB" != "n" ]; then<br>
diff -Naur linux-2.4.0orig/drivers/ide/Config.in linux-2.4.0exp/drivers/ide/Config.in<br>
--- linux-2.4.0orig/drivers/ide/Config.in	Wed May 31 12:01:47 2000<br>
+++ linux-2.4.0exp/drivers/ide/Config.in	Wed May 31 11:42:40 2000<br>
@@ -140,9 +140,9 @@<br>
 fi<br>
 <br>
 if [ "$CONFIG_BLK_DEV_TIVO" = "y" ]; then<br>
-  define CONFIG_DMA_NONPCI y<br>
+  define_bool CONFIG_DMA_NONPCI y<br>
 else<br>
-  define CONFIG_DMA_NONPCI n<br>
+  define_bool CONFIG_DMA_NONPCI n<br>
 fi<br>
 if [ "$CONFIG_IDE_CHIPSETS" = "y" -o \<br>
      "$CONFIG_BLK_DEV_AEC62XX" = "y" -o \<br>
diff -Naur linux-2.4.0orig/include/asm-i386/e820.h linux-2.4.0exp/include/asm-i386/e820.h<br>
--- linux-2.4.0orig/include/asm-i386/e820.h	Wed May 31 12:01:19 2000<br>
+++ linux-2.4.0exp/include/asm-i386/e820.h	Wed May 31 11:41:06 2000<br>
@@ -5,16 +5,19 @@<br>
  * In a nutshell, arch/i386/boot/setup.S populates a scratch table<br>
  * in the empty_zero_block that contains a list of usable address/size<br>
  * duples.   In arch/i386/kernel/setup.c, this information is<br>
- * transferred into the e820map, and in arch/i386/mm/init.c, that<br>
- * new information is used to mark pages reserved or not.<br>
+ * transferred into the bios[], then converted into a list of valid<br>
+ * memory regions in region[], and that new information is used in<br>
+ * arch/i386/mm/init.c to mark pages available or not.<br>
  *<br>
  */<br>
 #ifndef __E820_HEADER<br>
 #define __E820_HEADER<br>
 <br>
-#define E820MAP	0x2d0		/* our map */<br>
-#define E820MAX	32		/* number of entries in E820MAP */<br>
-#define E820NR	0x1e8		/* # entries in E820MAP */<br>
+#define E820MAP		0x2d0	/* our map */<br>
+#define E820MAX		32	/* number of entries in E820MAP */<br>
+#define E820PHYSMAX	64	/* number of entries in physical_memory.region */<br>
+#define E820NR		0x1e8	/* # entries in E820MAP */<br>
+#define E820LEN		20	/* size of an e820 entry */<br>
 <br>
 #define E820_RAM	1<br>
 #define E820_RESERVED	2<br>
@@ -23,18 +26,90 @@<br>
 <br>
 #define HIGH_MEMORY	(1024*1024)<br>
 <br>
+/* HACK: These macros map between page numbers and physical addresses.<br>
+ * They used to be in arch/i386/kernel/setup.c, but have been moved here<br>
+ * so that they can also be used in arch/i386/mm/init.c.<br>
+ */<br>
+#define PFN_UP(x)	(((x) + PAGE_SIZE-1) &gt;&gt; PAGE_SHIFT)<br>
+#define PFN_DOWN(x)	((x) &gt;&gt; PAGE_SHIFT)<br>
+#define PFN_PHYS(x)	((x) &lt;&lt; PAGE_SHIFT)<br>
+<br>
+/*<br>
+ * FLAG_E820_DEBUG enables bunches of debug messages.<br>
+ */<br>
+#define FLAG_E820_DEBUG	1<br>
+<br>
+/* FLAG_E820_RECLAIM tells add_memory_region/check_memory_region to<br>
+ * attempt to use E820 reclaim memory sections.  To have reclaim work,<br>
+ * you need to configure it on, _plus_ CONFIG_ACPI needs to be turned off.<br>
+ */<br>
+#if defined(CONFIG_E820_RECLAIM) &amp;&amp; !defined(CONFIG_ACPI)<br>
+#  define FLAG_E820_RECLAIM	1<br>
+#else<br>
+#  define FLAG_E820_RECLAIM	0<br>
+#endif<br>
+<br>
+/* FLAG_E820_4GB_ONLY tells the memory region adder to truncate memory<br>
+ * segments to the first 4 gb of memory.<br>
+ */<br>
+#define	FLAG_E820_4GB_ONLY	1<br>
+<br>
+<br>
 #ifndef __ASSEMBLY__<br>
 <br>
-struct e820map {<br>
-    int nr_map;<br>
-    struct {<br>
-	long long addr;		/* start of memory segment */<br>
-	long long size;		/* size of memory segment */<br>
-	long type;		/* type of memory segment */<br>
-    } map[E820MAX];<br>
-};<br>
+struct e820 {<br>
+    __u64 addr;	/* addr,size,type are returned by e820 bios call */<br>
+    __u64 size;<br>
+    __u32 type;<br>
+} __attribute__ ((__packed__));<br>
+<br>
+struct physical_region {<br>
+    __u64 start;<br>
+    __u64 end;<br>
+} ;<br>
+<br>
+struct physical_memory {<br>
+    int nr_bios;				/* bios[] holds memory region */<br>
+    int nr_region;				/* region[] holds valid mem */<br>
+    struct e820 bios[E820MAX];			/* returned by the bios */<br>
+    struct physical_region region[E820PHYSMAX];	/* that we want to allocate */<br>
+} ;<br>
+<br>
+#define NR_HOLES	10<br>
+<br>
+struct excluded_memory {<br>
+    int nr_hole;<br>
+    struct __hole {<br>
+	__u64 start;<br>
+	__u64 end;<br>
+	__u32 mask;<br>
+    } hole[NR_HOLES];<br>
+} ;<br>
 <br>
-extern struct e820map e820;<br>
-#endif/*!__ASSEMBLY__*/<br>
+extern struct physical_memory physical_memory;<br>
+<br>
+/* Typing shortcuts.<br>
+ */<br>
+#define Region  physical_memory.region<br>
+#define Bios    physical_memory.bios                                           <br>
 <br>
+/*<br>
+ * setup functions<br>
+ */<br>
+enum region_flags { RF_RECLAIM =0x01,<br>
+                    RF_NOT_RAM =0x02,<br>
+		    RF_OVERFLOW=0x04,<br>
+		    RF_ZERO    =0x08,<br>
+		    RF_MERGED  =0x10,<br>
+		    RF_ADDED   =0x20,<br>
+		    RF_TOOLONG =0x80 } ;<br>
+<br>
+enum region_flags add_memory_region(__u64, __u64, __u32);<br>
+int add_memory_hole(__u64, __u64);<br>
+int validate_regions(void);<br>
+void print_region_map(void);<br>
+void setup_detected_memory(void);<br>
+<br>
+<br>
+#endif/*!__ASSEMBLY__*/<br>
 #endif/*__E820_HEADER*/<br>
diff -Naur linux-2.4.0orig/scripts/Menuconfig linux-2.4.0exp/scripts/Menuconfig<br>
--- linux-2.4.0orig/scripts/Menuconfig	Wed May 31 12:01:20 2000<br>
+++ linux-2.4.0exp/scripts/Menuconfig	Sat May 27 01:59:31 2000<br>
@@ -545,7 +545,7 @@<br>
 <br>
 			# Semantics of + and ? in GNU expr changed, so<br>
 			# we avoid them:<br>
-			if expr "$answer" : '0$\|-[1-9][0-9]*$\|[1-9][0-9]*$' &gt;/dev/null<br>
+			if expr "$answer" : '0$' '|' "$answer" : '[1-9][0-9]*$' '|' "$answer" : '-[1-9][0-9]*$' &gt;/dev/null<br>
 			then<br>
 				eval $2="$answer"<br>
 			else<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0193.html">Alan Cox: "Re: New Linux 2.5 - 2.6 TODO (beat it up :)"</a>
<li> <b>Previous message:</b> <a href="0191.html">Khimenko Victor: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0210.html">Albert D. Cahalan: "Re: [PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch"</a>
<li> <b>Reply:</b> <a href="0210.html">Albert D. Cahalan: "Re: [PATCH] 2.4.0 test 1 ac 7  -- the last fancy memory detection patch"</a>
<!-- reply="end" -->
</ul>
</font></body>
