<!-- received="Mon Jun  5 14:51:26 2000 EET DST" -->
<!-- sent="Mon, 5 Jun 2000 12:39:17 +0100" -->
<!-- name="Tim Waugh" -->
<!-- email="twaugh@redhat.com" -->
<!-- subject="[patch] 2.2.16pre7: parport fixes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: [patch] 2.2.16pre7: parport fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] 2.2.16pre7: parport fixes</h1>
<b>Tim Waugh</b> (<a href="mailto:twaugh@redhat.com"><i>twaugh@redhat.com</i></a>)<br>
<i>Mon, 5 Jun 2000 12:39:17 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#282">[ date ]</a><a href="index.html#282">[ thread ]</a><a href="subject.html#282">[ subject ]</a><a href="author.html#282">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0283.html">Richard Torkar: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggests"</a>
<li> <b>Previous message:</b> <a href="0281.html">Malcolm Beattie: "Re: Hot pluggable CPUs ( was Linux 2.5 / 2.6 TODO (preliminary) )"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--mYCpIKhGyMATD0i+<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: quoted-printable<br>
<p>
Here is a patch that moves some 2.4.0 fixes back into 2.2.16pre7.<br>
PLEASE test it out for me, as I only have two machines here that I can<br>
test it with, and in particular no SMP machines.<br>
<p>
I would like any feedback, good or bad.  What would be especially nice<br>
would be if someone tried it out on an SMP machine while using a ZIP<br>
drive and a printer on the same port at the same time.<br>
<p>
Thanks,<br>
Tim.<br>
*/<br>
<p>
--- linux-2.2.16pre7/drivers/misc/parport_share.c	Tue Jan  4 18:12:17 2000<br>
+++ linux/drivers/misc/parport_share.c	Mon Jun  5 10:39:47 2000<br>
@@ -125,7 +125,18 @@<br>
 	 * This function must not run from an irq handler so we don' t need<br>
 	 * to clear irq on the local CPU. -arca<br>
 	 */<br>
+<br>
 	spin_lock(&amp;parportlist_lock);<br>
+<br>
+	/* We are locked against anyone else performing alterations, but<br>
+	 * because of parport_enumerate people can still _read_ the list<br>
+	 * while we are changing it, so be careful..<br>
+	 *<br>
+	 * It's okay to have portlist_tail a little bit out of sync<br>
+	 * since it's only used for changing the list, not for reading<br>
+	 * from it.<br>
+	 */<br>
+<br>
 	if (portlist_tail)<br>
 		portlist_tail-&gt;next =3D tmp;<br>
 	portlist_tail =3D tmp;<br>
@@ -144,6 +155,10 @@<br>
 	struct parport *p;<br>
=20<br>
 	spin_lock(&amp;parportlist_lock);<br>
+<br>
+	/* We are protected from other people changing the list, but<br>
+	 * they can still see it (using parport_enumerate).  So be<br>
+	 * careful about the order of writes.. */<br>
 	if (portlist =3D=3D port) {<br>
 		if ((portlist =3D port-&gt;next) =3D=3D NULL)<br>
 			portlist_tail =3D NULL;<br>
@@ -212,17 +227,25 @@<br>
 		}<br>
 	}<br>
=20<br>
+	/* We up our own module reference count, and that of the port<br>
+           on which a device is to be registered, to ensure that<br>
+           neither of us gets unloaded while we sleep in (e.g.)<br>
+           kmalloc.  To be absolutely safe, we have to require that<br>
+           our caller doesn't sleep in between parport_enumerate and<br>
+           parport_register_device.. */<br>
+	inc_parport_count ();<br>
+	port-&gt;ops-&gt;inc_use_count ();<br>
+<br>
 	tmp =3D kmalloc(sizeof(struct pardevice), GFP_KERNEL);<br>
 	if (tmp =3D=3D NULL) {<br>
 		printk(KERN_WARNING "%s: memory squeeze, couldn't register %s.\n", port-=<br>
<i>&gt;name, name);</i><br>
-		return NULL;<br>
+		goto out;<br>
 	}<br>
=20<br>
 	tmp-&gt;state =3D kmalloc(sizeof(struct parport_state), GFP_KERNEL);<br>
 	if (tmp-&gt;state =3D=3D NULL) {<br>
 		printk(KERN_WARNING "%s: memory squeeze, couldn't register %s.\n", port-=<br>
<i>&gt;name, name);</i><br>
-		kfree(tmp);<br>
-		return NULL;<br>
+		goto out_free_pardevice;<br>
 	}<br>
=20<br>
 	/* We may need to claw back the port hardware. */<br>
@@ -231,9 +254,7 @@<br>
 			printk(KERN_WARNING<br>
 			       "%s: unable to get hardware to register %s.\n",<br>
 			       port-&gt;name, name);<br>
-			kfree (tmp-&gt;state);<br>
-			kfree (tmp);<br>
-			return NULL;<br>
+			goto out_free_all;<br>
 		}<br>
 		port-&gt;flags &amp;=3D ~PARPORT_FLAG_COMA;<br>
 	}<br>
@@ -259,17 +280,18 @@<br>
 	if (flags &amp; PARPORT_DEV_EXCL) {<br>
 		if (port-&gt;devices) {<br>
 			spin_unlock (&amp;port-&gt;pardevice_lock);<br>
-			kfree (tmp-&gt;state);<br>
-			kfree (tmp);<br>
 			printk (KERN_DEBUG<br>
 				"%s: cannot grant exclusive access for "<br>
 				"device %s\n", port-&gt;name, name);<br>
-			return NULL;<br>
+			goto out_free_all;<br>
 		}<br>
 		port-&gt;flags |=3D PARPORT_FLAG_EXCL;<br>
 	}<br>
=20<br>
 	tmp-&gt;next =3D port-&gt;devices;<br>
+	wmb(); /* Make sure that tmp-&gt;next is written before it's<br>
+                  added to the list; see comments marked 'no locking<br>
+                  required' */<br>
 	if (port-&gt;devices)<br>
 		port-&gt;devices-&gt;prev =3D tmp;<br>
 	port-&gt;devices =3D tmp;<br>
@@ -283,11 +305,21 @@<br>
 	tmp-&gt;waitnext =3D tmp-&gt;waitprev =3D NULL;<br>
=20<br>
 	return tmp;<br>
+<br>
+ out_free_all:<br>
+	kfree (tmp-&gt;state);<br>
+ out_free_pardevice:<br>
+	kfree (tmp);<br>
+ out:<br>
+	dec_parport_count ();<br>
+	port-&gt;ops-&gt;dec_use_count ();<br>
+	return NULL;<br>
 }<br>
=20<br>
 void parport_unregister_device(struct pardevice *dev)<br>
 {<br>
 	struct parport *port;<br>
+	unsigned long flags;<br>
=20<br>
 #ifdef PARPORT_PARANOID<br>
 	if (dev =3D=3D NULL) {<br>
@@ -298,11 +330,14 @@<br>
=20<br>
 	port =3D dev-&gt;port;<br>
=20<br>
+	read_lock_irqsave (&amp;port-&gt;cad_lock, flags);<br>
 	if (port-&gt;cad =3D=3D dev) {<br>
+		read_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
 		printk(KERN_DEBUG "%s: %s forgot to release port\n",<br>
 		       port-&gt;name, dev-&gt;name);<br>
 		parport_release (dev);<br>
 	}<br>
+	read_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
=20<br>
 	spin_lock(&amp;port-&gt;pardevice_lock);<br>
 	if (dev-&gt;next)<br>
@@ -336,14 +371,17 @@<br>
 	struct parport *port =3D dev-&gt;port;<br>
 	unsigned long flags;<br>
=20<br>
+	read_lock_irqsave (&amp;port-&gt;cad_lock, flags);<br>
 	if (port-&gt;cad =3D=3D dev) {<br>
+		read_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
 		printk(KERN_INFO "%s: %s already owner\n",<br>
 			   dev-&gt;port-&gt;name,dev-&gt;name);<br>
 		return 0;<br>
 	}<br>
+	read_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
=20<br>
-try_again:<br>
 	/* Preempt any current device */<br>
+	write_lock_irqsave (&amp;port-&gt;cad_lock, flags);<br>
 	if ((oldcad =3D port-&gt;cad) !=3D NULL) {<br>
 		if (oldcad-&gt;preempt) {<br>
 			if (oldcad-&gt;preempt(oldcad-&gt;private))<br>
@@ -366,7 +404,7 @@<br>
 		dev-&gt;waiting =3D 0;<br>
=20<br>
 		/* Take ourselves out of the wait list again.  */<br>
-		spin_lock_irqsave (&amp;port-&gt;waitlist_lock, flags);<br>
+		spin_lock_irq (&amp;port-&gt;waitlist_lock);<br>
 		if (dev-&gt;waitprev)<br>
 			dev-&gt;waitprev-&gt;waitnext =3D dev-&gt;waitnext;<br>
 		else<br>
@@ -375,7 +413,7 @@<br>
 			dev-&gt;waitnext-&gt;waitprev =3D dev-&gt;waitprev;<br>
 		else<br>
 			port-&gt;waittail =3D dev-&gt;waitprev;<br>
-		spin_unlock_irqrestore (&amp;port-&gt;waitlist_lock, flags);<br>
+		spin_unlock_irq (&amp;port-&gt;waitlist_lock);<br>
 		dev-&gt;waitprev =3D dev-&gt;waitnext =3D NULL;<br>
 	}<br>
=20<br>
@@ -399,6 +437,7 @@<br>
=20<br>
 	/* Restore control registers */<br>
 	port-&gt;ops-&gt;restore_state(port, dev-&gt;state);<br>
+	write_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
 	dev-&gt;time =3D jiffies;<br>
 	return 0;<br>
=20<br>
@@ -406,13 +445,10 @@<br>
 	/* If this is the first time we tried to claim the port, register an<br>
 	   interest.  This is only allowed for devices sleeping in<br>
 	   parport_claim_or_block(), or those with a wakeup function.  */<br>
+<br>
+	/* The cad_lock is still held for writing here */<br>
 	if (dev-&gt;waiting &amp; 2 || dev-&gt;wakeup) {<br>
-		spin_lock_irqsave (&amp;port-&gt;waitlist_lock, flags);<br>
-		if (port-&gt;cad =3D=3D NULL) {<br>
-			/* The port got released in the meantime. */<br>
-			spin_unlock_irqrestore (&amp;port-&gt;waitlist_lock, flags);<br>
-			goto try_again;<br>
-		}<br>
+		spin_lock (&amp;port-&gt;waitlist_lock);<br>
 		if (test_and_set_bit(0, &amp;dev-&gt;waiting) =3D=3D 0) {<br>
 			/* First add ourselves to the end of the wait list. */<br>
 			dev-&gt;waitnext =3D NULL;<br>
@@ -423,8 +459,9 @@<br>
 			} else<br>
 				port-&gt;waithead =3D port-&gt;waittail =3D dev;<br>
 		}<br>
-		spin_unlock_irqrestore (&amp;port-&gt;waitlist_lock, flags);<br>
+		spin_unlock (&amp;port-&gt;waitlist_lock);<br>
 	}<br>
+	write_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
 	return -EAGAIN;<br>
 }<br>
=20<br>
@@ -474,12 +511,14 @@<br>
 	unsigned long flags;<br>
=20<br>
 	/* Make sure that dev is the current device */<br>
+	write_lock_irqsave (&amp;port-&gt;cad_lock, flags);<br>
 	if (port-&gt;cad !=3D dev) {<br>
+		write_unlock_irqrestore (&amp;port-&gt;cad_lock, flags);<br>
 		printk(KERN_WARNING "%s: %s tried to release parport "<br>
 		       "when not owner\n", port-&gt;name, dev-&gt;name);<br>
 		return;<br>
 	}<br>
-	write_lock_irqsave(&amp;port-&gt;cad_lock, flags);<br>
+<br>
 	port-&gt;cad =3D NULL;<br>
 	write_unlock_irqrestore(&amp;port-&gt;cad_lock, flags);<br>
=20<br>
@@ -503,7 +542,7 @@<br>
 			return;<br>
 		} else if (pd-&gt;wakeup) {<br>
 			pd-&gt;wakeup(pd-&gt;private);<br>
-			if (dev-&gt;port-&gt;cad)<br>
+			if (dev-&gt;port-&gt;cad) /* racy but no matter */<br>
 				return;<br>
 		} else {<br>
 			printk(KERN_ERR "%s: don't know how to wake %s\n", port-&gt;name, pd-&gt;name=<br>
);<br>
@@ -511,7 +550,7 @@<br>
 	}<br>
=20<br>
 	/* Nobody was waiting, so walk the list to see if anyone is<br>
-	   interested in being woken up.  */<br>
+	   interested in being woken up. (Note: no locking required) */<br>
 	for (pd =3D port-&gt;devices; (port-&gt;cad =3D=3D NULL) &amp;&amp; pd; pd =3D pd-&gt;next=<br>
) {<br>
 		if (pd-&gt;wakeup &amp;&amp; pd !=3D dev)<br>
 			pd-&gt;wakeup(pd-&gt;private);<br>
<p>
--mYCpIKhGyMATD0i+<br>
Content-Type: application/pgp-signature<br>
<p>
-----BEGIN PGP SIGNATURE-----<br>
Version: GnuPG v1.0.1 (GNU/Linux)<br>
Comment: For info see <a href="http://www.gnupg.org">http://www.gnupg.org</a><br>
<p>
iD8DBQE5O5FkzNKoNUTpbygRAWVqAJ9GNFHAFCn1hlg4LdxNzc0e8L1sYQCfTh99<br>
/w1SCk5VMhgW30gQF0pE/0A=<br>
=6xf0<br>
-----END PGP SIGNATURE-----<br>
<p>
--mYCpIKhGyMATD0i+--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0283.html">Richard Torkar: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggests"</a>
<li> <b>Previous message:</b> <a href="0281.html">Malcolm Beattie: "Re: Hot pluggable CPUs ( was Linux 2.5 / 2.6 TODO (preliminary) )"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
