<!-- received="Mon Jun  5 23:27:16 2000 EET DST" -->
<!-- sent="Mon, 5 Jun 2000 13:03:08 -0300 (BRST)" -->
<!-- name="Rik van Riel" -->
<!-- email="riel@conectiva.com.br" -->
<!-- subject="[uPatch] Re: Graceful failure?" -->
<!-- id="" -->
<!-- inreplyto="14651.49518.825666.298019@rhino.thrillseeker.net" -->
<title>Linux-kernel mailing list archive 2000-23,: [uPatch] Re: Graceful failure?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[uPatch] Re: Graceful failure?</h1>
<b>Rik van Riel</b> (<a href="mailto:riel@conectiva.com.br"><i>riel@conectiva.com.br</i></a>)<br>
<i>Mon, 5 Jun 2000 13:03:08 -0300 (BRST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#356">[ date ]</a><a href="index.html#356">[ thread ]</a><a href="subject.html#356">[ subject ]</a><a href="author.html#356">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0357.html">Tigran Aivazian: "Re: encouraging developer participation"</a>
<li> <b>Previous message:</b> <a href="0355.html">Horst von Brand: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0399.html">John Fremlin: "Re: [uPatch] Re: Graceful failure?"</a>
<li> <b>Reply:</b> <a href="0399.html">John Fremlin: "Re: [uPatch] Re: Graceful failure?"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 5 Jun 2000, Billy Harvey wrote:<br>
<p>
<i>&gt; A "make -j" slowly over the course of 5 minutes drives the load</i><br>
<i>&gt; to about 30.  At first the degradation is controlled, with</i><br>
<i>&gt; sendmail refusing service, but at about 160 process visible in</i><br>
<i>&gt; top, top quits updating (set a 8 second updates), showing about</i><br>
<i>&gt; 2 MB swap used.  At this point it sounds like the system is</i><br>
<i>&gt; thrashing.</i><br>
<p>
That probably means you're a lot more in swap now and top<br>
has stopped displaying before you really hit the swap...<br>
<p>
<i>&gt; Is this failure process acceptable?  I'd think the system should</i><br>
<i>&gt; react differently to the thrashing, killing off the load</i><br>
<i>&gt; demanding user process(es), rather than degrading to a point of</i><br>
<i>&gt; freeze.</i><br>
<p>
Please take into account that the system is quite a bit beyond<br>
where you could take previous kernels ... oh, and the attached<br>
patch should fix the problem somewhat ;)<br>
<p>
regards,<br>
<p>
Rik<br>
<pre>
--
The Internet is not a network of computers. It is a network
of people. That is its real strength.
<p>
Wanna talk about the kernel?  irc.openprojects.net / #kernelnewbies
<a href="http://www.conectiva.com/">http://www.conectiva.com/</a>		http://www.surriel.com/
<p>
<p>
<p>
--- linux-2.4.0-t1-ac8/include/linux/mm.h.orig	Wed May 31 21:00:14 2000
+++ linux-2.4.0-t1-ac8/include/linux/mm.h	Sun Jun  4 16:21:31 2000
@@ -202,6 +202,7 @@
 #define ClearPageError(page)	clear_bit(PG_error, &amp;(page)-&gt;flags)
 #define PageReferenced(page)	test_bit(PG_referenced, &amp;(page)-&gt;flags)
 #define SetPageReferenced(page)	set_bit(PG_referenced, &amp;(page)-&gt;flags)
+#define ClearPageReferenced(page)	clear_bit(PG_referenced, &amp;(page)-&gt;flags)
 #define PageTestandClearReferenced(page)	test_and_clear_bit(PG_referenced, &amp;(page)-&gt;flags)
 #define PageDecrAfter(page)	test_bit(PG_decr_after, &amp;(page)-&gt;flags)
 #define SetPageDecrAfter(page)	set_bit(PG_decr_after, &amp;(page)-&gt;flags)
--- linux-2.4.0-t1-ac8/include/linux/swap.h.orig	Wed May 31 21:00:06 2000
+++ linux-2.4.0-t1-ac8/include/linux/swap.h	Sun Jun  4 16:22:31 2000
@@ -179,6 +179,7 @@
 	list_add(&amp;(page)-&gt;lru, &amp;lru_cache);	\
 	nr_lru_pages++;				\
 	page-&gt;age = PG_AGE_START;		\
+	ClearPageReferenced(page);		\
 	SetPageActive(page);			\
 	spin_unlock(&amp;pagemap_lru_lock);		\
 } while (0)
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0357.html">Tigran Aivazian: "Re: encouraging developer participation"</a>
<li> <b>Previous message:</b> <a href="0355.html">Horst von Brand: "Re: OS stopping stack buffer overflow exploits"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0399.html">John Fremlin: "Re: [uPatch] Re: Graceful failure?"</a>
<li> <b>Reply:</b> <a href="0399.html">John Fremlin: "Re: [uPatch] Re: Graceful failure?"</a>
<!-- reply="end" -->
</ul>
</font></body>
