<!-- received="Mon Jun  5 23:27:25 2000 EET DST" -->
<!-- sent="Mon, 5 Jun 2000 19:09:51 +0300 (EET DST)" -->
<!-- name="Aki M Laukkanen" -->
<!-- email="amlaukka@cc.helsinki.fi" -->
<!-- subject="Re: Slow TCP connection between linux and wince" -->
<!-- id="" -->
<!-- inreplyto="200006031731.VAA10055@ms2.inr.ac.ru" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: Slow TCP connection between linux and wince</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Slow TCP connection between linux and wince</h1>
<b>Aki M Laukkanen</b> (<a href="mailto:amlaukka@cc.helsinki.fi"><i>amlaukka@cc.helsinki.fi</i></a>)<br>
<i>Mon, 5 Jun 2000 19:09:51 +0300 (EET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#367">[ date ]</a><a href="index.html#367">[ thread ]</a><a href="subject.html#367">[ subject ]</a><a href="author.html#367">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0368.html">Andreas Dilger: "Re: encouraging developer participation"</a>
<li> <b>Previous message:</b> <a href="0366.html">Chris Mason: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggests"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sat, 3 Jun 2000 <a href="mailto:kuznet@ms2.inr.ac.ru">kuznet@ms2.inr.ac.ru</a> wrote:<br>
<i>&gt; Probably, receiver delays each ACK by 500msec. I have no idea</i><br>
<i>&gt; why it does this, because it is apparently illegal behaviour.</i><br>
<i>&gt; Look:</i><br>
<p>
Yes, it looks that way and I got the acks mixed up.<br>
<p>
<i>&gt; for these 5 seconds. Probably, your sender selected illegal sndbuf,</i><br>
<i>&gt; which is much less than receiver window.</i><br>
<p>
The application in question was ttcp. And your guess is quite close to<br>
truth. I should've known what was the cause since we've been hit with the<br>
exact same thing already (albeit on the receive side).<br>
<p>
tcp_snd_test: tail: 1, packets_in_flight: 95, snd_cwnd: 95<br>
end_seq: -685618378, snd_una: -685641578, snd_wnd: 32488<br>
<p>
This is debugging output at the time the delay begins and looks perfectly<br>
reasonable.<br>
<p>
tcp_snd_test: tail: 1, packets_in_flight: 75, snd_cwnd: 116 <br>
end_seq: -685618190, snd_una: -685636454, snd_wnd: 32488<br>
<p>
And after the delay - in the between no calls were made to tcp_snd_test.<br>
So the real culprit is this test:<br>
<p>
	if (sock_wspace(sk) &gt;= tcp_min_write_space(sk) &amp;&amp;<br>
	    (sock = sk-&gt;socket) != NULL) {<br>
<p>
The key here is that mss was 256 - sock_wspace() is:<br>
<p>
		amt = sk-&gt;sndbuf - atomic_read(&amp;sk-&gt;wmem_alloc);<br>
<p>
wmem_alloc contains the sum of skb-&gt;truesize fields. If we do not<br>
take into account the overhead from struct (sk_buff) and aligning this<br>
test would be circa:<br>
<p>
	65536-32767 &gt;= 32767 <br>
<p>
when the sender is made to sleep so the two numbers are almost equal. <br>
However with MTU of 296 (as given to pppd) it is:<br>
<p>
tcp_new_space: wspace: 10435, write_space: 27550<br>
tcp_new_space: wspace: 11015, write_space: 27260<br>
tcp_new_space: wspace: 11595, write_space: 26970<br>
tcp_new_space: wspace: 12175, write_space: 26680<br>
... acks flow in ...<br>
tcp_new_space: wspace: 19715, write_space: 22910<br>
tcp_new_space: wspace: 20295, write_space: 22620<br>
tcp_new_space: wspace: 20875, write_space: 22330<br>
tcp_new_space: wspace: 21455, write_space: 22040  <br>
<p>
Hmm, 11015-10435=580 - it'd make sense if there were two skbs allocated<br>
for each segment? Oh, I see skb_clone() in tcp_send_skb, right?<br>
<p>
The disparity between this test and the available send window is the <br>
cause of the bursts. Also explained is why the over-scheduling masked<br>
this behaviour. Following patch changes wmem_alloc to only include<br>
the actual data and it seems to work. This is a hackish approach at <br>
best though.<br>
<p>
diff -urN --exclude=*~ linux-2.4.0-test1-ac6.bak/net/ipv4/tcp.c linux-2.4.0-test1-ac6/net/ipv4/tcp.c<br>
--- linux-2.4.0-test1-ac6.bak/net/ipv4/tcp.c	Mon Apr 24 23:59:57 2000<br>
+++ linux-2.4.0-test1-ac6/net/ipv4/tcp.c	Mon Jun  5 18:48:59 2000<br>
@@ -960,6 +960,7 @@<br>
 				skb = alloc_skb(tmp, GFP_KERNEL);<br>
 				if (skb == NULL)<br>
 					goto do_oom;<br>
+				skb-&gt;truesize = copy;<br>
 				skb_set_owner_w(skb, sk);<br>
 			} else {<br>
 				/* If we didn't get any memory, we need to sleep. */<br>
<p>
<p>
Our second problem with this disparity is on the receive side. The scenario<br>
is essentially the same but with an unreliable link (read wireless) which<br>
drops packets. In case of packet drop receiver keeps building an <br>
out-of-order queue which grows to the limit of the receive buffer <br>
quite quickly. However sender keeps sending more because of the difference<br>
between advertised window and the actual allocated space. This triggers<br>
tcp_input.c:prune_queue() which purges the whole out-of-order queue to<br>
free up space, thus killing the TCP performance quite effectively.<br>
<p>
The fix in our internal use is similar to the rmem_alloc case. I do think <br>
both of these situations are quite valid. I am not so sure about the correct<br>
fix though.<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0368.html">Andreas Dilger: "Re: encouraging developer participation"</a>
<li> <b>Previous message:</b> <a href="0366.html">Chris Mason: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggests"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
