<!-- received="Tue Jun  6 05:04:41 2000 EET DST" -->
<!-- sent="Tue, 6 Jun 2000 00:53:16 +0200" -->
<!-- name="Frank van Maarseveen" -->
<!-- email="F.vanMaarseveen@inter.NL.net" -->
<!-- subject="2.4.0-test1-ac8: recvfrom() bug" -->
<!-- id="" -->
<!-- inreplyto="E12QKoC-0006jl-00@the-village.bc.nu" -->
<title>Linux-kernel mailing list archive 2000-23,: 2.4.0-test1-ac8: recvfrom() bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>2.4.0-test1-ac8: recvfrom() bug</h1>
<b>Frank van Maarseveen</b> (<a href="mailto:F.vanMaarseveen@inter.NL.net"><i>F.vanMaarseveen@inter.NL.net</i></a>)<br>
<i>Tue, 6 Jun 2000 00:53:16 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#441">[ date ]</a><a href="index.html#441">[ thread ]</a><a href="subject.html#441">[ subject ]</a><a href="author.html#441">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0442.html">Xuan Baldauf: "Bug?: ip_conntrack"</a>
<li> <b>Previous message:</b> <a href="0440.html">Urban Widmark: "Re: IBM DB2 failures in 2.4.0-test*"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
A small fix from me for 2.2.14 didn't make it into 2.3.x/2.4.0-test1.<br>
To recall:<br>
<p>
	... tracking down a possible bug in RH6.1 routed daemon. It does a<br>
<p>
		recvfrom(fd, &amp;inbuf, sizeof (inbuf), 0, &amp;from, &amp;fromlen)<br>
<p>
	and it appears that even when `from' is cleared in advance the from-&gt;sa_data<br>
	contains not only a 2 byte port number + source IP but also some trailing<br>
	garbage afterwards ...<br>
<p>
Here is the fix for 2.4.0-test1-ac8:<br>
--- linux/net/ipv4/udp.c.orig	Wed May  3 10:48:03 2000<br>
+++ linux/net/ipv4/udp.c	Tue Jun  6 00:12:09 2000<br>
@@ -715,12 +715,13 @@<br>
 	/* Copy the address. */<br>
 	if (sin)<br>
 	{<br>
 		sin-&gt;sin_family = AF_INET;<br>
 		sin-&gt;sin_port = skb-&gt;h.uh-&gt;source;<br>
 		sin-&gt;sin_addr.s_addr = skb-&gt;nh.iph-&gt;saddr;<br>
+		memset(sin-&gt;sin_zero, 0, sizeof(sin-&gt;sin_zero));<br>
   	}<br>
 	if (sk-&gt;protinfo.af_inet.cmsg_flags)<br>
 		ip_cmsg_recv(msg, skb);<br>
 	err = copied;<br>
   <br>
 out_free:<br>
<p>
<pre>
-- 
Frank
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0442.html">Xuan Baldauf: "Bug?: ip_conntrack"</a>
<li> <b>Previous message:</b> <a href="0440.html">Urban Widmark: "Re: IBM DB2 failures in 2.4.0-test*"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
