<!-- received="Tue Jun  6 13:17:07 2000 EET DST" -->
<!-- sent="06 Jun 2000 10:29:56 +0200" -->
<!-- name="Christoph Rohland" -->
<!-- email="cr@sap.com" -->
<!-- subject="Re: IBM DB2 failures in 2.4.0-test*" -->
<!-- id="" -->
<!-- inreplyto="Mon, 5 Jun 2000 22:15:29 +0200 (CEST)"" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: IBM DB2 failures in 2.4.0-test*</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: IBM DB2 failures in 2.4.0-test*</h1>
<b>Christoph Rohland</b> (<a href="mailto:cr@sap.com"><i>cr@sap.com</i></a>)<br>
<i>06 Jun 2000 10:29:56 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#547">[ date ]</a><a href="index.html#547">[ thread ]</a><a href="subject.html#547">[ subject ]</a><a href="author.html#547">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0548.html">Hans Reiser: "Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<li> <b>Previous message:</b> <a href="0546.html">Dominik Kubla: "Re: ULTRA ATA/100  announced"</a>
<li> <b>In reply to:</b> <a href="0395.html">Urban Widmark: "IBM DB2 failures in 2.4.0-test*"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--=-=-=<br>
<p>
Urban Widmark &lt;<a href="mailto:urban@svenskatest.se">urban@svenskatest.se</a>&gt; writes:<br>
<p>
<i>&gt; Hello</i><br>
<i>&gt; </i><br>
<i>&gt; I have a problem with IBM DB2 not working in the few 2.4.0-test1-ac? I</i><br>
<i>&gt; know I have tested this on (2 &amp; 7, trying to restore a backup to be</i><br>
<i>&gt; precise, other stuff seems to work). Everything is fine in 2.2. I'm not</i><br>
<i>&gt; sure where it stopped working or why. It is of course perfectly possible</i><br>
<i>&gt; for this to be a db2 bug.</i><br>
<i>&gt; </i><br>
<i>&gt; I'm looking for:</i><br>
<i>&gt; + shm changes, what versions had major changes, ... I'd like to try and</i><br>
<i>&gt;   find which version it stops working. (just guessing, but db2 likes ipc a</i><br>
<i>&gt;   lot)</i><br>
<p>
Could you please try 2.4.0-test1-ac8 + the attached patch.<br>
<p>
Greetings<br>
		Christoph<br>
<p>
<p>
--=-=-=<br>
Content-Disposition: attachment; filename=patch-shm_perm<br>
<p>
--- 4-1-ac8/ipc/shm.c	Mon Jun  5 11:12:29 2000<br>
+++ linux/ipc/shm.c	Mon Jun  5 19:39:14 2000<br>
@@ -1198,6 +1198,7 @@<br>
  */<br>
 asmlinkage long sys_shmat (int shmid, char *shmaddr, int shmflg, ulong *raddr)<br>
 {<br>
+	struct shmid_kernel *shp;<br>
 	unsigned long addr;<br>
 	struct file * file;<br>
 	int    err;<br>
@@ -1225,13 +1226,25 @@<br>
 	if (shmflg &amp; SHM_RDONLY) {<br>
 		prot = PROT_READ;<br>
 		o_flags = O_RDONLY;<br>
-		acc_mode = MAY_READ;<br>
+		acc_mode = S_IRUGO;<br>
 	} else {<br>
 		prot = PROT_READ | PROT_WRITE;<br>
 		o_flags = O_RDWR;<br>
-		acc_mode = MAY_READ | MAY_WRITE;<br>
+		acc_mode = S_IRUGO | S_IWUGO;<br>
 	}<br>
 <br>
+	/*<br>
+	 * We cannot rely on the fs check since SYSV IPC does have an<br>
+	 * aditional creator id...<br>
+	 */<br>
+	shp = shm_lock(shmid);<br>
+	if(shp==NULL)<br>
+		return -EINVAL;<br>
+	err = ipcperms(&amp;shp-&gt;shm_perm, acc_mode);<br>
+	shm_unlock(shmid);<br>
+	if (err)<br>
+		return -EACCES;<br>
+<br>
 	sprintf (name, SHM_FMT, shmid);<br>
 <br>
 	lock_kernel();<br>
@@ -1244,9 +1257,6 @@<br>
 	err = -ENOENT;<br>
 	if (!dentry-&gt;d_inode)<br>
 		goto bad_file;<br>
-	err = permission(dentry-&gt;d_inode, acc_mode);<br>
-	if (err)<br>
-		goto bad_file1;<br>
 	file = dentry_open(dentry, shm_fs_type.kern_mnt, o_flags);<br>
 	err = PTR_ERR(file);<br>
 	if (IS_ERR (file))<br>
<p>
--=-=-=--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0548.html">Hans Reiser: "Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<li> <b>Previous message:</b> <a href="0546.html">Dominik Kubla: "Re: ULTRA ATA/100  announced"</a>
<li> <b>In reply to:</b> <a href="0395.html">Urban Widmark: "IBM DB2 failures in 2.4.0-test*"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
