<!-- received="Tue Jun  6 15:05:03 2000 EET DST" -->
<!-- sent="06 Jun 2000 13:54:20 +0200" -->
<!-- name="Christoph Rohland" -->
<!-- email="cr@sap.com" -->
<!-- subject="[Patch] get db2 (finally) working again with shm fs" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: [Patch] get db2 (finally) working again with shm fs</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[Patch] get db2 (finally) working again with shm fs</h1>
<b>Christoph Rohland</b> (<a href="mailto:cr@sap.com"><i>cr@sap.com</i></a>)<br>
<i>06 Jun 2000 13:54:20 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#572">[ date ]</a><a href="index.html#572">[ thread ]</a><a href="subject.html#572">[ subject ]</a><a href="author.html#572">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0573.html">Alan Cox: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<li> <b>Previous message:</b> <a href="0571.html">Alan Cox: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0690.html">Christopher Zimmerman: "Re: [Patch] get db2 (finally) working again with shm fs"</a>
<li> <b>Reply:</b> <a href="0690.html">Christopher Zimmerman: "Re: [Patch] get db2 (finally) working again with shm fs"</a>
<li> <b>Reply:</b> <a href="0755.html">Christopher Zimmerman: "Re: [Patch] get db2 (finally) working again with shm fs"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--=-=-=<br>
<p>
Hi Alan,<br>
<p>
The following patch against -ac8 finally gets db2 working again with<br>
recent kernels. (I hate the SYSV API :-( )<br>
<p>
It also makes a change to shm.h to make the compile of ipcs<br>
et.al. happy again.<br>
<p>
Please apply<br>
		Christoph<br>
<p>
<p>
--=-=-=<br>
Content-Disposition: attachment; filename=patch-shm_perm2<br>
<p>
diff -uNr 4-1-ac8/include/linux/shm.h c1/include/linux/shm.h<br>
--- 4-1-ac8/include/linux/shm.h	Mon Jun  5 11:20:23 2000<br>
+++ c1/include/linux/shm.h	Tue Jun  6 10:41:23 2000<br>
@@ -2,7 +2,7 @@<br>
 #define _LINUX_SHM_H_<br>
 <br>
 #include &lt;linux/ipc.h&gt;<br>
-#include &lt;linux/mm.h&gt;<br>
+#include &lt;asm/page.h&gt;<br>
 <br>
 /*<br>
  * SHMMAX, SHMMNI and SHMALL are upper limits are defaults which can<br>
diff -uNr 4-1-ac8/ipc/shm.c c1/ipc/shm.c<br>
--- 4-1-ac8/ipc/shm.c	Mon Jun  5 11:12:29 2000<br>
+++ c1/ipc/shm.c	Mon Jun  5 19:39:14 2000<br>
@@ -1198,6 +1198,7 @@<br>
  */<br>
 asmlinkage long sys_shmat (int shmid, char *shmaddr, int shmflg, ulong *raddr)<br>
 {<br>
+	struct shmid_kernel *shp;<br>
 	unsigned long addr;<br>
 	struct file * file;<br>
 	int    err;<br>
@@ -1225,13 +1226,25 @@<br>
 	if (shmflg &amp; SHM_RDONLY) {<br>
 		prot = PROT_READ;<br>
 		o_flags = O_RDONLY;<br>
-		acc_mode = MAY_READ;<br>
+		acc_mode = S_IRUGO;<br>
 	} else {<br>
 		prot = PROT_READ | PROT_WRITE;<br>
 		o_flags = O_RDWR;<br>
-		acc_mode = MAY_READ | MAY_WRITE;<br>
+		acc_mode = S_IRUGO | S_IWUGO;<br>
 	}<br>
 <br>
+	/*<br>
+	 * We cannot rely on the fs check since SYSV IPC does have an<br>
+	 * aditional creator id...<br>
+	 */<br>
+	shp = shm_lock(shmid);<br>
+	if(shp==NULL)<br>
+		return -EINVAL;<br>
+	err = ipcperms(&amp;shp-&gt;shm_perm, acc_mode);<br>
+	shm_unlock(shmid);<br>
+	if (err)<br>
+		return -EACCES;<br>
+<br>
 	sprintf (name, SHM_FMT, shmid);<br>
 <br>
 	lock_kernel();<br>
@@ -1244,9 +1257,6 @@<br>
 	err = -ENOENT;<br>
 	if (!dentry-&gt;d_inode)<br>
 		goto bad_file;<br>
-	err = permission(dentry-&gt;d_inode, acc_mode);<br>
-	if (err)<br>
-		goto bad_file1;<br>
 	file = dentry_open(dentry, shm_fs_type.kern_mnt, o_flags);<br>
 	err = PTR_ERR(file);<br>
 	if (IS_ERR (file))<br>
<p>
--=-=-=--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0573.html">Alan Cox: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<li> <b>Previous message:</b> <a href="0571.html">Alan Cox: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0690.html">Christopher Zimmerman: "Re: [Patch] get db2 (finally) working again with shm fs"</a>
<li> <b>Reply:</b> <a href="0690.html">Christopher Zimmerman: "Re: [Patch] get db2 (finally) working again with shm fs"</a>
<li> <b>Reply:</b> <a href="0755.html">Christopher Zimmerman: "Re: [Patch] get db2 (finally) working again with shm fs"</a>
<!-- reply="end" -->
</ul>
</font></body>
