<!-- received="Tue Jun  6 20:33:37 2000 EET DST" -->
<!-- sent="Tue, 6 Jun 2000 16:53:08 +0100 (BST)" -->
<!-- name="Tigran Aivazian" -->
<!-- email="tigran@veritas.com" -->
<!-- subject="[patch-2.4.0-test1-ac9] /dev/cpu/microcode fixes" -->
<!-- id="" -->
<!-- inreplyto="E12ydcy-0003Jl-00@the-village.bc.nu" -->
<title>Linux-kernel mailing list archive 2000-23,: [patch-2.4.0-test1-ac9] /dev/cpu/microcode fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch-2.4.0-test1-ac9] /dev/cpu/microcode fixes</h1>
<b>Tigran Aivazian</b> (<a href="mailto:tigran@veritas.com"><i>tigran@veritas.com</i></a>)<br>
<i>Tue, 6 Jun 2000 16:53:08 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#642">[ date ]</a><a href="index.html#642">[ thread ]</a><a href="subject.html#642">[ subject ]</a><a href="author.html#642">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0643.html">Alan Cox: "Re: [patch-2.4.0-test1-ac9] /dev/cpu/microcode fixes"</a>
<li> <b>Previous message:</b> <a href="0641.html">Alan Cox: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Dear Alan,<br>
<p>
Last Thursday (on Expo2000) you said that no Linux kernel feature<br>
currently relies (or should rely) on devfs being present.<br>
<p>
Therefore, here is the patch to the Intel P6 microcode update driver that<br>
does:<br>
<p>
a) makes the use of devfs optional, registering the driver as a misc<br>
   device on minor 184 (which H. Peter Anvin kindly allocated earlier)<br>
<p>
b) adds MICROCODE_IOCFREE ioctl to clear memory allocated by the<br>
   driver. The previous idea of overloading O_WRONLY flag at open() time <br>
   was flowed as it destroyed the data on unsuccessful attempt to update.<br>
<p>
c) removes unnecessary zero-initialisations from the driver (as BSS is<br>
   zero-cleared anyway)<br>
<p>
d) updated Documentation/Changes and Documentation/ioctl-number.txt to <br>
   reflect these changes.<br>
<p>
e) typos, cleanups, email address changes etc.<br>
<p>
Regards,<br>
Tigran<br>
<p>
diff -urN -X dontdiff linux/Documentation/Changes mc/Documentation/Changes<br>
--- linux/Documentation/Changes	Tue Jun  6 10:26:25 2000<br>
+++ mc/Documentation/Changes	Tue Jun  6 12:19:25 2000<br>
@@ -132,6 +132,14 @@<br>
 more information, see the files in Documentation/fb/ ; you may also<br>
 need to download the fbset utilities.<br>
 <br>
+   Intel P6 microcode update driver can now be accessed both via devfs<br>
+regular file and as a normal (misc) character device. If you are not using<br>
+devfs you may need to:<br>
+<br>
+	- mkdir /dev/cpu<br>
+	- mknod /dev/cpu/microcode c 10 184<br>
+	- chmod 0644 /dev/cpu/microcode<br>
+<br>
 Libc (libc5)<br>
 ============<br>
 <br>
diff -urN -X dontdiff linux/Documentation/ioctl-number.txt mc/Documentation/ioctl-number.txt<br>
--- linux/Documentation/ioctl-number.txt	Sat May 13 09:32:01 2000<br>
+++ mc/Documentation/ioctl-number.txt	Tue Jun  6 16:33:07 2000<br>
@@ -74,6 +74,8 @@<br>
 0x22	all	scsi/sg.h<br>
 '1'	00-1F	&lt;linux/timepps.h&gt;	PPS kit from Ulrich Windl<br>
 					&lt;<a href="ftp://ftp.de.kernel.org/pub/linux/daemons/ntp/PPS/">ftp://ftp.de.kernel.org/pub/linux/daemons/ntp/PPS/</a>&gt;<br>
+'6'	00-10	&lt;asm-i386/processor.h&gt;	Intel P6 microcode update driver<br>
+					&lt;<a href="mailto:tigran@veritas.com">tigran@veritas.com</a>&gt;<br>
 '8'	all				SNP8023 advanced NIC card<br>
 					&lt;<a href="mailto:mcr@solidum.com">mailto:mcr@solidum.com</a>&gt;<br>
 'A'	00-1F	linux/apm_bios.h<br>
diff -urN -X dontdiff linux/arch/i386/kernel/microcode.c mc/arch/i386/kernel/microcode.c<br>
--- linux/arch/i386/kernel/microcode.c	Thu Mar  2 18:10:24 2000<br>
+++ mc/arch/i386/kernel/microcode.c	Tue Jun  6 16:42:26 2000<br>
@@ -25,6 +25,9 @@<br>
  *		and frees the saved copy of applied microcode.<br>
  *	1.03	29 February 2000, Tigran Aivazian &lt;<a href="mailto:tigran@sco.com">tigran@sco.com</a>&gt;<br>
  *		Made to use devfs (/dev/cpu/microcode) + cleanups.<br>
+ *	1.04	06 June 2000, Simon Trimmer &lt;<a href="mailto:simon@veritas.com">simon@veritas.com</a>&gt;<br>
+ *		Added misc device support (now uses both devfs and misc).<br>
+ *		Added MICROCODE_IOCFREE ioctl to clear memory.<br>
  */<br>
 <br>
 #include &lt;linux/init.h&gt;<br>
@@ -33,16 +36,17 @@<br>
 #include &lt;linux/module.h&gt;<br>
 #include &lt;linux/vmalloc.h&gt;<br>
 #include &lt;linux/smp_lock.h&gt;<br>
+#include &lt;linux/miscdevice.h&gt;<br>
 #include &lt;linux/devfs_fs_kernel.h&gt;<br>
 <br>
 #include &lt;asm/msr.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/processor.h&gt;<br>
 <br>
-#define MICROCODE_VERSION 	"1.03"<br>
+#define MICROCODE_VERSION 	"1.04"<br>
 <br>
-MODULE_DESCRIPTION("CPU (P6) microcode update driver");<br>
-MODULE_AUTHOR("Tigran Aivazian &lt;<a href="mailto:tigran@ocston.org">tigran@ocston.org</a>&gt;");<br>
+MODULE_DESCRIPTION("Intel CPU (P6) microcode update driver");<br>
+MODULE_AUTHOR("Tigran Aivazian &lt;<a href="mailto:tigran@veritas.com">tigran@veritas.com</a>&gt;");<br>
 EXPORT_NO_SYMBOLS;<br>
 <br>
 /* VFS interface */<br>
@@ -50,6 +54,7 @@<br>
 static int microcode_release(struct inode *, struct file *);<br>
 static ssize_t microcode_read(struct file *, char *, size_t, loff_t *);<br>
 static ssize_t microcode_write(struct file *, const char *, size_t, loff_t *);<br>
+static int microcode_ioctl(struct inode *, struct file *, unsigned int, unsigned long);<br>
 <br>
 <br>
 /* internal helpers to do the work */<br>
@@ -60,43 +65,61 @@<br>
  *  Bits in microcode_status. (31 bits of room for future expansion)<br>
  */<br>
 #define MICROCODE_IS_OPEN	0	/* set if device is in use */<br>
-static unsigned long microcode_status = 0;<br>
+<br>
+static unsigned long microcode_status;<br>
 <br>
 /* the actual array of microcode blocks, each 2048 bytes */<br>
-static struct microcode *microcode = NULL;<br>
-static unsigned int microcode_num = 0;<br>
-static char *mc_applied = NULL; /* holds an array of applied microcode blocks */<br>
-static unsigned int mc_fsize;   /* used often, so compute once at microcode_init() */<br>
+static struct microcode *microcode;<br>
+static unsigned int microcode_num;<br>
+static char *mc_applied; /* holds an array of applied microcode blocks */<br>
+static unsigned int mc_fsize;<br>
 <br>
 static struct file_operations microcode_fops = {<br>
 	read:		microcode_read,<br>
 	write:		microcode_write,<br>
+	ioctl:		microcode_ioctl,<br>
 	open:		microcode_open,<br>
 	release:	microcode_release,<br>
 };<br>
 <br>
+static struct miscdevice microcode_dev = {<br>
+	minor: MICROCODE_MINOR,<br>
+	name:	"microcode",<br>
+	fops:	&amp;microcode_fops,<br>
+};<br>
+<br>
 static devfs_handle_t devfs_handle;<br>
 <br>
 static int __init microcode_init(void)<br>
 {<br>
-	devfs_handle = devfs_register(NULL, "cpu/microcode", 0, DEVFS_FL_DEFAULT, 0, 0,<br>
-				   S_IFREG | S_IRUSR | S_IWUSR, 0, 0, &amp;microcode_fops, NULL);<br>
-	if (!devfs_handle) {<br>
-		printk(KERN_ERR "microcode: can't create /dev/cpu/microcode\n");<br>
- 		return -ENOMEM;<br>
- 	}<br>
-	/* XXX assume no hotplug CPUs so smp_num_cpus does not change */<br>
-	mc_fsize = smp_num_cpus * sizeof(struct microcode);<br>
-	printk(KERN_INFO "P6 Microcode Update Driver v%s registered\n", MICROCODE_VERSION);<br>
+	int error = 0;<br>
+<br>
+	if (misc_register(&amp;microcode_dev) &lt; 0) {<br>
+		printk(KERN_WARNING <br>
+			"microcode: can't misc_register on minor=%d\n",<br>
+			MICROCODE_MINOR);<br>
+		error = 1;<br>
+	}<br>
+	devfs_handle = devfs_register(NULL, "cpu/microcode", 0, <br>
+			DEVFS_FL_DEFAULT, 0, 0, S_IFREG | S_IRUSR | S_IWUSR, <br>
+			0, 0, &amp;microcode_fops, NULL);<br>
+	if (devfs_handle == NULL &amp;&amp; error) {<br>
+		printk(KERN_ERR "microcode: failed to devfs_register()\n");<br>
+		return -EINVAL;<br>
+	}<br>
+	printk(KERN_INFO "P6 Microcode Update Driver v%s registered\n", <br>
+			MICROCODE_VERSION);<br>
 	return 0;<br>
 }<br>
 <br>
 static void __exit microcode_exit(void)<br>
 {<br>
+	misc_deregister(&amp;microcode_dev);<br>
 	devfs_unregister(devfs_handle);<br>
 	if (mc_applied)<br>
 		kfree(mc_applied);<br>
-	printk(KERN_INFO "P6 Microcode Update Driver v%s unregistered\n", MICROCODE_VERSION);<br>
+	printk(KERN_INFO "P6 Microcode Update Driver v%s unregistered\n", <br>
+			MICROCODE_VERSION);<br>
 }<br>
 <br>
 module_init(microcode_init);<br>
@@ -114,13 +137,6 @@<br>
 	if (test_and_set_bit(MICROCODE_IS_OPEN, &amp;microcode_status))<br>
 		return -EBUSY;<br>
 <br>
-	if ((file-&gt;f_flags &amp; O_ACCMODE) == O_WRONLY &amp;&amp; mc_applied) {<br>
-		devfs_set_file_size(devfs_handle, 0);<br>
-		memset(mc_applied, 0, mc_fsize);<br>
-		kfree(mc_applied);<br>
-		mc_applied = NULL;<br>
-	}<br>
-<br>
 	MOD_INC_USE_COUNT;<br>
 	return 0;<br>
 }<br>
@@ -132,7 +148,7 @@<br>
 	return 0;<br>
 }<br>
 <br>
-/* a pointer to 'struct update_req' is passed to the IPI hanlder = do_update_one()<br>
+/* a pointer to 'struct update_req' is passed to the IPI handler = do_update_one()<br>
  * update_req[cpu].err is set to 1 if update failed on 'cpu', 0 otherwise<br>
  * if err==0, microcode[update_req[cpu].slot] points to applied block of microcode<br>
  */<br>
@@ -240,7 +256,8 @@<br>
 		return -EINVAL;<br>
 	}<br>
 	if (!mc_applied) {<br>
-		mc_applied = kmalloc(mc_fsize, GFP_KERNEL);<br>
+		mc_applied = kmalloc(smp_num_cpus*sizeof(struct microcode),<br>
+				GFP_KERNEL);<br>
 		if (!mc_applied) {<br>
 			printk(KERN_ERR "microcode: out of memory for saved microcode\n");<br>
 			return -ENOMEM;<br>
@@ -257,17 +274,45 @@<br>
 	}<br>
 	if (copy_from_user(microcode, buf, len)) {<br>
 		ret = -EFAULT;<br>
-		goto out_vfree;<br>
+		goto out_fsize;<br>
 	}<br>
 	if(do_microcode_update()) {<br>
 		ret = -EIO;<br>
-		goto out_vfree;<br>
+		goto out_fsize;<br>
+	} else {<br>
+		mc_fsize = smp_num_cpus * sizeof(struct microcode);<br>
+		ret = (ssize_t)len;<br>
 	}<br>
+out_fsize:<br>
 	devfs_set_file_size(devfs_handle, mc_fsize);<br>
-	ret = (ssize_t)len;<br>
-out_vfree:<br>
 	vfree(microcode);<br>
 out_unlock:<br>
 	unlock_kernel();<br>
 	return ret;<br>
+}<br>
+<br>
+static int microcode_ioctl(struct inode *inode, struct file *file, <br>
+		unsigned int cmd, unsigned long arg)<br>
+{<br>
+	switch(cmd) {<br>
+		case MICROCODE_IOCFREE:<br>
+			if (mc_applied) {<br>
+				devfs_set_file_size(devfs_handle, 0);<br>
+				memset(mc_applied, 0, mc_fsize);<br>
+				kfree(mc_applied);<br>
+				mc_applied = NULL;<br>
+				printk(KERN_WARNING <br>
+					"microcode: freed %d bytes\n", mc_fsize);<br>
+				mc_fsize = 0;<br>
+				return 0;<br>
+			}<br>
+			return -ENODATA;<br>
+<br>
+		default:<br>
+			printk(KERN_ERR "microcode: unknown ioctl cmd=%d\n",<br>
+					cmd);<br>
+			return -EINVAL;<br>
+	}<br>
+	/* NOT REACHED */<br>
+	return -EINVAL;<br>
 }<br>
diff -urN -X dontdiff linux/fs/bfs/inode.c mc/fs/bfs/inode.c<br>
--- linux/fs/bfs/inode.c	Mon Mar 13 20:35:39 2000<br>
+++ mc/fs/bfs/inode.c	Tue Jun  6 11:06:35 2000<br>
@@ -1,7 +1,7 @@<br>
 /*<br>
  *	fs/bfs/inode.c<br>
  *	BFS superblock and inode operations.<br>
- *	Copyright (C) 1999 Tigran Aivazian &lt;<a href="mailto:tigran@ocston.org">tigran@ocston.org</a>&gt;<br>
+ *	Copyright (C) 1999 Tigran Aivazian &lt;<a href="mailto:tigran@veritas.com">tigran@veritas.com</a>&gt;<br>
  *	From fs/minix, Copyright (C) 1991, 1992 Linus Torvalds.<br>
  */<br>
 <br>
@@ -16,7 +16,7 @@<br>
 <br>
 #include "bfs_defs.h"<br>
 <br>
-MODULE_AUTHOR("Tigran A. Aivazian");<br>
+MODULE_AUTHOR("Tigran A. Aivazian &lt;<a href="mailto:tigran@veritas.com">tigran@veritas.com</a>&gt;");<br>
 MODULE_DESCRIPTION("SCO UnixWare BFS filesystem for Linux");<br>
 EXPORT_NO_SYMBOLS;<br>
 <br>
diff -urN -X dontdiff linux/include/asm-i386/processor.h mc/include/asm-i386/processor.h<br>
--- linux/include/asm-i386/processor.h	Tue Jun  6 10:26:26 2000<br>
+++ mc/include/asm-i386/processor.h	Tue Jun  6 16:32:37 2000<br>
@@ -549,4 +549,6 @@<br>
 	unsigned int bits[500];<br>
 };<br>
 <br>
+#define MICROCODE_IOCFREE	_IO('6',0) /* because it is for P6 */<br>
+<br>
 #endif /* __ASM_I386_PROCESSOR_H */<br>
diff -urN -X dontdiff linux/include/linux/miscdevice.h mc/include/linux/miscdevice.h<br>
--- linux/include/linux/miscdevice.h	Sat Mar 18 20:11:35 2000<br>
+++ mc/include/linux/miscdevice.h	Tue Jun  6 16:33:51 2000<br>
@@ -20,6 +20,7 @@<br>
 #define SUN_OPENPROM_MINOR 139<br>
 #define NVRAM_MINOR 144<br>
 #define I2O_MINOR 166<br>
+#define MICROCODE_MINOR		184<br>
 #define MISC_DYNAMIC_MINOR 255<br>
 <br>
 #define SGI_GRAPHICS_MINOR   146<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0643.html">Alan Cox: "Re: [patch-2.4.0-test1-ac9] /dev/cpu/microcode fixes"</a>
<li> <b>Previous message:</b> <a href="0641.html">Alan Cox: "Re: (reiserfs) Re: New Linux 2.5 - 2.6 TODO (Alan Cox suggestsdelaying"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
