<!-- received="Wed Jun  7 02:18:56 2000 EET DST" -->
<!-- sent="Tue, 6 Jun 2000 16:22:59 -0400 (EDT)" -->
<!-- name="Chuck Lever" -->
<!-- email="cel@monkey.org" -->
<!-- subject="POSIX signal queue overflow bug" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: POSIX signal queue overflow bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>POSIX signal queue overflow bug</h1>
<b>Chuck Lever</b> (<a href="mailto:cel@monkey.org"><i>cel@monkey.org</i></a>)<br>
<i>Tue, 6 Jun 2000 16:22:59 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#717">[ date ]</a><a href="index.html#717">[ thread ]</a><a href="subject.html#717">[ subject ]</a><a href="author.html#717">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0718.html">Andreas Bombe: "Re: Linux 2.4.0test1-ac10"</a>
<li> <b>Previous message:</b> <a href="0716.html">Stephen C. Tweedie: "Re: FOPS needs Shutdown SIG Hook!!!"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
hi all-<br>
<p>
i've been playing with zab's web server, and discovered that when the<br>
Posix RT signal queue overflows, no signal is raised.  the kernel is<br>
supposed to raise SIGIO when the queue overflows.<br>
<p>
looking at kernel/signal.c, it appears that an overflow signal will only<br>
happen if si_code is one of the kernel-generated signals.  unfortunately<br>
for applications like zab's server, even though these are<br>
"kernel-generated" signals, si_code is positive for all the signals it<br>
queues (POLL_IN, and so on, are all positive).<br>
<p>
here's a suggested patch to 2.4.0-pre that fixes the bug.  can anyone see<br>
a problem with this?  there is no MAINTAINER listed for this specific area<br>
of the kernel, so i'm posting here.<br>
<p>
--- kernel/signal.c.orig	Fri May 26 15:46:55 2000<br>
+++ kernel/signal.c	Tue Jun  6 16:09:38 2000<br>
@@ -375,7 +375,7 @@<br>
 				break;<br>
 		}<br>
 	} else if (sig &gt;= SIGRTMIN &amp;&amp; info &amp;&amp; (unsigned long)info != 1<br>
-		   &amp;&amp; info-&gt;si_code &lt; 0) {<br>
+		   &amp;&amp; info-&gt;si_code != SI_USER) {<br>
 		/*<br>
 		 * Queue overflow, abort.  We may abort if the signal was rt<br>
 		 * and sent by user using something other than kill().<br>
<p>
	- Chuck Lever<br>
<pre>
--
corporate:	&lt;<a href="mailto:chuckl@netscape.com">chuckl@netscape.com</a>&gt;
personal:	&lt;<a href="mailto:chucklever@bigfoot.com">chucklever@bigfoot.com</a>&gt;
<p>
The Linux Scalability project:
	<a href="http://www.citi.umich.edu/projects/linux-scalability/">http://www.citi.umich.edu/projects/linux-scalability/</a>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0718.html">Andreas Bombe: "Re: Linux 2.4.0test1-ac10"</a>
<li> <b>Previous message:</b> <a href="0716.html">Stephen C. Tweedie: "Re: FOPS needs Shutdown SIG Hook!!!"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
