<!-- received="Wed Jun  7 10:43:24 2000 EET DST" -->
<!-- sent="Wed, 07 Jun 2000 03:34:59 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@mandrakesoft.com" -->
<!-- subject="PATCH 2.4.0.1.ac10: a KISS memory pressure callback" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: PATCH 2.4.0.1.ac10: a KISS memory pressure callback</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH 2.4.0.1.ac10: a KISS memory pressure callback</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@mandrakesoft.com"><i>jgarzik@mandrakesoft.com</i></a>)<br>
<i>Wed, 07 Jun 2000 03:34:59 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#812">[ date ]</a><a href="index.html#812">[ thread ]</a><a href="subject.html#812">[ subject ]</a><a href="author.html#812">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0813.html">Alexander Viro: "Re: Loopback (dir-&gt;dir) mounting (NOT -o loop)"</a>
<li> <b>Previous message:</b> <a href="0811.html">almesber@lrc.di.epfl.ch: "Re: test1-ac10 and bttv"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0841.html">Jeff Garzik: "Re: PATCH 2.4.0.1.ac10: a KISS memory pressure callback"</a>
<li> <b>Reply:</b> <a href="0841.html">Jeff Garzik: "Re: PATCH 2.4.0.1.ac10: a KISS memory pressure callback"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------E7214397E2575411AFA345EC<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Cheesy maybe, effective probably.<br>
<pre>
-- 
Jeff Garzik              | Liberty is always dangerous, but
Building 1024            | it is the safest thing we have.
MandrakeSoft, Inc.       |      -- Harry Emerson Fosdick
--------------E7214397E2575411AFA345EC
Content-Type: text/plain; charset=us-ascii;
 name="freemem.patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="freemem.patch"
<p>
Index: mm/vmscan.c
===================================================================
RCS file: /g/cvslan/linux_2_3/mm/vmscan.c,v
retrieving revision 1.1.1.40
diff -u -r1.1.1.40 vmscan.c
--- mm/vmscan.c	2000/06/05 03:14:23	1.1.1.40
+++ mm/vmscan.c	2000/06/07 07:32:47
@@ -428,6 +428,31 @@
 }
 
 /*
+ * The freemem notifier list holds a list of functions
+ * that are to be called when trying to free pages.
+ *
+ * Call them...  We don't use notifier_call_chain
+ * because the return code from a freemem notifier
+ * is treated as a shrink_*_memory-style return value.
+ */
+extern struct notifier_block *freemem_notifier_list;
+static int shrink_misc_memory (int priority, unsigned int gfp_mask)
+{
+	int count = 0;
+	struct notifier_block *nb = freemem_notifier_list;
+
+	while (nb) {
+		count += nb-&gt;notifier_call(nb,
+			(unsigned long) priority,
+			(void *)(unsigned long) gfp_mask);
+		nb = nb-&gt;next;
+	}
+
+	return count;
+}
+
+
+/*
  * We need to make the locks finer granularity, but right
  * now we need this so that we can do page allocations
  * without holding the kernel lock etc.
@@ -476,6 +501,13 @@
 				if (!--count)
 					goto done;
 			}
+		}
+
+		/* call everybody who registered a mem pressure notifier */
+		count -= shrink_misc_memory(priority, gfp_mask);
+		if (count &lt;= 0) {
+			ret = 1;
+			goto done;
 		}
 
 		/*
Index: kernel/ksyms.c
===================================================================
RCS file: /g/cvslan/linux_2_3/kernel/ksyms.c,v
retrieving revision 1.1.1.62
diff -u -r1.1.1.62 ksyms.c
--- kernel/ksyms.c	2000/05/29 23:48:48	1.1.1.62
+++ kernel/ksyms.c	2000/06/07 07:32:53
@@ -448,6 +448,8 @@
 EXPORT_SYMBOL(machine_power_off);
 EXPORT_SYMBOL(register_reboot_notifier);
 EXPORT_SYMBOL(unregister_reboot_notifier);
+EXPORT_SYMBOL(register_freemem_notifier);
+EXPORT_SYMBOL(unregister_freemem_notifier);
 EXPORT_SYMBOL(_ctype);
 EXPORT_SYMBOL(secure_tcp_sequence_number);
 EXPORT_SYMBOL(get_random_bytes);
Index: kernel/sys.c
===================================================================
RCS file: /g/cvslan/linux_2_3/kernel/sys.c,v
retrieving revision 1.1.1.19
diff -u -r1.1.1.19 sys.c
--- kernel/sys.c	2000/05/31 13:07:05	1.1.1.19
+++ kernel/sys.c	2000/06/07 07:32:53
@@ -47,15 +47,51 @@
  */
 
 static struct notifier_block *reboot_notifier_list = NULL;
+struct notifier_block *freemem_notifier_list = NULL;
+static spinlock_t notifier_lock = SPIN_LOCK_UNLOCKED;
 
 int register_reboot_notifier(struct notifier_block * nb)
 {
-	return notifier_chain_register(&amp;reboot_notifier_list, nb);
+	int i;
+
+	spin_lock(&amp;notifier_lock);
+	i = notifier_chain_register(&amp;reboot_notifier_list, nb);
+	spin_unlock(&amp;notifier_lock);
+
+	return i;
 }
 
 int unregister_reboot_notifier(struct notifier_block * nb)
+{
+	int i;
+
+	spin_lock(&amp;notifier_lock);
+	i = notifier_chain_unregister(&amp;reboot_notifier_list, nb);
+	spin_unlock(&amp;notifier_lock);
+
+	return i;
+}
+
+int register_freemem_notifier(struct notifier_block * nb)
 {
-	return notifier_chain_unregister(&amp;reboot_notifier_list, nb);
+	int i;
+
+	spin_lock(&amp;notifier_lock);
+	i = notifier_chain_register(&amp;freemem_notifier_list, nb);
+	spin_unlock(&amp;notifier_lock);
+
+	return i;
+}
+
+int unregister_freemem_notifier(struct notifier_block * nb)
+{
+	int i;
+
+	spin_lock(&amp;notifier_lock);
+	i = notifier_chain_unregister(&amp;freemem_notifier_list, nb);
+	spin_unlock(&amp;notifier_lock);
+
+	return i;
 }
 
 asmlinkage long sys_ni_syscall(void)
<p>
--------------E7214397E2575411AFA345EC--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0813.html">Alexander Viro: "Re: Loopback (dir-&gt;dir) mounting (NOT -o loop)"</a>
<li> <b>Previous message:</b> <a href="0811.html">almesber@lrc.di.epfl.ch: "Re: test1-ac10 and bttv"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0841.html">Jeff Garzik: "Re: PATCH 2.4.0.1.ac10: a KISS memory pressure callback"</a>
<li> <b>Reply:</b> <a href="0841.html">Jeff Garzik: "Re: PATCH 2.4.0.1.ac10: a KISS memory pressure callback"</a>
<!-- reply="end" -->
</ul>
</font></body>
