<!-- received="Wed Jun  7 17:10:21 2000 EET DST" -->
<!-- sent="Wed, 7 Jun 2000 15:08:32 +0200" -->
<!-- name="Jens Axboe" -->
<!-- email="axboe@suse.de" -->
<!-- subject="Re: test1-ac9 changes broken keyboard behaviour" -->
<!-- id="" -->
<!-- inreplyto="20000607200144.A4687@metastasis.f00f.org" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: test1-ac9 changes broken keyboard behaviour</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: test1-ac9 changes broken keyboard behaviour</h1>
<b>Jens Axboe</b> (<a href="mailto:axboe@suse.de"><i>axboe@suse.de</i></a>)<br>
<i>Wed, 7 Jun 2000 15:08:32 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#897">[ date ]</a><a href="index.html#897">[ thread ]</a><a href="subject.html#897">[ subject ]</a><a href="author.html#897">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0898.html">Michal Kosek: "Re: capabilities PATCH"</a>
<li> <b>Previous message:</b> <a href="0896.html">Jesse Pollard: "Re: capabilities PATCH"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--uAKRQypu60I7Lcqm<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: inline<br>
<p>
On Wed, Jun 07 2000, Chris Wedgwood wrote:<br>
<i>&gt;     I can't test any of this on my other machine (which seemed</i><br>
<i>&gt;     completely unaffected by the keyboard problem), 'cos it's got a</i><br>
<i>&gt;     AIC7xxx.</i><br>
<i>&gt; </i><br>
<i>&gt; Back out the SCSI changes, specifically take the attached patch and</i><br>
<i>&gt; do something like:</i><br>
<i>&gt; </i><br>
<i>&gt;   cd /usr/src/linux</i><br>
<i>&gt;   patch -p1 -R &lt; /path/to/ac8-scsi</i><br>
<i>&gt; </i><br>
<i>&gt; and rebuild.</i><br>
<p>
You are backing out way too much, if you have to back stuff out until<br>
Doug fixes this use the attached patch.<br>
<p>
<pre>
-- 
* Jens Axboe &lt;<a href="mailto:axboe@suse.de">axboe@suse.de</a>&gt;
* SuSE Labs
<p>
--uAKRQypu60I7Lcqm
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="scsi_scan-ac5.diff"
<p>
--- /opt/kernel/linux-2.4.0-test1-ac6/drivers/scsi/scsi_scan.c	Wed May 31 00:14:25 2000
+++ drivers/scsi/scsi_scan.c	Wed May 31 00:14:18 2000
@@ -483,7 +483,38 @@
 	SDpnt-&gt;expecting_cc_ua = 0;
 	SDpnt-&gt;starved = 0;
 
+	scsi_cmd[0] = TEST_UNIT_READY;
+	scsi_cmd[1] = lun &lt;&lt; 5;
+	scsi_cmd[2] = scsi_cmd[3] = scsi_cmd[4] = scsi_cmd[5] = 0;
+
 	SRpnt = scsi_allocate_request(SDpnt);
+
+	SRpnt-&gt;sr_data_direction = SCSI_DATA_NONE;
+	scsi_wait_req (SRpnt, (void *) scsi_cmd,
+	          (void *) NULL,
+	          0, SCSI_TIMEOUT + 4 * HZ, 5);
+
+	SCSI_LOG_SCAN_BUS(3, printk("scsi: scan_scsis_single id %d lun %d. Return code 0x%08x\n",
+				    dev, lun, SRpnt-&gt;sr_result));
+	SCSI_LOG_SCAN_BUS(3, print_driverbyte(SRpnt-&gt;sr_result));
+	SCSI_LOG_SCAN_BUS(3, print_hostbyte(SRpnt-&gt;sr_result));
+	SCSI_LOG_SCAN_BUS(3, printk("\n"));
+
+	if (SRpnt-&gt;sr_result) {
+		if (((driver_byte(SRpnt-&gt;sr_result) &amp; DRIVER_SENSE) ||
+		     (status_byte(SRpnt-&gt;sr_result) &amp; CHECK_CONDITION)) &amp;&amp;
+		    ((SRpnt-&gt;sr_sense_buffer[0] &amp; 0x70) &gt;&gt; 4) == 7) {
+			if (((SRpnt-&gt;sr_sense_buffer[2] &amp; 0xf) != NOT_READY) &amp;&amp;
+			    ((SRpnt-&gt;sr_sense_buffer[2] &amp; 0xf) != UNIT_ATTENTION) &amp;&amp;
+			    ((SRpnt-&gt;sr_sense_buffer[2] &amp; 0xf) != ILLEGAL_REQUEST || lun &gt; 0)) {
+				scsi_release_request(SRpnt);
+				return 1;
+			}
+		} else {
+			scsi_release_request(SRpnt);
+			return 0;
+		}
+	}
 
 	/*
 	 * We used to do a TEST_UNIT_READY before the INQUIRY but that was 
<p>
--uAKRQypu60I7Lcqm--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0898.html">Michal Kosek: "Re: capabilities PATCH"</a>
<li> <b>Previous message:</b> <a href="0896.html">Jesse Pollard: "Re: capabilities PATCH"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
