<!-- received="Wed Jun  7 23:48:03 2000 EET DST" -->
<!-- sent="Wed, 07 Jun 2000 22:09:44 +0300" -->
<!-- name="Topi Miettinen" -->
<!-- email="Topi.Miettinen@nic.fi" -->
<!-- subject="Re: [PATCH] Quotas for /dev/pts/" -->
<!-- id="200006071858.VAA13858@jakorasia.nic.fi" -->
<!-- inreplyto="[PATCH] Quotas for /dev/pts/" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: [PATCH] Quotas for /dev/pts/</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] Quotas for /dev/pts/</h1>
<b>Topi Miettinen</b> (<a href="mailto:Topi.Miettinen@nic.fi"><i>Topi.Miettinen@nic.fi</i></a>)<br>
<i>Wed, 07 Jun 2000 22:09:44 +0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#979">[ date ]</a><a href="index.html#979">[ thread ]</a><a href="subject.html#979">[ subject ]</a><a href="author.html#979">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0980.html">Steve Dodd: "Re: (wh)OOPS.txt"</a>
<li> <b>Previous message:</b> <a href="0978.html">Hans Reiser: "Re: journaling &amp; VM  (was: Re: reiserfs being part of the kernel:it'snot"</a>
<li> <b>Maybe in reply to:</b> <a href="0164.html">Topi Miettinen: "[PATCH] Quotas for /dev/pts/"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
(Please cc: me, I'm not subscribed.)<br>
<p>
<i>&gt; I don't think this is the right way to do it.  It should fail the open</i><br>
<i>&gt; of /dev/ptmx, not when trying to access the slave.</i><br>
<i>&gt; </i><br>
<i>&gt; 	-hpa</i><br>
<p>
This is exactly what will happen:<br>
<p>
open("typescript", O_WRONLY|O_CREAT|O_TRUNC, 0666) = 3<br>
ioctl(0, TCGETS, {B9600 opost isig icanon echo ...}) = 0<br>
ioctl(0, TIOCGWINSZ, {ws_row=24, ws_col=80, ws_xpixel=484, ws_ypixel=316}) = 0<br>
open("/dev/ptmx", O_RDWR)               = -1 EDQUOT (Disk quota exceeded)<br>
write(2, "openpty failed\n", 15openpty failed<br>
)        = 15<br>
kill(0, SIGTERM &lt;unfinished ...&gt;<br>
<p>
BTW, the patch I sent earlier missed a part, sorry. For some reason, devices<br>
weren't counted in inode quotas, which is inconsistent with quotacheck.<br>
<p>
-Topi<br>
<p>
diff -ru linux-2.2.15.orig/fs/devpts/inode.c linux-2.2.15/fs/devpts/inode.c<br>
--- linux-2.2.15.orig/fs/devpts/inode.c	Fri Aug 21 04:33:50 1998<br>
+++ linux-2.2.15/fs/devpts/inode.c	Sun Jun  4 23:22:59 2000<br>
@@ -21,6 +21,7 @@<br>
 #include &lt;linux/malloc.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
 #include &lt;linux/tty.h&gt;<br>
+#include &lt;linux/quotaops.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -111,6 +112,11 @@<br>
 			if (*value)<br>
 				return 1;<br>
 		}<br>
+		else if (!strcmp(this_char,"usrquota")<br>
+			 || !strcmp(this_char,"grpquota")<br>
+			 || !strcmp(this_char,"rsquash")) {<br>
+			;<br>
+		}<br>
 		else<br>
 			return 1;<br>
 	}<br>
@@ -302,7 +308,7 @@<br>
 	NULL<br>
 };<br>
 <br>
-void devpts_pty_new(int number, kdev_t device)<br>
+int devpts_pty_new(int number, kdev_t device)<br>
 {<br>
 	struct super_block *sb;<br>
 	struct devpts_sb_info *sbi;<br>
@@ -324,8 +330,17 @@<br>
 			inode-&gt;i_rdev = device;<br>
 			inode-&gt;i_nlink++;<br>
 			sbi-&gt;inodes[number] = inode;<br>
+<br>
+			if (DQUOT_ALLOC_INODE(sb, inode)) {<br>
+				if (sb-&gt;dq_op)<br>
+					sb-&gt;dq_op-&gt;drop(inode);<br>
+				inode-&gt;i_nlink = 0;<br>
+				iput(inode);<br>
+				return -EDQUOT;<br>
+			}<br>
 		}<br>
 	}<br>
+	return 0;<br>
 }<br>
 <br>
 void devpts_pty_kill(int number)<br>
@@ -340,6 +355,8 @@<br>
 		inode = sbi-&gt;inodes[number];<br>
 <br>
 		if ( inode ) {<br>
+			DQUOT_FREE_INODE(sb, inode);<br>
+			DQUOT_DROP(inode);<br>
 			sbi-&gt;inodes[number] = NULL;<br>
 			inode-&gt;i_nlink--;<br>
 			iput(inode);<br>
diff -ru linux-2.2.15.orig/fs/dquot.c linux-2.2.15/fs/dquot.c<br>
--- linux-2.2.15.orig/fs/dquot.c	Wed Jun  7 21:27:18 2000<br>
+++ linux-2.2.15/fs/dquot.c	Wed Jun  7 21:17:19 2000<br>
@@ -667,8 +667,10 @@<br>
 {<br>
 	int cnt;<br>
 <br>
+#if 0<br>
         if (!(S_ISREG(inode-&gt;i_mode) || S_ISDIR(inode-&gt;i_mode) || <br>
S_ISLNK(inode-&gt;i_mode)))<br>
                 return 0;<br>
+#endif<br>
 	if (is_quotafile(inode))<br>
 		return 0;<br>
 	if (type != -1)<br>
@@ -1082,9 +1084,11 @@<br>
 	unsigned int id = 0;<br>
 	short cnt;<br>
 <br>
+#if 0<br>
 	if (S_ISREG(inode-&gt;i_mode) ||<br>
             S_ISDIR(inode-&gt;i_mode) ||<br>
             S_ISLNK(inode-&gt;i_mode)) {<br>
+#endif<br>
 		/* We don't want to have quotas on quota files - nasty deadlocks possible */<br>
 		if (is_quotafile(inode))<br>
 			return;<br>
@@ -1115,7 +1119,9 @@<br>
 				inode-&gt;i_flags |= S_QUOTA;<br>
 			}<br>
 		}<br>
+#if 0<br>
 	}<br>
+#endif<br>
 }<br>
 <br>
 /*<br>
diff -ru linux-2.2.15.orig/drivers/char/tty_io.c linux-2.2.15/drivers/char/tty_<br>
io.c<br>
--- linux-2.2.15.orig/drivers/char/tty_io.c	Wed Jun  7 21:05:33 2000<br>
+++ linux-2.2.15/drivers/char/tty_io.c	Sun Jun  4 23:41:37 2000<br>
@@ -1331,7 +1331,12 @@<br>
 	ptmx_found:<br>
 		set_bit(TTY_PTY_LOCK, &amp;tty-&gt;flags); /* LOCK THE SLAVE */<br>
 		minor -= driver-&gt;minor_start;<br>
-		devpts_pty_new(driver-&gt;other-&gt;name_base + minor, MKDEV(driver-&gt;other-&gt;<br>
major, minor + driver-&gt;other-&gt;minor_start));<br>
+		retval = devpts_pty_new(driver-&gt;other-&gt;name_base + minor, MKDEV(driver-&gt;<br>
other-&gt;major, minor + driver-&gt;other-&gt;minor_start));<br>
+		if (retval) {<br>
+			filp-&gt;private_data = tty;<br>
+			release_dev(filp);<br>
+			return retval; /* quota exceeded */<br>
+		}<br>
 		tty_register_devfs(&amp;pts_driver[major], 0,<br>
 				   pts_driver[major].minor_start + minor);<br>
 		noctty = 1;<br>
diff -ru linux-2.2.15.orig/include/linux/devpts_fs.h <br>
linux-2.2.15/include/linux/devpts_fs.h<br>
--- linux-2.2.15.orig/include/linux/devpts_fs.h	Tue May 11 20:35:45 1999<br>
+++ linux-2.2.15/include/linux/devpts_fs.h	Sun Jun  4 23:32:26 2000<br>
@@ -25,14 +25,14 @@<br>
 <br>
 #ifdef CONFIG_DEVPTS_FS<br>
 <br>
-void devpts_pty_new(int, kdev_t);<br>
+int devpts_pty_new(int, kdev_t);<br>
 void devpts_pty_kill(int);<br>
 #define unix98_max_ptys               NR_PTYS * UNIX98_NR_MAJORS;<br>
 <br>
 #elif defined(CONFIG_DEVPTS_FS_MODULE)<br>
 <br>
 #ifdef BUILDING_PTY_C<br>
-void (*devpts_upcall_new)(int,kdev_t) = NULL;<br>
+int (*devpts_upcall_new)(int,kdev_t)  = NULL;<br>
 void (*devpts_upcall_kill)(int)       = NULL;<br>
 unsigned int unix98_max_ptys          = NR_PTYS * UNIX98_NR_MAJORS;<br>
 <br>
@@ -46,7 +46,7 @@<br>
 #endif<br>
 <br>
 #ifndef BUILDING_DEVPTS<br>
-extern inline void<br>
+extern inline int<br>
 devpts_pty_new(int line, kdev_t device)<br>
 {<br>
 	if ( devpts_upcall_new )<br>
@@ -63,8 +63,8 @@<br>
 <br>
 #else  /* No /dev/pts filesystem at all */<br>
 <br>
-extern inline void<br>
-devpts_pty_new(int line, kdev_t device) { }<br>
+extern inline int<br>
+devpts_pty_new(int line, kdev_t device) { return 0; }<br>
 <br>
 extern inline void<br>
 devpts_pty_kill(int line) { }<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0980.html">Steve Dodd: "Re: (wh)OOPS.txt"</a>
<li> <b>Previous message:</b> <a href="0978.html">Hans Reiser: "Re: journaling &amp; VM  (was: Re: reiserfs being part of the kernel:it'snot"</a>
<li> <b>Maybe in reply to:</b> <a href="0164.html">Topi Miettinen: "[PATCH] Quotas for /dev/pts/"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
