<!-- received="Thu Jun  8 06:58:54 2000 EET DST" -->
<!-- sent="Thu, 8 Jun 2000 03:45:06 +0200" -->
<!-- name="Andries Brouwer" -->
<!-- email="aeb@veritas.com" -->
<!-- subject="[PATCH] Re: Help with a loop device bug" -->
<!-- id="" -->
<!-- inreplyto="84ln0j300h.fsf@athena.dhis.org" -->
<title>Linux-kernel mailing list archive 2000-23,: [PATCH] Re: Help with a loop device bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Re: Help with a loop device bug</h1>
<b>Andries Brouwer</b> (<a href="mailto:aeb@veritas.com"><i>aeb@veritas.com</i></a>)<br>
<i>Thu, 8 Jun 2000 03:45:06 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1069">[ date ]</a><a href="index.html#1069">[ thread ]</a><a href="subject.html#1069">[ subject ]</a><a href="author.html#1069">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1070.html">kaos@ocs.com.au: "test2"</a>
<li> <b>Previous message:</b> <a href="1068.html">David Marshall: "Re: 'lock' modules?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1249.html">David Marshall: "Loop device bug #2"</a>
<li> <b>Reply:</b> <a href="1249.html">David Marshall: "Loop device bug #2"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, Jun 05, 2000 at 11:29:34PM -0500, David Marshall wrote:<br>
<p>
<i>&gt; The bug I'm not understanding is related to a -ETXTBSY which is</i><br>
<i>&gt; returned from loop_clr_fd(). When I use losetup (yes, it's the</i><br>
<i>&gt; included version) to attach a loop device to another file, then when I</i><br>
<i>&gt; try to detach the loop device the kernel still thinks that the file is</i><br>
<i>&gt; busy and will return -ETXTBSY the *next* time that get_write_access()</i><br>
<i>&gt; is called.</i><br>
<i>&gt; </i><br>
<i>&gt; Example:</i><br>
<i>&gt; </i><br>
<i>&gt; # losetup -e none /dev/loop0 foobar</i><br>
<i>&gt; # losetup -d /dev/loop0</i><br>
<i>&gt; # losetup -e none /dev/loop0 foobar</i><br>
<i>&gt; foobar: Text file busy</i><br>
<p>
Yes. The problem is that losetup does get_write_access(),<br>
and losetup -d does put_write_access(), but then the fput()<br>
done afterwards again does put_write_access() (if FMODE_WRITE is set).<br>
So, loop.c must only do the put_write_access() in case FMODE_WRITE<br>
is not set. Below a patch (only one change, the rest is shortening<br>
some lines that do not fit an 80-col screen).<br>
<p>
Andries<br>
<p>
--- ../linux-2.3.99p9/linux/drivers/block/loop.c	Wed May 24 15:18:10 2000<br>
+++ linux/drivers/block/loop.c	Thu Jun  8 03:19:59 2000<br>
@@ -238,7 +238,8 @@<br>
 	kaddr = (char*)kmap(page);<br>
 	if ((lo-&gt;transfer)(lo,READ,kaddr+offset,p-&gt;data,size,IV)) {<br>
 		size = 0;<br>
-		printk(KERN_ERR "loop: transfer error block %ld\n",page-&gt;index);<br>
+		printk(KERN_ERR "loop: transfer error block %ld\n",<br>
+		       page-&gt;index);<br>
 		desc-&gt;error = -EINVAL;<br>
 	}<br>
 	kunmap(page);<br>
@@ -345,9 +346,11 @@<br>
 			}<br>
 		}<br>
 <br>
-		if ((lo-&gt;transfer)(lo, current_request-&gt;cmd, bh-&gt;b_data + offset,<br>
-				dest_addr, size, block)) {<br>
-			printk(KERN_ERR "loop: transfer error block %d\n", block);<br>
+		if ((lo-&gt;transfer)(lo, current_request-&gt;cmd,<br>
+				   bh-&gt;b_data + offset,<br>
+				   dest_addr, size, block)) {<br>
+			printk(KERN_ERR "loop: transfer error block %d\n",<br>
+			       block);<br>
 			brelse(bh);<br>
 			goto error_out_lock;<br>
 		}<br>
@@ -539,8 +542,10 @@<br>
 	lo-&gt;lo_dentry = NULL;<br>
 <br>
 	if (lo-&gt;lo_backing_file != NULL) {<br>
-		put_write_access(lo-&gt;lo_backing_file-&gt;f_dentry-&gt;d_inode);<br>
-		fput(lo-&gt;lo_backing_file);<br>
+		struct file *filp = lo-&gt;lo_backing_file;<br>
+		if ((filp-&gt;f_mode &amp; FMODE_WRITE) == 0)<br>
+			put_write_access(filp-&gt;f_dentry-&gt;d_inode);<br>
+		fput(filp);<br>
 		lo-&gt;lo_backing_file = NULL;<br>
 	} else {<br>
 		dput(dentry);<br>
@@ -636,7 +641,8 @@<br>
 	if (!inode)<br>
 		return -EINVAL;<br>
 	if (MAJOR(inode-&gt;i_rdev) != MAJOR_NR) {<br>
-		printk(KERN_WARNING "lo_ioctl: pseudo-major != %d\n", MAJOR_NR);<br>
+		printk(KERN_WARNING "lo_ioctl: pseudo-major != %d\n",<br>
+		       MAJOR_NR);<br>
 		return -ENODEV;<br>
 	}<br>
 	dev = MINOR(inode-&gt;i_rdev);<br>
@@ -698,7 +704,8 @@<br>
 	if (!inode)<br>
 		return 0;<br>
 	if (MAJOR(inode-&gt;i_rdev) != MAJOR_NR) {<br>
-		printk(KERN_WARNING "lo_release: pseudo-major != %d\n", MAJOR_NR);<br>
+		printk(KERN_WARNING "lo_release: pseudo-major != %d\n",<br>
+		       MAJOR_NR);<br>
 		return 0;<br>
 	}<br>
 	dev = MINOR(inode-&gt;i_rdev);<br>
@@ -706,7 +713,8 @@<br>
 		return 0;<br>
 	lo = &amp;loop_dev[dev];<br>
 	if (lo-&gt;lo_refcnt &lt;= 0)<br>
-		printk(KERN_ERR "lo_release: refcount(%d) &lt;= 0\n", lo-&gt;lo_refcnt);<br>
+		printk(KERN_ERR "lo_release: refcount(%d) &lt;= 0\n",<br>
+		       lo-&gt;lo_refcnt);<br>
 	else  {<br>
 		int type  = lo-&gt;lo_encrypt_type;<br>
 		--lo-&gt;lo_refcnt;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1070.html">kaos@ocs.com.au: "test2"</a>
<li> <b>Previous message:</b> <a href="1068.html">David Marshall: "Re: 'lock' modules?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1249.html">David Marshall: "Loop device bug #2"</a>
<li> <b>Reply:</b> <a href="1249.html">David Marshall: "Loop device bug #2"</a>
<!-- reply="end" -->
</ul>
</font></body>
