<!-- received="Fri Jun  9 03:56:17 2000 EET DST" -->
<!-- sent="Fri, 9 Jun 2000 02:34:48 +0200 (MET DST)" -->
<!-- name="Andries.Brouwer@cwi.nl" -->
<!-- email="Andries.Brouwer@cwi.nl" -->
<!-- subject="[PATCH] cdrom stuff" -->
<!-- id="UTC200006090034.CAA06254.aeb@eland.cwi.nl" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-23,: [PATCH] cdrom stuff</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] cdrom stuff</h1>
<a href="mailto:Andries.Brouwer@cwi.nl"><i>Andries.Brouwer@cwi.nl</i></a><br>
<i>Fri, 9 Jun 2000 02:34:48 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1228">[ date ]</a><a href="index.html#1228">[ thread ]</a><a href="subject.html#1228">[ subject ]</a><a href="author.html#1228">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1229.html">Rolf Martin-Hoster: "HighPoint IDE RAID"</a>
<li> <b>Previous message:</b> <a href="1227.html">Andre Hedrick: "TCQ"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1233.html">Jens Axboe: "Re: [PATCH] cdrom stuff"</a>
<li> <b>Reply:</b> <a href="1233.html">Jens Axboe: "Re: [PATCH] cdrom stuff"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Jeff complained about dd errors while reading a CDROM,<br>
and I also get such errors at the end, after reading all.<br>
The reason is that the READ CD-ROM CAPACITY command is<br>
not guaranteed to be precise, and indeed is not precise<br>
on my hardware.<br>
In 2.3.16 some better code was introduced, but it was<br>
backed out again in 2.3.17 after people complained that<br>
it yielded error messages. This better code uses the<br>
READ DISC INFORMATION command. According to my docs,<br>
this is a CD-R/RW only command, unavailable on an ordinary<br>
CDROM reader. (And my hardware agrees with my docs.)<br>
<p>
Thus, the patch below resurrects the 2.3.16 stuff, but<br>
only on CD-R/RW. This means that dd now reads an image<br>
correctly on CD-R/RW, but still gets EIO at the end on<br>
a CDROM drive.<br>
<p>
Andries<br>
<p>
diff -u --recursive --new-file ../linux-2.3.99p9/linux/drivers/cdrom/cdrom.c ./linux/drivers/cdrom/cdrom.c<br>
--- ../linux-2.3.99p9/linux/drivers/cdrom/cdrom.c	Sat May 13 03:18:23 2000<br>
+++ ./linux/drivers/cdrom/cdrom.c	Fri Jun  9 01:47:40 2000<br>
@@ -193,7 +193,7 @@<br>
 <br>
   3.07 Feb 2, 2000 - Jens Axboe &lt;<a href="mailto:axboe@suse.de">axboe@suse.de</a>&gt;<br>
   -- Do same "read header length" trick in cdrom_get_disc_info() as<br>
-  we do in cdrom_get_track_info() -- some drive don't obbey specs and<br>
+  we do in cdrom_get_track_info() -- some drive don't obey specs and<br>
   fail if they can't supply the full Mt Fuji size table.<br>
   -- Deleted stuff related to setting up write modes. It has a different<br>
   home now.<br>
@@ -285,7 +285,7 @@<br>
 <br>
 /* The (cdo-&gt;capability &amp; ~cdi-&gt;mask &amp; CDC_XXX) construct was used in<br>
    a lot of places. This macro makes the code more clear. */<br>
-#define CDROM_CAN(type) (cdi-&gt;ops-&gt;capability &amp; ~cdi-&gt;mask &amp; type)<br>
+#define CDROM_CAN(type) (cdi-&gt;ops-&gt;capability &amp; ~cdi-&gt;mask &amp; (type))<br>
 <br>
 /* used in the audio ioctls */<br>
 #define CHECKAUDIO if ((ret=check_for_audio_disc(cdi, cdo))) return ret<br>
@@ -2158,6 +2158,7 @@<br>
 	return cdo-&gt;generic_packet(cdi, &amp;cgc);<br>
 }<br>
 <br>
+/* requires CD R/RW */<br>
 int cdrom_get_disc_info(kdev_t dev, disc_information *di)<br>
 {<br>
 	struct cdrom_device_info *cdi = cdrom_find_device(dev);<br>
@@ -2199,6 +2200,9 @@<br>
 	int ret = -1;<br>
 <br>
 	if (!CDROM_CAN(CDC_GENERIC_PACKET))<br>
+		goto use_toc;<br>
+<br>
+	if (!CDROM_CAN(CDC_CD_R | CDC_CD_RW))<br>
 		goto use_toc;<br>
 <br>
 	if ((ret = cdrom_get_disc_info(dev, &amp;di)))<br>
diff -u --recursive --new-file ../linux-2.3.99p9/linux/drivers/ide/ide-cd.c ./linux/drivers/ide/ide-cd.c<br>
--- ../linux-2.3.99p9/linux/drivers/ide/ide-cd.c	Sat May 13 03:18:24 2000<br>
+++ ./linux/drivers/ide/ide-cd.c	Fri Jun  9 02:03:14 2000<br>
@@ -426,11 +426,13 @@<br>
 <br>
 			while (hi &gt; lo) {<br>
 				mid = (lo + hi) / 2;<br>
-				if (packet_command_texts[mid].packet_command == failed_command-&gt;c[0]) {<br>
+				if (packet_command_texts[mid].packet_command ==<br>
+				    failed_command-&gt;c[0]) {<br>
 					s = packet_command_texts[mid].text;<br>
 					break;<br>
 				}<br>
-				else if (packet_command_texts[mid].packet_command &gt; failed_command-&gt;c[0])<br>
+				if (packet_command_texts[mid].packet_command &gt;<br>
+				    failed_command-&gt;c[0])<br>
 					hi = mid;<br>
 				else<br>
 					lo = mid+1;<br>
@@ -1624,7 +1626,8 @@<br>
 /* Try to read the entire TOC for the disk into our internal buffer. */<br>
 static int cdrom_read_toc(ide_drive_t *drive, struct request_sense *sense)<br>
 {<br>
-	int stat, ntracks, i;<br>
+	int minor, stat, ntracks, i;<br>
+	kdev_t dev;<br>
 	struct cdrom_info *info = drive-&gt;driver_data;<br>
 	struct atapi_toc *toc = info-&gt;toc;<br>
 	struct {<br>
@@ -1663,8 +1666,10 @@<br>
 #endif  /* not STANDARD_ATAPI */<br>
 <br>
 	ntracks = toc-&gt;hdr.last_track - toc-&gt;hdr.first_track + 1;<br>
-	if (ntracks &lt;= 0) return -EIO;<br>
-	if (ntracks &gt; MAX_TRACKS) ntracks = MAX_TRACKS;<br>
+	if (ntracks &lt;= 0)<br>
+		return -EIO;<br>
+	if (ntracks &gt; MAX_TRACKS)<br>
+		ntracks = MAX_TRACKS;<br>
 <br>
 	/* Now read the whole schmeer. */<br>
 	stat = cdrom_read_tocentry(drive, toc-&gt;hdr.first_track, 1, 0,<br>
@@ -1755,13 +1760,13 @@<br>
 	toc-&gt;xa_flag = (ms_tmp.hdr.first_track != ms_tmp.hdr.last_track);<br>
 <br>
 	/* Now try to get the total cdrom capacity. */<br>
-#if 0<br>
-	stat = cdrom_get_last_written(MKDEV(HWIF(drive)-&gt;major, minor),<br>
-				     (long *)&amp;toc-&gt;capacity);<br>
+	minor = (drive-&gt;select.b.unit) &lt;&lt; PARTN_BITS;<br>
+	dev = MKDEV(HWIF(drive)-&gt;major, minor);<br>
+	stat = cdrom_get_last_written(dev, (long *)&amp;toc-&gt;capacity);<br>
 	if (stat)<br>
-#endif<br>
-	stat = cdrom_read_capacity(drive, &amp;toc-&gt;capacity, sense);<br>
-	if (stat) toc-&gt;capacity = 0x1fffff;<br>
+		stat = cdrom_read_capacity(drive, &amp;toc-&gt;capacity, sense);<br>
+	if (stat)<br>
+		toc-&gt;capacity = 0x1fffff;<br>
 <br>
 	/* Remember that we've read this stuff. */<br>
 	CDROM_STATE_FLAGS (drive)-&gt;toc_valid = 1;<br>
@@ -2552,7 +2557,8 @@<br>
 {<br>
 	unsigned capacity;<br>
 <br>
-	return cdrom_read_capacity(drive, &amp;capacity, NULL) ? 0 : capacity * SECTORS_PER_FRAME;<br>
+	return cdrom_read_capacity(drive, &amp;capacity, NULL)<br>
+		? 0 : capacity * SECTORS_PER_FRAME;<br>
 }<br>
 <br>
 static<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1229.html">Rolf Martin-Hoster: "HighPoint IDE RAID"</a>
<li> <b>Previous message:</b> <a href="1227.html">Andre Hedrick: "TCQ"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1233.html">Jens Axboe: "Re: [PATCH] cdrom stuff"</a>
<li> <b>Reply:</b> <a href="1233.html">Jens Axboe: "Re: [PATCH] cdrom stuff"</a>
<!-- reply="end" -->
</ul>
</font></body>
