<!-- received="Fri Jun  9 11:35:50 2000 EET DST" -->
<!-- sent="Fri, 9 Jun 2000 10:13:25 +0200" -->
<!-- name="Andries Brouwer" -->
<!-- email="aeb@veritas.com" -->
<!-- subject="Re: Loop device bug #2" -->
<!-- id="" -->
<!-- inreplyto="84itvjxw4q.fsf_-_@athena.dhis.org" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: Loop device bug #2</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Loop device bug #2</h1>
<b>Andries Brouwer</b> (<a href="mailto:aeb@veritas.com"><i>aeb@veritas.com</i></a>)<br>
<i>Fri, 9 Jun 2000 10:13:25 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1265">[ date ]</a><a href="index.html#1265">[ thread ]</a><a href="subject.html#1265">[ subject ]</a><a href="author.html#1265">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1266.html">Jacob Luna Lundberg: "Re: Floppy handling"</a>
<li> <b>Previous message:</b> <a href="1264.html">Ian McKellar: "Re: Floppy handling"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, Jun 09, 2000 at 12:26:45AM -0500, David Marshall wrote:<br>
<p>
<i>&gt; Thanks for the help with the write access locking, Andries.</i><br>
<i>&gt; It works like a charm.</i><br>
<p>
Good.<br>
<p>
<i>&gt; I've run into another bug, though. It occurs both in my</i><br>
<i>&gt; crypto-enabled kernel and the pristine no-crypto mainline kernel. </i><br>
<i>&gt; </i><br>
<i>&gt; The loopback devices, even with the "none" transform, are hosing out </i><br>
<i>&gt; quite horribly. After a rather trivial amount of data write activity</i><br>
<i>&gt; across a loop device, the system locks on disk activity.</i><br>
<p>
Yes, this is a well-known problem, but one I have not<br>
looked at so far. People have advertized several things<br>
that should help, but I have not yet spent time to see<br>
whether I understand why this should help, and what particular<br>
problem is fixed. So, below I am only repeating what others<br>
have said.<br>
<p>
Pavel Machek tells us to use a dummy plugging function:<br>
<p>
diff -u --recursive --new-file ../linux-2.3.99p9/linux/drivers/block/loop.c ./linux/drivers/block/loop.c<br>
--- ../linux-2.3.99p9/linux/drivers/block/loop.c        Wed May 24 15:18:10 2000<br>
+++ ./linux/drivers/block/loop.c        Sat May 20 14:21:47 2000<br>
@@ -761,6 +761,10 @@<br>
 EXPORT_SYMBOL(loop_register_transfer);<br>
 EXPORT_SYMBOL(loop_unregister_transfer);<br>
 <br>
+static void no_plug_device(void)<br>
+{<br>
+}<br>
+<br>
 int __init loop_init(void) <br>
 {<br>
        int     i;<br>
@@ -806,6 +810,7 @@<br>
        }<br>
 <br>
        blk_init_queue(BLK_DEFAULT_QUEUE(MAJOR_NR), DEVICE_REQUEST);<br>
+       ((request_queue_t *) BLK_DEFAULT_QUEUE(MAJOR_NR))-&gt;plug_device_fn = no_plug_device;<br>
        blk_queue_headactive(BLK_DEFAULT_QUEUE(MAJOR_NR), 0);<br>
        for (i=0; i &lt; max_loop; i++) {<br>
                memset(&amp;loop_dev[i], 0, sizeof(struct loop_device));<br>
<p>
<p>
and someone else, I forgot who, reports success with reserving<br>
more requests:<br>
<p>
diff -u --recursive --new-file ../linux-2.3.99p9/linux/drivers/block/ll_rw_blk.c ./linux/drivers/block/ll_rw_blk.c<br>
--- ../linux-2.3.99p9/linux/drivers/block/ll_rw_blk.c   Sat May 13 03:19:46 2000<br>
+++ ./linux/drivers/block/ll_rw_blk.c   Sun May 21 17:01:21 2000<br>
@@ -586,7 +586,7 @@<br>
         * Cut max_req in half to avoid running out and deadlocking.<br>
         */<br>
         if ((major == LOOP_MAJOR) || (major == NBD_MAJOR))<br>
-               max_req &gt;&gt;= 1;<br>
+               max_req &gt;&gt;= 2;<br>
 <br>
        /*<br>
         * Try to coalesce the new request with old requests<br>
<p>
<p>
You may try and report on whether these things improve your situation.<br>
<p>
Andries<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1266.html">Jacob Luna Lundberg: "Re: Floppy handling"</a>
<li> <b>Previous message:</b> <a href="1264.html">Ian McKellar: "Re: Floppy handling"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
