<!-- received="Fri Jun  9 16:02:29 2000 EET DST" -->
<!-- sent="Fri, 9 Jun 2000 15:54:36 +0300 (EET DST)" -->
<!-- name="Aki M Laukkanen" -->
<!-- email="amlaukka@cc.helsinki.fi" -->
<!-- subject="Re: tcp_timestamps problems with BSD ? (2.2.14,2.2.16)" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.21.0006090850410.3851-100000@coredump.atriserv.nl" -->
<title>Linux-kernel mailing list archive 2000-23,: Re: tcp_timestamps problems with BSD ? (2.2.14,2.2.16)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: tcp_timestamps problems with BSD ? (2.2.14,2.2.16)</h1>
<b>Aki M Laukkanen</b> (<a href="mailto:amlaukka@cc.helsinki.fi"><i>amlaukka@cc.helsinki.fi</i></a>)<br>
<i>Fri, 9 Jun 2000 15:54:36 +0300 (EET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1308">[ date ]</a><a href="index.html#1308">[ thread ]</a><a href="subject.html#1308">[ subject ]</a><a href="author.html#1308">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1309.html">yoann@mandrakesoft.com: "Re: linux and micro kernel"</a>
<li> <b>Previous message:</b> <a href="1307.html">Manfred Spraul: "Re: [PATCH] per-cpu slab"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 9 Jun 2000, Filius, Arjan wrote:<br>
<i>&gt; Here it is: (i shortened it because maximum message size on linux-kernel)</i><br>
<p>
Your other dump had:<br>
06:16:44.644780 194.151.216.202.http &gt; 10.1.3.120.search-agent: . 1481498025:1481499473(1448) ack 510105446 win 8760 &lt;nop,nop,timestamp 301982 6399689&gt; (frag 16472:1480@0+) (ttl 46)<br>
06:16:44.644809 194.151.216.202 &gt; 10.1.3.120: (frag 16472:12@1480) (ttl 46)<br>
06:16:44.645085 10.1.3.120.search-agent &gt; 194.151.216.202.http: R 510105446:510105446(0) win 0 (ttl 255, id 10073)  <br>
<p>
Btw. WTF was that? Almost looks like pure garbage. Infoseek search agent<br>
doesn't say much to me. <br>
<p>
<i>&gt; With tcp_timestamp=1:</i><br>
<i>&gt; 06:24:13.273021 194.151.216.202.http &gt; 10.1.3.120.1269: . 141:141(0) ack 443 win 8760 &lt;nop,nop,timestamp 303429 6445420&gt; (DF) (ttl 46, id 128)</i><br>
<i>&gt; 06:24:13.296879 194.151.216.202.http &gt; 10.1.3.120.1271: . 1013:1013(0) ack 383 win 8760 &lt;nop,nop,timestamp 303430 6445422&gt; (DF) (ttl 46, id 140)</i><br>
<i>&gt; 06:24:13.338438 10.1.3.120.1252 &gt; 194.151.216.202.http: . 324:324(0) ack 11681 win 32120 &lt;nop,nop,timestamp 6445430 302878&gt; (DF) (ttl 64, id 10152)</i><br>
<i>&gt; 06:25:20.831866 194.151.216.202.http &gt; 10.1.3.120.1252: . 11681:13129(1448) ack 324 win 8760 &lt;nop,nop,timestamp 303014 6445430&gt; (frag 49066:1480@0+) (ttl 46)</i><br>
<i>&gt; 06:25:20.831896 194.151.216.202 &gt; 10.1.3.120: (frag 49066:12@1480) (ttl 46)</i><br>
<p>
The sender embeds a TCP timestamp option to the message which causes<br>
fragmentation. Maybe that throws something on the route seriously<br>
off-balance? Your Firewall/NAT box? <br>
<p>
Should we prevent fragmentation? The logic below is passive. In active<br>
case the other host might not support timestamps and then we'd be stuck<br>
with a lower mss.<br>
<p>
--- linux-2.4.0-test1-ac6.bak/net/ipv4/tcp_output.c     Wed Apr 12 19:12:36 2000<br>
+++ linux-2.4.0-test1-ac6/net/ipv4/tcp_output.c Fri Jun  9 15:48:15 2000<br>
@@ -998,8 +1003,10 @@<br>
        th-&gt;window = htons(req-&gt;rcv_wnd);<br>
 <br>
        TCP_SKB_CB(skb)-&gt;when = tcp_time_stamp;<br>
-       tcp_syn_build_options((__u32 *)(th + 1), dst-&gt;advmss, req-&gt;tstamp_ok,<br>
-                             req-&gt;sack_ok, req-&gt;wscale_ok, req-&gt;rcv_wscale,<br>
+       tcp_syn_build_options((__u32 *)(th + 1),<br>
+                             req-&gt;tstamp_ok ? dst-&gt;advmss - TCOLEN_TSTAMP_ALIGNED : dst-&gt;advmss,<br>
+                             req-&gt;tstamp_ok, req-&gt;sack_ok,<br>
+                             req-&gt;wscale_ok, req-&gt;rcv_wscale,<br>
                              TCP_SKB_CB(skb)-&gt;when,<br>
                              req-&gt;ts_recent);                                   <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1309.html">yoann@mandrakesoft.com: "Re: linux and micro kernel"</a>
<li> <b>Previous message:</b> <a href="1307.html">Manfred Spraul: "Re: [PATCH] per-cpu slab"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
