<!-- received="Sun Jul 16 02:19:30 2000 EET DST" -->
<!-- sent="Sat, 15 Jul 2000 19:11:18 -0400" -->
<!-- name="john.cavan@sympatico.ca" -->
<!-- email="john.cavan@sympatico.ca" -->
<!-- subject="Patch for tdfx" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: Patch for tdfx</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Patch for tdfx</h1>
<a href="mailto:john.cavan@sympatico.ca"><i>john.cavan@sympatico.ca</i></a><br>
<i>Sat, 15 Jul 2000 19:11:18 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#10">[ date ]</a><a href="index.html#10">[ thread ]</a><a href="subject.html#10">[ subject ]</a><a href="author.html#10">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0011.html">Roger Larsson: "[PATCH] test5-1 vm fix"</a>
<li> <b>Previous message:</b> <a href="0009.html">Andrea Arcangeli: "Re: [Announce] BKL shifting into drivers and filesystems - beware"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------D44DE71DA36C5186CE6299AE<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
This patch brings the DRM code for the Voodoo card up to date with the<br>
code from the DRI project. I didn't patch in the other cards, I have no<br>
way of testing them, nor did I update the other code (3DLabs and the Sun<br>
driver) for the same reason. It seems to be mostly functional on my<br>
machine, at least windowed 3D acceleration under XFree86 4.0.1 is<br>
working, but mileage may vary and I have no idea what impact this has to<br>
the 3DLabs and other cards. At the very least, maybe it will push<br>
someone into doing the same.<br>
<p>
John<br>
<p>
P.S. I was going to do the BTTV stuff, but that is apparently handled. I<br>
tried it, it works for me as well.<br>
--------------D44DE71DA36C5186CE6299AE<br>
Content-Type: text/plain; charset=us-ascii;<br>
 name="tdfx.patch"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline;<br>
 filename="tdfx.patch"<br>
<p>
diff -urN linux.clean/drivers/char/drm/Makefile linux/drivers/char/drm/Makefile<br>
--- linux.clean/drivers/char/drm/Makefile	Wed Jun 21 13:10:02 2000<br>
+++ linux/drivers/char/drm/Makefile	Sat Jul 15 14:36:16 2000<br>
@@ -13,7 +13,11 @@<br>
 O_TARGET	:= drm.o<br>
 <br>
 L_OBJS		:= init.o memory.o proc.o auth.o context.o drawable.o bufs.o \<br>
-			lists.o lock.o ioctl.o fops.o vm.o dma.o<br>
+			lists.o lock.o ioctl.o fops.o vm.o dma.o  ctxbitmap.o<br>
+<br>
+ifdef CONFIG_AGP<br>
+L_OBJS		+= agpsupport.o<br>
+endif<br>
 <br>
 M_OBJS		:= <br>
 <br>
diff -urN linux.clean/drivers/char/drm/agpsupport.c linux/drivers/char/drm/agpsupport.c<br>
--- linux.clean/drivers/char/drm/agpsupport.c	Wed Dec 31 19:00:00 1969<br>
+++ linux/drivers/char/drm/agpsupport.c	Sat Jul 15 14:40:49 2000<br>
@@ -0,0 +1,315 @@<br>
+/* agpsupport.c -- DRM support for AGP/GART backend -*- linux-c -*-<br>
+ * Created: Mon Dec 13 09:56:45 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
+ *<br>
+ * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
+ * All Rights Reserved.<br>
+ *<br>
+ * Permission is hereby granted, free of charge, to any person obtaining a<br>
+ * copy of this software and associated documentation files (the "Software"),<br>
+ * to deal in the Software without restriction, including without limitation<br>
+ * the rights to use, copy, modify, merge, publish, distribute, sublicense,<br>
+ * and/or sell copies of the Software, and to permit persons to whom the<br>
+ * Software is furnished to do so, subject to the following conditions:<br>
+ * <br>
+ * The above copyright notice and this permission notice (including the next<br>
+ * paragraph) shall be included in all copies or substantial portions of the<br>
+ * Software.<br>
+ * <br>
+ * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR<br>
+ * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,<br>
+ * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL<br>
+ * PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR<br>
+ * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,<br>
+ * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER<br>
+ * DEALINGS IN THE SOFTWARE.<br>
+ * <br>
+ * Author: Rickard E. (Rik) Faith &lt;<a href="mailto:faith@valinux.com">faith@valinux.com</a>&gt;<br>
+ *<br>
+ */<br>
+<br>
+#define __NO_VERSION__<br>
+#include "drmP.h"<br>
+<br>
+drm_agp_func_t drm_agp = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };<br>
+<br>
+/* The C standard says that 'void *' is not guaranteed to hold a function<br>
+   pointer, so we use this union to define a generic pointer that is<br>
+   guaranteed to hold any of the function pointers we care about. */<br>
+typedef union {<br>
+	void          (*free_memory)(agp_memory *);<br>
+	agp_memory    *(*allocate_memory)(size_t, u32);<br>
+	int           (*bind_memory)(agp_memory *, off_t);<br>
+	int           (*unbind_memory)(agp_memory *);<br>
+	void          (*enable)(u32);<br>
+	int           (*acquire)(void);<br>
+	void          (*release)(void);<br>
+	void          (*copy_info)(agp_kern_info *);<br>
+	unsigned long address;<br>
+} drm_agp_func_u;<br>
+<br>
+typedef struct drm_agp_fill {<br>
+        const char     *name;<br>
+	drm_agp_func_u *f;<br>
+} drm_agp_fill_t;<br>
+<br>
+static drm_agp_fill_t drm_agp_fill[] = {<br>
+	{ __MODULE_STRING(agp_free_memory),<br>
+	   (drm_agp_func_u *)&amp;drm_agp.free_memory     },<br>
+	{ __MODULE_STRING(agp_allocate_memory), <br>
+	   (drm_agp_func_u *)&amp;drm_agp.allocate_memory },<br>
+	{ __MODULE_STRING(agp_bind_memory),     <br>
+	   (drm_agp_func_u *)&amp;drm_agp.bind_memory     },<br>
+	{ __MODULE_STRING(agp_unbind_memory),   <br>
+	   (drm_agp_func_u *)&amp;drm_agp.unbind_memory   },<br>
+	{ __MODULE_STRING(agp_enable),          <br>
+	   (drm_agp_func_u *)&amp;drm_agp.enable          },<br>
+	{ __MODULE_STRING(agp_backend_acquire), <br>
+	   (drm_agp_func_u *)&amp;drm_agp.acquire         },<br>
+	{ __MODULE_STRING(agp_backend_release), <br>
+	   (drm_agp_func_u *)&amp;drm_agp.release         },<br>
+	{ __MODULE_STRING(agp_copy_info),       <br>
+	   (drm_agp_func_u *)&amp;drm_agp.copy_info       },<br>
+	{ NULL, NULL }<br>
+};<br>
+<br>
+int drm_agp_info(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		 unsigned long arg)<br>
+{<br>
+	drm_file_t	 *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	 *dev	 = priv-&gt;dev;<br>
+	agp_kern_info    *kern;<br>
+	drm_agp_info_t   info;<br>
+<br>
+	if (!dev-&gt;agp-&gt;acquired || !drm_agp.copy_info) return -EINVAL;<br>
+<br>
+	kern                   = &amp;dev-&gt;agp-&gt;agp_info;<br>
+	info.agp_version_major = kern-&gt;version.major;<br>
+	info.agp_version_minor = kern-&gt;version.minor;<br>
+	info.mode              = kern-&gt;mode;<br>
+	info.aperture_base     = kern-&gt;aper_base;<br>
+	info.aperture_size     = kern-&gt;aper_size * 1024 * 1024;<br>
+	info.memory_allowed    = kern-&gt;max_memory &lt;&lt; PAGE_SHIFT;<br>
+	info.memory_used       = kern-&gt;current_memory &lt;&lt; PAGE_SHIFT;<br>
+	info.id_vendor         = kern-&gt;device-&gt;vendor;<br>
+	info.id_device         = kern-&gt;device-&gt;device;<br>
+<br>
+	copy_to_user_ret((drm_agp_info_t *)arg, &amp;info, sizeof(info), -EFAULT);<br>
+	return 0;<br>
+}<br>
+<br>
+int drm_agp_acquire(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		    unsigned long arg)<br>
+{<br>
+	drm_file_t	 *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	 *dev	 = priv-&gt;dev;<br>
+	int              retcode;<br>
+<br>
+	if (dev-&gt;agp-&gt;acquired || !drm_agp.acquire) return -EINVAL;<br>
+	if ((retcode = (*drm_agp.acquire)())) return retcode;<br>
+	dev-&gt;agp-&gt;acquired = 1;<br>
+	return 0;<br>
+}<br>
+<br>
+int drm_agp_release(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		    unsigned long arg)<br>
+{<br>
+	drm_file_t	 *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	 *dev	 = priv-&gt;dev;<br>
+<br>
+	if (!dev-&gt;agp-&gt;acquired || !drm_agp.release) return -EINVAL;<br>
+	(*drm_agp.release)();<br>
+	dev-&gt;agp-&gt;acquired = 0;<br>
+	return 0;<br>
+	<br>
+}<br>
+<br>
+int drm_agp_enable(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		   unsigned long arg)<br>
+{<br>
+	drm_file_t	 *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	 *dev	 = priv-&gt;dev;<br>
+	drm_agp_mode_t   mode;<br>
+<br>
+	if (!dev-&gt;agp-&gt;acquired || !drm_agp.enable) return -EINVAL;<br>
+<br>
+	copy_from_user_ret(&amp;mode, (drm_agp_mode_t *)arg, sizeof(mode),<br>
+			   -EFAULT);<br>
+	<br>
+	dev-&gt;agp-&gt;mode    = mode.mode;<br>
+	(*drm_agp.enable)(mode.mode);<br>
+	dev-&gt;agp-&gt;base    = dev-&gt;agp-&gt;agp_info.aper_base;<br>
+	dev-&gt;agp-&gt;enabled = 1;<br>
+	return 0;<br>
+}<br>
+<br>
+int drm_agp_alloc(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		  unsigned long arg)<br>
+{<br>
+	drm_file_t	 *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	 *dev	 = priv-&gt;dev;<br>
+	drm_agp_buffer_t request;<br>
+	drm_agp_mem_t    *entry;<br>
+	agp_memory       *memory;<br>
+	unsigned long    pages;<br>
+	u32 		 type;<br>
+	if (!dev-&gt;agp-&gt;acquired) return -EINVAL;<br>
+	copy_from_user_ret(&amp;request, (drm_agp_buffer_t *)arg, sizeof(request),<br>
+			   -EFAULT);<br>
+	if (!(entry = drm_alloc(sizeof(*entry), DRM_MEM_AGPLISTS)))<br>
+		return -ENOMEM;<br>
+   <br>
+   	memset(entry, 0, sizeof(*entry));<br>
+<br>
+	pages = (request.size + PAGE_SIZE - 1) / PAGE_SIZE;<br>
+	type = (u32) request.type;<br>
+<br>
+	if (!(memory = drm_alloc_agp(pages, type))) {<br>
+		drm_free(entry, sizeof(*entry), DRM_MEM_AGPLISTS);<br>
+		return -ENOMEM;<br>
+	}<br>
+	<br>
+	entry-&gt;handle    = (unsigned long)memory-&gt;memory;<br>
+	entry-&gt;memory    = memory;<br>
+	entry-&gt;bound     = 0;<br>
+	entry-&gt;pages     = pages;<br>
+	entry-&gt;prev      = NULL;<br>
+	entry-&gt;next      = dev-&gt;agp-&gt;memory;<br>
+	if (dev-&gt;agp-&gt;memory) dev-&gt;agp-&gt;memory-&gt;prev = entry;<br>
+	dev-&gt;agp-&gt;memory = entry;<br>
+<br>
+	request.handle   = entry-&gt;handle;<br>
+        request.physical = memory-&gt;physical;<br>
+<br>
+	if (copy_to_user((drm_agp_buffer_t *)arg, &amp;request, sizeof(request))) {<br>
+		dev-&gt;agp-&gt;memory       = entry-&gt;next;<br>
+		dev-&gt;agp-&gt;memory-&gt;prev = NULL;<br>
+		drm_free_agp(memory, pages);<br>
+		drm_free(entry, sizeof(*entry), DRM_MEM_AGPLISTS);<br>
+		return -EFAULT;<br>
+	}<br>
+	return 0;<br>
+}<br>
+<br>
+static drm_agp_mem_t *drm_agp_lookup_entry(drm_device_t *dev,<br>
+					   unsigned long handle)<br>
+{<br>
+	drm_agp_mem_t *entry;<br>
+<br>
+	for (entry = dev-&gt;agp-&gt;memory; entry; entry = entry-&gt;next) {<br>
+		if (entry-&gt;handle == handle) return entry;<br>
+	}<br>
+	return NULL;<br>
+}<br>
+<br>
+int drm_agp_unbind(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		   unsigned long arg)<br>
+{<br>
+	drm_file_t	  *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	  *dev	 = priv-&gt;dev;<br>
+	drm_agp_binding_t request;<br>
+	drm_agp_mem_t     *entry;<br>
+<br>
+	if (!dev-&gt;agp-&gt;acquired) return -EINVAL;<br>
+	copy_from_user_ret(&amp;request, (drm_agp_binding_t *)arg, sizeof(request),<br>
+			   -EFAULT);<br>
+	if (!(entry = drm_agp_lookup_entry(dev, request.handle)))<br>
+		return -EINVAL;<br>
+	if (!entry-&gt;bound) return -EINVAL;<br>
+	return drm_unbind_agp(entry-&gt;memory);<br>
+}<br>
+<br>
+int drm_agp_bind(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		 unsigned long arg)<br>
+{<br>
+	drm_file_t	  *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	  *dev	 = priv-&gt;dev;<br>
+	drm_agp_binding_t request;<br>
+	drm_agp_mem_t     *entry;<br>
+	int               retcode;<br>
+	int               page;<br>
+	<br>
+	if (!dev-&gt;agp-&gt;acquired || !drm_agp.bind_memory) return -EINVAL;<br>
+	copy_from_user_ret(&amp;request, (drm_agp_binding_t *)arg, sizeof(request),<br>
+			   -EFAULT);<br>
+	if (!(entry = drm_agp_lookup_entry(dev, request.handle)))<br>
+		return -EINVAL;<br>
+	if (entry-&gt;bound) return -EINVAL;<br>
+	page = (request.offset + PAGE_SIZE - 1) / PAGE_SIZE;<br>
+	if ((retcode = drm_bind_agp(entry-&gt;memory, page))) return retcode;<br>
+	entry-&gt;bound = dev-&gt;agp-&gt;base + (page &lt;&lt; PAGE_SHIFT);<br>
+	DRM_DEBUG("base = 0x%lx entry-&gt;bound = 0x%lx\n", <br>
+		  dev-&gt;agp-&gt;base, entry-&gt;bound);<br>
+	return 0;<br>
+}<br>
+<br>
+int drm_agp_free(struct inode *inode, struct file *filp, unsigned int cmd,<br>
+		 unsigned long arg)<br>
+{<br>
+	drm_file_t	 *priv	 = filp-&gt;private_data;<br>
+	drm_device_t	 *dev	 = priv-&gt;dev;<br>
+	drm_agp_buffer_t request;<br>
+	drm_agp_mem_t    *entry;<br>
+	<br>
+	if (!dev-&gt;agp-&gt;acquired) return -EINVAL;<br>
+	copy_from_user_ret(&amp;request, (drm_agp_buffer_t *)arg, sizeof(request),<br>
+			   -EFAULT);<br>
+	if (!(entry = drm_agp_lookup_entry(dev, request.handle)))<br>
+		return -EINVAL;<br>
+	if (entry-&gt;bound) drm_unbind_agp(entry-&gt;memory);<br>
+   <br>
+	if (entry-&gt;prev) entry-&gt;prev-&gt;next = entry-&gt;next;<br>
+	else             dev-&gt;agp-&gt;memory  = entry-&gt;next;<br>
+	if (entry-&gt;next) entry-&gt;next-&gt;prev = entry-&gt;prev;<br>
+	drm_free_agp(entry-&gt;memory, entry-&gt;pages);<br>
+	drm_free(entry, sizeof(*entry), DRM_MEM_AGPLISTS);<br>
+	return 0;<br>
+}<br>
+<br>
+drm_agp_head_t *drm_agp_init(void)<br>
+{<br>
+	drm_agp_fill_t *fill;<br>
+	drm_agp_head_t *head         = NULL;<br>
+	int            agp_available = 1;<br>
+<br>
+	for (fill = &amp;drm_agp_fill[0]; fill-&gt;name; fill++) {<br>
+		char *n  = (char *)fill-&gt;name;<br>
+		*fill-&gt;f = (drm_agp_func_u)get_module_symbol(NULL, n);<br>
+		DRM_DEBUG("%s resolves to 0x%08lx\n", n, (*fill-&gt;f).address);<br>
+		if (!(*fill-&gt;f).address) agp_available = 0;<br>
+	}<br>
+   <br>
+	DRM_DEBUG("agp_available = %d\n", agp_available);<br>
+<br>
+	if (agp_available) {<br>
+		if (!(head = drm_alloc(sizeof(*head), DRM_MEM_AGPLISTS)))<br>
+			return NULL;<br>
+		memset((void *)head, 0, sizeof(*head));<br>
+		(*drm_agp.copy_info)(&amp;head-&gt;agp_info);<br>
+		head-&gt;memory = NULL;<br>
+		switch (head-&gt;agp_info.chipset) {<br>
+		case INTEL_GENERIC:  head-&gt;chipset = "Intel";          break;<br>
+		case INTEL_LX:       head-&gt;chipset = "Intel 440LX";    break;<br>
+		case INTEL_BX:       head-&gt;chipset = "Intel 440BX";    break;<br>
+		case INTEL_GX:       head-&gt;chipset = "Intel 440GX";    break;<br>
+		case INTEL_I810:     head-&gt;chipset = "Intel i810";     break;<br>
+		case VIA_GENERIC:    head-&gt;chipset = "VIA";            break;<br>
+		case VIA_VP3:        head-&gt;chipset = "VIA VP3";        break;<br>
+		case VIA_MVP3:       head-&gt;chipset = "VIA MVP3";       break;<br>
+		case VIA_APOLLO_PRO: head-&gt;chipset = "VIA Apollo Pro"; break;<br>
+		case SIS_GENERIC:    head-&gt;chipset = "SiS";            break;<br>
+		case AMD_GENERIC:    head-&gt;chipset = "AMD";            break;<br>
+		case AMD_IRONGATE:   head-&gt;chipset = "AMD Irongate";   break;<br>
+		case ALI_GENERIC:    head-&gt;chipset = "ALi";            break;<br>
+		case ALI_M1541:      head-&gt;chipset = "ALi M1541";      break;<br>
+		default:<br>
+		}<br>
+		DRM_INFO("AGP %d.%d on %s @ 0x%08lx %dMB\n",<br>
+			 head-&gt;agp_info.version.major,<br>
+			 head-&gt;agp_info.version.minor,<br>
+			 head-&gt;chipset,<br>
+			 head-&gt;agp_info.aper_base,<br>
+			 head-&gt;agp_info.aper_size);<br>
+	}<br>
+	return head;<br>
+}<br>
diff -urN linux.clean/drivers/char/drm/auth.c linux/drivers/char/drm/auth.c<br>
--- linux.clean/drivers/char/drm/auth.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/auth.c	Sat Jul 15 11:30:48 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Tue Feb  2 08:37:54 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -44,7 +45,6 @@<br>
 <br>
 	down(&amp;dev-&gt;struct_sem);<br>
 	for (pt = dev-&gt;magiclist[hash].head; pt; pt = pt-&gt;next) {<br>
-		if (pt-&gt;priv-&gt;authenticated) continue;<br>
 		if (pt-&gt;magic == magic) {<br>
 			retval = pt-&gt;priv;<br>
 			break;<br>
diff -urN linux.clean/drivers/char/drm/bufs.c linux/drivers/char/drm/bufs.c<br>
--- linux.clean/drivers/char/drm/bufs.c	Wed Jun 21 13:10:02 2000<br>
+++ linux/drivers/char/drm/bufs.c	Sat Jul 15 14:46:21 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Tue Feb  2 08:37:54 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999, 2000 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -105,6 +106,11 @@<br>
 			dev-&gt;lock.hw_lock = map-&gt;handle; /* Pointer to lock */<br>
 		}<br>
 		break;<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+    case _DRM_AGP:<br>
+        map-&gt;offset = map-&gt;offset + dev-&gt;agp-&gt;base;<br>
+        break;<br>
+#endif<br>
 	default:<br>
 		drm_free(map, sizeof(*map), DRM_MEM_MAPS);<br>
 		return -EINVAL;<br>
@@ -175,7 +181,7 @@<br>
 	if (order &lt; DRM_MIN_ORDER || order &gt; DRM_MAX_ORDER) return -EINVAL;<br>
 	if (dev-&gt;queue_count) return -EBUSY; /* Not while in use */<br>
 <br>
-	alignment  = (request.flags &amp; DRM_PAGE_ALIGN) ? PAGE_ALIGN(size) :size;<br>
+	alignment  = (request.flags &amp; _DRM_PAGE_ALIGN) ? PAGE_ALIGN(size) :size;<br>
 	page_order = order - PAGE_SHIFT &gt; 0 ? order - PAGE_SHIFT : 0;<br>
 	total	   = PAGE_SIZE &lt;&lt; page_order;<br>
 <br>
@@ -480,10 +486,8 @@<br>
 			   -EFAULT);<br>
 <br>
 	if (request.count &gt;= dma-&gt;buf_count) {<br>
-		down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		virtual = do_mmap(filp, 0, dma-&gt;byte_count,<br>
 				  PROT_READ|PROT_WRITE, MAP_SHARED, 0);<br>
-		up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		if (virtual &gt; -1024UL) {<br>
 				/* Real error */<br>
 			retcode = (signed long)virtual;<br>
diff -urN linux.clean/drivers/char/drm/context.c linux/drivers/char/drm/context.c<br>
--- linux.clean/drivers/char/drm/context.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/context.c	Sat Jul 15 11:40:26 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Tue Feb  2 08:37:54 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/ctxbitmap.c linux/drivers/char/drm/ctxbitmap.c<br>
--- linux.clean/drivers/char/drm/ctxbitmap.c	Wed Dec 31 19:00:00 1969<br>
+++ linux/drivers/char/drm/ctxbitmap.c	Sat Jul 15 12:52:13 2000<br>
@@ -0,0 +1,85 @@<br>
+/* ctxbitmap.c -- Context bitmap management -*- linux-c -*-<br>
+ * Created: Thu Jan 6 03:56:42 2000 by <a href="mailto:jhartmann@precisioninsight.com">jhartmann@precisioninsight.com</a><br>
+ * <br>
+ * Copyright 2000 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
+ * All Rights Reserved.<br>
+ *<br>
+ * Permission is hereby granted, free of charge, to any person obtaining a<br>
+ * copy of this software and associated documentation files (the "Software"),<br>
+ * to deal in the Software without restriction, including without limitation<br>
+ * the rights to use, copy, modify, merge, publish, distribute, sublicense,<br>
+ * and/or sell copies of the Software, and to permit persons to whom the<br>
+ * Software is furnished to do so, subject to the following conditions:<br>
+ * <br>
+ * The above copyright notice and this permission notice (including the next<br>
+ * paragraph) shall be included in all copies or substantial portions of the<br>
+ * Software.<br>
+ * <br>
+ * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR<br>
+ * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,<br>
+ * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL<br>
+ * PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR<br>
+ * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,<br>
+ * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER<br>
+ * DEALINGS IN THE SOFTWARE.<br>
+ *<br>
+ * Author: Jeff Hartmann &lt;<a href="mailto:jhartmann@valinux.com">jhartmann@valinux.com</a>&gt;<br>
+ *<br>
+ */<br>
+<br>
+#define __NO_VERSION__<br>
+#include "drmP.h"<br>
+<br>
+void drm_ctxbitmap_free(drm_device_t *dev, int ctx_handle)<br>
+{<br>
+	if (ctx_handle &lt; 0) goto failed;<br>
+<br>
+	if (ctx_handle &lt; DRM_MAX_CTXBITMAP) {<br>
+		clear_bit(ctx_handle, dev-&gt;ctx_bitmap);<br>
+		return;<br>
+	}<br>
+failed:<br>
+       	DRM_ERROR("Attempt to free invalid context handle: %d\n",<br>
+		  ctx_handle);<br>
+       	return;<br>
+}<br>
+<br>
+int drm_ctxbitmap_next(drm_device_t *dev)<br>
+{<br>
+	int bit;<br>
+<br>
+	bit = find_first_zero_bit(dev-&gt;ctx_bitmap, DRM_MAX_CTXBITMAP);<br>
+	if (bit &lt; DRM_MAX_CTXBITMAP) {<br>
+		set_bit(bit, dev-&gt;ctx_bitmap);<br>
+	   	DRM_DEBUG("drm_ctxbitmap_next bit : %d\n", bit);<br>
+		return bit;<br>
+	}<br>
+	return -1;<br>
+}<br>
+<br>
+int drm_ctxbitmap_init(drm_device_t *dev)<br>
+{<br>
+	int i;<br>
+   	int temp;<br>
+<br>
+	dev-&gt;ctx_bitmap = (unsigned long *) drm_alloc(PAGE_SIZE, <br>
+						      DRM_MEM_CTXBITMAP);<br>
+	if(dev-&gt;ctx_bitmap == NULL) {<br>
+		return -ENOMEM;<br>
+	}<br>
+	memset((void *) dev-&gt;ctx_bitmap, 0, PAGE_SIZE);<br>
+	for(i = 0; i &lt; DRM_RESERVED_CONTEXTS; i++) {<br>
+		temp = drm_ctxbitmap_next(dev);<br>
+	   	DRM_DEBUG("drm_ctxbitmap_init : %d\n", temp);<br>
+	}<br>
+<br>
+	return 0;<br>
+}<br>
+<br>
+void drm_ctxbitmap_cleanup(drm_device_t *dev)<br>
+{<br>
+	drm_free((void *)dev-&gt;ctx_bitmap, PAGE_SIZE,<br>
+		 DRM_MEM_CTXBITMAP);<br>
+}<br>
+<br>
diff -urN linux.clean/drivers/char/drm/dma.c linux/drivers/char/drm/dma.c<br>
--- linux.clean/drivers/char/drm/dma.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/dma.c	Sat Jul 15 11:44:22 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Fri Mar 19 14:30:16 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -63,17 +64,26 @@<br>
 					       dma-&gt;bufs[i].page_order,<br>
 					       DRM_MEM_DMA);<br>
 			}<br>
-			drm_free(dma-&gt;bufs[i].buflist,<br>
-				 dma-&gt;buf_count<br>
-				 * sizeof(*dma-&gt;bufs[0].buflist),<br>
-				 DRM_MEM_BUFS);<br>
 			drm_free(dma-&gt;bufs[i].seglist,<br>
 				 dma-&gt;buf_count<br>
 				 * sizeof(*dma-&gt;bufs[0].seglist),<br>
 				 DRM_MEM_SEGS);<br>
-			drm_freelist_destroy(&amp;dma-&gt;bufs[i].freelist);<br>
 		}<br>
-	}<br>
+        if(dma-&gt;bufs[i].buf_count) {<br>
+            for(j = 0; j &lt; dma-&gt;bufs[i].buf_count; j++) {<br>
+               if(dma-&gt;bufs[i].buflist[j].dev_private) {<br>
+                  drm_free(dma-&gt;bufs[i].buflist[j].dev_private,<br>
+                       dma-&gt;bufs[i].buflist[j].dev_priv_size,<br>
+                       DRM_MEM_BUFS);<br>
+               }<br>
+            }<br>
+            drm_free(dma-&gt;bufs[i].buflist,<br>
+                 dma-&gt;bufs[i].buf_count *<br>
+                 sizeof(*dma-&gt;bufs[0].buflist),<br>
+                 DRM_MEM_BUFS);<br>
+            drm_freelist_destroy(&amp;dma-&gt;bufs[i].freelist);<br>
+        }<br>
+    }<br>
 	<br>
 	if (dma-&gt;buflist) {<br>
 		drm_free(dma-&gt;buflist,<br>
diff -urN linux.clean/drivers/char/drm/drawable.c linux/drivers/char/drm/drawable.c<br>
--- linux.clean/drivers/char/drm/drawable.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/drawable.c	Sat Jul 15 11:44:48 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Tue Feb  2 08:37:54 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/drm.h linux/drivers/char/drm/drm.h<br>
--- linux.clean/drivers/char/drm/drm.h	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/drm.h	Sat Jul 15 13:06:51 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 10:05:05 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All rights reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -61,6 +62,12 @@<br>
 typedef unsigned int  drm_drawable_t;<br>
 typedef unsigned int  drm_magic_t;<br>
 <br>
+typedef struct drm_clip_rect {<br>
+           unsigned short x1;<br>
+           unsigned short y1;<br>
+           unsigned short x2;<br>
+           unsigned short y2;<br>
+} drm_clip_rect_t;<br>
 <br>
 typedef struct drm_version {<br>
 	int    version_major;	  /* Major version			    */<br>
@@ -101,7 +108,8 @@<br>
 typedef enum drm_map_type {<br>
 	_DRM_FRAME_BUFFER = 0,	  /* WC (no caching), no core dump	    */<br>
 	_DRM_REGISTERS	  = 1,	  /* no caching, no core dump		    */<br>
-	_DRM_SHM	  = 2	  /* shared, cached			    */<br>
+	_DRM_SHM	  = 2,	  /* shared, cached			    */<br>
+    _DRM_AGP		  = 3	  /* AGP support */<br>
 } drm_map_type_t;<br>
 <br>
 typedef enum drm_map_flags {<br>
@@ -165,8 +173,11 @@<br>
 	int	      low_mark;	 /* Low water mark			     */<br>
 	int	      high_mark; /* High water mark			     */<br>
 	enum {<br>
-		DRM_PAGE_ALIGN = 0x01  /* Align on page boundaries for DMA   */<br>
+		_DRM_PAGE_ALIGN = 0x01,  /* Align on page boundaries for DMA   */<br>
+		_DRM_AGP_BUFFER = 0x02  /* Buffer is in agp space            */<br>
 	}	      flags;<br>
+    unsigned long agp_start; /* Start address of where the agp buffers<br>
+                  * are in the agp aperture */<br>
 } drm_buf_desc_t;<br>
 <br>
 typedef struct drm_buf_info {<br>
@@ -237,6 +248,39 @@<br>
 	int funcnum;<br>
 } drm_irq_busid_t;<br>
 <br>
+typedef struct drm_agp_mode {<br>
+    unsigned long mode;<br>
+} drm_agp_mode_t;<br>
+<br>
+                /* For drm_agp_alloc -- allocated a buffer */<br>
+typedef struct drm_agp_buffer {<br>
+    unsigned long size; /* In bytes -- will round to page boundary */<br>
+    unsigned long handle;   /* Used for BIND/UNBIND ioctls */<br>
+    unsigned long type;     /* Type of memory to allocate  */<br>
+        unsigned long physical; /* Physical used by i810       */<br>
+} drm_agp_buffer_t;<br>
+<br>
+                /* For drm_agp_bind */<br>
+typedef struct drm_agp_binding {<br>
+    unsigned long handle;   /* From drm_agp_buffer */<br>
+    unsigned long offset;   /* In bytes -- will round to page boundary */<br>
+} drm_agp_binding_t;<br>
+<br>
+typedef struct drm_agp_info {<br>
+    int            agp_version_major;<br>
+    int            agp_version_minor;<br>
+    unsigned long  mode;<br>
+    unsigned long  aperture_base;  /* physical address */<br>
+    unsigned long  aperture_size;  /* bytes */<br>
+    unsigned long  memory_allowed; /* bytes */<br>
+    unsigned long  memory_used;<br>
+<br>
+                /* PCI information */<br>
+    unsigned short id_vendor;<br>
+    unsigned short id_device;<br>
+} drm_agp_info_t;<br>
+<br>
+<br>
 #define DRM_IOCTL_BASE	     'd'<br>
 #define DRM_IOCTL_NR(n)	     _IOC_NR(n)<br>
 #define DRM_IO(nr)	     _IO(DRM_IOCTL_BASE,nr)<br>
@@ -247,7 +291,7 @@<br>
 <br>
 #define DRM_IOCTL_VERSION    DRM_IOWR(0x00, drm_version_t)<br>
 #define DRM_IOCTL_GET_UNIQUE DRM_IOWR(0x01, drm_unique_t)<br>
-#define DRM_IOCTL_GET_MAGIC  DRM_IOW( 0x02, drm_auth_t)<br>
+#define DRM_IOCTL_GET_MAGIC  DRM_IOR( 0x02, drm_auth_t)<br>
 #define DRM_IOCTL_IRQ_BUSID  DRM_IOWR(0x03, drm_irq_busid_t)<br>
 <br>
 #define DRM_IOCTL_SET_UNIQUE DRM_IOW( 0x10, drm_unique_t)<br>
@@ -275,5 +319,14 @@<br>
 #define DRM_IOCTL_LOCK	     DRM_IOW( 0x2a, drm_lock_t)<br>
 #define DRM_IOCTL_UNLOCK     DRM_IOW( 0x2b, drm_lock_t)<br>
 #define DRM_IOCTL_FINISH     DRM_IOW( 0x2c, drm_lock_t)<br>
+<br>
+#define DRM_IOCTL_AGP_ACQUIRE DRM_IO(  0x30)<br>
+#define DRM_IOCTL_AGP_RELEASE DRM_IO(  0x31)<br>
+#define DRM_IOCTL_AGP_ENABLE  DRM_IOW( 0x32, drm_agp_mode_t)<br>
+#define DRM_IOCTL_AGP_INFO    DRM_IOR( 0x33, drm_agp_info_t)<br>
+#define DRM_IOCTL_AGP_ALLOC   DRM_IOWR(0x34, drm_agp_buffer_t)<br>
+#define DRM_IOCTL_AGP_FREE    DRM_IOW( 0x35, drm_agp_buffer_t)<br>
+#define DRM_IOCTL_AGP_BIND    DRM_IOW( 0x36, drm_agp_binding_t)<br>
+#define DRM_IOCTL_AGP_UNBIND  DRM_IOW( 0x37, drm_agp_binding_t)<br>
 <br>
 #endif<br>
diff -urN linux.clean/drivers/char/drm/drmP.h linux/drivers/char/drm/drmP.h<br>
--- linux.clean/drivers/char/drm/drmP.h	Mon Jul 10 17:22:24 2000<br>
+++ linux/drivers/char/drm/drmP.h	Sat Jul 15 16:59:42 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 10:05:05 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All rights reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -49,7 +50,12 @@<br>
 #ifdef CONFIG_MTRR<br>
 #include &lt;asm/mtrr.h&gt;<br>
 #endif<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+#include &lt;linux/types.h&gt;<br>
+#include &lt;linux/agp_backend.h&gt;<br>
+#endif<br>
 #if LINUX_VERSION_CODE &gt;= KERNEL_VERSION(2,1,0)<br>
+#include &lt;linux/tqueue.h&gt;<br>
 #include &lt;linux/poll.h&gt;<br>
 #endif<br>
 #include "drm.h"<br>
@@ -84,6 +90,12 @@<br>
 #define DRM_MEM_CMDS	 12<br>
 #define DRM_MEM_MAPPINGS 13<br>
 #define DRM_MEM_BUFLISTS 14<br>
+#define DRM_MEM_AGPLISTS  15<br>
+#define DRM_MEM_TOTALAGP  16<br>
+#define DRM_MEM_BOUNDAGP  17<br>
+#define DRM_MEM_CTXBITMAP 18<br>
+<br>
+#define DRM_MAX_CTXBITMAP (PAGE_SIZE * 8)<br>
 <br>
 				/* Backward compatibility section */<br>
 				/* _PAGE_WT changed to _PAGE_PWT in 2.2.6 */<br>
@@ -103,11 +115,7 @@<br>
 #endif<br>
 <br>
 				/* vm_offset changed to vm_pgoff in 2.3.25 */<br>
-#if LINUX_VERSION_CODE &lt; 0x020319<br>
-#define VM_OFFSET(vma) ((vma)-&gt;vm_offset)<br>
-#else<br>
 #define VM_OFFSET(vma) ((vma)-&gt;vm_pgoff &lt;&lt; PAGE_SHIFT)<br>
-#endif<br>
 <br>
 				/* *_nopage return values defined in 2.3.26 */<br>
 #ifndef NOPAGE_SIGBUS<br>
@@ -230,6 +238,7 @@<br>
 	int		  used;	       /* Amount of buffer in use (for DMA)  */<br>
 	unsigned long	  offset;      /* Byte offset (used internally)	     */<br>
 	void		  *address;    /* Address of buffer		     */<br>
+    unsigned long     bus_address; /* Bus address of buffer          */<br>
 	struct drm_buf	  *next;       /* Kernel-only: used for free list    */<br>
 	__volatile__ int  waiting;     /* On kernel DMA queue		     */<br>
 	__volatile__ int  pending;     /* On hardware DMA queue		     */<br>
@@ -245,12 +254,16 @@<br>
 		DRM_LIST_PRIO	 = 4,<br>
 		DRM_LIST_RECLAIM = 5<br>
 	}		  list;	       /* Which list we're on		     */<br>
+<br>
 #if DRM_DMA_HISTOGRAM<br>
 	cycles_t	  time_queued;	   /* Queued to kernel DMA queue     */<br>
 	cycles_t	  time_dispatched; /* Dispatched to hardware	     */<br>
 	cycles_t	  time_completed;  /* Completed by hardware	     */<br>
 	cycles_t	  time_freed;	   /* Back on freelist		     */<br>
 #endif<br>
+<br>
+    int       dev_priv_size; /* Size of buffer private stoarge   */<br>
+    void          *dev_private;  /* Per-buffer private storage       */<br>
 } drm_buf_t;<br>
 <br>
 #if DRM_DMA_HISTOGRAM<br>
@@ -371,6 +384,9 @@<br>
 	int		  page_count;<br>
 	unsigned long	  *pagelist;<br>
 	unsigned long	  byte_count;<br>
+    enum {<br>
+       _DRM_DMA_USE_AGP = 0x01<br>
+    } flags;<br>
 <br>
 				/* DMA support */<br>
 	drm_buf_t	  *this_buffer;	/* Buffer being sent		   */<br>
@@ -379,6 +395,41 @@<br>
 	wait_queue_head_t waiting;	/* Processes waiting on free bufs  */<br>
 } drm_device_dma_t;<br>
 <br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+typedef struct drm_agp_mem {<br>
+    unsigned long      handle;<br>
+    agp_memory         *memory;<br>
+    unsigned long      bound; /* address */<br>
+    int                pages;<br>
+    struct drm_agp_mem *prev;<br>
+    struct drm_agp_mem *next;<br>
+} drm_agp_mem_t;<br>
+<br>
+typedef struct drm_agp_head {<br>
+    agp_kern_info      agp_info;<br>
+    const char         *chipset;<br>
+    drm_agp_mem_t      *memory;<br>
+    unsigned long      mode;<br>
+    int                enabled;<br>
+    int                acquired;<br>
+    unsigned long      base;<br>
+    int            agp_mtrr;<br>
+} drm_agp_head_t;<br>
+<br>
+typedef struct {<br>
+    void       (*free_memory)(agp_memory *);<br>
+    agp_memory *(*allocate_memory)(size_t, u32);<br>
+    int        (*bind_memory)(agp_memory *, off_t);<br>
+    int        (*unbind_memory)(agp_memory *);<br>
+    void       (*enable)(u32);<br>
+    int        (*acquire)(void);<br>
+    void       (*release)(void);<br>
+    void       (*copy_info)(agp_kern_info *);<br>
+} drm_agp_func_t;<br>
+<br>
+extern drm_agp_func_t drm_agp;<br>
+#endif<br>
+<br>
 typedef struct drm_device {<br>
 	const char	  *name;	/* Simple driver name		   */<br>
 	char		  *unique;	/* Unique identifier: e.g., busid  */<br>
@@ -457,6 +508,12 @@<br>
 	struct fasync_struct *buf_async;/* Processes waiting for SIGIO	   */<br>
 	wait_queue_head_t buf_readers;	/* Processes waiting to read	   */<br>
 	wait_queue_head_t buf_writers;	/* Processes waiting to ctx switch */<br>
+<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+    drm_agp_head_t    *agp;<br>
+#endif<br>
+    unsigned long     *ctx_bitmap;<br>
+    void          *dev_private;<br>
 } drm_device_t;<br>
 <br>
 <br>
@@ -529,6 +586,14 @@<br>
 extern void	     *drm_ioremap(unsigned long offset, unsigned long size);<br>
 extern void	     drm_ioremapfree(void *pt, unsigned long size);<br>
 <br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+extern agp_memory    *drm_alloc_agp(int pages, u32 type);<br>
+extern int           drm_free_agp(agp_memory *handle, int pages);<br>
+extern int           drm_bind_agp(agp_memory *handle, unsigned int start);<br>
+extern int           drm_unbind_agp(agp_memory *handle);<br>
+#endif<br>
+<br>
+<br>
 				/* Buffer management support (bufs.c) */<br>
 extern int	     drm_order(unsigned long size);<br>
 extern int	     drm_addmap(struct inode *inode, struct file *filp,<br>
@@ -638,5 +703,32 @@<br>
 				       drm_lock_flags_t flags);<br>
 extern int	     drm_flush_block_and_flush(drm_device_t *dev, int context,<br>
 					       drm_lock_flags_t flags);<br>
+<br>
+                /* Context Bitmap support (ctxbitmap.c) */<br>
+extern int       drm_ctxbitmap_init(drm_device_t *dev);<br>
+extern void      drm_ctxbitmap_cleanup(drm_device_t *dev);<br>
+extern int       drm_ctxbitmap_next(drm_device_t *dev);<br>
+extern void      drm_ctxbitmap_free(drm_device_t *dev, int ctx_handle);<br>
+<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+                /* AGP/GART support (agpsupport.c) */<br>
+extern drm_agp_head_t *drm_agp_init(void);<br>
+extern int            drm_agp_acquire(struct inode *inode, struct file *filp,<br>
+                      unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_release(struct inode *inode, struct file *filp,<br>
+                      unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_enable(struct inode *inode, struct file *filp,<br>
+                     unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_info(struct inode *inode, struct file *filp,<br>
+                   unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_alloc(struct inode *inode, struct file *filp,<br>
+                    unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_free(struct inode *inode, struct file *filp,<br>
+                   unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_unbind(struct inode *inode, struct file *filp,<br>
+                     unsigned int cmd, unsigned long arg);<br>
+extern int            drm_agp_bind(struct inode *inode, struct file *filp,<br>
+                   unsigned int cmd, unsigned long arg);<br>
+#endif<br>
 #endif<br>
 #endif<br>
diff -urN linux.clean/drivers/char/drm/fops.c linux/drivers/char/drm/fops.c<br>
--- linux.clean/drivers/char/drm/fops.c	Wed Jun 21 13:10:02 2000<br>
+++ linux/drivers/char/drm/fops.c	Sat Jul 15 18:41:38 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 08:58:31 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999, 2000 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -31,6 +32,7 @@<br>
 <br>
 #define __NO_VERSION__<br>
 #include "drmP.h"<br>
+#include &lt;linux/poll.h&gt;<br>
 <br>
 /* drm_open is called whenever a process opens /dev/drm. */<br>
 <br>
@@ -93,7 +95,6 @@<br>
 		  current-&gt;pid, dev-&gt;device, dev-&gt;open_count);<br>
 <br>
 	if (dev-&gt;lock.hw_lock != NULL<br>
-	    &amp;&amp; _DRM_LOCK_IS_HELD(dev-&gt;lock.hw_lock-&gt;lock)<br>
 	    &amp;&amp; dev-&gt;lock.pid == current-&gt;pid) {<br>
 		DRM_ERROR("Process %d dead, freeing lock for context %d\n",<br>
 			  current-&gt;pid,<br>
@@ -213,12 +214,7 @@<br>
 		send -= count;<br>
 	}<br>
 <br>
-#if LINUX_VERSION_CODE &lt; 0x020315<br>
-	if (dev-&gt;buf_async) kill_fasync(dev-&gt;buf_async, SIGIO);<br>
-#else<br>
-				/* Parameter added in 2.3.21 */<br>
 	kill_fasync(&amp;dev-&gt;buf_async, SIGIO, POLL_IN);<br>
-#endif<br>
 	DRM_DEBUG("waking\n");<br>
 	wake_up_interruptible(&amp;dev-&gt;buf_readers);<br>
 	return 0;<br>
diff -urN linux.clean/drivers/char/drm/gamma_dma.c linux/drivers/char/drm/gamma_dma.c<br>
--- linux.clean/drivers/char/drm/gamma_dma.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/gamma_dma.c	Sat Jul 15 12:05:45 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Fri Mar 19 14:30:16 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -87,28 +88,45 @@<br>
 	GAMMA_WRITE(GAMMA_DMACOUNT, length / 4);<br>
 }<br>
 <br>
-static inline void gamma_dma_quiescent(drm_device_t *dev)<br>
+static inline void gamma_dma_quiescent_single(drm_device_t *dev)<br>
 {<br>
 	while (GAMMA_READ(GAMMA_DMACOUNT))<br>
 		;<br>
 	while (GAMMA_READ(GAMMA_INFIFOSPACE) &lt; 3)<br>
 		;<br>
-	GAMMA_WRITE(GAMMA_BROADCASTMASK, 3);<br>
+<br>
 	GAMMA_WRITE(GAMMA_FILTERMODE, 1 &lt;&lt; 10);<br>
 	GAMMA_WRITE(GAMMA_SYNC, 0);<br>
 	<br>
-				/* Read from first MX */<br>
 	do {<br>
 		while (!GAMMA_READ(GAMMA_OUTFIFOWORDS))<br>
 			;<br>
 	} while (GAMMA_READ(GAMMA_OUTPUTFIFO) != GAMMA_SYNC_TAG);<br>
-	<br>
+}<br>
 <br>
-				/* Read from second MX */<br>
-	do {<br>
-		while (!GAMMA_READ(GAMMA_OUTFIFOWORDS + 0x10000))<br>
-			;<br>
-	} while (GAMMA_READ(GAMMA_OUTPUTFIFO + 0x10000) != GAMMA_SYNC_TAG);<br>
+static inline void gamma_dma_quiescent_dual(drm_device_t *dev)<br>
+{<br>
+    while (GAMMA_READ(GAMMA_DMACOUNT))<br>
+        ;<br>
+    while (GAMMA_READ(GAMMA_INFIFOSPACE) &lt; 3)<br>
+        ;<br>
+<br>
+    GAMMA_WRITE(GAMMA_BROADCASTMASK, 3);<br>
+<br>
+    GAMMA_WRITE(GAMMA_FILTERMODE, 1 &lt;&lt; 10);<br>
+    GAMMA_WRITE(GAMMA_SYNC, 0);<br>
+   <br>
+                /* Read from first MX */<br>
+    do {<br>
+        while (!GAMMA_READ(GAMMA_OUTFIFOWORDS))<br>
+            ;<br>
+    } while (GAMMA_READ(GAMMA_OUTPUTFIFO) != GAMMA_SYNC_TAG);<br>
+   <br>
+                /* Read from second MX */<br>
+    do {<br>
+        while (!GAMMA_READ(GAMMA_OUTFIFOWORDS + 0x10000))<br>
+            ;<br>
+    } while (GAMMA_READ(GAMMA_OUTPUTFIFO + 0x10000) != GAMMA_SYNC_TAG);<br>
 }<br>
 <br>
 static inline void gamma_dma_ready(drm_device_t *dev)<br>
@@ -788,8 +806,13 @@<br>
 	if (!ret) {<br>
 		if (lock.flags &amp; _DRM_LOCK_READY)<br>
 			gamma_dma_ready(dev);<br>
-		if (lock.flags &amp; _DRM_LOCK_QUIESCENT)<br>
-			gamma_dma_quiescent(dev);<br>
+		if (lock.flags &amp; _DRM_LOCK_QUIESCENT) {<br>
+            if (gamma_found() == 1) {<br>
+                gamma_dma_quiescent_single(dev);<br>
+            } else {<br>
+                gamma_dma_quiescent_dual(dev);<br>
+            }<br>
+		}<br>
 	}<br>
 	DRM_DEBUG("%d %s\n", lock.context, ret ? "interrupted" : "has lock");<br>
 <br>
diff -urN linux.clean/drivers/char/drm/gamma_drv.c linux/drivers/char/drm/gamma_drv.c<br>
--- linux.clean/drivers/char/drm/gamma_drv.c	Sat Jul 15 10:44:13 2000<br>
+++ linux/drivers/char/drm/gamma_drv.c	Sat Jul 15 14:48:10 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 08:58:31 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999, 2000 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -36,6 +37,13 @@<br>
 EXPORT_SYMBOL(gamma_init);<br>
 EXPORT_SYMBOL(gamma_cleanup);<br>
 <br>
+#ifndef PCI_DEVICE_ID_3DLABS_GAMMA<br>
+#define PCI_DEVICE_ID_3DLABS_GAMMA 0x0008<br>
+#endif<br>
+#ifndef PCI_DEVICE_ID_3DLABS_MX<br>
+#define PCI_DEVICE_ID_3DLABS_MX 0x0006<br>
+#endif<br>
+<br>
 #define GAMMA_NAME	 "gamma"<br>
 #define GAMMA_DESC	 "3dlabs GMX 2000"<br>
 #define GAMMA_DATE	 "19990830"<br>
@@ -46,7 +54,6 @@<br>
 static drm_device_t	      gamma_device;<br>
 <br>
 static struct file_operations gamma_fops = {<br>
-	owner:		THIS_MODULE,<br>
 	open:		gamma_open,<br>
 	flush:		drm_flush,<br>
 	release:	gamma_release,<br>
@@ -101,10 +108,13 @@<br>
 int			      init_module(void);<br>
 void			      cleanup_module(void);<br>
 static char		      *gamma = NULL;<br>
+static int            devices = 0;<br>
 <br>
 MODULE_AUTHOR("Precision Insight, Inc., Cedar Park, Texas.");<br>
 MODULE_DESCRIPTION("3dlabs GMX 2000");<br>
 MODULE_PARM(gamma, "s");<br>
+MODULE_PARM(devices, "i");<br>
+MODULE_PARM_DESC(devices, "devices=x, where x is the number of MX chips on your card\n");<br>
 <br>
 /* init_module is called when insmod is used to load the module */<br>
 <br>
@@ -274,6 +284,12 @@<br>
 					       - PAGE_SHIFT,<br>
 					       DRM_MEM_SAREA);<br>
 				break;<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+            case _DRM_AGP:<br>
+                /* Do nothing here, because this is all<br>
+                                   handled in the AGP/GART driver. */<br>
+                break;<br>
+#endif<br>
 			}<br>
 			drm_free(map, sizeof(*map), DRM_MEM_MAPS);<br>
 		}<br>
@@ -313,6 +329,34 @@<br>
 	return 0;<br>
 }<br>
 <br>
+int gamma_found(void)<br>
+{<br>
+    return devices;<br>
+}<br>
+<br>
+int gamma_find_devices(void)<br>
+{<br>
+    struct pci_dev *d = NULL, *one = NULL, *two = NULL;<br>
+<br>
+    d = pci_find_device(PCI_VENDOR_ID_3DLABS,PCI_DEVICE_ID_3DLABS_GAMMA,d);<br>
+    if (!d) return 0;<br>
+<br>
+    one = pci_find_device(PCI_VENDOR_ID_3DLABS,PCI_DEVICE_ID_3DLABS_MX,d);<br>
+    if (!one) return 0;<br>
+<br>
+    /* Make sure it's on the same card, if not - no MX's found */<br>
+    if (PCI_SLOT(d-&gt;devfn) != PCI_SLOT(one-&gt;devfn)) return 0;<br>
+<br>
+    two = pci_find_device(PCI_VENDOR_ID_3DLABS,PCI_DEVICE_ID_3DLABS_MX,one);<br>
+    if (!two) return 1;<br>
+<br>
+    /* Make sure it's on the same card, if not - only 1 MX found */<br>
+    if (PCI_SLOT(d-&gt;devfn) != PCI_SLOT(two-&gt;devfn)) return 1;<br>
+<br>
+    /* Two MX's found - we don't currently support more than 2 */<br>
+    return 2;<br>
+}<br>
+<br>
 /* gamma_init is called via init_module at module load time, or via<br>
  * linux/init/main.c (this is not currently supported). */<br>
 <br>
@@ -330,6 +374,8 @@<br>
 #ifdef MODULE<br>
 	drm_parse_options(gamma);<br>
 #endif<br>
+    devices = gamma_find_devices();<br>
+    if (devices == 0) return -1;<br>
 <br>
 	if ((retcode = misc_register(&amp;gamma_misc))) {<br>
 		DRM_ERROR("Cannot register \"%s\"\n", GAMMA_NAME);<br>
@@ -347,7 +393,8 @@<br>
 		 GAMMA_MINOR,<br>
 		 GAMMA_PATCHLEVEL,<br>
 		 GAMMA_DATE,<br>
-		 gamma_misc.minor);<br>
+		 gamma_misc.minor,<br>
+		 devices);<br>
 	<br>
 	return 0;<br>
 }<br>
@@ -410,6 +457,7 @@<br>
 	<br>
 	DRM_DEBUG("open_count = %d\n", dev-&gt;open_count);<br>
 	if (!(retcode = drm_open_helper(inode, filp, dev))) {<br>
+        MOD_INC_USE_COUNT;<br>
 		atomic_inc(&amp;dev-&gt;total_open);<br>
 		spin_lock(&amp;dev-&gt;count_lock);<br>
 		if (!dev-&gt;open_count++) {<br>
@@ -427,10 +475,9 @@<br>
 	drm_device_t  *dev;<br>
 	int	      retcode = 0;<br>
 <br>
-	lock_kernel();<br>
-	dev    = priv-&gt;dev;<br>
 	DRM_DEBUG("open_count = %d\n", dev-&gt;open_count);<br>
 	if (!(retcode = drm_release(inode, filp))) {<br>
+        MOD_INC_USE_COUNT;<br>
 		atomic_inc(&amp;dev-&gt;total_close);<br>
 		spin_lock(&amp;dev-&gt;count_lock);<br>
 		if (!--dev-&gt;open_count) {<br>
@@ -439,17 +486,13 @@<br>
 					  atomic_read(&amp;dev-&gt;ioctl_count),<br>
 					  dev-&gt;blocked);<br>
 				spin_unlock(&amp;dev-&gt;count_lock);<br>
-				unlock_kernel();<br>
 				return -EBUSY;<br>
 			}<br>
 			spin_unlock(&amp;dev-&gt;count_lock);<br>
-			retcode = gamma_takedown(dev);<br>
-			unlock_kernel();<br>
-			return retcode;<br>
+			return gamma_takedown(dev);<br>
 		}<br>
 		spin_unlock(&amp;dev-&gt;count_lock);<br>
 	}<br>
-	unlock_kernel();<br>
 	return retcode;<br>
 }<br>
 <br>
diff -urN linux.clean/drivers/char/drm/gamma_drv.h linux/drivers/char/drm/gamma_drv.h<br>
--- linux.clean/drivers/char/drm/gamma_drv.h	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/gamma_drv.h	Sat Jul 15 12:14:45 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 10:05:05 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All rights reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -53,5 +54,7 @@<br>
 extern int  gamma_irq_uninstall(drm_device_t *dev);<br>
 extern int  gamma_control(struct inode *inode, struct file *filp,<br>
 			  unsigned int cmd, unsigned long arg);<br>
+extern int  gamma_find_devices(void);<br>
+extern int  gamma_found(void);<br>
 <br>
 #endif<br>
diff -urN linux.clean/drivers/char/drm/init.c linux/drivers/char/drm/init.c<br>
--- linux.clean/drivers/char/drm/init.c	Wed Jun 21 13:10:02 2000<br>
+++ linux/drivers/char/drm/init.c	Sat Jul 15 12:16:10 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 08:58:31 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/ioctl.c linux/drivers/char/drm/ioctl.c<br>
--- linux.clean/drivers/char/drm/ioctl.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/ioctl.c	Sat Jul 15 12:16:50 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Fri Jan  8 09:01:26 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/lists.c linux/drivers/char/drm/lists.c<br>
--- linux.clean/drivers/char/drm/lists.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/lists.c	Sat Jul 15 12:18:23 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Apr 19 20:54:22 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/lock.c linux/drivers/char/drm/lock.c<br>
--- linux.clean/drivers/char/drm/lock.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/lock.c	Sat Jul 15 12:19:27 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Tue Feb  2 08:37:54 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/memory.c linux/drivers/char/drm/memory.c<br>
--- linux.clean/drivers/char/drm/memory.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/memory.c	Sat Jul 15 14:48:29 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Thu Feb  4 14:00:34 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -59,6 +60,10 @@<br>
 	[DRM_MEM_CMDS]	   = { "commands" },<br>
 	[DRM_MEM_MAPPINGS] = { "mappings" },<br>
 	[DRM_MEM_BUFLISTS] = { "buflists" },<br>
+    [DRM_MEM_AGPLISTS]  = { "agplist"  },<br>
+    [DRM_MEM_TOTALAGP]  = { "totalagp" },<br>
+    [DRM_MEM_BOUNDAGP]  = { "boundagp" },<br>
+    [DRM_MEM_CTXBITMAP] = { "ctxbitmap"},<br>
 	{ NULL, 0, }		/* Last entry must be null */<br>
 };<br>
 <br>
@@ -76,12 +81,7 @@<br>
 	}<br>
 	<br>
 	si_meminfo(&amp;si);<br>
-#if LINUX_VERSION_CODE &lt; 0x020317<br>
-				/* Changed to page count in 2.3.23 */<br>
-	drm_ram_available = si.totalram &gt;&gt; PAGE_SHIFT;<br>
-#else<br>
-	drm_ram_available = si.totalram;<br>
-#endif<br>
+    drm_ram_available = si.totalram;<br>
 	drm_ram_used	  = 0;<br>
 }<br>
 <br>
@@ -324,3 +324,121 @@<br>
 			      free_count, alloc_count);<br>
 	}<br>
 }<br>
+<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+agp_memory *drm_alloc_agp(int pages, u32 type)<br>
+{<br>
+    agp_memory *handle;<br>
+<br>
+    if (!pages) {<br>
+        DRM_MEM_ERROR(DRM_MEM_TOTALAGP, "Allocating 0 pages\n");<br>
+        return NULL;<br>
+    }<br>
+<br>
+    if (drm_agp.allocate_memory) {<br>
+        if ((handle = (*drm_agp.allocate_memory)(pages,<br>
+                             type))) {<br>
+            spin_lock(&amp;drm_mem_lock);<br>
+            ++drm_mem_stats[DRM_MEM_TOTALAGP].succeed_count;<br>
+            drm_mem_stats[DRM_MEM_TOTALAGP].bytes_allocated<br>
+                += pages &lt;&lt; PAGE_SHIFT;<br>
+            spin_unlock(&amp;drm_mem_lock);<br>
+            return handle;<br>
+        }<br>
+    }<br>
+    spin_lock(&amp;drm_mem_lock);<br>
+    ++drm_mem_stats[DRM_MEM_TOTALAGP].fail_count;<br>
+    spin_unlock(&amp;drm_mem_lock);<br>
+    return NULL;<br>
+}<br>
+<br>
+int drm_free_agp(agp_memory *handle, int pages)<br>
+{<br>
+    int           alloc_count;<br>
+    int           free_count;<br>
+    int           retval = -EINVAL;<br>
+<br>
+    if (!handle) {<br>
+        DRM_MEM_ERROR(DRM_MEM_TOTALAGP,<br>
+                  "Attempt to free NULL AGP handle\n");<br>
+        return retval;;<br>
+    }<br>
+<br>
+    if (drm_agp.free_memory) {<br>
+        (*drm_agp.free_memory)(handle);<br>
+        spin_lock(&amp;drm_mem_lock);<br>
+        free_count  = ++drm_mem_stats[DRM_MEM_TOTALAGP].free_count;<br>
+        alloc_count =   drm_mem_stats[DRM_MEM_TOTALAGP].succeed_count;<br>
+        drm_mem_stats[DRM_MEM_TOTALAGP].bytes_freed<br>
+            += pages &lt;&lt; PAGE_SHIFT;<br>
+        spin_unlock(&amp;drm_mem_lock);<br>
+        if (free_count &gt; alloc_count) {<br>
+            DRM_MEM_ERROR(DRM_MEM_TOTALAGP,<br>
+                      "Excess frees: %d frees, %d allocs\n",<br>
+                      free_count, alloc_count);<br>
+        }<br>
+        return 0;<br>
+    }<br>
+    return retval;<br>
+}<br>
+<br>
+<br>
+int drm_bind_agp(agp_memory *handle, unsigned int start)<br>
+{<br>
+    int retcode = -EINVAL;<br>
+<br>
+   DRM_DEBUG("drm_bind_agp called\n");<br>
+    if (!handle) {<br>
+        DRM_MEM_ERROR(DRM_MEM_BOUNDAGP,<br>
+                  "Attempt to bind NULL AGP handle\n");<br>
+        return retcode;<br>
+    }<br>
+<br>
+   DRM_DEBUG("drm_agp.bind_memory : %p\n", drm_agp.bind_memory);<br>
+    if (drm_agp.bind_memory) {<br>
+        if (!(retcode = (*drm_agp.bind_memory)(handle, start))) {<br>
+            spin_lock(&amp;drm_mem_lock);<br>
+            ++drm_mem_stats[DRM_MEM_BOUNDAGP].succeed_count;<br>
+            drm_mem_stats[DRM_MEM_BOUNDAGP].bytes_allocated<br>
+                += handle-&gt;page_count &lt;&lt; PAGE_SHIFT;<br>
+            spin_unlock(&amp;drm_mem_lock);<br>
+           DRM_DEBUG("drm_agp.bind_memory: retcode %d\n", retcode);<br>
+            return retcode;<br>
+        }<br>
+    }<br>
+    spin_lock(&amp;drm_mem_lock);<br>
+    ++drm_mem_stats[DRM_MEM_BOUNDAGP].fail_count;<br>
+    spin_unlock(&amp;drm_mem_lock);<br>
+    return retcode;<br>
+}<br>
+<br>
+int drm_unbind_agp(agp_memory *handle)<br>
+{<br>
+    int alloc_count;<br>
+    int free_count;<br>
+    int retcode = -EINVAL;<br>
+<br>
+    if (!handle) {<br>
+        DRM_MEM_ERROR(DRM_MEM_BOUNDAGP,<br>
+                  "Attempt to unbind NULL AGP handle\n");<br>
+        return retcode;<br>
+    }<br>
+<br>
+    if (drm_agp.unbind_memory) {<br>
+        int c = handle-&gt;page_count;<br>
+        if ((retcode = (*drm_agp.unbind_memory)(handle)))<br>
+            return retcode;<br>
+        spin_lock(&amp;drm_mem_lock);<br>
+        free_count  = ++drm_mem_stats[DRM_MEM_BOUNDAGP].free_count;<br>
+        alloc_count = drm_mem_stats[DRM_MEM_BOUNDAGP].succeed_count;<br>
+        drm_mem_stats[DRM_MEM_BOUNDAGP].bytes_freed += c &lt;&lt; PAGE_SHIFT;<br>
+        spin_unlock(&amp;drm_mem_lock);<br>
+        if (free_count &gt; alloc_count) {<br>
+            DRM_MEM_ERROR(DRM_MEM_BOUNDAGP,<br>
+                      "Excess frees: %d frees, %d allocs\n",<br>
+                      free_count, alloc_count);<br>
+        }<br>
+    }<br>
+    return retcode;<br>
+}<br>
+#endif<br>
diff -urN linux.clean/drivers/char/drm/proc.c linux/drivers/char/drm/proc.c<br>
--- linux.clean/drivers/char/drm/proc.c	Thu Jul  6 01:15:27 2000<br>
+++ linux/drivers/char/drm/proc.c	Sat Jul 15 17:50:35 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan 11 09:48:47 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -25,7 +26,6 @@<br>
  * <br>
  * Authors:<br>
  *    Rickard E. (Rik) Faith &lt;<a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a>&gt;<br>
- *<br>
  */<br>
 <br>
 #define __NO_VERSION__<br>
@@ -164,7 +164,10 @@<br>
 {<br>
 	drm_device_t *dev = (drm_device_t *)data;<br>
 	drm_map_t    *map;<br>
-	const char   *types[] = { "FB", "REG", "SHM" };<br>
+                /* Hardcoded from _DRM_FRAME_BUFFER,<br>
+                                   _DRM_REGISTERS, _DRM_SHM, and<br>
+                                   _DRM_AGP. */<br>
+	const char   *types[] = { "FB", "REG", "SHM", "AGP" };<br>
 	const char   *type;<br>
 	int	     i;<br>
 <br>
@@ -175,7 +178,7 @@<br>
 		       "address mtrr\n\n");<br>
 	for (i = 0; i &lt; dev-&gt;map_count; i++) {<br>
 		map = dev-&gt;maplist[i];<br>
-		if (map-&gt;type &lt; 0 || map-&gt;type &gt; 2) type = "??";<br>
+		if (map-&gt;type &lt; 0 || map-&gt;type &gt; 3) type = "??";<br>
 		else				    type = types[map-&gt;type];<br>
 		DRM_PROC_PRINT("%4d 0x%08lx 0x%08lx %4.4s  0x%02x 0x%08lx ",<br>
 			       i,<br>
@@ -397,6 +400,7 @@<br>
 			       pgprot &amp; _PAGE_GLOBAL   ? 'g' : 'l' );<br>
 #endif		<br>
 		DRM_PROC_PRINT("\n");<br>
+#if 0<br>
 		for (i = vma-&gt;vm_start; i &lt; vma-&gt;vm_end; i += PAGE_SIZE) {<br>
 			pgd = pgd_offset(vma-&gt;vm_mm, i);<br>
 			pmd = pmd_offset(pgd, i);<br>
@@ -417,6 +421,7 @@<br>
 				DRM_PROC_PRINT("      0x%08lx\n", i);<br>
 			}<br>
 		}<br>
+#endif<br>
 	}<br>
 	<br>
 	return len;<br>
diff -urN linux.clean/drivers/char/drm/tdfx_context.c linux/drivers/char/drm/tdfx_context.c<br>
--- linux.clean/drivers/char/drm/tdfx_context.c	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/tdfx_context.c	Sat Jul 15 12:31:19 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Thu Oct  7 10:50:22 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -25,6 +26,7 @@<br>
  * <br>
  * Authors:<br>
  *    Rickard E. (Rik) Faith &lt;<a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a>&gt;<br>
+ *    Daryll Strauss &lt;<a href="mailto:daryll@valinux.com">daryll@valinux.com</a>&gt;<br>
  *<br>
  */<br>
 <br>
@@ -38,9 +40,7 @@<br>
 <br>
 static int tdfx_alloc_queue(drm_device_t *dev)<br>
 {<br>
-	static int context = 0;<br>
-<br>
-	return ++context;	/* Should this reuse contexts in the future? */<br>
+    return drm_ctxbitmap_next(dev);<br>
 }<br>
 <br>
 int tdfx_context_switch(drm_device_t *dev, int old, int new)<br>
@@ -137,6 +137,12 @@<br>
 		ctx.handle = tdfx_alloc_queue(dev);<br>
 	}<br>
 	DRM_DEBUG("%d\n", ctx.handle);<br>
+    if (ctx.handle == -1) {<br>
+        DRM_DEBUG("Not enough free contexts.\n");<br>
+                /* Should this return -EBUSY instead? */<br>
+        return -ENOMEM;<br>
+    }<br>
+<br>
 	copy_to_user_ret((drm_ctx_t *)arg, &amp;ctx, sizeof(ctx), -EFAULT);<br>
 	return 0;<br>
 }<br>
diff -urN linux.clean/drivers/char/drm/tdfx_drv.c linux/drivers/char/drm/tdfx_drv.c<br>
--- linux.clean/drivers/char/drm/tdfx_drv.c	Sat Jul 15 10:44:13 2000<br>
+++ linux/drivers/char/drm/tdfx_drv.c	Sat Jul 15 18:42:08 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Thu Oct  7 10:38:32 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999, 2000 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -30,23 +31,23 @@<br>
  */<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
-#include &lt;linux/sched.h&gt;<br>
-#include &lt;linux/smp_lock.h&gt;<br>
+#define EXPORT_SYMTAB<br>
 #include "drmP.h"<br>
 #include "tdfx_drv.h"<br>
+EXPORT_SYMBOL(tdfx_init);<br>
+EXPORT_SYMBOL(tdfx_cleanup);<br>
 <br>
 #define TDFX_NAME	 "tdfx"<br>
 #define TDFX_DESC	 "tdfx"<br>
 #define TDFX_DATE	 "19991009"<br>
-#define TDFX_MAJOR	 0<br>
+#define TDFX_MAJOR	 1<br>
 #define TDFX_MINOR	 0<br>
-#define TDFX_PATCHLEVEL  1<br>
+#define TDFX_PATCHLEVEL  0<br>
 <br>
 static drm_device_t	      tdfx_device;<br>
 drm_ctx_t	              tdfx_res_ctx;<br>
 <br>
 static struct file_operations tdfx_fops = {<br>
-	owner:	THIS_MODULE,<br>
 	open:	 tdfx_open,<br>
 	flush:	 drm_flush,<br>
 	release: tdfx_release,<br>
@@ -87,17 +88,62 @@<br>
 	[DRM_IOCTL_NR(DRM_IOCTL_LOCK)]	     = { tdfx_lock,	  1, 0 },<br>
 	[DRM_IOCTL_NR(DRM_IOCTL_UNLOCK)]     = { tdfx_unlock,	  1, 0 },<br>
 	[DRM_IOCTL_NR(DRM_IOCTL_FINISH)]     = { drm_finish,	  1, 0 },<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_ACQUIRE)]   = {drm_agp_acquire, 1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_RELEASE)]   = {drm_agp_release, 1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_ENABLE)]    = {drm_agp_enable,  1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_INFO)]      = {drm_agp_info,    1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_ALLOC)]     = {drm_agp_alloc,   1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_FREE)]      = {drm_agp_free,    1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_BIND)]      = {drm_agp_unbind,  1, 1},<br>
+    [DRM_IOCTL_NR(DRM_IOCTL_AGP_UNBIND)]    = {drm_agp_bind,    1, 1},<br>
+#endif<br>
 };<br>
 #define TDFX_IOCTL_COUNT DRM_ARRAY_SIZE(tdfx_ioctls)<br>
 <br>
 #ifdef MODULE<br>
+int               init_module(void);<br>
+void                  cleanup_module(void);<br>
 static char		      *tdfx = NULL;<br>
-#endif<br>
 <br>
 MODULE_AUTHOR("Precision Insight, Inc., Cedar Park, Texas.");<br>
 MODULE_DESCRIPTION("tdfx");<br>
 MODULE_PARM(tdfx, "s");<br>
 <br>
+/* init_module is called when insmod is used to load the module */<br>
+<br>
+int init_module(void)<br>
+{<br>
+    return tdfx_init();<br>
+}<br>
+<br>
+/* cleanup_module is called when rmmod is used to unload the module */<br>
+<br>
+void cleanup_module(void)<br>
+{<br>
+    tdfx_cleanup();<br>
+}<br>
+#endif<br>
+<br>
+#ifndef MODULE<br>
+/* tdfx_setup is called by the kernel to parse command-line options passed<br>
+ * via the boot-loader (e.g., LILO).  It calls the insmod option routine,<br>
+ * drm_parse_drm.<br>
+ *<br>
+ * This is not currently supported, since it requires changes to<br>
+ * linux/init/main.c. */<br>
+<br>
+<br>
+void __init tdfx_setup(char *str, int *ints)<br>
+{<br>
+    if (ints[0] != 0) {<br>
+        DRM_ERROR("Illegal command line format, ignored\n");<br>
+        return;<br>
+    }<br>
+    drm_parse_options(str);<br>
+}<br>
+#endif<br>
+<br>
 static int tdfx_setup(drm_device_t *dev)<br>
 {<br>
 	int i;<br>
@@ -195,7 +241,24 @@<br>
 		}<br>
 		dev-&gt;magiclist[i].head = dev-&gt;magiclist[i].tail = NULL;<br>
 	}<br>
-	<br>
+#if defined(CONFIG_AGP) || defined(CONFIG_AGP_MODULE)<br>
+                /* Clear AGP information */<br>
+    if (dev-&gt;agp) {<br>
+        drm_agp_mem_t *temp;<br>
+        drm_agp_mem_t *temp_next;<br>
+<br>
+        temp = dev-&gt;agp-&gt;memory;<br>
+        while(temp != NULL) {<br>
+            temp_next = temp-&gt;next;<br>
+            drm_free_agp(temp-&gt;memory, temp-&gt;pages);<br>
+            drm_free(temp, sizeof(*temp), DRM_MEM_AGPLISTS);<br>
+            temp = temp_next;<br>
+        }<br>
+        if(dev-&gt;agp-&gt;acquired) (*drm_agp.release)();<br>
+        drm_free(dev-&gt;agp, sizeof(*dev-&gt;agp), DRM_MEM_AGPLISTS);<br>
+        dev-&gt;agp = NULL;<br>
+    }<br>
+#endif<br>
 				/* Clear vma list (only built for debugging) */<br>
 	if (dev-&gt;vmalist) {<br>
 		for (vma = dev-&gt;vmalist; vma; vma = vma_next) {<br>
@@ -229,6 +292,10 @@<br>
 					       - PAGE_SHIFT,<br>
 					       DRM_MEM_SAREA);<br>
 				break;<br>
+            case _DRM_AGP:<br>
+                /* Do nothing here, because this is all<br>
+                                   handled in the AGP/GART driver. */<br>
+                break;<br>
 			}<br>
 			drm_free(map, sizeof(*map), DRM_MEM_MAPS);<br>
 		}<br>
@@ -276,6 +343,16 @@<br>
 <br>
 	drm_mem_init();<br>
 	drm_proc_init(dev);<br>
+#ifdef DRM_AGP<br>
+    dev-&gt;agp    = drm_agp_init();<br>
+#endif<br>
+    if((retcode = drm_ctxbitmap_init(dev))) {<br>
+        DRM_ERROR("Cannot allocate memory for context bitmap.\n");<br>
+        drm_proc_cleanup();<br>
+        misc_deregister(&amp;tdfx_misc);<br>
+        tdfx_takedown(dev);<br>
+        return retcode;<br>
+    }<br>
 <br>
 	DRM_INFO("Initialized %s %d.%d.%d %s on minor %d\n",<br>
 		 TDFX_NAME,<br>
@@ -302,6 +379,7 @@<br>
 	} else {<br>
 		DRM_INFO("Module unloaded\n");<br>
 	}<br>
+    drm_ctxbitmap_cleanup(dev);<br>
 	tdfx_takedown(dev);<br>
 }<br>
 <br>
@@ -346,6 +424,7 @@<br>
 	<br>
 	DRM_DEBUG("open_count = %d\n", dev-&gt;open_count);<br>
 	if (!(retcode = drm_open_helper(inode, filp, dev))) {<br>
+		MOD_INC_USE_COUNT;<br>
 		atomic_inc(&amp;dev-&gt;total_open);<br>
 		spin_lock(&amp;dev-&gt;count_lock);<br>
 		if (!dev-&gt;open_count++) {<br>
@@ -363,10 +442,9 @@<br>
 	drm_device_t  *dev;<br>
 	int	      retcode = 0;<br>
 <br>
-	lock_kernel();<br>
-	dev    = priv-&gt;dev;<br>
 	DRM_DEBUG("open_count = %d\n", dev-&gt;open_count);<br>
 	if (!(retcode = drm_release(inode, filp))) {<br>
+		MOD_DEC_USE_COUNT;<br>
 		atomic_inc(&amp;dev-&gt;total_close);<br>
 		spin_lock(&amp;dev-&gt;count_lock);<br>
 		if (!--dev-&gt;open_count) {<br>
@@ -375,17 +453,13 @@<br>
 					  atomic_read(&amp;dev-&gt;ioctl_count),<br>
 					  dev-&gt;blocked);<br>
 				spin_unlock(&amp;dev-&gt;count_lock);<br>
-				unlock_kernel();<br>
 				return -EBUSY;<br>
 			}<br>
 			spin_unlock(&amp;dev-&gt;count_lock);<br>
-			retcode = tdfx_takedown(dev);<br>
-			unlock_kernel();<br>
-			return retcode;<br>
+			return tdfx_takedown(dev);<br>
 		}<br>
 		spin_unlock(&amp;dev-&gt;count_lock);<br>
 	}<br>
-	unlock_kernel();<br>
 	return retcode;<br>
 }<br>
 <br>
@@ -500,7 +574,9 @@<br>
                                 /* Contention */<br>
                         atomic_inc(&amp;dev-&gt;total_sleeps);<br>
                         current-&gt;state = TASK_INTERRUPTIBLE;<br>
+#if 1<br>
 			current-&gt;policy |= SCHED_YIELD;<br>
+#endif<br>
                         schedule();<br>
                         if (signal_pending(current)) {<br>
                                 ret = -ERESTARTSYS;<br>
@@ -549,11 +625,20 @@<br>
 		}<br>
         }<br>
 <br>
+#if 0<br>
+    DRM_ERROR("pid = %5d, old counter = %5ld\n",<br>
+        current-&gt;pid, current-&gt;counter);<br>
+#endif<br>
 	if (lock.context != tdfx_res_ctx.handle) {<br>
 		current-&gt;counter = 5;<br>
 		current-&gt;nice = 0;<br>
 	}<br>
-<br>
+#if 0<br>
+    while (current-&gt;counter &gt; 25)<br>
+        current-&gt;counter &gt;&gt;= 1; /* decrease time slice */<br>
+    DRM_ERROR("pid = %5d, new counter = %5ld\n",<br>
+         current-&gt;pid, current-&gt;counter);<br>
+#endif<br>
         DRM_DEBUG("%d %s\n", lock.context, ret ? "interrupted" : "has lock");<br>
 <br>
 #if DRM_DMA_HISTOGRAM<br>
@@ -593,29 +678,21 @@<br>
 			DRM_ERROR("\n");<br>
 		}<br>
 	}<br>
+<br>
+#if 0<br>
+    current-&gt;policy |= SCHED_YIELD;<br>
+    current-&gt;state = TASK_INTERRUPTIBLE;<br>
+    schedule_timeout(1000);<br>
+#endif<br>
 	<br>
 	if (lock.context != tdfx_res_ctx.handle) {<br>
 		current-&gt;counter = 5;<br>
 		current-&gt;nice = 0;<br>
 	}<br>
+#if 0<br>
+    current-&gt;state = TASK_INTERRUPTIBLE;<br>
+    schedule_timeout(10);<br>
+#endif<br>
 <br>
 	return 0;<br>
 }<br>
-<br>
-module_init(tdfx_init);<br>
-module_exit(tdfx_cleanup);<br>
-<br>
-#ifndef MODULE<br>
-/*<br>
- * tdfx_setup is called by the kernel to parse command-line options passed<br>
- * via the boot-loader (e.g., LILO).  It calls the insmod option routine,<br>
- * drm_parse_options.<br>
- */<br>
-static int __init tdfx_options(char *str)<br>
-{<br>
-	drm_parse_options(str);<br>
-	return 1;<br>
-}<br>
-<br>
-__setup("tdfx=", tdfx_options);<br>
-#endif<br>
diff -urN linux.clean/drivers/char/drm/tdfx_drv.h linux/drivers/char/drm/tdfx_drv.h<br>
--- linux.clean/drivers/char/drm/tdfx_drv.h	Tue Mar 14 12:27:31 2000<br>
+++ linux/drivers/char/drm/tdfx_drv.h	Sat Jul 15 12:43:53 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Thu Oct  7 10:40:04 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All rights reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
diff -urN linux.clean/drivers/char/drm/vm.c linux/drivers/char/drm/vm.c<br>
--- linux.clean/drivers/char/drm/vm.c	Sat Jul 15 10:44:13 2000<br>
+++ linux/drivers/char/drm/vm.c	Sat Jul 15 18:36:28 2000<br>
@@ -2,6 +2,7 @@<br>
  * Created: Mon Jan  4 08:58:31 1999 by <a href="mailto:faith@precisioninsight.com">faith@precisioninsight.com</a><br>
  *<br>
  * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.<br>
+ * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.<br>
  * All Rights Reserved.<br>
  *<br>
  * Permission is hereby granted, free of charge, to any person obtaining a<br>
@@ -65,16 +66,9 @@<br>
 	return NOPAGE_SIGBUS;		/* Disallow mremap */<br>
 }<br>
 <br>
-#if LINUX_VERSION_CODE &lt; 0x020317<br>
-unsigned long drm_vm_shm_nopage(struct vm_area_struct *vma,<br>
-				unsigned long address,<br>
-				int write_access)<br>
-#else<br>
-				/* Return type changed in 2.3.23 */<br>
 struct page *drm_vm_shm_nopage(struct vm_area_struct *vma,<br>
 			       unsigned long address,<br>
 			       int write_access)<br>
-#endif<br>
 {<br>
 	drm_file_t	 *priv	 = vma-&gt;vm_file-&gt;private_data;<br>
 	drm_device_t	 *dev	 = priv-&gt;dev;<br>
@@ -91,23 +85,12 @@<br>
 	atomic_inc(&amp;mem_map[MAP_NR(physical)].count); /* Dec. by kernel */<br>
 <br>
 	DRM_DEBUG("0x%08lx (page %lu) =&gt; 0x%08lx\n", address, page, physical);<br>
-#if LINUX_VERSION_CODE &lt; 0x020317<br>
-	return physical;<br>
-#else<br>
 	return mem_map + MAP_NR(physical);<br>
-#endif<br>
 }<br>
 <br>
-#if LINUX_VERSION_CODE &lt; 0x020317<br>
-unsigned long drm_vm_dma_nopage(struct vm_area_struct *vma,<br>
-				unsigned long address,<br>
-				int write_access)<br>
-#else<br>
-				/* Return type changed in 2.3.23 */<br>
 struct page *drm_vm_dma_nopage(struct vm_area_struct *vma,<br>
 			       unsigned long address,<br>
 			       int write_access)<br>
-#endif<br>
 {<br>
 	drm_file_t	 *priv	 = vma-&gt;vm_file-&gt;private_data;<br>
 	drm_device_t	 *dev	 = priv-&gt;dev;<br>
@@ -126,11 +109,7 @@<br>
 	atomic_inc(&amp;mem_map[MAP_NR(physical)].count); /* Dec. by kernel */<br>
 <br>
 	DRM_DEBUG("0x%08lx (page %lu) =&gt; 0x%08lx\n", address, page, physical);<br>
-#if LINUX_VERSION_CODE &lt; 0x020317<br>
-	return physical;<br>
-#else<br>
 	return mem_map + MAP_NR(physical);<br>
-#endif<br>
 }<br>
 <br>
 void drm_vm_open(struct vm_area_struct *vma)<br>
@@ -144,6 +123,7 @@<br>
 	DRM_DEBUG("0x%08lx,0x%08lx\n",<br>
 		  vma-&gt;vm_start, vma-&gt;vm_end - vma-&gt;vm_start);<br>
 	atomic_inc(&amp;dev-&gt;vma_count);<br>
+    MOD_INC_USE_COUNT;<br>
 <br>
 #if DRM_DEBUG_CODE<br>
 	vma_entry = drm_alloc(sizeof(*vma_entry), DRM_MEM_VMAS);<br>
@@ -168,6 +148,7 @@<br>
 <br>
 	DRM_DEBUG("0x%08lx,0x%08lx\n",<br>
 		  vma-&gt;vm_start, vma-&gt;vm_end - vma-&gt;vm_start);<br>
+	MOD_DEC_USE_COUNT;<br>
 	atomic_dec(&amp;dev-&gt;vma_count);<br>
 <br>
 #if DRM_DEBUG_CODE<br>
@@ -203,11 +184,6 @@<br>
 	vma-&gt;vm_ops   = &amp;drm_vm_dma_ops;<br>
 	vma-&gt;vm_flags |= VM_LOCKED | VM_SHM; /* Don't swap */<br>
 	<br>
-#if LINUX_VERSION_CODE &lt; 0x020203 /* KERNEL_VERSION(2,2,3) */<br>
-				/* In Linux 2.2.3 and above, this is<br>
-				   handled in do_mmap() in mm/mmap.c. */<br>
-	++filp-&gt;f_count;<br>
-#endif<br>
 	vma-&gt;vm_file  =	 filp;	/* Needed for drm_vm_open() */<br>
 	drm_vm_open(vma);<br>
 	return 0;<br>
@@ -244,10 +220,23 @@<br>
 				/* Check for valid size. */<br>
 	if (map-&gt;size != vma-&gt;vm_end - vma-&gt;vm_start) return -EINVAL;<br>
 	<br>
+    if (!capable(CAP_SYS_ADMIN) &amp;&amp; (map-&gt;flags &amp; _DRM_READ_ONLY)) {<br>
+        vma-&gt;vm_flags &amp;= VM_MAYWRITE;<br>
+#if defined(__i386__)<br>
+        pgprot_val(vma-&gt;vm_page_prot) &amp;= ~_PAGE_RW;<br>
+#else<br>
+                /* Ye gads this is ugly.  With more thought<br>
+                                   we could move this up higher and use<br>
+                                   `protection_map' instead.  */<br>
+        vma-&gt;vm_page_prot = __pgprot(pte_val(pte_wrprotect(<br>
+            __pte(pgprot_val(vma-&gt;vm_page_prot)))));<br>
+#endif<br>
+    }<br>
 <br>
 	switch (map-&gt;type) {<br>
 	case _DRM_FRAME_BUFFER:<br>
 	case _DRM_REGISTERS:<br>
+    case _DRM_AGP:<br>
 		if (VM_OFFSET(vma) &gt;= __pa(high_memory)) {<br>
 #if defined(__i386__)<br>
 			if (boot_cpu_data.x86 &gt; 3) {<br>
@@ -262,6 +251,10 @@<br>
 				     vma-&gt;vm_end - vma-&gt;vm_start,<br>
 				     vma-&gt;vm_page_prot))<br>
 				return -EAGAIN;<br>
+        DRM_DEBUG("   Type = %d; start = 0x%lx, end = 0x%lx,"<br>
+              " offset = 0x%lx\n",<br>
+              map-&gt;type,<br>
+              vma-&gt;vm_start, vma-&gt;vm_end, VM_OFFSET(vma));<br>
 		vma-&gt;vm_ops = &amp;drm_vm_ops;<br>
 		break;<br>
 	case _DRM_SHM:<br>
@@ -274,25 +267,8 @@<br>
 		return -EINVAL;	/* This should never happen. */<br>
 	}<br>
 	vma-&gt;vm_flags |= VM_LOCKED | VM_SHM; /* Don't swap */<br>
-	if (map-&gt;flags &amp; _DRM_READ_ONLY) {<br>
-#if defined(__i386__)<br>
-		pgprot_val(vma-&gt;vm_page_prot) &amp;= ~_PAGE_RW;<br>
-#else<br>
-				/* Ye gads this is ugly.  With more thought<br>
-                                   we could move this up higher and use<br>
-                                   `protection_map' instead.  */<br>
-		vma-&gt;vm_page_prot = __pgprot(pte_val(pte_wrprotect(<br>
-			__pte(pgprot_val(vma-&gt;vm_page_prot)))));<br>
-#endif<br>
-	}<br>
 <br>
-	<br>
-#if LINUX_VERSION_CODE &lt; 0x020203 /* KERNEL_VERSION(2,2,3) */<br>
-				/* In Linux 2.2.3 and above, this is<br>
-				   handled in do_mmap() in mm/mmap.c. */<br>
-	++filp-&gt;f_count;<br>
-#endif<br>
-	vma-&gt;vm_file  =	 filp;	/* Needed for drm_vm_open() */<br>
-	drm_vm_open(vma);<br>
-	return 0;<br>
+    vma-&gt;vm_file  =  filp;  /* Needed for drm_vm_open() */<br>
+    drm_vm_open(vma);<br>
+    return 0;<br>
 }<br>
<p>
--------------D44DE71DA36C5186CE6299AE--<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0011.html">Roger Larsson: "[PATCH] test5-1 vm fix"</a>
<li> <b>Previous message:</b> <a href="0009.html">Andrea Arcangeli: "Re: [Announce] BKL shifting into drivers and filesystems - beware"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
