<!-- received="Sun Jul 16 02:23:55 2000 EET DST" -->
<!-- sent="Sun, 16 Jul 2000 01:07:37 +0200" -->
<!-- name="Roger Larsson" -->
<!-- email="roger.larsson@norran.net" -->
<!-- subject="[PATCH] test5-1 vm fix" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] test5-1 vm fix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] test5-1 vm fix</h1>
<b>Roger Larsson</b> (<a href="mailto:roger.larsson@norran.net"><i>roger.larsson@norran.net</i></a>)<br>
<i>Sun, 16 Jul 2000 01:07:37 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#11">[ date ]</a><a href="index.html#11">[ thread ]</a><a href="subject.html#11">[ subject ]</a><a href="author.html#11">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0012.html">john.cavan@sympatico.ca: "Ignore my last, re: tdfx patch"</a>
<li> <b>Previous message:</b> <a href="0010.html">john.cavan@sympatico.ca: "Patch for tdfx"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0105.html">Roger Larsson: "Re: [PATCH] test5-1 vm fix"</a>
<li> <b>Reply:</b> <a href="0105.html">Roger Larsson: "Re: [PATCH] test5-1 vm fix"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------DFBE1F8495F7A6A3807CCD28<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Hi,<br>
<p>
Since I am responsible for messing up some aspects of vm<br>
(when fixing others)<br>
here is a patch that tries to solve the introduced problems.<br>
<p>
* no more periodic wake up of kswapd - not needed anymore<br>
* no more freeing all zones to (free_pages &gt; pages_high)<br>
* always wakes kswapd up after try_to_free_pages<br>
* always wakes kswapd up when (free_pages &lt; pages_low)<br>
* remove keep_kswapd_awake() function - not needed anymore<br>
<p>
/RogerL<br>
<p>
Note: Includes Riels "[PATCH] 2.4.0-test4 kswapd rebalancing fix"<br>
<p>
<pre>
--
Home page:
  <a href="http://www.norran.net/nra02596/">http://www.norran.net/nra02596/</a>
--------------DFBE1F8495F7A6A3807CCD28
Content-Type: text/plain; charset=us-ascii;
 name="patch-2.4.0-test5-1-vmfix.2"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-2.4.0-test5-1-vmfix.2"
<p>
--- linux/mm/vmscan.c.orig	Sat Jul 15 23:44:34 2000
+++ linux/mm/vmscan.c	Sun Jul 16 00:57:00 2000
@@ -439,26 +439,6 @@ static inline int memory_pressure(void)
 	return 0;
 }
 
-/*
- * Check if there recently has been memory pressure (zone_wake_kswapd)
- */
-static inline int keep_kswapd_awake(void)
-{
-	pg_data_t *pgdat = pgdat_list;
-
-	do {
-		int i;
-		for(i = 0; i &lt; MAX_NR_ZONES; i++) {
-			zone_t *zone = pgdat-&gt;node_zones+ i;
-			if (zone-&gt;size &amp;&amp;
-			    zone-&gt;zone_wake_kswapd)
-				return 1;
-		}
-		pgdat = pgdat-&gt;node_next;
-	} while (pgdat);
-
-	return 0;
-}
 
 /*
  * We need to make the locks finer granularity, but right
@@ -499,7 +479,7 @@ static int do_try_to_free_pages(unsigned
 		/* not (been) low on memory - it is
 		 * pointless to try to swap out.
 		 */
-		if (!keep_kswapd_awake())
+		if (!memory_pressure())
 			goto done;
 
 		/* Try to get rid of some shared memory pages.. */
@@ -520,7 +500,7 @@ static int do_try_to_free_pages(unsigned
 			 *	if (count &lt;= 0)
 			 *		goto done;
 			 */
-			if (!keep_kswapd_awake())
+			if (!memory_pressure())
 				goto done;
 
 			while (shm_swap(priority, gfp_mask)) {
@@ -595,11 +575,8 @@ int kswapd(void *unused)
 	tsk-&gt;flags |= PF_MEMALLOC;
 
 	for (;;) {
-		if (!keep_kswapd_awake()) {
-			/* wake up regulary to do an early attempt too free
-			 * pages - pages will not actually be freed.
-			 */
-			interruptible_sleep_on_timeout(&amp;kswapd_wait, HZ);
+		if (!memory_pressure()) {
+			interruptible_sleep_on(&amp;kswapd_wait);
 		}
 
 		do_try_to_free_pages(GFP_KSWAPD);
@@ -631,18 +608,18 @@ int try_to_free_pages(unsigned int gfp_m
 		retval = do_try_to_free_pages(gfp_mask);
 		current-&gt;flags &amp;= ~PF_MEMALLOC;
 	}
-	else {
-		/* make sure kswapd runs */
-		if (waitqueue_active(&amp;kswapd_wait))
-			wake_up_interruptible(&amp;kswapd_wait);
-	}
+
+	/* someone needed memory that kswapd had not provided
+	 * make sure kswapd runs, should not happen often */
+	if (waitqueue_active(&amp;kswapd_wait))
+	  wake_up_interruptible(&amp;kswapd_wait);
 
 	return retval;
 }
 
 static int __init kswapd_init(void)
 {
-	printk("Starting kswapd v1.6\n");
+	printk("Starting kswapd v1.7\n");
 	swap_setup();
 	kernel_thread(kswapd, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);
 	return 0;
--- linux/mm/page_alloc.c.orig	Sat Jul 15 23:44:46 2000
+++ linux/mm/page_alloc.c	Sat Jul 15 23:55:55 2000
@@ -275,8 +275,16 @@ struct page * __alloc_pages(zonelist_t *
 			break;
 		if (!z-&gt;low_on_memory) {
 			struct page *page = rmqueue(z, order);
-			if (z-&gt;free_pages &lt; z-&gt;pages_min)
+			if (z-&gt;free_pages &lt; z-&gt;pages_min) {
 				z-&gt;low_on_memory = 1;
+				/* Suppose all zones have zone_wake_kswapd set
+				 * but kswapd has stopped running due to
+				 * no memory_pressure()
+				 */
+				z-&gt;zone_wake_kswapd = 1; /* should be set already */
+				if (waitqueue_active(&amp;kswapd_wait))
+					wake_up_interruptible(&amp;kswapd_wait);
+			}
 			if (page)
 				return page;
 		}
<p>
--------------DFBE1F8495F7A6A3807CCD28--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0012.html">john.cavan@sympatico.ca: "Ignore my last, re: tdfx patch"</a>
<li> <b>Previous message:</b> <a href="0010.html">john.cavan@sympatico.ca: "Patch for tdfx"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0105.html">Roger Larsson: "Re: [PATCH] test5-1 vm fix"</a>
<li> <b>Reply:</b> <a href="0105.html">Roger Larsson: "Re: [PATCH] test5-1 vm fix"</a>
<!-- reply="end" -->
</ul>
</font></body>
