<!-- received="Tue Jul 18 07:55:16 2000 EET DST" -->
<!-- sent="Tue, 18 Jul 2000 14:33:20 +1000" -->
<!-- name="Keith Owens" -->
<!-- email="kaos@ocs.com.au" -->
<!-- subject="nmi_counter cleanup" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: nmi_counter cleanup</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>nmi_counter cleanup</h1>
<b>Keith Owens</b> (<a href="mailto:kaos@ocs.com.au"><i>kaos@ocs.com.au</i></a>)<br>
<i>Tue, 18 Jul 2000 14:33:20 +1000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#218">[ date ]</a><a href="index.html#218">[ thread ]</a><a href="subject.html#218">[ subject ]</a><a href="author.html#218">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0219.html">David Hinds: "Re: 2.4.0-test5/pre1 PCMCIA modem bug?"</a>
<li> <b>Previous message:</b> <a href="0217.html">Gerhard Mack: "Re: Printing out kernel message"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch against 2.4.0-test5-pre2 :-<br>
<p>
(1) Changes nmi_counter from atomic_t to unsigned int.  nmi_counter is<br>
    per cpu and is only updated from the owning cpu.  There is no need<br>
    for it to be atomic, the lock prefix just slows things down,<br>
    especially with the NMI oopser going.<br>
<p>
(2) Removes nmi_counter from ppp, mips and s390 architectures, they<br>
    define it but never use it.<br>
<p>
Any objections before I send it to Linus?<br>
<p>
Index: 0-test5-pre2.1/include/asm-ia64/hardirq.h<br>
--- 0-test5-pre2.1/include/asm-ia64/hardirq.h Fri, 26 May 2000 13:10:01 +1000 kaos (linux-2.4/p/24_hardirq.h 1.1 644)<br>
+++ 0-test5-pre2.1(w)/include/asm-ia64/hardirq.h Tue, 18 Jul 2000 13:50:14 +1000 kaos (linux-2.4/p/24_hardirq.h 1.1 644)<br>
@@ -14,7 +14,7 @@<br>
 typedef struct {<br>
 	unsigned int __local_irq_count;<br>
 	unsigned int __local_bh_count;<br>
-	atomic_t __nmi_counter;<br>
+	unsigned int __nmi_counter;<br>
 # if NR_CPUS &gt; 1<br>
 	unsigned int __pad[13];		/* this assumes 64-byte cache-lines... */<br>
 # endif<br>
Index: 0-test5-pre2.1/include/asm-ppc/hardirq.h<br>
--- 0-test5-pre2.1/include/asm-ppc/hardirq.h Fri, 14 Jul 2000 19:35:46 +1000 kaos (linux-2.4/A/36_hardirq.h 1.2 644)<br>
+++ 0-test5-pre2.1(w)/include/asm-ppc/hardirq.h Tue, 18 Jul 2000 13:51:59 +1000 kaos (linux-2.4/A/36_hardirq.h 1.2 644)<br>
@@ -7,8 +7,7 @@<br>
 typedef struct {<br>
 	unsigned int __local_irq_count;<br>
 	unsigned int __local_bh_count;<br>
-	atomic_t __nmi_counter;<br>
-	unsigned int __pad[5];<br>
+	unsigned int __pad[6];<br>
 } ____cacheline_aligned irq_cpustat_t;<br>
 <br>
 extern irq_cpustat_t irq_stat [NR_CPUS];<br>
@@ -18,7 +17,6 @@<br>
  */<br>
 #define local_irq_count(cpu) (irq_stat[(cpu)].__local_irq_count)<br>
 #define local_bh_count(cpu) (irq_stat[(cpu)].__local_bh_count)<br>
-#define nmi_counter(cpu) (irq_stat[(cpu)].__nmi_counter)<br>
 <br>
 /*<br>
  * Are we in an interrupt context? Either doing bottom half<br>
Index: 0-test5-pre2.1/include/asm-mips/hardirq.h<br>
--- 0-test5-pre2.1/include/asm-mips/hardirq.h Fri, 26 May 2000 13:10:01 +1000 kaos (linux-2.4/M/14_hardirq.h 1.1 644)<br>
+++ 0-test5-pre2.1(w)/include/asm-mips/hardirq.h Tue, 18 Jul 2000 13:49:32 +1000 kaos (linux-2.4/M/14_hardirq.h 1.1 644)<br>
@@ -26,7 +26,6 @@<br>
  */<br>
 #define local_irq_count(cpu) (irq_stat[(cpu)].__local_irq_count)<br>
 #define local_bh_count(cpu) (irq_stat[(cpu)].__local_bh_count)<br>
-#define nmi_counter(cpu) (irq_stat[(cpu)].__nmi_counter)<br>
 <br>
 /*<br>
  * Are we in an interrupt context? Either doing bottom half<br>
Index: 0-test5-pre2.1/include/asm-i386/hardirq.h<br>
--- 0-test5-pre2.1/include/asm-i386/hardirq.h Fri, 26 May 2000 13:10:01 +1000 kaos (linux-2.4/O/23_hardirq.h 1.1 644)<br>
+++ 0-test5-pre2.1(w)/include/asm-i386/hardirq.h Tue, 18 Jul 2000 13:51:28 +1000 kaos (linux-2.4/O/23_hardirq.h 1.1 644)<br>
@@ -8,7 +8,7 @@<br>
 typedef struct {<br>
 	unsigned int __local_irq_count;<br>
 	unsigned int __local_bh_count;<br>
-	atomic_t __nmi_counter;<br>
+	unsigned int __nmi_counter;<br>
 	unsigned int __pad[5];<br>
 } ____cacheline_aligned irq_cpustat_t;<br>
 <br>
Index: 0-test5-pre2.1/arch/s390/kernel/irq.c<br>
--- 0-test5-pre2.1/arch/s390/kernel/irq.c Fri, 26 May 2000 13:10:01 +1000 kaos (linux-2.4/Y/b/39_irq.c 1.1 644)<br>
+++ 0-test5-pre2.1(w)/arch/s390/kernel/irq.c Tue, 18 Jul 2000 13:48:33 +1000 kaos (linux-2.4/Y/b/39_irq.c 1.1 644)<br>
@@ -45,8 +45,6 @@<br>
                      const char    *devname,<br>
                      void          *dev_id);<br>
 <br>
-atomic_t nmi_counter;<br>
-<br>
 #if 0<br>
 /*<br>
  * The following vectors are part of the Linux architecture, there<br>
@@ -105,7 +103,7 @@<br>
 	<br>
 	} /* endfor */<br>
 <br>
-	p += sprintf(p, "NMI: %10u\n", atomic_read(&amp;nmi_counter));<br>
+	p += sprintf(p, "NMI: %10u\n", nmi_counter);<br>
 #ifdef CONFIG_SMP<br>
 	p += sprintf(p, "IPI: %10u\n", atomic_read(&amp;ipi_count));<br>
 #endif<br>
Index: 0-test5-pre2.1/arch/ia64/kernel/irq.c<br>
--- 0-test5-pre2.1/arch/ia64/kernel/irq.c Fri, 23 Jun 2000 07:53:48 +1000 kaos (linux-2.4/c/c/10_irq.c 1.2 644)<br>
+++ 0-test5-pre2.1(w)/arch/ia64/kernel/irq.c Tue, 18 Jul 2000 13:47:37 +1000 kaos (linux-2.4/c/c/10_irq.c 1.2 644)<br>
@@ -162,7 +162,7 @@<br>
 	p += sprintf(p, "NMI: ");<br>
 	for (j = 0; j &lt; smp_num_cpus; j++)<br>
 		p += sprintf(p, "%10u ",<br>
-			atomic_read(&amp;nmi_counter(cpu_logical_map(j))));<br>
+			nmi_counter(cpu_logical_map(j)));<br>
 	p += sprintf(p, "\n");<br>
 #if defined(CONFIG_SMP) &amp;&amp; defined(__i386__)<br>
 	p += sprintf(p, "LOC: ");<br>
Index: 0-test5-pre2.1/arch/i386/kernel/io_apic.c<br>
--- 0-test5-pre2.1/arch/i386/kernel/io_apic.c Thu, 06 Jul 2000 11:41:49 +1000 kaos (linux-2.4/z/c/33_io_apic.c 1.1.1.2 644)<br>
+++ 0-test5-pre2.1(w)/arch/i386/kernel/io_apic.c Tue, 18 Jul 2000 13:47:14 +1000 kaos (linux-2.4/z/c/33_io_apic.c 1.1.1.2 644)<br>
@@ -1059,8 +1059,6 @@<br>
 	return 0;<br>
 }<br>
 <br>
-extern atomic_t nmi_counter[NR_CPUS];<br>
-<br>
 static int __init nmi_irq_works(void)<br>
 {<br>
 	irq_cpustat_t tmp[NR_CPUS];<br>
@@ -1072,7 +1070,7 @@<br>
 <br>
 	for (j = 0; j &lt; smp_num_cpus; j++) {<br>
 		cpu = cpu_logical_map(j);<br>
-		if (atomic_read(&amp;nmi_counter(cpu)) - atomic_read(&amp;tmp[cpu].__nmi_counter) &lt;= 3) {<br>
+		if (nmi_counter(cpu) - tmp[cpu].__nmi_counter &lt;= 3) {<br>
 			printk(KERN_WARNING "CPU#%d NMI appears to be stuck.\n", cpu);<br>
 			return 0;<br>
 		}<br>
Index: 0-test5-pre2.1/arch/i386/kernel/irq.c<br>
--- 0-test5-pre2.1/arch/i386/kernel/irq.c Fri, 26 May 2000 13:10:01 +1000 kaos (linux-2.4/z/c/43_irq.c 1.1 644)<br>
+++ 0-test5-pre2.1(w)/arch/i386/kernel/irq.c Tue, 18 Jul 2000 13:45:11 +1000 kaos (linux-2.4/z/c/43_irq.c 1.1 644)<br>
@@ -160,7 +160,7 @@<br>
 	p += sprintf(p, "NMI: ");<br>
 	for (j = 0; j &lt; smp_num_cpus; j++)<br>
 		p += sprintf(p, "%10u ",<br>
-			atomic_read(&amp;nmi_counter(cpu_logical_map(j))));<br>
+			nmi_counter(cpu_logical_map(j)));<br>
 	p += sprintf(p, "\n");<br>
 #if CONFIG_SMP<br>
 	p += sprintf(p, "LOC: ");<br>
Index: 0-test5-pre2.1/arch/i386/kernel/traps.c<br>
--- 0-test5-pre2.1/arch/i386/kernel/traps.c Fri, 07 Jul 2000 14:32:54 +1000 kaos (linux-2.4/A/c/1_traps.c 1.1.2.2.1.1 644)<br>
+++ 0-test5-pre2.1(w)/arch/i386/kernel/traps.c Tue, 18 Jul 2000 13:44:53 +1000 kaos (linux-2.4/A/c/1_traps.c 1.1.2.2.1.1 644)<br>
@@ -459,7 +459,7 @@<br>
 	unsigned char reason = inb(0x61);<br>
 <br>
 <br>
-	atomic_inc(&amp;nmi_counter(smp_processor_id()));<br>
+	++nmi_counter(smp_processor_id());<br>
 	if (!(reason &amp; 0xc0)) {<br>
 #if CONFIG_X86_IO_APIC<br>
 		/*<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0219.html">David Hinds: "Re: 2.4.0-test5/pre1 PCMCIA modem bug?"</a>
<li> <b>Previous message:</b> <a href="0217.html">Gerhard Mack: "Re: Printing out kernel message"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
