<!-- received="Tue Jul 18 09:44:15 2000 EET DST" -->
<!-- sent="Tue, 18 Jul 2000 08:16:19 +0200" -->
<!-- name="Alain Knaff" -->
<!-- email="Alain.Knaff@ltnb.lu" -->
<!-- subject="[PATCH] Patch for Toshiba 2520 Laptops" -->
<!-- id="200007180616.IAA00647@hitchhiker.org.lu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] Patch for Toshiba 2520 Laptops</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Patch for Toshiba 2520 Laptops</h1>
<b>Alain Knaff</b> (<a href="mailto:Alain.Knaff@ltnb.lu"><i>Alain.Knaff@ltnb.lu</i></a>)<br>
<i>Tue, 18 Jul 2000 08:16:19 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#234">[ date ]</a><a href="index.html#234">[ thread ]</a><a href="subject.html#234">[ subject ]</a><a href="author.html#234">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0235.html">John Covici: "2.4.0 test5 pre2 fails to compile -- unresolved symbol"</a>
<li> <b>Previous message:</b> <a href="0233.html">Marcelo de Paula Bezerra: "Re: D-Link DFE-570TX: driver issues w/ tulip and de4x5"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Certain Toshiba laptop's floppy disk controllers (toshiba 2520)<br>
occasionnally send bogus interrupts, which confuse the floppy<br>
driver. This interrupts are easily recognizable by their<br>
head/sector/cylinder numbers being out of range.  The following patch<br>
instructs the floppy controller to ignore these interrupts.<br>
<p>
Regards,<br>
<p>
Alain<br>
<p>
diff -ur test5-pre2/linux/drivers/block/floppy.c linux/drivers/block/floppy.c<br>
--- test5-pre2/linux/drivers/block/floppy.c	Tue Jul 18 07:43:08 2000<br>
+++ linux/drivers/block/floppy.c	Tue Jul 18 08:01:35 2000<br>
@@ -2339,6 +2339,13 @@<br>
 {<br>
 	int nr_sectors, ssize, eoc, heads;<br>
 <br>
+	if (R_HEAD &gt;= 2) {<br>
+	    /* some Toshiba floppy controllers occasionnally seem to<br>
+	     * return bogus interrupts after read/write operations, which<br>
+	     * can be recognized by a bad head number (&gt;= 2) */<br>
+	     return;<br>
+	}  <br>
+<br>
 	if (!DRS-&gt;first_read_date)<br>
 		DRS-&gt;first_read_date = jiffies;<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0235.html">John Covici: "2.4.0 test5 pre2 fails to compile -- unresolved symbol"</a>
<li> <b>Previous message:</b> <a href="0233.html">Marcelo de Paula Bezerra: "Re: D-Link DFE-570TX: driver issues w/ tulip and de4x5"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
