<!-- received="Tue Jul 18 10:16:48 2000 EET DST" -->
<!-- sent="Mon, 17 Jul 2000 15:08:27 -0700" -->
<!-- name="Dunlap, Randy" -->
<!-- email="randy.dunlap@intel.com" -->
<!-- subject="FW: A20 gate control question." -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: FW: A20 gate control question.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>FW: A20 gate control question.</h1>
<b>Dunlap, Randy</b> (<a href="mailto:randy.dunlap@intel.com"><i>randy.dunlap@intel.com</i></a>)<br>
<i>Mon, 17 Jul 2000 15:08:27 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#260">[ date ]</a><a href="index.html#260">[ thread ]</a><a href="subject.html#260">[ subject ]</a><a href="author.html#260">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0261.html">Michael Babcock: ""real time" patches &amp; naughty drivers"</a>
<li> <b>Previous message:</b> <a href="0259.html">Sampsa Ranta: "Re: [patch] drivers/net/3c59x.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
[Resending...first one didn't show up in about 5 hours.]<br>
<p>
<p>
<i>&gt; Hi.</i><br>
<p>
Jesse Off (<a href="mailto:joff@newmonics.com">joff@newmonics.com</a>) posted a patch to do<br>
this on Oct. 26, 1999.  His patch needs to be added<br>
to setup.S IMO, along with the current gating of A20.<br>
<p>
<p>
&lt;from joff:&gt;<br>
The company I work for, NewMonics, does a lot of work on embedded systems<br>
and we've recently ported our product (a lightweight realtime Java virtual<br>
machine) to Linux.  On some of the embedded systems/PLC's we work with<br>
(specifically, those based on the AMD Elan SC310 and SC300 386<br>
microcontrollers) Linux fails to boot because the keyboard controller is<br>
not there to set the A20 bit.  These machines are headless, keyboardless,<br>
and diskless (except for a small PCMCIA flash card).  With the following<br>
patch, we were able to get our virtual machine running on<br>
Linux under this hardware via a serial port console.<br>
<p>
--- setup.S     Mon Aug  9 12:04:38 1999<br>
+++ setup.S.patched     Tue Oct 26 10:50:36 1999<br>
@@ -553,6 +553,15 @@<br>
        out     #0x60,al<br>
        call    empty_8042<br>
 <br>
+! The AMD 386 Elan SC300 and SC310 microcontrollers which<br>
+! are used in some embedded systems don't have<br>
+! a keyboard controller; we have to do things different on <br>
+! these chips.  Jesse Off, NewMonics, Inc. &lt;<a href="mailto:joff@newmonics.com">joff@newmonics.com</a>&gt; <br>
+<br>
+       mov     al,#0x2         ! GATEA20 functionality is acheived<br>
+       out     #0x92, al       ! via port 0x92, bit 1.<br>
+<br>
+<br>
 ! wait until a20 really *is* enabled; it can take a fair amount of<br>
 ! time on certain systems; Toshiba Tecras are known to have this<br>
 ! problem.  The memory location used here is the int 0x1f vector,<br>
-<br>
&lt;/from joff&gt;<br>
<p>
<p>
This applies to newer Intel systems also.  I asked<br>
internally if port 0x92 might have conflicts with<br>
other chipsets and the answer I got was "no."<br>
<p>
<p>
Also, from other email on this subject, is there<br>
an implication here that the timeout (counter) in<br>
"empty_8042" doesn't work (on systems that don't<br>
have an 8042 controller)?<br>
<p>
~Randy<br>
___________________________________________________<br>
<i>|Randy Dunlap     Intel Corp., DAL    Sr. SW Engr.|</i><br>
<i>|randy.dunlap.at.intel.com            503-696-2055|</i><br>
<i>|NOTE:  Any views presented here are mine alone   |</i><br>
<i>|and may not represent the views of my employer.  |</i><br>
<i>|_________________________________________________|</i><br>
<p>
<i>&gt; -----Original Message-----</i><br>
<i>&gt; From: Agust Karlsson [<a href="mailto:Gusti@pallas.dk">mailto:Gusti@pallas.dk</a>]</i><br>
<i>&gt; Sent: Friday, July 14, 2000 5:46 AM</i><br>
<i>&gt; To: <a href="mailto:'linux-kernel@vger.rutgers.edu';">'linux-kernel@vger.rutgers.edu';</a> 'linux-config@vger.rutgers.edu'</i><br>
<i>&gt; Subject: A20 gate control question.</i><br>
<i>&gt; </i><br>
<i>&gt; Where does Linux set the System Control Port A (io port 0x92) or where</i><br>
<i>&gt; should I put the code to use port 0x92 as a a20 gate handler.</i><br>
<i>&gt; </i><br>
<i>&gt; Best regards</i><br>
<i>&gt; </i><br>
<i>&gt; Agust Karlsson</i><br>
<i>&gt; Pallas Informatik</i><br>
<i>&gt; Allerd Denmark</i><br>
<i>&gt; </i><br>
<i>&gt; -</i><br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0261.html">Michael Babcock: ""real time" patches &amp; naughty drivers"</a>
<li> <b>Previous message:</b> <a href="0259.html">Sampsa Ranta: "Re: [patch] drivers/net/3c59x.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
