<!-- received="Tue Jul 18 10:41:07 2000 EET DST" -->
<!-- sent="Tue, 18 Jul 2000 03:14:13 +0200" -->
<!-- name="Roger Larsson" -->
<!-- email="roger.larsson@norran.net" -->
<!-- subject="[PATCH] test5-pre1 vmfix (rev 8)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] test5-pre1 vmfix (rev 8)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] test5-pre1 vmfix (rev 8)</h1>
<b>Roger Larsson</b> (<a href="mailto:roger.larsson@norran.net"><i>roger.larsson@norran.net</i></a>)<br>
<i>Tue, 18 Jul 2000 03:14:13 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#286">[ date ]</a><a href="index.html#286">[ thread ]</a><a href="subject.html#286">[ subject ]</a><a href="author.html#286">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0287.html">Sasi Peter: "Re: UDMA on WDC == (Re: 2.4.0-test4 Corrupt filesystems)"</a>
<li> <b>Previous message:</b> <a href="0285.html">Dunlap, Randy: "RE: gcc-2.7.2.3 warnings [PATCH]"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0282.html">Roger Larsson: "Re: [PATCH] test5-pre1 vmfix (rev 8)"</a>
<li> <b>Maybe reply:</b> <a href="0282.html">Roger Larsson: "Re: [PATCH] test5-pre1 vmfix (rev 8)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------FDA74AD99A03F4965B626A7B<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Hi,<br>
<p>
Since I am responsible for messing up some aspects of vm<br>
(when fixing others)<br>
here is a patch that tries to solve the introduced problems.<br>
<p>
* no more periodic wake up of kswapd - not needed anymore<br>
* no more freeing all zones to (free_pages &gt; pages_high)<br>
* always wakes kswapd up after try_to_free_pages<br>
* kswapd starts when all zones gets zone_wake_kswapd<br>
  (runs once for each zone that hits zone_wake_kswapd)<br>
* removed test for more than pages_high in alloc_pages,<br>
  zones will mostly be in the range [pages_high...pages_low]<br>
* I get 10% better throughput than 2.4.0-test4, YMMV<br>
<p>
Note: logic of function keep_kswapd_awake has changed.<br>
<p>
/RogerL<br>
<p>
<p>
<pre>
--
Home page:
  <a href="http://www.norran.net/nra02596/">http://www.norran.net/nra02596/</a>
--------------FDA74AD99A03F4965B626A7B
Content-Type: text/plain; charset=us-ascii;
 name="patch-2.4.0-test5-1-vmfix.8"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-2.4.0-test5-1-vmfix.8"
<p>
--- linux/mm/vmscan.c.orig	Sat Jul 15 23:44:34 2000
+++ linux/mm/vmscan.c	Tue Jul 18 02:08:48 2000
@@ -440,7 +440,7 @@ static inline int memory_pressure(void)
 }
 
 /*
- * Check if there recently has been memory pressure (zone_wake_kswapd)
+ * Check if all zones have recently had memory_pressure (zone_wake_kswapd)
  */
 static inline int keep_kswapd_awake(void)
 {
@@ -451,13 +451,13 @@ static inline int keep_kswapd_awake(void
 		for(i = 0; i &lt; MAX_NR_ZONES; i++) {
 			zone_t *zone = pgdat-&gt;node_zones+ i;
 			if (zone-&gt;size &amp;&amp;
-			    zone-&gt;zone_wake_kswapd)
-				return 1;
+			    !zone-&gt;zone_wake_kswapd)
+				return 0;
 		}
 		pgdat = pgdat-&gt;node_next;
 	} while (pgdat);
 
-	return 0;
+	return 1;
 }
 
 /*
@@ -496,9 +496,7 @@ static int do_try_to_free_pages(unsigned
 				goto done;
 		}
 
-		/* not (been) low on memory - it is
-		 * pointless to try to swap out.
-		 */
+		/* check if mission completed */
 		if (!keep_kswapd_awake())
 			goto done;
 
@@ -596,10 +594,7 @@ int kswapd(void *unused)
 
 	for (;;) {
 		if (!keep_kswapd_awake()) {
-			/* wake up regulary to do an early attempt too free
-			 * pages - pages will not actually be freed.
-			 */
-			interruptible_sleep_on_timeout(&amp;kswapd_wait, HZ);
+			interruptible_sleep_on(&amp;kswapd_wait);
 		}
 
 		do_try_to_free_pages(GFP_KSWAPD);
@@ -631,18 +626,18 @@ int try_to_free_pages(unsigned int gfp_m
 		retval = do_try_to_free_pages(gfp_mask);
 		current-&gt;flags &amp;= ~PF_MEMALLOC;
 	}
-	else {
-		/* make sure kswapd runs */
-		if (waitqueue_active(&amp;kswapd_wait))
-			wake_up_interruptible(&amp;kswapd_wait);
-	}
+
+	/* someone needed memory that kswapd had not provided
+	 * make sure kswapd runs, should not happen often */
+	if (waitqueue_active(&amp;kswapd_wait))
+		wake_up_interruptible(&amp;kswapd_wait);
 
 	return retval;
 }
 
 static int __init kswapd_init(void)
 {
-	printk("Starting kswapd v1.6\n");
+	printk("Starting kswapd v1.7\n");
 	swap_setup();
 	kernel_thread(kswapd, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);
 	return 0;
--- linux/mm/page_alloc.c.orig	Sat Jul 15 23:44:46 2000
+++ linux/mm/page_alloc.c	Tue Jul 18 02:19:30 2000
@@ -217,7 +217,7 @@ static struct page * rmqueue(zone_t *zon
  */
 struct page * __alloc_pages(zonelist_t *zonelist, unsigned long order)
 {
-	zone_t **zone = zonelist-&gt;zones;
+	zone_t **zone;
 	extern wait_queue_head_t kswapd_wait;
 
 	/*
@@ -228,21 +228,6 @@ struct page * __alloc_pages(zonelist_t *
 	 * in a higher zone fails.
 	 */
 
-	for (;;) {
-		zone_t *z = *(zone++);
-		if (!z)
-			break;
-		if (!z-&gt;size)
-			BUG();
-
-		/* If there are zones with a lot of free memory allocate from them */
-		if (z-&gt;free_pages &gt; z-&gt;pages_high) {
-			struct page *page = rmqueue(z, order);
-			if (page)
-				return page;
-		}
-	}
-
 	zone = zonelist-&gt;zones;
 	for (;;) {
 		zone_t *z = *(zone++);
@@ -263,6 +248,21 @@ struct page * __alloc_pages(zonelist_t *
 				return page;
 		}
 	}
+
+	/* Three possibilities to get here
+	 * - Previous alloc_pages resulted in last zone set to have
+	 *   zone_wake_kswapd and start it. kswapd has not been able
+	 *   to release enough pages so that one zone does not have
+	 *   zone_wake_kswapd set.
+	 * - Different sets of zones (zonelist)
+	 *   previous did not have all zones with zone_wake_kswapd but
+	 *   this one has... should kswapd be woken up? it will run once.
+	 * - SMP race, kswapd went to sleep slightly after it as running
+	 *   in 'if (waitqueue_active(...))' above.
+	 * + anyway the test is very cheap to do...
+	 */
+	if (waitqueue_active(&amp;kswapd_wait))
+		wake_up_interruptible(&amp;kswapd_wait);
 
 	/*
 	 * Ok, we don't have any zones that don't need some
<p>
--------------FDA74AD99A03F4965B626A7B--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0287.html">Sasi Peter: "Re: UDMA on WDC == (Re: 2.4.0-test4 Corrupt filesystems)"</a>
<li> <b>Previous message:</b> <a href="0285.html">Dunlap, Randy: "RE: gcc-2.7.2.3 warnings [PATCH]"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0282.html">Roger Larsson: "Re: [PATCH] test5-pre1 vmfix (rev 8)"</a>
<li> <b>Maybe reply:</b> <a href="0282.html">Roger Larsson: "Re: [PATCH] test5-pre1 vmfix (rev 8)"</a>
<!-- reply="end" -->
</ul>
</font></body>
