<!-- received="Tue Jul 18 13:03:11 2000 EET DST" -->
<!-- sent="Tue, 18 Jul 2000 02:25:22 -0700" -->
<!-- name="David Ford" -->
<!-- email="david@kalifornia.com" -->
<!-- subject="Re: 2.4.0-test4 niggles" -->
<!-- id="" -->
<!-- inreplyto="2.4.0-test4 niggles" -->
<title>Linux-kernel mailing list archive 2000-29,: Re: 2.4.0-test4 niggles</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.4.0-test4 niggles</h1>
<b>David Ford</b> (<a href="mailto:david@kalifornia.com"><i>david@kalifornia.com</i></a>)<br>
<i>Tue, 18 Jul 2000 02:25:22 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#292">[ date ]</a><a href="index.html#292">[ thread ]</a><a href="subject.html#292">[ subject ]</a><a href="author.html#292">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0293.html">Rogier Wolff: "Re: ipchains in 2.4.0-test5"</a>
<li> <b>Previous message:</b> <a href="0291.html">Rob Taylor: "RE: DHCP in the kernel"</a>
<li> <b>Maybe in reply to:</b> <a href="0125.html">Jareth Hein: "2.4.0-test4 niggles"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------F822D005CF4FCFE06C7D48DB<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Esound code came from a crackbaby design. :)<br>
<p>
esd writes nonstop to the audio dev without checking any return values.<br>
Chances are incredibly strong that the buffer is overflowing and sound data<br>
is being lost.<br>
<p>
Attached is a patch to help that.  I've no suggestion for the second problem.<br>
<p>
-d<br>
<p>
<p>
Jareth Hein wrote:<br>
<p>
<i>&gt; Started playing with 2.4.0-test4 (first new kernel since 2.3.99) this</i><br>
<i>&gt; weekend, and have a couple of small concerns. First off, running a mostly</i><br>
<i>&gt; Debian potato setup w/Gnome on my 2x300 PII box has amazing sound</i><br>
<i>&gt; problems on anything that routes through esd (Enlightenment Sound</i><br>
<i>&gt; Daemon).  I've tried play, playmidi and xmms, and the sounds get</i><br>
<i>&gt; fragmented. If I have them directly open /dev/sound they work fine.</i><br>
<i>&gt;</i><br>
<i>&gt; Secondly, neither raid1 or raid5 can be built as modules.  raid1 simply</i><br>
<i>&gt; needs to have drive_stat_acct exported from drivers/block/ll_rw_blk.c</i><br>
<i>&gt; (however: is it kosher to export inline functions?), but one of the</i><br>
<i>&gt; symbols raid5 needs to be modulized is set_bh_page from fs/buffer.c, and</i><br>
<i>&gt; buffer.c is not searched for exportable symbols. Is this alright for me</i><br>
<i>&gt; (or whomsoever) to modify the makefile to do this, or should raid5 not be</i><br>
<i>&gt; asking to call that function?</i><br>
<i>&gt;</i><br>
<i>&gt; --</i><br>
<i>&gt; Jareth Hein</i><br>
<i>&gt; Weirdness for hire</i><br>
<p>
<pre>
--
"The difference between 'involvement' and 'commitment' is like an
eggs-and-ham breakfast: the chicken was 'involved' - the pig was
'committed'."
<p>
<p>
<p>
--------------F822D005CF4FCFE06C7D48DB
Content-Type: text/plain; charset=us-ascii;
 name="esound-audio.c.patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="esound-audio.c.patch"
<p>
--- audio.c.old	Wed Feb 10 17:48:24 1999
+++ audio.c	Tue Jun 13 02:25:43 2000
@@ -1,6 +1,7 @@
 #include "esd.h"
 #include "config.h"
 
+#include &lt;errno.h&gt;
 #include &lt;stdio.h&gt;
 #include &lt;stdlib.h&gt;
 #include &lt;unistd.h&gt;
@@ -75,7 +75,27 @@
 /* dump a buffer to the sound device */
 int esd_audio_write( void *buffer, int buf_size )
 {
-    return write( esd_audio_fd, buffer, buf_size );
+	/* silly author doesn't do any return value checking =)
+	 * some sound card drivers don't tolerate full bore writes
+	 */
+	 int retval, newsize, counter=0;
+	 newsize=buf_size;
+	do {
+		retval = write( esd_audio_fd, buffer, newsize );
+		if(retval == newsize)
+			return;
+		if(retval == -1 &amp;&amp; errno != EAGAIN)
+			return -1;
+		if(retval == -1 &amp;&amp; errno == EAGAIN) {
+			counter++;
+			usleep(100);
+		}
+		else {
+			counter=0;
+			newsize=retval;
+		}
+	 } while(counter &lt; 100);
+	return -1;
 }
 #endif
 
<p>
--------------F822D005CF4FCFE06C7D48DB
Content-Type: text/x-vcard; charset=us-ascii;
 name="david.vcf"
Content-Transfer-Encoding: 7bit
Content-Description: Card for David Ford
Content-Disposition: attachment;
 filename="david.vcf"
<p>
begin:vcard 
n:Ford;David
x-mozilla-html:TRUE
org:&lt;img src="<a href="http://www.kalifornia.com/images/paradise.jpg">http://www.kalifornia.com/images/paradise.jpg</a>"&gt;
adr:;;;;;;
version:2.1
email;<a href="mailto:internet:david@kalifornia.com">internet:david@kalifornia.com</a>
title:Blue Labs Developer
x-mozilla-cpt:;-12480
fn:David Ford
end:vcard
<p>
--------------F822D005CF4FCFE06C7D48DB--
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0293.html">Rogier Wolff: "Re: ipchains in 2.4.0-test5"</a>
<li> <b>Previous message:</b> <a href="0291.html">Rob Taylor: "RE: DHCP in the kernel"</a>
<li> <b>Maybe in reply to:</b> <a href="0125.html">Jareth Hein: "2.4.0-test4 niggles"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
