<!-- received="Thu Jul 20 10:39:34 2000 EET DST" -->
<!-- sent="20 Jul 2000 08:54:49 +0200" -->
<!-- name="Marc Zyngier" -->
<!-- email="mzyngier@freesurf.fr" -->
<!-- subject="e820 memory detection (was Re: 2.4.0-test3 oops (BIOS bug))" -->
<!-- id="" -->
<!-- inreplyto="Tue, 18 Jul 2000 18:22:44 -0700"" -->
<title>Linux-kernel mailing list archive 2000-29,: e820 memory detection (was Re: 2.4.0-test3 oops (BIOS bug))</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>e820 memory detection (was Re: 2.4.0-test3 oops (BIOS bug))</h1>
<b>Marc Zyngier</b> (<a href="mailto:mzyngier@freesurf.fr"><i>mzyngier@freesurf.fr</i></a>)<br>
<i>20 Jul 2000 08:54:49 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#547">[ date ]</a><a href="index.html#547">[ thread ]</a><a href="subject.html#547">[ subject ]</a><a href="author.html#547">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0548.html">Franz Reitinger: "2.4 test4, Mylex DAC960"</a>
<li> <b>Previous message:</b> <a href="0546.html">Christophe Broult: "Re: [BUG] 2.4.0-test5-pre2 doesn't boot"</a>
<li> <b>In reply to:</b> <a href="0400.html">Jean Tourrilhes: "2.4.0-test3 oops (BIOS bug)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt;&gt;&gt;&gt;&gt; "Jean" == Jean Tourrilhes &lt;<a href="mailto:jt@bougret.hpl.hp.com">jt@bougret.hpl.hp.com</a>&gt; writes:</i><br>
<p>
Jean&gt; 	I spent enough hours trying to fight this bug, which is quite<br>
Jean&gt; difficult to pin point, and I don't want other people to waste as much<br>
Jean&gt; time as I did, especially if it is a known problem but not documented.<br>
<p>
Yes, I spent almost 2 months trying random 2.3 versions, and only<br>
found this while suspecting bad memory, and booting the machine with<br>
8MB, which resulted in an instant crash, while it would only crash<br>
under heavy load with 96MB...<br>
<p>
Jean&gt; 	So, I guess what I'm saying is that a fix for this problem<br>
Jean&gt; would be more than welcomed in the standard kernel. Maybe there should<br>
Jean&gt; be a BIOS blacklist ;-)<br>
<p>
Here's the patch I sent to LKML back in december. I've been told by<br>
Nathan Zook to forget about this, since there was a better (and much<br>
more complete) memory detection patch under way. Alas, such patch<br>
hasn't made it into the kernel yet, and a whole range of systems is<br>
currently left in the dust for 2.4, at least without adding the<br>
mem=xxx option, which was not exactly easy to guess...<br>
<p>
--- linux/arch/i386/kernel/setup.c.orig	Mon Dec 13 19:22:03 1999<br>
+++ linux/arch/i386/kernel/setup.c	Mon Dec 13 19:22:22 1999<br>
@@ -406,9 +406,7 @@<br>
 void __init setup_memory_region(void)<br>
 {<br>
 #define E820_DEBUG	1<br>
-#ifdef E820_DEBUG<br>
 	int i;<br>
-#endif<br>
 <br>
 	/*<br>
 	 * If we're lucky and live on a modern system, the setup code<br>
@@ -421,6 +419,9 @@<br>
 	 * regions: one from 0 to 640k, and one from 1mb up.  (The IBM<br>
 	 * thinkpad 560x, for example, does not cooperate with the memory<br>
 	 * detection code.)<br>
+	 *<br>
+	 * Do not trust e820 maps telling you that there is usable RAM<br>
+	 * sitting between 640k and 1MB, this is probably a lie...<br>
 	 */<br>
 	if (E820_MAP_NR &gt; 1) {<br>
 		/* got a memory map; copy it into a safe place.<br>
@@ -429,13 +430,23 @@<br>
 		if (e820.nr_map &gt; E820MAX)<br>
 			e820.nr_map = E820MAX;<br>
 		memcpy(e820.map, E820_MAP, e820.nr_map * sizeof e820.map[0]);<br>
-#ifdef E820_DEBUG<br>
 		for (i=0; i &lt; e820.nr_map; i++) {<br>
+#ifdef E820_DEBUG<br>
 			printk("e820: %08x @ %08x ", (int)e820.map[i].size,<br>
 						(int)e820.map[i].addr);<br>
+#endif<br>
 			switch (e820.map[i].type) {<br>
-			case E820_RAM:	printk("(usable)\n");<br>
+			case E820_RAM:  if ((int) e820.map[i].addr &gt;= LOWMEMSIZE() &amp;&amp;<br>
+					    (int) e820.map[i].addr &lt; HIGH_MEMORY) {<br>
+					        e820.map[i].type = E820_RESERVED;<br>
+#ifdef E820_DEBUG<br>
+						printk ("(was usable, forced to reserved)\n");<br>
+					} else {<br>
+					        printk("(usable)\n");<br>
+#endif<br>
+					}<br>
 					break;<br>
+#ifdef E820_DEBUG<br>
 			case E820_RESERVED:<br>
 					printk("(reserved)\n");<br>
 					break;<br>
@@ -447,9 +458,9 @@<br>
 					break;<br>
 			default:	printk("type %lu\n", e820.map[i].type);<br>
 					break;<br>
+#endif<br>
 			}<br>
 		}<br>
-#endif<br>
 	}<br>
 	else {<br>
 		/* otherwise fake a memory map; one section from 0k-&gt;640k,<br>
<p>
Jean&gt; 	Merci encore pour le tuyeau...<br>
<p>
De rien...<br>
<p>
	M.<br>
<pre>
-- 
Places change, faces change. Life is so very strange.
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0548.html">Franz Reitinger: "2.4 test4, Mylex DAC960"</a>
<li> <b>Previous message:</b> <a href="0546.html">Christophe Broult: "Re: [BUG] 2.4.0-test5-pre2 doesn't boot"</a>
<li> <b>In reply to:</b> <a href="0400.html">Jean Tourrilhes: "2.4.0-test3 oops (BIOS bug)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
