<!-- received="Thu Jul 20 21:30:24 2000 EET DST" -->
<!-- sent="Thu, 20 Jul 2000 20:32:40 +0200 (CEST)" -->
<!-- name="Manfred" -->
<!-- email="manfred@colorfullife.com" -->
<!-- subject="Re: [patch-2.4.0-test5-pre3] struct inode shortened" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.10007201018080.5025-100000@penguin.transmeta.com" -->
<title>Linux-kernel mailing list archive 2000-29,: Re: [patch-2.4.0-test5-pre3] struct inode shortened</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [patch-2.4.0-test5-pre3] struct inode shortened</h1>
<b>Manfred</b> (<a href="mailto:manfred@colorfullife.com"><i>manfred@colorfullife.com</i></a>)<br>
<i>Thu, 20 Jul 2000 20:32:40 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#604">[ date ]</a><a href="index.html#604">[ thread ]</a><a href="subject.html#604">[ subject ]</a><a href="author.html#604">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0605.html">Vojtech Pavlik: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Previous message:</b> <a href="0603.html">Adam Radford: "Problem with notifier_lock in notifier_chain_unregister with 2.4."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 20 Jul 2000, Linus Torvalds wrote:<br>
<p>
<i>&gt; I wasn't serious.</i><br>
<i>&gt; </i><br>
<i>&gt; It was a comment to your "if you have a million inodes it's a lot of bits"</i><br>
<i>&gt; comment.</i><br>
<i>&gt; </i><br>
<i>&gt; Considering that the inode is probably 200+ bytes, the million inodes case</i><br>
<i>&gt; is fairly scary. And the 4 bytes won't be that noticeable..</i><br>
<i>&gt; </i><br>
<p>
around 416 bytes [just cat /proc/slabinfo, the third number is size,<br>
rounded to cache line size]<br>
<p>
<i>&gt; You'd save more by making the quota stuff go away when quotas aren't</i><br>
<i>&gt; enabled..</i><br>
<i>&gt; </i><br>
<p>
Or by removing a superflous variable in each buffer head: the kiobuf code<br>
adds it's own callback parameter instead of using the generic one.<br>
<p>
Someone promised several times to merge my patch ;)<br>
<p>
<pre>
--
	Manfred
&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt; untested patch, I don't have a raid or kiobuf test setup
// $Header$
// Kernel Version:
//  VERSION = 2
//  PATCHLEVEL = 4
//  SUBLEVEL = 0
//  EXTRAVERSION = -test5
--- 2.4/drivers/block/raid1.c	Thu Jul 20 20:21:51 2000
+++ build-2.4/drivers/block/raid1.c	Thu Jul 20 20:18:20 2000
@@ -379,7 +379,7 @@
 }
 void raid1_end_request (struct buffer_head *bh, int uptodate)
 {
-	struct raid1_bh * r1_bh = (struct raid1_bh *)(bh-&gt;b_dev_id);
+	struct raid1_bh * r1_bh = (struct raid1_bh *)(bh-&gt;b_private);
 
 	/*
 	 * this branch is our 'one mirror IO has finished' event handler:
@@ -626,7 +626,7 @@
 		bh_req-&gt;b_rdev = mirror-&gt;dev;
 	/*	bh_req-&gt;b_rsector = bh-&gt;n_rsector; */
 		bh_req-&gt;b_end_io = raid1_end_request;
-		bh_req-&gt;b_dev_id = r1_bh;
+		bh_req-&gt;b_private = r1_bh;
 		q = blk_get_queue(bh_req-&gt;b_rdev);
 		generic_make_request (q, rw, bh_req);
 		return 0;
@@ -679,7 +679,7 @@
  		mbh-&gt;b_data	  = bh-&gt;b_data;
  		mbh-&gt;b_list       = BUF_LOCKED;
  		mbh-&gt;b_end_io     = raid1_end_request;
- 		mbh-&gt;b_dev_id     = r1_bh;
+ 		mbh-&gt;b_private    = r1_bh;
 
 		mbh-&gt;b_next = r1_bh-&gt;mirror_bh_list;
 		r1_bh-&gt;mirror_bh_list = mbh;
@@ -1192,7 +1192,7 @@
 					mbh-&gt;b_data	  = bh-&gt;b_data;
 					mbh-&gt;b_list       = BUF_LOCKED;
 					mbh-&gt;b_end_io     = end_sync_write;
-					mbh-&gt;b_dev_id     = r1_bh;
+					mbh-&gt;b_private    = r1_bh;
 
 					mbh-&gt;b_next = r1_bh-&gt;mirror_bh_list;
 					r1_bh-&gt;mirror_bh_list = mbh;
@@ -1430,7 +1430,7 @@
 	if (bh-&gt;b_data != (char *) page_address(bh-&gt;b_page))
 		BUG();
 	bh-&gt;b_end_io = end_sync_read;
-	bh-&gt;b_dev_id = (void *) r1_bh;
+	bh-&gt;b_private = r1_bh;
 	bh-&gt;b_rsector = block_nr&lt;&lt;1;
 	init_waitqueue_head(&amp;bh-&gt;b_wait);
 
@@ -1448,7 +1448,7 @@
 
 static void end_sync_read(struct buffer_head *bh, int uptodate)
 {
-	struct raid1_bh * r1_bh = (struct raid1_bh *)(bh-&gt;b_dev_id);
+	struct raid1_bh * r1_bh = (struct raid1_bh *)(bh-&gt;b_private);
 
 	/* we have read a block, now it needs to be re-written,
 	 * or re-read if the read failed.
@@ -1463,7 +1463,7 @@
 
 static void end_sync_write(struct buffer_head *bh, int uptodate)
 {
-	struct raid1_bh * r1_bh = (struct raid1_bh *)(bh-&gt;b_dev_id);
+ 	struct raid1_bh * r1_bh = (struct raid1_bh *)(bh-&gt;b_private);
 	
 	if (!uptodate)
  		md_error (mddev_to_kdev(r1_bh-&gt;mddev), bh-&gt;b_dev);
--- 2.4/drivers/block/raid5.c	Thu Jul 20 20:21:51 2000
+++ build-2.4/drivers/block/raid5.c	Thu Jul 20 20:18:20 2000
@@ -597,7 +597,7 @@
 
 static void raid5_end_request (struct buffer_head * bh, int uptodate)
 {
-	struct stripe_head *sh = bh-&gt;b_dev_id;
+ 	struct stripe_head *sh = bh-&gt;b_private;
 	raid5_conf_t *conf = sh-&gt;raid_conf;
 	int disks = conf-&gt;raid_disks, i;
 	unsigned long flags;
--- 2.4/fs/buffer.c	Thu Jul 20 20:21:59 2000
+++ build-2.4/fs/buffer.c	Thu Jul 20 20:18:20 2000
@@ -708,11 +708,11 @@
 	}
 }
 
-void init_buffer(struct buffer_head *bh, bh_end_io_t *handler, void *dev_id)
+void init_buffer(struct buffer_head *bh, bh_end_io_t *handler, void *private)
 {
 	bh-&gt;b_list = BUF_CLEAN;
 	bh-&gt;b_end_io = handler;
-	bh-&gt;b_dev_id = dev_id;
+	bh-&gt;b_private = private;
 }
 
 static void end_buffer_io_sync(struct buffer_head *bh, int uptodate)
@@ -1742,7 +1742,7 @@
 	
 	mark_buffer_uptodate(bh, uptodate);
 
-	kiobuf = bh-&gt;b_kiobuf;
+	kiobuf = bh-&gt;b_private;
 	unlock_buffer(bh);
 	end_kio_request(kiobuf, uptodate);
 }
@@ -1862,11 +1862,10 @@
 				set_bh_page(tmp, map, offset);
 				tmp-&gt;b_this_page = tmp;
 
-				init_buffer(tmp, end_buffer_io_kiobuf, NULL);
+				init_buffer(tmp, end_buffer_io_kiobuf, iobuf);
 				tmp-&gt;b_dev = dev;
 				tmp-&gt;b_blocknr = blocknr;
 				tmp-&gt;b_state = 1 &lt;&lt; BH_Mapped;
-				tmp-&gt;b_kiobuf = iobuf;
 
 				if (rw == WRITE) {
 					set_bit(BH_Uptodate, &amp;tmp-&gt;b_state);
--- 2.4/include/linux/fs.h	Thu Jul 20 20:22:03 2000
+++ build-2.4/include/linux/fs.h	Thu Jul 20 20:19:18 2000
@@ -238,11 +238,10 @@
 	char * b_data;			/* pointer to data block (512 byte) */
 	struct page *b_page;		/* the page this bh is mapped to */
 	void (*b_end_io)(struct buffer_head *bh, int uptodate); /* I/O completion */
-	void *b_dev_id;
+ 	void *b_private;		/* reserved for b_end_io */
 
 	unsigned long b_rsector;	/* Real buffer location on disk */
 	wait_queue_head_t b_wait;
-	struct kiobuf * b_kiobuf;	/* kiobuf which owns this IO */
 };
 
 typedef void (bh_end_io_t)(struct buffer_head *bh, int uptodate);
--- 2.4/mm/highmem.c	Mon Jun 12 10:07:59 2000
+++ build-2.4/mm/highmem.c	Thu Jul 20 20:18:20 2000
@@ -281,7 +281,7 @@
 
 static inline void bounce_end_io (struct buffer_head *bh, int uptodate)
 {
-	struct buffer_head *bh_orig = (struct buffer_head *)(bh-&gt;b_dev_id);
+	struct buffer_head *bh_orig = (struct buffer_head *)(bh-&gt;b_private);
 
 	bh_orig-&gt;b_end_io(bh_orig, uptodate);
 	__free_page(bh-&gt;b_page);
@@ -295,7 +295,7 @@
 
 static void bounce_end_io_read (struct buffer_head *bh, int uptodate)
 {
-	struct buffer_head *bh_orig = (struct buffer_head *)(bh-&gt;b_dev_id);
+	struct buffer_head *bh_orig = (struct buffer_head *)(bh-&gt;b_private);
 
 	if (uptodate)
 		copy_to_high_bh_irq(bh_orig, bh);
@@ -354,10 +354,9 @@
 		copy_from_high_bh(bh, bh_orig);
 	} else
 		bh-&gt;b_end_io = bounce_end_io_read;
-	bh-&gt;b_dev_id = (void *)bh_orig;
+	bh-&gt;b_private = (void *)bh_orig;
 	bh-&gt;b_rsector = bh_orig-&gt;b_rsector;
 	memset(&amp;bh-&gt;b_wait, -1, sizeof(bh-&gt;b_wait));
-	bh-&gt;b_kiobuf = NULL;
 
 	return bh;
 }
&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0605.html">Vojtech Pavlik: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Previous message:</b> <a href="0603.html">Adam Radford: "Problem with notifier_lock in notifier_chain_unregister with 2.4."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
