<!-- received="Fri Jul 21 07:00:35 2000 EET DST" -->
<!-- sent="Fri, 21 Jul 2000 12:57:26 +0900" -->
<!-- name="NIIBE Yutaka" -->
<!-- email="gniibe@chroot.org" -->
<!-- subject="[PATCH] Flushing cache at exit_mmap" -->
<!-- id="E13FTwE-0004vO-00@pwd.chroot.org" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] Flushing cache at exit_mmap</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Flushing cache at exit_mmap</h1>
<b>NIIBE Yutaka</b> (<a href="mailto:gniibe@chroot.org"><i>gniibe@chroot.org</i></a>)<br>
<i>Fri, 21 Jul 2000 12:57:26 +0900</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#682">[ date ]</a><a href="index.html#682">[ thread ]</a><a href="subject.html#682">[ subject ]</a><a href="author.html#682">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0683.html">Nathan Simons: "knfsd oops (2.4.0-test1) and tulip weirdness"</a>
<li> <b>Previous message:</b> <a href="0681.html">Keith Owens: "Re: Cache coherency... and locking"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Stuart Menefy found that there's something wrong in cache handling<br>
(for SuperH (SH-4) port).  It's not SuperH specific, but generic issue.<br>
<p>
As he seems to be off-line these days, I submit the patch on behalf of<br>
him.  If there's something wrong, it's due to me.<br>
<p>
SH-4 has virtually indexed and physically tagged cache, which has<br>
alias problem to be handled by kernel.  When process exits, we need to<br>
flush the caches used by the process.  If we don't do flush here,<br>
something wrong will be happened later, because of cache aliases, when<br>
the pages will be reused.  The page will be polluted by old cache data<br>
in unrelated way.<br>
<p>
I don't know if TLB flush is needed, but every code has TLB flush, it<br>
is added.<br>
<p>
--- linux-2.4.0-test5-pre3/mm/mmap.c	Thu Jul 20 14:59:44 2000<br>
+++ linux/mm/mmap.c	Thu Jul 20 14:37:42 2000<br>
@@ -864,7 +864,9 @@<br>
 		}<br>
 		mm-&gt;map_count--;<br>
 		remove_shared_vm_struct(mpnt);<br>
+		flush_cache_range(mm, start, end);<br>
 		zap_page_range(mm, start, size);<br>
+		flush_tlb_range(mm, start, end);<br>
 		if (mpnt-&gt;vm_file)<br>
 			fput(mpnt-&gt;vm_file);<br>
 		kmem_cache_free(vm_area_cachep, mpnt);<br>
<pre>
-- 
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0683.html">Nathan Simons: "knfsd oops (2.4.0-test1) and tulip weirdness"</a>
<li> <b>Previous message:</b> <a href="0681.html">Keith Owens: "Re: Cache coherency... and locking"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
